/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootPool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootTable {
    private static final Logger field_186465_b = LogManager.getLogger();
    public static final LootTable EMPTY_LOOT_TABLE = new LootTable(new LootPool[0]);
    private final LootPool[] field_186466_c;

    public LootTable(LootPool[] p_i46641_1_) {
        this.field_186466_c = p_i46641_1_;
    }

    public List<ItemStack> func_186462_a(Random p_186462_1_, LootContext p_186462_2_) {
        ArrayList list = Lists.newArrayList();
        if (p_186462_2_.addLootTable(this)) {
            LootPool[] lootPoolArray = this.field_186466_c;
            int n = this.field_186466_c.length;
            int n2 = 0;
            while (n2 < n) {
                LootPool lootpool = lootPoolArray[n2];
                lootpool.func_186449_b(list, p_186462_1_, p_186462_2_);
                ++n2;
            }
            p_186462_2_.removeLootTable(this);
        } else {
            field_186465_b.warn("Detected infinite loop in loot tables");
        }
        return list;
    }

    public void func_186460_a(IInventory p_186460_1_, Random p_186460_2_, LootContext p_186460_3_) {
        List<ItemStack> list = this.func_186462_a(p_186460_2_, p_186460_3_);
        List<Integer> list1 = this.getEmptySlotsRandomized(p_186460_1_, p_186460_2_);
        this.func_186463_a(list, list1.size(), p_186460_2_);
        for (ItemStack itemstack : list) {
            if (list1.isEmpty()) {
                field_186465_b.warn("Tried to over-fill a container");
                return;
            }
            if (itemstack == null) {
                p_186460_1_.setInventorySlotContents(list1.remove(list1.size() - 1), null);
                continue;
            }
            p_186460_1_.setInventorySlotContents(list1.remove(list1.size() - 1), itemstack);
        }
    }

    private void func_186463_a(List<ItemStack> p_186463_1_, int p_186463_2_, Random p_186463_3_) {
        ArrayList list = Lists.newArrayList();
        Iterator<ItemStack> iterator = p_186463_1_.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = iterator.next();
            if (itemstack.stackSize <= 0) {
                iterator.remove();
                continue;
            }
            if (itemstack.stackSize <= 1) continue;
            list.add(itemstack);
            iterator.remove();
        }
        p_186463_2_ -= p_186463_1_.size();
        while (p_186463_2_ > 0 && list.size() > 0) {
            ItemStack itemstack2 = (ItemStack)list.remove(MathHelper.getRandomIntegerInRange(p_186463_3_, 0, list.size() - 1));
            int i = MathHelper.getRandomIntegerInRange(p_186463_3_, 1, itemstack2.stackSize / 2);
            itemstack2.stackSize -= i;
            ItemStack itemstack1 = itemstack2.copy();
            itemstack1.stackSize = i;
            if (itemstack2.stackSize > 1 && p_186463_3_.nextBoolean()) {
                list.add(itemstack2);
            } else {
                p_186463_1_.add(itemstack2);
            }
            if (itemstack1.stackSize > 1 && p_186463_3_.nextBoolean()) {
                list.add(itemstack1);
                continue;
            }
            p_186463_1_.add(itemstack1);
        }
        p_186463_1_.addAll(list);
        Collections.shuffle(p_186463_1_, p_186463_3_);
    }

    private List<Integer> getEmptySlotsRandomized(IInventory p_186459_1_, Random p_186459_2_) {
        ArrayList list = Lists.newArrayList();
        int i = 0;
        while (i < p_186459_1_.getSizeInventory()) {
            if (p_186459_1_.getStackInSlot(i) == null) {
                list.add(i);
            }
            ++i;
        }
        Collections.shuffle(list, p_186459_2_);
        return list;
    }

    public static class Serializer
    implements JsonDeserializer<LootTable>,
    JsonSerializer<LootTable> {
        public LootTable deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            JsonObject jsonobject = JsonUtils.getJsonObject(p_deserialize_1_, "loot table");
            LootPool[] alootpool = JsonUtils.func_188177_a(jsonobject, "pools", new LootPool[0], p_deserialize_3_, LootPool[].class);
            return new LootTable(alootpool);
        }

        public JsonElement serialize(LootTable p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.add("pools", p_serialize_3_.serialize((Object)p_serialize_1_.field_186466_c));
            return jsonobject;
        }
    }
}

