/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.bot;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import net.minecraft.client.main.Main;
import tk.wurst_client.bot.commands.Command;
import tk.wurst_client.bot.commands.CommandManager;

public class WurstBot {
    private static boolean enabled = false;
    private static WurstBot wurstBot;
    private final CommandManager commandManager = new CommandManager();

    public static void main(String[] args) {
        System.out.println("Starting Wurst-Bot...");
        enabled = true;
        wurstBot = new WurstBot();
        Main.main(new String[]{"--version", "mcp", "--accessToken", "0", "--assetsDir", "assets", "--assetIndex", "1.8", "--userProperties", "{}"});
    }

    public void start() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    WurstBot.this.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, "Wurst-Bot").start();
    }

    private void run() throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println();
        System.out.println("           +++++++++++++++++++++++++++++++++++++++++++++++           ");
        System.out.println("       +++#++++##++++#+#+++++++#++######+++++######+#######+++       ");
        System.out.println("     +++++#++++##++++#+#+++++++#++#+++++##++#++++++++++#++++++++     ");
        System.out.println("    +++++++#++#++#++#++#+++++++#++#######++++######++++#+++++++++    ");
        System.out.println("     ++++++#++#++#++#+++#+++++#+++#+++##+++++++++++#+++#++++++++     ");
        System.out.println("       +++++##++++##+++++#####++++#+++++##+++######++++#++++++       ");
        System.out.println("           +++++++++++++++++++++++++++++++++++++++++++++++           ");
        System.out.println();
        System.out.println("Wurst-Bot v3.0pre1");
        System.out.println("Type \"help\" for a list of commands.");
        while (true) {
            String input = br.readLine();
            String commandName = input.split(" ")[0];
            String[] args = input.contains(" ") ? input.substring(input.indexOf(" ") + 1).split(" ") : new String[]{};
            Command command = this.commandManager.getCommandByName(commandName);
            if (command != null) {
                try {
                    command.execute(args);
                }
                catch (Command.SyntaxError e) {
                    if (e.getMessage() != null) {
                        System.err.println("Syntax error: " + e.getMessage());
                    } else {
                        System.err.println("Syntax error!");
                    }
                    command.printSyntax();
                }
                catch (Command.Error e) {
                    System.err.println(e.getMessage());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            System.err.println("\"" + commandName + "\" is not a valid command.");
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static WurstBot getBot() {
        return wurstBot;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }
}

