/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.bot.commands;

import tk.wurst_client.bot.commands.Command;
import tk.wurst_client.utils.MiscUtils;

@Command.Info(help="Changes the proxy used for server connections. Must be a SOCKS proxy.", name="proxy", syntax={"<ip>:<port>", "none"})
public class ProxyCmd
extends Command {
    @Override
    public void execute(String[] args) throws Command.Error {
        if (args.length < 1 || args.length > 2) {
            this.syntaxError();
        }
        if (args[0].contains(":")) {
            String ip = args[0].split(":")[0];
            String portSring = args[0].split(":")[1];
            if (!MiscUtils.isInteger(portSring)) {
                this.syntaxError("Invalid port: " + portSring);
            }
            try {
                System.setProperty("socksProxyHost", ip);
                System.setProperty("socksProxyPort", portSring);
            }
            catch (Exception e) {
                this.error(e.getMessage());
            }
        } else if (args[0].equalsIgnoreCase("none")) {
            System.setProperty("socksProxyHost", "");
            System.setProperty("socksProxyPort", "");
        } else {
            this.syntaxError("Not a proxy: " + args[0]);
        }
        System.out.println("Proxy set to " + args[0]);
    }
}

