/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.capes;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import javax.net.ssl.HttpsURLConnection;
import net.minecraft.client.resources.SkinManager;
import tk.wurst_client.capes.CapeFetcher;
import tk.wurst_client.utils.JsonUtils;

public class WurstCapes {
    private static JsonObject capes;
    private static CapeFetcher capeFetcher;

    public static void checkCape(GameProfile player, HashMap skinManagerMap, SkinManager.SkinAvailableCallback callback) {
        if (capes == null) {
            try {
                HttpsURLConnection connection = (HttpsURLConnection)new URL("https://www.wurst-client.tk/api/v1/capes.json").openConnection();
                connection.connect();
                capes = JsonUtils.jsonParser.parse((Reader)new InputStreamReader(connection.getInputStream())).getAsJsonObject();
            }
            catch (Exception e) {
                System.err.println("[Wurst] Failed to load capes from wurst-client.tk!");
                e.printStackTrace();
                return;
            }
        }
        if (capes.has("use_new_server") && capes.get("use_new_server").getAsBoolean()) {
            try {
                String uuid = player.getId().toString().replace("-", "");
                if (capeFetcher == null || !capeFetcher.addUUID(uuid, callback)) {
                    capeFetcher = new CapeFetcher();
                    capeFetcher.addUUID(uuid, callback);
                    new Thread(capeFetcher).start();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                if (capes.has(player.getName())) {
                    skinManagerMap.put(MinecraftProfileTexture.Type.CAPE, new MinecraftProfileTexture(capes.get(player.getName()).getAsString(), null));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

