/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.commands;

import tk.wurst_client.commands.Cmd;
import tk.wurst_client.events.ChatInputEvent;
import tk.wurst_client.events.listeners.ChatInputListener;

@Cmd.Info(help="Annoys a player by repeating everything he says.", name="annoy", syntax={"[<player>]"})
public class AnnoyCmd
extends Cmd
implements ChatInputListener {
    private boolean toggled;
    private String name;

    @Override
    public void execute(String[] args) throws Cmd.Error {
        boolean bl = this.toggled = !this.toggled;
        if (this.toggled) {
            if (args.length == 1) {
                this.name = args[0];
                AnnoyCmd.wurst.chat.message("Now annoying " + this.name + ".");
                if (this.name.equals(AnnoyCmd.mc.thePlayer.getName())) {
                    AnnoyCmd.wurst.chat.warning("Annoying yourself is a bad idea!");
                }
                AnnoyCmd.wurst.events.add(ChatInputListener.class, this);
            } else {
                this.toggled = false;
                this.syntaxError();
            }
        } else {
            AnnoyCmd.wurst.events.remove(ChatInputListener.class, this);
            if (this.name != null) {
                AnnoyCmd.wurst.chat.message("No longer annoying " + this.name + ".");
                this.name = null;
            }
        }
    }

    @Override
    public void onReceivedMessage(ChatInputEvent event) {
        String message = new String(event.getComponent().getUnformattedText());
        if (message.startsWith("\u00a7c[\u00a76Wurst\u00a7c]\u00a7f ")) {
            return;
        }
        if (message.startsWith("<" + this.name + ">") || message.contains(String.valueOf(this.name) + ">")) {
            String repeatMessage = message.substring(message.indexOf(">") + 1);
            AnnoyCmd.mc.thePlayer.sendChatMessage(repeatMessage);
        } else if (message.contains("] " + this.name + ":") || message.contains("]" + this.name + ":")) {
            String repeatMessage = message.substring(message.indexOf(":") + 1);
            AnnoyCmd.mc.thePlayer.sendChatMessage(repeatMessage);
        }
    }
}

