/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.commands;

import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.gui.inventory.GuiInventory;
import tk.wurst_client.commands.Cmd;
import tk.wurst_client.events.listeners.RenderListener;

@Cmd.Info(help="Allows you to see parts of another player's inventory.", name="invsee", syntax={"<player>"})
public class InvseeCmd
extends Cmd
implements RenderListener {
    private String playerName;

    @Override
    public void execute(String[] args) throws Cmd.Error {
        if (args.length != 1) {
            this.syntaxError();
        }
        if (InvseeCmd.mc.thePlayer.capabilities.isCreativeMode) {
            InvseeCmd.wurst.chat.error("Survival mode only.");
            return;
        }
        this.playerName = args[0];
        InvseeCmd.wurst.events.add(RenderListener.class, this);
    }

    @Override
    public void onRender() {
        boolean found = false;
        for (Object entity : InvseeCmd.mc.theWorld.loadedEntityList) {
            EntityOtherPlayerMP player;
            if (!(entity instanceof EntityOtherPlayerMP) || !(player = (EntityOtherPlayerMP)entity).getName().equals(this.playerName)) continue;
            InvseeCmd.wurst.chat.message("Showing inventory of " + player.getName() + ".");
            mc.displayGuiScreen(new GuiInventory(player));
            found = true;
        }
        if (!found) {
            InvseeCmd.wurst.chat.error("Player not found.");
        }
        this.playerName = null;
        InvseeCmd.wurst.events.remove(RenderListener.class, this);
    }
}

