/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.commands;

import net.minecraft.network.play.client.CPacketChatMessage;
import net.minecraft.network.play.client.CPacketPlayer;
import net.minecraft.network.play.client.CPacketUseEntity;
import net.minecraft.util.EnumHand;
import tk.wurst_client.commands.Cmd;
import tk.wurst_client.events.ChatOutputEvent;

@Cmd.Info(help="Leaves the current server or changes the mode of AutoLeave.", name="leave", syntax={"[chars|tp|selfhurt|quit]", "mode chars|tp|selfhurt|quit"})
public class LeaveCmd
extends Cmd {
    @Override
    public void execute(String[] args) throws Cmd.Error {
        if (args.length > 2) {
            this.syntaxError();
        }
        if (mc.isIntegratedServerRunning() && LeaveCmd.mc.thePlayer.sendQueue.getPlayerInfoMap().size() == 1) {
            this.error("Cannot leave server when in singleplayer.");
        }
        switch (args.length) {
            case 0: {
                this.disconnectWithMode(LeaveCmd.wurst.mods.autoLeaveMod.getMode());
                break;
            }
            case 1: {
                if (args[0].equalsIgnoreCase("taco")) {
                    int i = 0;
                    while (i < 128) {
                        LeaveCmd.mc.thePlayer.sendAutomaticChatMessage("Taco!");
                        ++i;
                    }
                    break;
                }
                this.disconnectWithMode(this.parseMode(args[0]));
                break;
            }
            case 2: {
                LeaveCmd.wurst.mods.autoLeaveMod.setMode(this.parseMode(args[1]));
                LeaveCmd.wurst.files.saveOptions();
                LeaveCmd.wurst.chat.message("AutoLeave mode set to \"" + args[1] + "\".");
                break;
            }
        }
    }

    @Override
    public String getPrimaryAction() {
        return "Leave";
    }

    @Override
    public void doPrimaryAction() {
        LeaveCmd.wurst.commands.onSentMessage(new ChatOutputEvent(".leave", true));
    }

    private void disconnectWithMode(int mode) {
        switch (mode) {
            case 0: {
                LeaveCmd.mc.theWorld.sendQuittingDisconnectingPacket();
                break;
            }
            case 1: {
                LeaveCmd.mc.thePlayer.sendQueue.addToSendQueue(new CPacketChatMessage("\u00a7"));
                break;
            }
            case 2: {
                LeaveCmd.mc.thePlayer.sendQueue.addToSendQueue(new CPacketPlayer.C04PacketPlayerPosition(3.1E7, 100.0, 3.1E7, false));
            }
            case 3: {
                LeaveCmd.mc.thePlayer.sendQueue.addToSendQueue(new CPacketUseEntity(LeaveCmd.mc.thePlayer, EnumHand.MAIN_HAND));
                break;
            }
        }
    }

    private int parseMode(String input) throws Cmd.SyntaxError {
        String[] modeNames = LeaveCmd.wurst.mods.autoLeaveMod.getModes();
        int i = 0;
        while (i < modeNames.length) {
            if (input.equals(modeNames[i].toLowerCase())) {
                return i;
            }
            ++i;
        }
        this.syntaxError("Invalid mode: " + input);
        return 0;
    }
}

