/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.commands;

import java.util.Iterator;
import tk.wurst_client.commands.Cmd;
import tk.wurst_client.navigator.NavigatorItem;
import tk.wurst_client.navigator.settings.ModeSetting;
import tk.wurst_client.navigator.settings.NavigatorSetting;

@Cmd.Info(help="Changes a mode setting of a feature. Allows you to\nswitch modes through keybinds.", name="setmode", syntax={"<feature> <mode_setting> (<mode>|next|prev)"})
public class SetModeCmd
extends Cmd {
    @Override
    public void execute(String[] args) throws Cmd.Error {
        if (args.length != 3) {
            this.syntaxError();
        }
        NavigatorItem feature = null;
        String featureName = args[0];
        Iterator<NavigatorItem> itr = SetModeCmd.wurst.navigator.iterator();
        while (itr.hasNext()) {
            NavigatorItem item = itr.next();
            if (!featureName.equalsIgnoreCase(item.getName())) continue;
            feature = item;
            break;
        }
        if (feature == null) {
            this.error("A feature named \"" + featureName + "\" could not be found.");
        }
        NavigatorSetting setting = null;
        String settingName = args[1].replace("_", " ");
        for (NavigatorSetting featureSetting : feature.getSettings()) {
            if (!featureSetting.getName().equalsIgnoreCase(settingName)) continue;
            setting = featureSetting;
            break;
        }
        if (setting == null) {
            this.error("A setting named \"" + settingName + "\" could not be found in " + feature.getName() + ".");
        }
        if (!(setting instanceof ModeSetting)) {
            this.error(String.valueOf(feature.getName()) + " " + setting.getName() + " is not a mode setting.");
        }
        ModeSetting modeSetting = (ModeSetting)setting;
        String modeName = args[2];
        if (modeName.equalsIgnoreCase("next")) {
            modeSetting.nextMode();
        } else if (modeName.equalsIgnoreCase("prev")) {
            modeSetting.prevMode();
        } else {
            int mode = modeSetting.indexOf(modeName);
            if (mode == -1) {
                this.error("A " + feature.getName() + " " + setting.getName() + " named \"" + modeName + "\" could not be found.");
            }
            modeSetting.setSelected(mode);
        }
    }
}

