/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.files;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import tk.wurst_client.WurstClient;
import tk.wurst_client.alts.Alt;
import tk.wurst_client.alts.Encryption;
import tk.wurst_client.files.DefaultAutoBuildTemplates;
import tk.wurst_client.gui.alts.GuiAltList;
import tk.wurst_client.mods.AntiAfkMod;
import tk.wurst_client.mods.ArenaBrawlMod;
import tk.wurst_client.mods.AutoBuildMod;
import tk.wurst_client.mods.AutoSignMod;
import tk.wurst_client.mods.BlinkMod;
import tk.wurst_client.mods.FightBotMod;
import tk.wurst_client.mods.FollowMod;
import tk.wurst_client.mods.ForceOpMod;
import tk.wurst_client.mods.FreecamMod;
import tk.wurst_client.mods.InvisibilityMod;
import tk.wurst_client.mods.LsdMod;
import tk.wurst_client.mods.MassTpaMod;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.mods.ProtectMod;
import tk.wurst_client.mods.RemoteViewMod;
import tk.wurst_client.mods.SpammerMod;
import tk.wurst_client.mods.XRayMod;
import tk.wurst_client.navigator.Navigator;
import tk.wurst_client.navigator.NavigatorItem;
import tk.wurst_client.navigator.settings.NavigatorSetting;
import tk.wurst_client.options.FriendsList;
import tk.wurst_client.options.OptionsManager;
import tk.wurst_client.utils.JsonUtils;
import tk.wurst_client.utils.XRayUtils;

public class FileManager {
    public final File wurstDir;
    public final File autobuildDir;
    public final File skinDir;
    public final File serverlistsDir;
    public final File spamDir;
    public final File scriptsDir;
    public final File alts;
    public final File friends;
    public final File modules;
    public final File navigatorData;
    public final File keybinds;
    public final File options;
    public final File autoMaximize;
    public final File xray;
    private HashSet<String> modBlacklist;

    public FileManager() {
        this.wurstDir = new File(Minecraft.getMinecraft().mcDataDir, "wurst");
        this.autobuildDir = new File(this.wurstDir, "autobuild");
        this.skinDir = new File(this.wurstDir, "skins");
        this.serverlistsDir = new File(this.wurstDir, "serverlists");
        this.spamDir = new File(this.wurstDir, "spam");
        this.scriptsDir = new File(this.spamDir, "autorun");
        this.alts = new File(this.wurstDir, "alts.json");
        this.friends = new File(this.wurstDir, "friends.json");
        this.modules = new File(this.wurstDir, "modules.json");
        this.navigatorData = new File(this.wurstDir, "navigator.json");
        this.keybinds = new File(this.wurstDir, "keybinds.json");
        this.options = new File(this.wurstDir, "options.json");
        this.autoMaximize = new File(Minecraft.getMinecraft().mcDataDir + "/wurst/automaximize.json");
        this.xray = new File(this.wurstDir, "xray.json");
        this.modBlacklist = Sets.newHashSet((Object[])new String[]{AntiAfkMod.class.getName(), BlinkMod.class.getName(), ArenaBrawlMod.class.getName(), AutoBuildMod.class.getName(), AutoSignMod.class.getName(), FightBotMod.class.getName(), FollowMod.class.getName(), ForceOpMod.class.getName(), FreecamMod.class.getName(), InvisibilityMod.class.getName(), LsdMod.class.getName(), MassTpaMod.class.getName(), ProtectMod.class.getName(), RemoteViewMod.class.getName(), SpammerMod.class.getName()});
    }

    public void init() {
        if (!this.wurstDir.exists()) {
            this.wurstDir.mkdir();
        }
        if (!this.autobuildDir.exists()) {
            this.autobuildDir.mkdir();
        }
        if (!this.spamDir.exists()) {
            this.spamDir.mkdir();
        }
        if (!this.scriptsDir.exists()) {
            this.scriptsDir.mkdir();
        }
        if (!this.skinDir.exists()) {
            this.skinDir.mkdir();
        }
        if (!this.serverlistsDir.exists()) {
            this.serverlistsDir.mkdir();
        }
        if (!this.options.exists()) {
            this.saveOptions();
        } else {
            this.loadOptions();
        }
        if (!this.modules.exists()) {
            this.saveMods();
        } else {
            this.loadMods();
        }
        if (!this.keybinds.exists()) {
            this.saveKeybinds();
        } else {
            this.loadKeybinds();
        }
        if (!this.navigatorData.exists()) {
            this.saveNavigatorData();
        } else {
            this.loadNavigatorData();
        }
        if (!this.alts.exists()) {
            this.saveAlts();
        } else {
            this.loadAlts();
        }
        if (!this.friends.exists()) {
            this.saveFriends();
        } else {
            this.loadFriends();
        }
        if (!this.xray.exists()) {
            XRayUtils.initXRayBlocks();
            this.saveXRayBlocks();
        } else {
            this.loadXRayBlocks();
        }
        File[] autobuildFiles = this.autobuildDir.listFiles();
        if (autobuildFiles != null && autobuildFiles.length == 0) {
            this.createDefaultAutoBuildTemplates();
        }
        this.loadAutoBuildTemplates();
        AutoBuildMod autoBuildMod = WurstClient.INSTANCE.mods.autoBuildMod;
        autoBuildMod.initTemplateSetting();
        if (autoBuildMod.getTemplate() >= AutoBuildMod.names.size()) {
            autoBuildMod.setTemplate(0);
            this.saveNavigatorData();
        }
    }

    public void saveMods() {
        try {
            JsonObject json = new JsonObject();
            for (Mod mod : WurstClient.INSTANCE.mods.getAllMods()) {
                JsonObject jsonMod = new JsonObject();
                jsonMod.addProperty("enabled", Boolean.valueOf(mod.isEnabled()));
                json.add(mod.getName(), (JsonElement)jsonMod);
            }
            PrintWriter save = new PrintWriter(new FileWriter(this.modules));
            save.println(JsonUtils.prettyGson.toJson((JsonElement)json));
            save.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isModBlacklisted(Mod mod) {
        return this.modBlacklist.contains(mod.getClass().getName());
    }

    public void loadMods() {
        try {
            BufferedReader load = new BufferedReader(new FileReader(this.modules));
            JsonObject json = (JsonObject)JsonUtils.jsonParser.parse((Reader)load);
            load.close();
            for (Map.Entry entry : json.entrySet()) {
                JsonObject jsonModule;
                boolean enabled;
                Mod mod = WurstClient.INSTANCE.mods.getModByName((String)entry.getKey());
                if (mod == null || mod.getCategory() == Mod.Category.HIDDEN || this.modBlacklist.contains(mod.getClass().getName()) || !(enabled = (jsonModule = (JsonObject)entry.getValue()).get("enabled").getAsBoolean())) continue;
                mod.enableOnStartup();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveKeybinds() {
        try {
            JsonObject json = new JsonObject();
            for (Map.Entry entry : WurstClient.INSTANCE.keybinds.entrySet()) {
                json.addProperty((String)entry.getKey(), (String)entry.getValue());
            }
            PrintWriter save = new PrintWriter(new FileWriter(this.keybinds));
            save.println(JsonUtils.prettyGson.toJson((JsonElement)json));
            save.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadKeybinds() {
        try {
            BufferedReader load = new BufferedReader(new FileReader(this.keybinds));
            JsonObject json = (JsonObject)JsonUtils.jsonParser.parse((Reader)load);
            load.close();
            WurstClient.INSTANCE.keybinds.clear();
            for (Map.Entry entry : json.entrySet()) {
                WurstClient.INSTANCE.keybinds.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveNavigatorData() {
        try {
            final JsonObject json = new JsonObject();
            final Navigator navigator = WurstClient.INSTANCE.navigator;
            navigator.forEach(new Consumer<NavigatorItem>(){

                @Override
                public void accept(NavigatorItem item) {
                    JsonObject jsonFeature = new JsonObject();
                    long preference = navigator.getPreference(item.getName());
                    if (preference != 0L) {
                        jsonFeature.addProperty("preference", (Number)preference);
                    }
                    if (!item.getSettings().isEmpty()) {
                        JsonObject jsonSettings = new JsonObject();
                        for (NavigatorSetting setting : item.getSettings()) {
                            try {
                                setting.save(jsonSettings);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        jsonFeature.add("settings", (JsonElement)jsonSettings);
                    }
                    if (!jsonFeature.entrySet().isEmpty()) {
                        json.add(item.getName(), (JsonElement)jsonFeature);
                    }
                }
            });
            PrintWriter save = new PrintWriter(new FileWriter(this.navigatorData));
            save.println(JsonUtils.prettyGson.toJson((JsonElement)json));
            save.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadNavigatorData() {
        try {
            BufferedReader load = new BufferedReader(new FileReader(this.navigatorData));
            final JsonObject json = (JsonObject)JsonUtils.jsonParser.parse((Reader)load);
            load.close();
            final Navigator navigator = WurstClient.INSTANCE.navigator;
            navigator.forEach(new Consumer<NavigatorItem>(){

                @Override
                public void accept(NavigatorItem item) {
                    String itemName = item.getName();
                    if (!json.has(itemName)) {
                        return;
                    }
                    JsonObject jsonFeature = json.get(itemName).getAsJsonObject();
                    if (jsonFeature.has("preference")) {
                        navigator.setPreference(itemName, jsonFeature.get("preference").getAsLong());
                    }
                    if (jsonFeature.has("settings")) {
                        JsonObject jsonSettings = jsonFeature.get("settings").getAsJsonObject();
                        for (NavigatorSetting setting : item.getSettings()) {
                            try {
                                setting.load(jsonSettings);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveOptions() {
        try {
            PrintWriter save = new PrintWriter(new FileWriter(this.options));
            save.println(JsonUtils.prettyGson.toJson((Object)WurstClient.INSTANCE.options));
            save.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadOptions() {
        try {
            BufferedReader load = new BufferedReader(new FileReader(this.options));
            WurstClient.INSTANCE.options = (OptionsManager)JsonUtils.gson.fromJson((Reader)load, OptionsManager.class);
            load.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean loadAutoMaximize() {
        boolean autoMaximizeEnabled = false;
        if (!this.autoMaximize.exists()) {
            this.saveAutoMaximize(true);
        }
        try {
            BufferedReader load = new BufferedReader(new FileReader(this.autoMaximize));
            autoMaximizeEnabled = (Boolean)JsonUtils.gson.fromJson((Reader)load, Boolean.class) != false && !Minecraft.isRunningOnMac;
            load.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return autoMaximizeEnabled;
    }

    public void saveAutoMaximize(boolean autoMaximizeEnabled) {
        try {
            if (!this.autoMaximize.getParentFile().exists()) {
                this.autoMaximize.getParentFile().mkdirs();
            }
            PrintWriter save = new PrintWriter(new FileWriter(this.autoMaximize));
            save.println(JsonUtils.prettyGson.toJson((Object)autoMaximizeEnabled));
            save.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveAlts() {
        try {
            JsonObject json = new JsonObject();
            for (Alt alt : GuiAltList.alts) {
                JsonObject jsonAlt = new JsonObject();
                jsonAlt.addProperty("name", alt.getName());
                jsonAlt.addProperty("password", alt.getPassword());
                jsonAlt.addProperty("cracked", Boolean.valueOf(alt.isCracked()));
                jsonAlt.addProperty("starred", Boolean.valueOf(alt.isStarred()));
                json.add(alt.getEmail(), (JsonElement)jsonAlt);
            }
            Files.write(this.alts.toPath(), Encryption.encrypt(JsonUtils.prettyGson.toJson((JsonElement)json)).getBytes("UTF-8"), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadAlts() {
        try {
            JsonObject json = (JsonObject)JsonUtils.jsonParser.parse(Encryption.decrypt(new String(Files.readAllBytes(this.alts.toPath()), "UTF-8")));
            GuiAltList.alts.clear();
            for (Map.Entry entry : json.entrySet()) {
                boolean starred;
                JsonObject jsonAlt = ((JsonElement)entry.getValue()).getAsJsonObject();
                String email = (String)entry.getKey();
                String name = jsonAlt.get("name") == null ? "" : jsonAlt.get("name").getAsString();
                String password = jsonAlt.get("password") == null ? "" : jsonAlt.get("password").getAsString();
                boolean cracked = jsonAlt.get("cracked") == null ? true : jsonAlt.get("cracked").getAsBoolean();
                boolean bl = starred = jsonAlt.get("starred") == null ? false : jsonAlt.get("starred").getAsBoolean();
                if (cracked) {
                    GuiAltList.alts.add(new Alt(email, starred));
                    continue;
                }
                GuiAltList.alts.add(new Alt(email, name, password, starred));
            }
            GuiAltList.sortAlts();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveFriends() {
        try {
            PrintWriter save = new PrintWriter(new FileWriter(this.friends));
            save.println(JsonUtils.prettyGson.toJson((Object)WurstClient.INSTANCE.friends));
            save.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadFriends() {
        try {
            BufferedReader load = new BufferedReader(new FileReader(this.friends));
            WurstClient.INSTANCE.friends = (FriendsList)JsonUtils.gson.fromJson((Reader)load, FriendsList.class);
            load.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveXRayBlocks() {
        try {
            XRayUtils.sortBlocks();
            JsonArray json = new JsonArray();
            int i = 0;
            while (i < XRayMod.xrayBlocks.size()) {
                json.add(JsonUtils.prettyGson.toJsonTree((Object)Block.getIdFromBlock(XRayMod.xrayBlocks.get(i))));
                ++i;
            }
            PrintWriter save = new PrintWriter(new FileWriter(this.xray));
            save.println(JsonUtils.prettyGson.toJson((JsonElement)json));
            save.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadXRayBlocks() {
        try {
            BufferedReader load = new BufferedReader(new FileReader(this.xray));
            JsonArray json = JsonUtils.jsonParser.parse((Reader)load).getAsJsonArray();
            load.close();
            Iterator itr = json.iterator();
            while (itr.hasNext()) {
                try {
                    String jsonBlock = ((JsonElement)itr.next()).getAsString();
                    XRayMod.xrayBlocks.add(Block.getBlockFromName(jsonBlock));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            XRayUtils.sortBlocks();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createDefaultAutoBuildTemplates() {
        try {
            String[] comment = new String[]{"Copyright \u00a9 2014 - 2016 | Wurst-Imperium | All rights reserved.", "This Source Code Form is subject to the terms of the Mozilla Public", "License, v. 2.0. If a copy of the MPL was not distributed with this", "file, You can obtain one at http://mozilla.org/MPL/2.0/."};
            for (Map.Entry entry : new DefaultAutoBuildTemplates().entrySet()) {
                JsonObject json = new JsonObject();
                json.add("__comment", JsonUtils.prettyGson.toJsonTree((Object)comment, String[].class));
                json.add("blocks", JsonUtils.prettyGson.toJsonTree(entry.getValue(), int[][].class));
                PrintWriter save = new PrintWriter(new FileWriter(new File(this.autobuildDir, String.valueOf((String)entry.getKey()) + ".json")));
                save.println(JsonUtils.prettyGson.toJson((JsonElement)json));
                save.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadAutoBuildTemplates() {
        try {
            File[] files = this.autobuildDir.listFiles();
            if (files == null) {
                return;
            }
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                BufferedReader load = new BufferedReader(new FileReader(file));
                JsonObject json = (JsonObject)JsonUtils.jsonParser.parse((Reader)load);
                load.close();
                AutoBuildMod.templates.add((int[][])JsonUtils.gson.fromJson(json.get("blocks"), int[][].class));
                AutoBuildMod.names.add(file.getName().substring(0, file.getName().indexOf(".json")));
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

