/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.gui.multiplayer;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import org.lwjgl.input.Keyboard;
import tk.wurst_client.WurstClient;
import tk.wurst_client.utils.MiscUtils;

public class GuiUseProxy
extends GuiScreen {
    private GuiMultiplayer prevMenu;
    private GuiTextField proxyBox;
    private String error = "";

    public GuiUseProxy(GuiMultiplayer prevMultiplayerMenu) {
        this.prevMenu = prevMultiplayerMenu;
    }

    @Override
    public void updateScreen() {
        this.proxyBox.updateCursorCounter();
    }

    @Override
    public void initGui() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonList.clear();
        this.buttonList.add(new GuiButton(0, this.width / 2 - 100, this.height / 4 + 120 + 12, "Cancel"));
        this.buttonList.add(new GuiButton(1, this.width / 2 - 100, this.height / 4 + 72 + 12, "Connect"));
        this.buttonList.add(new GuiButton(2, this.width / 2 - 100, this.height / 4 + 96 + 12, "Reset"));
        this.proxyBox = new GuiTextField(0, this.fontRendererObj, this.width / 2 - 100, 60, 200, 20);
        this.proxyBox.setFocused(true);
        WurstClient.INSTANCE.analytics.trackPageView("/multiplayer/use-proxy", "Use Proxy");
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    protected void actionPerformed(GuiButton clickedButton) {
        if (clickedButton.enabled) {
            if (clickedButton.id == 0) {
                WurstClient.INSTANCE.analytics.trackEvent("use proxy", "cancel");
                this.mc.displayGuiScreen(this.prevMenu);
            } else if (clickedButton.id == 1) {
                WurstClient.INSTANCE.analytics.trackEvent("use proxy", "connect");
                if (!this.proxyBox.getText().contains(":") || this.proxyBox.getText().split(":").length != 2) {
                    WurstClient.INSTANCE.analytics.trackEvent("use proxy", "error", "not a proxy");
                    this.error = "Not a proxy!";
                    return;
                }
                String[] parts = this.proxyBox.getText().split(":");
                if (!MiscUtils.isInteger(parts[1]) || Integer.parseInt(parts[1]) > 65536 || Integer.parseInt(parts[1]) < 0) {
                    WurstClient.INSTANCE.analytics.trackEvent("use proxy", "error", "invalid port");
                    this.error = "Invalid port!";
                    return;
                }
                try {
                    System.setProperty("socksProxyHost", parts[0]);
                    System.setProperty("socksProxyPort", parts[1]);
                }
                catch (Exception e) {
                    WurstClient.INSTANCE.analytics.trackEvent("use proxy", "exception", e.toString());
                    this.error = e.toString();
                    return;
                }
                if (this.error.isEmpty()) {
                    WurstClient.INSTANCE.analytics.trackEvent("use proxy", "success");
                    this.mc.displayGuiScreen(this.prevMenu);
                } else {
                    WurstClient.INSTANCE.analytics.trackEvent("use proxy", "error", this.error);
                }
            } else if (clickedButton.id == 2) {
                WurstClient.INSTANCE.analytics.trackEvent("use proxy", "reset");
                System.setProperty("socksProxyHost", "");
                System.setProperty("socksProxyPort", "");
                this.mc.displayGuiScreen(this.prevMenu);
            }
        }
    }

    @Override
    protected void keyTyped(char par1, int par2) {
        this.proxyBox.textboxKeyTyped(par1, par2);
        if (par2 == 28 || par2 == 156) {
            this.actionPerformed((GuiButton)this.buttonList.get(1));
        }
    }

    @Override
    protected void mouseClicked(int par1, int par2, int par3) throws IOException {
        super.mouseClicked(par1, par2, par3);
        this.proxyBox.mouseClicked(par1, par2, par3);
        if (this.proxyBox.isFocused()) {
            this.error = "";
        }
    }

    @Override
    public void drawScreen(int par1, int par2, float par3) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRendererObj, "Use Proxy", this.width / 2, 20, 0xFFFFFF);
        this.drawString(this.fontRendererObj, "IP:Port (must be a SOCKS proxy)", this.width / 2 - 100, 47, 0xA0A0A0);
        this.drawCenteredString(this.fontRendererObj, this.error, this.width / 2, 87, 0xFF0000);
        String currentProxy = String.valueOf(System.getProperty("socksProxyHost")) + ":" + System.getProperty("socksProxyPort");
        if (currentProxy.equals(":") || currentProxy.equals("null:null")) {
            currentProxy = "none";
        }
        this.drawString(this.fontRendererObj, "Current proxy: " + currentProxy, this.width / 2 - 100, 97, 0xA0A0A0);
        this.proxyBox.drawTextBox();
        super.drawScreen(par1, par2, par3);
    }
}

