/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import tk.wurst_client.WurstClient;
import tk.wurst_client.gui.error.GuiError;
import tk.wurst_client.navigator.NavigatorItem;
import tk.wurst_client.navigator.PossibleKeybind;
import tk.wurst_client.navigator.settings.NavigatorSetting;

public class Mod
implements NavigatorItem {
    private final String name = this.getClass().getAnnotation(Info.class).name();
    private final String description = this.getClass().getAnnotation(Info.class).description();
    private final Category category = this.getClass().getAnnotation(Info.class).category();
    private final String tags = this.getClass().getAnnotation(Info.class).tags();
    private final String tutorial = this.getClass().getAnnotation(Info.class).tutorial();
    private boolean enabled;
    private boolean blocked;
    private boolean active;
    protected ArrayList<NavigatorSetting> settings = new ArrayList();
    private long currentMS = 0L;
    protected long lastMS = -1L;
    protected static final WurstClient wurst = WurstClient.INSTANCE;
    protected static final Minecraft mc = Minecraft.getMinecraft();

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getType() {
        return "Mod";
    }

    public String getRenderName() {
        return this.name;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final String getTags() {
        return this.tags;
    }

    @Override
    public final ArrayList<NavigatorSetting> getSettings() {
        return this.settings;
    }

    @Override
    public final ArrayList<PossibleKeybind> getPossibleKeybinds() {
        String dotT = ".t " + this.name.toLowerCase();
        ArrayList<PossibleKeybind> possibleKeybinds = new ArrayList<PossibleKeybind>(Arrays.asList(new PossibleKeybind(dotT, "Toggle " + this.name), new PossibleKeybind(String.valueOf(dotT) + " on", "Enable " + this.name), new PossibleKeybind(String.valueOf(dotT) + " off", "Disable " + this.name)));
        for (NavigatorSetting setting : this.settings) {
            possibleKeybinds.addAll(setting.getPossibleKeybinds(this.name));
        }
        return possibleKeybinds;
    }

    @Override
    public final String getPrimaryAction() {
        return this.enabled ? "Disable" : "Enable";
    }

    @Override
    public final void doPrimaryAction() {
        this.toggle();
    }

    @Override
    public final String getTutorialPage() {
        return this.tutorial;
    }

    @Override
    public NavigatorItem[] getSeeAlso() {
        return new NavigatorItem[0];
    }

    public final Category getCategory() {
        return this.category;
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    public final boolean isActive() {
        return this.active;
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
        boolean bl = this.active = enabled && !this.blocked;
        if (this.blocked && enabled) {
            return;
        }
        try {
            this.onToggle();
        }
        catch (Exception e) {
            Minecraft.getMinecraft().displayGuiScreen(new GuiError(e, this, "toggling", "Mod was toggled " + (enabled ? "on" : "off") + "."));
        }
        if (enabled) {
            try {
                this.onEnable();
            }
            catch (Exception e) {
                Minecraft.getMinecraft().displayGuiScreen(new GuiError(e, this, "enabling", ""));
            }
        } else {
            try {
                this.onDisable();
            }
            catch (Exception e) {
                Minecraft.getMinecraft().displayGuiScreen(new GuiError(e, this, "disabling", ""));
            }
        }
        if (!WurstClient.INSTANCE.files.isModBlacklisted(this)) {
            WurstClient.INSTANCE.files.saveMods();
        }
    }

    public final void enableOnStartup() {
        this.enabled = true;
        this.active = this.enabled && !this.blocked;
        try {
            this.onToggle();
        }
        catch (Exception e) {
            Minecraft.getMinecraft().displayGuiScreen(new GuiError(e, this, "toggling", "Mod was toggled " + (this.enabled ? "on" : "off") + "."));
        }
        try {
            this.onEnable();
        }
        catch (Exception e) {
            Minecraft.getMinecraft().displayGuiScreen(new GuiError(e, this, "enabling", ""));
        }
    }

    public final void toggle() {
        this.setEnabled(!this.isEnabled());
    }

    @Override
    public boolean isBlocked() {
        return this.blocked;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
        boolean bl = this.active = this.enabled && !blocked;
        if (this.enabled) {
            try {
                this.onToggle();
            }
            catch (Exception e) {
                Minecraft.getMinecraft().displayGuiScreen(new GuiError(e, this, "toggling", "Mod was toggled " + (blocked ? "off" : "on") + "."));
            }
            try {
                if (blocked) {
                    this.onDisable();
                } else {
                    this.onEnable();
                }
            }
            catch (Exception e) {
                Minecraft.getMinecraft().displayGuiScreen(new GuiError(e, this, blocked ? "disabling" : "enabling", ""));
            }
        }
    }

    public final void noCheatMessage() {
        WurstClient.INSTANCE.chat.warning(String.valueOf(this.name) + " cannot bypass NoCheat+.");
    }

    public final void updateMS() {
        this.currentMS = System.currentTimeMillis();
    }

    public final void updateLastMS() {
        this.lastMS = System.currentTimeMillis();
    }

    public final boolean hasTimePassedM(long MS) {
        return this.currentMS >= this.lastMS + MS;
    }

    public final boolean hasTimePassedS(float speed) {
        return this.currentMS >= this.lastMS + (long)(1000.0f / speed);
    }

    public void onToggle() {
    }

    public void onEnable() {
    }

    public void onDisable() {
    }

    public void initSettings() {
    }

    public static enum Category {
        AUTOBUILD,
        BLOCKS,
        CHAT,
        COMBAT,
        EXPLOITS,
        FUN,
        HIDDEN,
        RENDER,
        MISC,
        MOVEMENT;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Info {
        public String name();

        public String description();

        public Category category();

        public boolean noCheatCompatible() default true;

        public String tags() default "";

        public String tutorial() default "";
    }
}

