/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.navigator.settings;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import tk.wurst_client.WurstClient;
import tk.wurst_client.navigator.PossibleKeybind;
import tk.wurst_client.navigator.gui.NavigatorFeatureScreen;
import tk.wurst_client.navigator.settings.NavigatorSetting;

public class CheckboxSetting
implements NavigatorSetting {
    private String name;
    private boolean checked;

    public CheckboxSetting(String name, boolean checked) {
        this.name = name;
        this.checked = checked;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void addToFeatureScreen(NavigatorFeatureScreen featureScreen) {
        featureScreen.addText("\n\n");
        NavigatorFeatureScreen navigatorFeatureScreen = featureScreen;
        navigatorFeatureScreen.getClass();
        featureScreen.addCheckbox(new NavigatorFeatureScreen.CheckboxData(navigatorFeatureScreen, this.name, this.checked, 60 + featureScreen.getTextHeight() - 8){

            @Override
            public void toggle() {
                CheckboxSetting.this.setChecked(this.checked);
                WurstClient.INSTANCE.files.saveNavigatorData();
            }
        });
    }

    @Override
    public ArrayList<PossibleKeybind> getPossibleKeybinds(String featureName) {
        ArrayList<PossibleKeybind> possibleKeybinds = new ArrayList<PossibleKeybind>();
        String fullName = String.valueOf(featureName) + " " + this.name;
        String command = ".setcheckbox " + featureName.toLowerCase() + " " + this.name.toLowerCase().replace(" ", "_") + " ";
        possibleKeybinds.add(new PossibleKeybind(String.valueOf(command) + "toggle", "Toggle " + fullName));
        possibleKeybinds.add(new PossibleKeybind(String.valueOf(command) + "on", "Enable " + fullName));
        possibleKeybinds.add(new PossibleKeybind(String.valueOf(command) + "off", "Disable " + fullName));
        return possibleKeybinds;
    }

    public final boolean isChecked() {
        return this.checked;
    }

    public final void setChecked(boolean checked) {
        this.checked = checked;
        this.update();
    }

    @Override
    public final void save(JsonObject json) {
        json.addProperty(this.name, Boolean.valueOf(this.checked));
    }

    @Override
    public final void load(JsonObject json) {
        this.checked = json.get(this.name).getAsBoolean();
    }

    @Override
    public void update() {
    }
}

