/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.navigator.settings;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.util.ArrayList;
import tk.wurst_client.navigator.PossibleKeybind;
import tk.wurst_client.navigator.gui.NavigatorFeatureScreen;
import tk.wurst_client.navigator.settings.NavigatorSetting;
import tk.wurst_client.utils.JsonUtils;

public class ColorsSetting
implements NavigatorSetting {
    private String name;
    private boolean[] selected;

    public ColorsSetting(String name, boolean[] selected) {
        if (selected.length != 16) {
            throw new IllegalArgumentException("Length of 'selected' must be 16 but was " + selected.length + " instead.");
        }
        this.name = name;
        this.selected = selected;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final void addToFeatureScreen(NavigatorFeatureScreen featureScreen) {
        featureScreen.addText("\n" + this.name + ":\n\n\n\n\n\n\n");
        int x = featureScreen.getMiddleX() - 104;
        int y = 60 + featureScreen.getTextHeight() - 72;
        String[] colorNames = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        int[] nArray = new int[16];
        nArray[1] = 26316;
        nArray[2] = 52224;
        nArray[3] = 52428;
        nArray[4] = 0xCC0000;
        nArray[5] = 0xCC00CC;
        nArray[6] = 0xFF8800;
        nArray[7] = 0xAAAAAA;
        nArray[8] = 0x666666;
        nArray[9] = 255;
        nArray[10] = 65280;
        nArray[11] = 65535;
        nArray[12] = 0xFF0000;
        nArray[13] = 0xFF8888;
        nArray[14] = 0xFFFF00;
        nArray[15] = 0xFFFFFF;
        int[] colors = nArray;
        class ColorButton
        extends NavigatorFeatureScreen.ButtonData {
            public int index;

            public ColorButton(NavigatorFeatureScreen featureScreen, int x, int y, String displayString, int color, int index) {
                NavigatorFeatureScreen navigatorFeatureScreen = featureScreen;
                navigatorFeatureScreen.getClass();
                super(x, y, 12, 12, displayString, color);
                this.index = index;
                this.textColor = color;
                this.updateColor();
            }

            @Override
            public void press() {
                ColorsSetting.this.setSelected(this.index, !ColorsSetting.this.selected[this.index]);
                this.updateColor();
            }

            public void updateColor() {
                this.color = new Color(ColorsSetting.this.selected[this.index] ? 0xCCCCCC : 0x222222);
            }
        }
        final ColorButton[] buttons = new ColorButton[this.selected.length];
        int i = 0;
        while (i < this.selected.length) {
            ColorButton button;
            switch (i % 4) {
                case 0: {
                    x -= 48;
                    y += 16;
                    break;
                }
                default: {
                    x += 16;
                }
            }
            buttons[i] = button = new ColorButton(featureScreen, x, y, colorNames[i], colors[i], i);
            featureScreen.addButton(button);
            ++i;
        }
        NavigatorFeatureScreen navigatorFeatureScreen = featureScreen;
        navigatorFeatureScreen.getClass();
        featureScreen.addButton(new NavigatorFeatureScreen.ButtonData(navigatorFeatureScreen, x += 16, y -= 48, 48, 12, "All On", 0x404040){
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4, $anonymous5);
            }

            @Override
            public void press() {
                int i = 0;
                while (i < buttons.length) {
                    ((ColorsSetting)ColorsSetting.this).selected[i] = true;
                    buttons[i].updateColor();
                    ++i;
                }
                ColorsSetting.this.update();
            }
        });
        NavigatorFeatureScreen navigatorFeatureScreen2 = featureScreen;
        navigatorFeatureScreen2.getClass();
        featureScreen.addButton(new NavigatorFeatureScreen.ButtonData(navigatorFeatureScreen2, x, y += 16, 48, 12, "All Off", 0x404040){
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4, $anonymous5);
            }

            @Override
            public void press() {
                int i = 0;
                while (i < buttons.length) {
                    ((ColorsSetting)ColorsSetting.this).selected[i] = false;
                    buttons[i].updateColor();
                    ++i;
                }
                ColorsSetting.this.update();
            }
        });
    }

    @Override
    public ArrayList<PossibleKeybind> getPossibleKeybinds(String featureName) {
        return new ArrayList<PossibleKeybind>();
    }

    public boolean[] getSelected() {
        return this.selected;
    }

    public void setSelected(int index, boolean selected) {
        this.selected[index] = selected;
        this.update();
    }

    @Override
    public final void save(JsonObject json) {
        json.add(this.name, JsonUtils.gson.toJsonTree((Object)this.selected));
    }

    @Override
    public final void load(JsonObject json) {
        JsonArray jsonColors = json.get(this.name).getAsJsonArray();
        int i = 0;
        while (i < this.selected.length) {
            this.selected[i] = jsonColors.get(i).getAsBoolean();
            ++i;
        }
    }

    @Override
    public void update() {
    }
}

