/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.command;

import de.paxii.clarinet.Wrapper;
import de.paxii.clarinet.command.AClientCommand;
import de.paxii.clarinet.command.CommandCategory;
import de.paxii.clarinet.command.IClientCommand;
import de.paxii.clarinet.event.EventHandler;
import de.paxii.clarinet.event.events.game.StopGameEvent;
import de.paxii.clarinet.event.events.gui.DisplayGuiScreenEvent;
import de.paxii.clarinet.event.events.player.PlayerSendChatMessageEvent;
import de.paxii.clarinet.gui.menu.chat.GuiChatConsole;
import de.paxii.clarinet.module.Module;
import de.paxii.clarinet.util.chat.Chat;
import de.paxii.clarinet.util.settings.ClientSettings;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiSleepMP;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class ClientConsole {
    private TreeMap<String, AClientCommand> commandList = new TreeMap();

    public ClientConsole() {
        this.addCommands();
        Wrapper.getEventManager().register(this);
    }

    public void reloadCommands() {
        this.addCommands();
    }

    private void addCommands() {
        for (CommandCategory ca : CommandCategory.values()) {
            String packageName = "de.paxii.clarinet.command.commands." + ca.toString().toLowerCase();
            System.out.println("Searching for Commands in " + packageName);
            Reflections reflections = new Reflections(packageName, new Scanner[0]);
            Set<Class<AClientCommand>> allClasses = reflections.getSubTypesOf(AClientCommand.class);
            for (Class<AClientCommand> c : allClasses) {
                try {
                    AClientCommand newCommand = c.newInstance();
                    this.addCommand(newCommand);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }
    }

    public void addCommand(AClientCommand command) {
        if (!this.commandList.containsKey(command.getCommand())) {
            System.out.println("Loading " + command.getCommand() + "...");
            this.commandList.put(command.getCommand(), command);
        }
    }

    public void removeCommand(IClientCommand command) {
        if (this.commandList.containsKey(command.getCommand())) {
            this.commandList.remove(command.getCommand());
        }
    }

    @EventHandler
    public void onChatMessage(PlayerSendChatMessageEvent event) {
        String chatMessage = event.getChatMessage();
        if (chatMessage.startsWith(ClientSettings.getClientSettings().get("client.prefix").getSettingValue())) {
            String[] args;
            String userMessage;
            event.setCancelled(true);
            String userCommand = userMessage = chatMessage.substring(ClientSettings.getClientSettings().get("client.prefix").getSettingValue().length());
            if (userCommand.contains(" ")) {
                userCommand = userCommand.split(" ")[0];
                args = this.getArguments(userCommand, userMessage);
            } else {
                args = new String[]{};
            }
            if (args.length == 1 && args[0].startsWith(" ")) {
                args = new String[]{};
            }
            if (this.commandList.containsKey(userCommand)) {
                for (Map.Entry<String, AClientCommand> clientCommand : this.commandList.entrySet()) {
                    if (!clientCommand.getKey().equalsIgnoreCase(userCommand)) continue;
                    clientCommand.getValue().runCommand(args);
                }
            } else if (Wrapper.getModuleManager().doesModuleExist(userCommand)) {
                Module module = Wrapper.getModuleManager().getModuleIgnoreCase(userCommand);
                if (module.isCommand()) {
                    module.onCommand(args);
                } else {
                    Chat.printChatMessage(module.getName() + " does not have a command!");
                }
            } else {
                Chat.printClientMessage("Unknown command! Type \"" + ClientSettings.getClientSettings().get("client.prefix").getSettingValue() + "help\" for a list of commands.");
            }
        }
    }

    @EventHandler(priority=0)
    public void onDisplayGuiScreen(DisplayGuiScreenEvent event) {
        if (event.getGuiScreen() instanceof GuiChat && !(event.getGuiScreen() instanceof GuiSleepMP)) {
            GuiChat guiChat = (GuiChat)event.getGuiScreen();
            GuiChatConsole guiChatConsole = new GuiChatConsole();
            guiChatConsole.setDefaultInputFieldText(guiChat.getDefaultInputFieldText());
            event.setGuiScreen(guiChatConsole);
        }
    }

    private String[] getArguments(String userCommand, String userMessage) {
        String argsWithoutWhiteSpace = userMessage.replaceFirst(userCommand, "");
        while (argsWithoutWhiteSpace.startsWith(" ")) {
            argsWithoutWhiteSpace = argsWithoutWhiteSpace.substring(1);
        }
        return argsWithoutWhiteSpace.split(" ");
    }

    @EventHandler
    public void onShutdown(StopGameEvent event) {
        Wrapper.getEventManager().unregister(this);
    }

    public TreeMap<String, AClientCommand> getCommandList() {
        return this.commandList;
    }
}

