/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.event;

import de.paxii.clarinet.event.EventManager;
import de.paxii.clarinet.event.events.game.SendPacketEvent;
import de.paxii.clarinet.event.events.player.PlayerSendChatMessageEvent;
import de.paxii.clarinet.event.events.player.PlayerSwingItemEvent;
import java.util.ArrayList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketAnimation;
import net.minecraft.network.play.client.CPacketChatMessage;

public class PacketPatcher {
    private static ArrayList<Class<? extends Packet>> filterList = new ArrayList();
    private static boolean shouldFilter = false;

    public static Packet getPatchedPacket(Packet packetIn) {
        Packet packetOut = packetIn;
        SendPacketEvent packageEvent = new SendPacketEvent(packetIn);
        EventManager.call(packageEvent);
        if (packageEvent.isCancelled()) {
            return null;
        }
        if (PacketPatcher.isShouldFilter()) {
            for (Class<? extends Packet> blockedPacket : filterList) {
                if (packetIn.getClass() != blockedPacket) continue;
                System.out.println("Found " + packetIn.getClass().getName() + ", Packet blocked.");
                packetOut = null;
                return packetOut;
            }
        }
        if (packetIn instanceof CPacketAnimation) {
            EventManager.call(new PlayerSwingItemEvent());
        }
        if (packetIn instanceof CPacketChatMessage) {
            CPacketChatMessage tempPacket = (CPacketChatMessage)packetIn;
            String bypassPrefix = "_PASS_";
            if (tempPacket.getMessage().startsWith(bypassPrefix)) {
                String chatMessage = tempPacket.getMessage().substring(bypassPrefix.length());
                packetOut = new CPacketChatMessage(chatMessage);
            } else {
                PlayerSendChatMessageEvent messageEvent = new PlayerSendChatMessageEvent(tempPacket);
                EventManager.call(messageEvent);
                if (messageEvent.isCancelled()) {
                    return null;
                }
                packetOut = messageEvent.getPacket();
            }
        }
        return packetOut;
    }

    public static ArrayList<Class<? extends Packet>> getFilterList() {
        return filterList;
    }

    public static boolean isShouldFilter() {
        return shouldFilter;
    }

    public static void setShouldFilter(boolean shouldFilter) {
        PacketPatcher.shouldFilter = shouldFilter;
    }
}

