/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.event.events.player;

import de.paxii.clarinet.event.events.type.EventCancellable;
import net.minecraft.client.entity.EntityPlayerSP;

public class PlayerMoveEvent
extends EventCancellable {
    private EntityPlayerSP player;
    private double motionX;
    private double motionY;
    private double motionZ;
    private double posX;
    private double posY;
    private double posZ;

    public PlayerMoveEvent(EntityPlayerSP player) {
        this.player = player;
        this.motionX = this.player.motionX;
        this.motionY = this.player.motionY;
        this.motionZ = this.player.motionZ;
        this.posX = this.player.posX;
        this.posY = this.player.posY;
        this.posZ = this.player.posZ;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerMoveEvent)) {
            return false;
        }
        PlayerMoveEvent other = (PlayerMoveEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EntityPlayerSP this$player = this.getPlayer();
        EntityPlayerSP other$player = other.getPlayer();
        if (this$player == null ? other$player != null : !((Object)this$player).equals(other$player)) {
            return false;
        }
        if (Double.compare(this.getMotionX(), other.getMotionX()) != 0) {
            return false;
        }
        if (Double.compare(this.getMotionY(), other.getMotionY()) != 0) {
            return false;
        }
        if (Double.compare(this.getMotionZ(), other.getMotionZ()) != 0) {
            return false;
        }
        if (Double.compare(this.getPosX(), other.getPosX()) != 0) {
            return false;
        }
        if (Double.compare(this.getPosY(), other.getPosY()) != 0) {
            return false;
        }
        return Double.compare(this.getPosZ(), other.getPosZ()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlayerMoveEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntityPlayerSP $player = this.getPlayer();
        result = result * 59 + ($player == null ? 0 : ((Object)$player).hashCode());
        long $motionX = Double.doubleToLongBits(this.getMotionX());
        result = result * 59 + (int)($motionX >>> 32 ^ $motionX);
        long $motionY = Double.doubleToLongBits(this.getMotionY());
        result = result * 59 + (int)($motionY >>> 32 ^ $motionY);
        long $motionZ = Double.doubleToLongBits(this.getMotionZ());
        result = result * 59 + (int)($motionZ >>> 32 ^ $motionZ);
        long $posX = Double.doubleToLongBits(this.getPosX());
        result = result * 59 + (int)($posX >>> 32 ^ $posX);
        long $posY = Double.doubleToLongBits(this.getPosY());
        result = result * 59 + (int)($posY >>> 32 ^ $posY);
        long $posZ = Double.doubleToLongBits(this.getPosZ());
        result = result * 59 + (int)($posZ >>> 32 ^ $posZ);
        return result;
    }

    public EntityPlayerSP getPlayer() {
        return this.player;
    }

    public double getMotionX() {
        return this.motionX;
    }

    public double getMotionY() {
        return this.motionY;
    }

    public double getMotionZ() {
        return this.motionZ;
    }

    public double getPosX() {
        return this.posX;
    }

    public double getPosY() {
        return this.posY;
    }

    public double getPosZ() {
        return this.posZ;
    }

    public void setPlayer(EntityPlayerSP player) {
        this.player = player;
    }

    public void setMotionX(double motionX) {
        this.motionX = motionX;
    }

    public void setMotionY(double motionY) {
        this.motionY = motionY;
    }

    public void setMotionZ(double motionZ) {
        this.motionZ = motionZ;
    }

    public void setPosX(double posX) {
        this.posX = posX;
    }

    public void setPosY(double posY) {
        this.posY = posY;
    }

    public void setPosZ(double posZ) {
        this.posZ = posZ;
    }

    public String toString() {
        return "PlayerMoveEvent(player=" + this.getPlayer() + ", motionX=" + this.getMotionX() + ", motionY=" + this.getMotionY() + ", motionZ=" + this.getMotionZ() + ", posX=" + this.getPosX() + ", posY=" + this.getPosY() + ", posZ=" + this.getPosZ() + ")";
    }
}

