/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.gui.ingame;

import de.paxii.clarinet.Wrapper;
import de.paxii.clarinet.gui.ingame.panel.GuiPanel;
import de.paxii.clarinet.gui.ingame.panel.element.PanelElement;
import de.paxii.clarinet.gui.ingame.panel.element.elements.PanelButton;
import de.paxii.clarinet.gui.ingame.panel.element.elements.PanelColorButton;
import de.paxii.clarinet.gui.ingame.panel.element.elements.PanelSlider;
import de.paxii.clarinet.gui.ingame.panel.theme.IClientTheme;
import de.paxii.clarinet.gui.ingame.panel.theme.themes.DefaultClientTheme;
import de.paxii.clarinet.gui.ingame.panel.theme.themes.MatixTheme;
import de.paxii.clarinet.module.Module;
import de.paxii.clarinet.module.ModuleCategory;
import de.paxii.clarinet.util.module.settings.ValueBase;
import de.paxii.clarinet.util.settings.ClientSetting;
import de.paxii.clarinet.util.settings.ClientSettings;
import de.paxii.clarinet.util.threads.ConcurrentArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;

public class ClientClickableGui
extends GuiScreen {
    private IClientTheme currentTheme;
    private ConcurrentArrayList<GuiPanel> guiPanels = new ConcurrentArrayList();
    private ConcurrentArrayList<IClientTheme> panelThemes = new ConcurrentArrayList();

    public ClientClickableGui() {
        this.loadThemes();
        this.loadPanels();
    }

    public void loadThemes() {
        this.panelThemes.add(new DefaultClientTheme());
        this.panelThemes.add(new MatixTheme());
        this.setCurrentTheme(this.panelThemes.get(0));
    }

    public void setCurrentTheme(IClientTheme clientTheme) {
        GuiPanel colorPanel = this.getGuiPanel("Gui Color");
        if (colorPanel != null) {
            if (clientTheme instanceof DefaultClientTheme) {
                colorPanel.setVisible(true);
            } else {
                colorPanel.setVisible(false);
            }
        }
        this.currentTheme = clientTheme;
        ClientSettings.getClientSettings().put("client.guitheme", new ClientSetting("client.guitheme", this.getCurrentTheme().getName()));
    }

    public void loadPanels() {
        new Thread(() -> {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.out.println("loading Panels...");
            this.reloadPanels();
            AtomicBoolean error = new AtomicBoolean();
            this.getGuiPanels().forEach(guiPanel -> {
                if (guiPanel.isVisible() && guiPanel.getPanelElements().size() == 0) {
                    error.set(true);
                }
            });
            if (error.get()) {
                this.reloadPanels();
            }
        }).start();
    }

    private void reloadPanels() {
        int xIndex = 5;
        int yIndex = 5;
        ArrayList<GuiPanel> savedPanels = new ArrayList<GuiPanel>();
        if (!this.guiPanels.isEmpty()) {
            savedPanels.addAll(this.guiPanels);
            this.guiPanels.clear();
        }
        for (ModuleCategory moduleCategory : ModuleCategory.values()) {
            final TreeMap<String, Module> sortedKeys = new TreeMap<String, Module>(Wrapper.getModuleManager().getModulesByCategory(moduleCategory));
            this.guiPanels.add(new GuiPanel(moduleCategory.toString(), xIndex, yIndex){

                @Override
                public void addElements() {
                    sortedKeys.forEach((moduleName, module) -> {
                        if (module.isDisplayedInGui()) {
                            this.getPanelElements().add(new PanelButton((Module)module));
                        }
                    });
                }
            });
            ScaledResolution scaledResolution = Wrapper.getScaledResolution();
            if ((xIndex += 110) < scaledResolution.getScaledWidth()) continue;
            xIndex = 5;
            yIndex += this.getGuiPanels().get(0).getPanelHeight() + 20;
        }
        this.guiPanels.add(new GuiPanel("Settings", xIndex, yIndex, 120, 200){

            @Override
            public void addElements() {
                Collections.sort(ValueBase.getValueList());
                ValueBase.getValueList().forEach(valueBase -> this.getPanelElements().add(new PanelSlider((ValueBase)valueBase, valueBase.isShouldRound())));
            }
        });
        xIndex += this.getGuiPanel("Settings").getPanelWidth() + 10;
        if (this.currentTheme.getName().equals("Default")) {
            this.guiPanels.add(new GuiPanel("Gui Color", xIndex, yIndex, 100, 200){

                @Override
                public void addElements() {
                    DefaultClientTheme defaultTheme = (DefaultClientTheme)ClientClickableGui.this.currentTheme;
                    defaultTheme.getColorObjects().forEach(colorObject -> this.getPanelElements().add(new PanelColorButton((DefaultClientTheme.DefaultThemeColorObject)colorObject)));
                }
            });
        }
        savedPanels.forEach(savedPanel -> this.guiPanels.forEach(guiPanel2 -> {
            if (savedPanel.getPanelName().equals(guiPanel2.getPanelName())) {
                guiPanel2.setPanelX(savedPanel.getPanelX());
                guiPanel2.setPanelY(savedPanel.getPanelY());
                guiPanel2.setOpened(savedPanel.isOpened());
                guiPanel2.setPinned(savedPanel.isPinned());
            }
        }));
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.getGuiPanels().forEach(guiPanel -> {
            if (guiPanel.isVisible()) {
                guiPanel.drawPanel(mouseX, mouseY);
            }
        });
        super.drawScreen(mouseX, mouseY, partialTicks);
    }

    @Override
    protected void mouseClicked(int mouseX, int mouseY, int buttonClicked) throws IOException {
        for (int i = 0; i < this.getGuiPanels().size(); ++i) {
            GuiPanel guiPanel = this.getGuiPanels().get(i);
            if (!guiPanel.isVisible() || !guiPanel.isMouseOverAll(mouseX, mouseY)) continue;
            if (this.getGuiPanels().indexOf(guiPanel) == this.getGuiPanels().size() - 1) {
                guiPanel.mouseClicked(mouseX, mouseY, buttonClicked);
            }
            this.getGuiPanels().remove(guiPanel);
            this.getGuiPanels().add(guiPanel);
        }
        super.mouseClicked(mouseX, mouseY, buttonClicked);
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int buttonReleased) {
        if (buttonReleased == 0) {
            for (GuiPanel guiPanel : this.getGuiPanels()) {
                guiPanel.setDragging(false);
                for (PanelElement panelElement : guiPanel.getPanelElements()) {
                    panelElement.mouseMovedOrUp(mouseX, mouseY, buttonReleased);
                }
            }
        }
        super.mouseReleased(mouseX, mouseY, buttonReleased);
    }

    public boolean doesPanelExist(String panelName) {
        for (GuiPanel guiPanel : this.getGuiPanels()) {
            if (!guiPanel.getPanelName().equals(panelName)) continue;
            return true;
        }
        return false;
    }

    public GuiPanel getGuiPanel(String panelName) {
        for (GuiPanel guiPanel : this.getGuiPanels()) {
            if (!guiPanel.getPanelName().equals(panelName)) continue;
            return guiPanel;
        }
        return null;
    }

    public boolean doesThemeExist(String themeName) {
        for (IClientTheme theme : this.getPanelThemes()) {
            if (!theme.getName().equalsIgnoreCase(themeName)) continue;
            return true;
        }
        return false;
    }

    public IClientTheme getTheme(String themeName) {
        for (IClientTheme theme : this.getPanelThemes()) {
            if (!theme.getName().equalsIgnoreCase(themeName)) continue;
            return theme;
        }
        return null;
    }

    public IClientTheme getCurrentTheme() {
        return this.currentTheme;
    }

    public ConcurrentArrayList<GuiPanel> getGuiPanels() {
        return this.guiPanels;
    }

    public ConcurrentArrayList<IClientTheme> getPanelThemes() {
        return this.panelThemes;
    }
}

