/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.gui.ingame.panel.element.elements;

import de.paxii.clarinet.Wrapper;
import de.paxii.clarinet.gui.ingame.panel.element.PanelElement;
import de.paxii.clarinet.util.module.settings.ValueBase;

public class PanelSlider
extends PanelElement {
    private float dragX;
    private float lastDragX;
    private ValueBase sliderValue;
    private boolean shouldRound;
    private boolean isDragging;

    public PanelSlider(ValueBase sliderValue, boolean shouldRound) {
        super(110, 15);
        this.sliderValue = sliderValue;
        this.shouldRound = shouldRound;
        this.setValue(sliderValue.getValue());
    }

    public void dragSlider(int mouseX) {
        this.dragX = (float)mouseX - this.lastDragX;
    }

    @Override
    public void drawElement(int elementX, int elementY, int mouseX, int mouseY) {
        this.setElementX(elementX);
        this.setElementY(elementY);
        this.setValue(this.sliderValue.getValue());
        if (this.isDragging()) {
            this.dragSlider(mouseX);
        }
        if (this.dragX < 0.0f) {
            this.dragX = 0.0f;
        }
        if (this.dragX > (float)this.getElementWidth()) {
            this.dragX = this.getElementWidth();
        }
        Wrapper.getClickableGui().getCurrentTheme().drawSlider(this.sliderValue, this.getElementX(), this.getElementY(), this.getElementWidth(), this.getElementHeight(), this.dragX, this.shouldRound);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int buttonClicked) {
        if (buttonClicked == 0 && this.isMouseOverSlider(mouseX, mouseY)) {
            this.lastDragX = (float)mouseX - this.dragX;
            this.setDragging(true);
        }
    }

    @Override
    public void mouseMovedOrUp(int mouseX, int mouseY, int buttonClicked) {
        if (buttonClicked == 0) {
            this.setDragging(false);
        }
    }

    public boolean isMouseOverSlider(int mouseX, int mouseY) {
        boolean rightX = (float)mouseX >= (float)this.getElementX() + this.dragX - 3.0f && (float)mouseX <= (float)this.getElementX() + this.dragX + 6.0f + 3.0f;
        boolean rightY = mouseY >= this.getElementY() && mouseY <= this.getElementY() + this.getElementHeight();
        return rightX && rightY;
    }

    public void setValue(float value) {
        this.sliderValue.setValue(value);
        float fraction = (float)this.getElementWidth() / (this.sliderValue.getMax() - this.sliderValue.getMin());
        this.dragX = fraction * (value -= this.sliderValue.getMin());
    }

    public ValueBase getSliderValue() {
        return this.sliderValue;
    }

    public boolean isShouldRound() {
        return this.shouldRound;
    }

    public void setShouldRound(boolean shouldRound) {
        this.shouldRound = shouldRound;
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public void setDragging(boolean isDragging) {
        this.isDragging = isDragging;
    }
}

