/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.gui.ingame.panel.theme.themes;

import de.paxii.clarinet.Wrapper;
import de.paxii.clarinet.gui.ingame.panel.GuiPanel;
import de.paxii.clarinet.gui.ingame.panel.element.PanelElement;
import de.paxii.clarinet.gui.ingame.panel.element.elements.PanelButton;
import de.paxii.clarinet.gui.ingame.panel.theme.ClientTheme;
import de.paxii.clarinet.module.Module;
import de.paxii.clarinet.util.module.settings.ValueBase;
import de.paxii.clarinet.util.render.GuiMethods;
import java.text.DecimalFormat;

public class MatixTheme
extends ClientTheme {
    private final int COLOR_PRIMARY = -16752929;
    private final int COLOR_BACKGROUND = -1720158088;
    private final int COLOR_BUTTON = -865704346;
    private final int COLOR_CIRCLE_ACTIVE = -14169792;
    private final int COLOR_CIRCLE_INACTIVE = -40616;

    @Override
    public String getName() {
        return "Matix";
    }

    @Override
    public void drawPanel(GuiPanel guiPanel, int mouseX, int mouseY) {
        if (guiPanel.isOpened()) {
            GuiMethods.drawRect(guiPanel.getPanelX(), guiPanel.getPanelY(), guiPanel.getPanelX() + guiPanel.getPanelWidth(), guiPanel.getPanelY() + guiPanel.getTitleHeight(), -16752929);
            GuiMethods.drawRect(guiPanel.getPanelX(), guiPanel.getPanelY() + guiPanel.getTitleHeight(), guiPanel.getPanelX() + guiPanel.getPanelWidth(), guiPanel.getPanelY() + guiPanel.getPanelHeight(), -1720158088);
            Wrapper.getFontRenderer().drawString(guiPanel.getPanelName(), guiPanel.getPanelX() + 5, guiPanel.getPanelY() + guiPanel.getTitleHeight() / 2 - Wrapper.getFontRenderer().FONT_HEIGHT / 2, 0xFFFFFF);
            int index = guiPanel.getTitleHeight() + 10;
            for (PanelElement panelElement : guiPanel.getPanelElements()) {
                panelElement.drawElement(guiPanel.getPanelX() + 5, guiPanel.getPanelY() + index - 5, mouseX, mouseY);
                if (panelElement instanceof PanelButton) {
                    panelElement.setElementHeight(14);
                    panelElement.setElementYOffset(4);
                }
                index += panelElement.getElementHeight() + panelElement.getElementYOffset();
            }
        }
    }

    @Override
    public void drawButton(Module module, int buttonX, int buttonY, int buttonWidth, int buttonHeight, boolean buttonHovered) {
        GuiMethods.drawRect(buttonX, buttonY, buttonX + buttonWidth, buttonY + buttonHeight, this.COLOR_BUTTON);
        GuiMethods.drawFilledCircle(buttonX + buttonWidth - 7, buttonY + buttonHeight / 2, 3.0f, module.isEnabled() ? this.COLOR_CIRCLE_ACTIVE : this.COLOR_CIRCLE_INACTIVE);
        Wrapper.getFontRenderer().drawString(module.getName(), buttonX + 5, buttonY + 3, 0xFFFFFF);
    }

    @Override
    public void drawColorButton(String colorName, int buttonX, int buttonY, int buttonWidth, int buttonHeight, boolean buttonHovered) {
    }

    @Override
    public void drawSlider(ValueBase valueBase, int sliderX, int sliderY, int sliderWidth, int sliderHeight, float dragX, boolean shouldRound) {
        DecimalFormat format = new DecimalFormat(shouldRound ? "0" : "0.0");
        GuiMethods.drawHLine(sliderX, sliderX + sliderWidth, sliderY + 12, this.COLOR_BACKGROUND);
        GuiMethods.drawHLine(sliderX, (float)sliderX + dragX, sliderY + 12, -12303292);
        GuiMethods.drawFilledCircle(dragX + 3.0f > (float)sliderWidth ? sliderX + sliderWidth : sliderX + (int)dragX + 3, sliderY + 12, 3.0f, this.COLOR_PRIMARY);
        Wrapper.getFontRenderer().drawString(valueBase.getName() + ": " + format.format(valueBase.getValue()), sliderX, sliderY, 0xFFFFFF);
        super.drawSlider(valueBase, sliderX, sliderY, sliderWidth, sliderHeight, dragX, shouldRound);
    }
}

