/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.gui.menu.controls;

import de.paxii.clarinet.Client;
import de.paxii.clarinet.Wrapper;
import de.paxii.clarinet.gui.menu.controls.GuiKeybindsList;
import de.paxii.clarinet.gui.menu.controls.GuiListEntryModuleKey;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;

public class GuiKeybinds
extends GuiScreen {
    private GuiScreen parentScreen;
    private GuiKeybindsList keybindsList;
    private GuiListEntryModuleKey selectedButton;
    private GuiListEntryModuleKey pressedButton;
    private int pressedKey;
    boolean shouldListen;
    private GuiButton doneButton;

    public GuiKeybinds(GuiScreen parentScreen) {
        this.parentScreen = parentScreen;
    }

    @Override
    public void initGui() {
        this.keybindsList = new GuiKeybindsList(this);
        this.doneButton = new GuiButton(0, this.width / 2 - 50, this.height - 25, 100, 20, "Done");
        this.buttonList.add(this.doneButton);
    }

    @Override
    protected void keyTyped(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            if (this.isShouldListen()) {
                this.getPressedButton().getModule().setKey(-1);
                this.setShouldListen(false);
                this.setPressedButton(null);
            } else {
                Wrapper.getMinecraft().displayGuiScreen(this.parentScreen);
            }
        }
        if (this.isShouldListen()) {
            if (this.getPressedButton() != null) {
                this.getPressedButton().getModule().setKey(keyCode);
            }
            this.setShouldListen(false);
            this.pressedKey = keyCode;
        }
    }

    @Override
    public void handleMouseInput() throws IOException {
        super.handleMouseInput();
        this.keybindsList.handleMouseInput();
    }

    @Override
    protected void actionPerformed(GuiButton button) throws IOException {
        if (button.id == this.doneButton.id) {
            Wrapper.getMinecraft().displayGuiScreen(this.parentScreen);
        }
    }

    @Override
    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.keybindsList.mouseClicked(mouseX, mouseY, mouseButton);
        super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    protected void mouseReleased(int mouseX, int mouseY, int state) {
        this.keybindsList.mouseReleased(mouseX, mouseY, state);
        super.mouseReleased(mouseX, mouseY, state);
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        if (this.keybindsList != null) {
            this.keybindsList.drawScreen(mouseX, mouseY, partialTicks);
        }
        this.drawCenteredString(this.fontRendererObj, Client.getClientName() + " Keys", this.width / 2, 8, 0xFFFFFF);
        super.drawScreen(mouseX, mouseY, partialTicks);
    }

    public GuiListEntryModuleKey getSelectedButton() {
        return this.selectedButton;
    }

    public void setSelectedButton(GuiListEntryModuleKey selectedButton) {
        this.selectedButton = selectedButton;
    }

    public GuiListEntryModuleKey getPressedButton() {
        return this.pressedButton;
    }

    public void setPressedButton(GuiListEntryModuleKey pressedButton) {
        this.pressedButton = pressedButton;
    }

    public int getPressedKey() {
        return this.pressedKey;
    }

    public boolean isShouldListen() {
        return this.shouldListen;
    }

    public void setShouldListen(boolean shouldListen) {
        this.shouldListen = shouldListen;
    }
}

