/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.module.combat;

import de.paxii.clarinet.Wrapper;
import de.paxii.clarinet.event.EventHandler;
import de.paxii.clarinet.event.events.player.PostMotionUpdateEvent;
import de.paxii.clarinet.event.events.player.PreMotionUpdateEvent;
import de.paxii.clarinet.module.Module;
import de.paxii.clarinet.module.ModuleCategory;
import de.paxii.clarinet.util.chat.Chat;
import de.paxii.clarinet.util.module.killaura.AuraManager;
import de.paxii.clarinet.util.module.killaura.EntityManager;
import de.paxii.clarinet.util.module.killaura.TimeManager;
import de.paxii.clarinet.util.module.settings.ValueBase;
import de.paxii.clarinet.util.settings.ClientSettings;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.network.play.client.CPacketAnimation;
import net.minecraft.util.EnumHand;

public class ModuleKillaura
extends Module {
    private AuraManager auraManager;
    private EntityManager entityManager;
    private TimeManager timeManager;
    private EntityLivingBase target;
    private ValueBase valueRandomness;

    public ModuleKillaura() {
        super("KillAura", ModuleCategory.COMBAT, 33);
        this.setCommand(true);
        this.setSyntax("killaura set <speed/range/animals/mobs/players/silent/legit> <digit/true/false>");
        this.setDescription("Automatically hits entities around you.");
        this.auraManager = new AuraManager(this);
        this.timeManager = new TimeManager();
        this.timeManager.setRandom(true);
        this.entityManager = new EntityManager(this.auraManager, Wrapper.getFriendManager());
        this.valueRandomness = new ValueBase(String.format("%s Random", this.getName()), 50.0f, 1.0f, 250.0f, true);
        this.getModuleSettings().put("animal", String.valueOf(this.auraManager.isAnimal()));
        this.getModuleSettings().put("mob", String.valueOf(this.auraManager.isMob()));
        this.getModuleSettings().put("player", String.valueOf(this.auraManager.isPlayer()));
        this.getModuleSettings().put("silent", String.valueOf(this.auraManager.isSilent()));
        this.getModuleSettings().put("legit", String.valueOf(this.auraManager.isLegit()));
        this.getModuleSettings().put("invisible", String.valueOf(this.auraManager.isInvisible()));
        this.getModuleValues().put("randomness", this.valueRandomness);
    }

    @Override
    public void onStartup() {
        this.auraManager.setAnimal(Boolean.parseBoolean(this.getModuleSettings().getOrDefault("animal", "true")));
        this.auraManager.setMob(Boolean.parseBoolean(this.getModuleSettings().getOrDefault("mob", "true")));
        this.auraManager.setPlayer(Boolean.parseBoolean(this.getModuleSettings().getOrDefault("player", "true")));
        this.auraManager.setSilent(Boolean.parseBoolean(this.getModuleSettings().getOrDefault("silent", "true")));
        this.auraManager.setLegit(Boolean.parseBoolean(this.getModuleSettings().getOrDefault("legit", "true")));
        this.auraManager.setInvisible(Boolean.parseBoolean(this.getModuleSettings().getOrDefault("invisible", "false")));
    }

    @Override
    public void onEnable() {
        Wrapper.getEventManager().register(this);
    }

    @EventHandler
    public void preMotion(PreMotionUpdateEvent event) {
        if (this.auraManager.isSilent()) {
            this.auraManager.saveCamera(Wrapper.getPlayer());
        }
        this.timeManager.updateTimer((int)this.valueRandomness.getValue());
        this.target = this.entityManager.getEntity(80.0f, this.auraManager.getRange());
        if (this.target == null) {
            return;
        }
        this.auraManager.setAngles(this.target, this.entityManager);
        if (this.timeManager.sleep(this.auraManager.getDelay())) {
            Wrapper.getMinecraft().playerController.attackEntity(Wrapper.getPlayer(), this.target);
            Wrapper.getSendQueue().addToSendQueue(new CPacketAnimation(EnumHand.MAIN_HAND));
            this.auraManager.addToAttackMap(this.target.getEntityId(), this.timeManager.getLast());
            this.timeManager.updateLast();
        }
    }

    @EventHandler
    public void postMotion(PostMotionUpdateEvent event) {
        if (this.auraManager.isSilent()) {
            this.auraManager.restoreCamera(Wrapper.getPlayer());
        }
    }

    @Override
    public void onCommand(String[] args) {
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("set")) {
                if (args.length >= 3) {
                    String identifier = args[1];
                    String value = args[2];
                    if (identifier.equalsIgnoreCase("speed")) {
                        try {
                            float speed = Float.parseFloat(value);
                            this.auraManager.setDelay(speed);
                            Chat.printClientMessage("KillAura speed has been set to " + speed + ".");
                        }
                        catch (Exception e) {
                            Chat.printClientMessage("Invalid argument!");
                        }
                    } else if (identifier.equalsIgnoreCase("range")) {
                        try {
                            float range = Float.parseFloat(value);
                            this.auraManager.setDelay(range);
                            Chat.printClientMessage("KillAura range has been set to " + range + ".");
                        }
                        catch (Exception e) {
                            Chat.printClientMessage("Invalid argument!");
                        }
                    } else if (identifier.equalsIgnoreCase("animals")) {
                        try {
                            boolean animal = Boolean.parseBoolean(value);
                            this.auraManager.setAnimal(animal);
                            Chat.printClientMessage("KillAura animal mode has been set to " + animal + ".");
                        }
                        catch (Exception e) {
                            Chat.printClientMessage("Invalid argument!");
                        }
                    } else if (identifier.equalsIgnoreCase("mobs")) {
                        try {
                            boolean mob = Boolean.parseBoolean(value);
                            this.auraManager.setMob(mob);
                            Chat.printClientMessage("KillAura mob mode has been set to " + mob + ".");
                        }
                        catch (Exception e) {
                            Chat.printClientMessage("Invalid argument!");
                        }
                    } else if (identifier.equalsIgnoreCase("players")) {
                        try {
                            boolean player = Boolean.parseBoolean(value);
                            this.auraManager.setPlayer(player);
                            Chat.printClientMessage("KillAura player mode has been set to " + player + ".");
                        }
                        catch (Exception e) {
                            Chat.printClientMessage("Invalid argument!");
                        }
                    } else if (identifier.equalsIgnoreCase("silent")) {
                        try {
                            boolean silent = Boolean.parseBoolean(value);
                            this.auraManager.setSilent(silent);
                            Chat.printClientMessage("KillAura silent mode has been set to " + silent + ".");
                        }
                        catch (Exception e) {
                            Chat.printClientMessage("Invalid argument!");
                        }
                    } else if (identifier.equalsIgnoreCase("legit")) {
                        try {
                            boolean legit = Boolean.parseBoolean(value);
                            this.auraManager.setLegit(legit);
                            Chat.printClientMessage("KillAura legit mode has been set to " + legit + ".");
                        }
                        catch (Exception e) {
                            Chat.printClientMessage("Invalid argument!");
                        }
                    } else if (identifier.equalsIgnoreCase("invisible")) {
                        try {
                            boolean invisible = Boolean.parseBoolean(value);
                            this.auraManager.setInvisible(invisible);
                            Chat.printClientMessage("KillAura invisibility mode has been set to " + invisible + ".");
                        }
                        catch (Exception e) {
                            Chat.printClientMessage("Invalid argument!");
                        }
                    } else {
                        Chat.printClientMessage("Invalid subcommand! Use \"" + ClientSettings.getClientSettings().get("client.prefix").getSettingValue() + "help killaura\"");
                    }
                } else {
                    Chat.printClientMessage("Too few arguments!");
                }
            } else {
                Chat.printClientMessage("Invalid subcommand! Use \"" + ClientSettings.getClientSettings().get("client.prefix").getSettingValue() + "help killaura\"");
            }
        } else {
            Chat.printClientMessage("Too few arguments!");
        }
    }

    @Override
    public void onDisable() {
        Wrapper.getEventManager().unregister(this);
    }

    @Override
    public void onShutdown() {
        this.getModuleSettings().put("animal", String.valueOf(this.auraManager.isAnimal()));
        this.getModuleSettings().put("mob", String.valueOf(this.auraManager.isMob()));
        this.getModuleSettings().put("player", String.valueOf(this.auraManager.isPlayer()));
        this.getModuleSettings().put("silent", String.valueOf(this.auraManager.isSilent()));
        this.getModuleSettings().put("legit", String.valueOf(this.auraManager.isLegit()));
        this.getModuleSettings().put("invisible", String.valueOf(this.auraManager.isInvisible()));
    }
}

