/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.module.external;

import de.paxii.clarinet.Wrapper;
import de.paxii.clarinet.module.Module;
import de.paxii.clarinet.util.settings.ClientSettings;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ServiceLoader;

public class ExternalModuleLoader {
    private File moduleFolder = new File(ClientSettings.getClientFolderPath().getSettingValue() + "/modules");

    public ExternalModuleLoader() {
        this.moduleFolder.mkdirs();
        this.loadModules();
    }

    public void loadModules() {
        new Thread(() -> {
            Module[] externalModules;
            this.loadModuleJars(this.getModuleJars());
            for (Module externalModule : externalModules = this.loadExternalModules()) {
                Wrapper.getModuleManager().addModule(externalModule);
            }
        }).start();
    }

    public File[] getModuleJars() {
        ArrayList<File> moduleJars = new ArrayList<File>();
        moduleJars.addAll(Arrays.asList(this.moduleFolder.listFiles(f -> f.getName().endsWith(".jar"))));
        return moduleJars.toArray(new File[moduleJars.size()]);
    }

    public void loadModuleJars(File[] moduleJars) {
        for (File moduleFile : moduleJars) {
            this.addToClassPath(moduleFile);
        }
    }

    public Module[] loadExternalModules() {
        ArrayList moduleList = new ArrayList();
        try {
            Iterator<Module> it = ServiceLoader.load(Module.class).iterator();
            it.forEachRemaining(moduleList::add);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        return moduleList.toArray(new Module[moduleList.size()]);
    }

    private void addToClassPath(File file) {
        URLClassLoader systemClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> systemClassLoaderClass = URLClassLoader.class;
        try {
            Method method = systemClassLoaderClass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)systemClassLoader, file.toURI().toURL());
        }
        catch (Exception e) {
            System.out.println("Could not load Module " + file.getName());
            e.printStackTrace();
        }
    }
}

