/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.module.render;

import de.paxii.clarinet.Wrapper;
import de.paxii.clarinet.event.EventHandler;
import de.paxii.clarinet.event.events.chat.ReceiveChatEvent;
import de.paxii.clarinet.event.events.game.RenderTickEvent;
import de.paxii.clarinet.event.events.player.PlayerSendChatMessageEvent;
import de.paxii.clarinet.module.Module;
import de.paxii.clarinet.module.ModuleCategory;
import de.paxii.clarinet.util.chat.ChatColor;
import de.paxii.clarinet.util.render.GL11Helper;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.opengl.GL11;

public class ModuleWorldEditESP
extends Module {
    private BlockPos[] blockPos = new BlockPos[]{null, null};

    public ModuleWorldEditESP() {
        super("WorldEditESP", ModuleCategory.RENDER, -1);
    }

    @Override
    public void onEnable() {
        Wrapper.getEventManager().register(this);
    }

    @EventHandler
    public void onChatMessage(PlayerSendChatMessageEvent event) {
        if (event.getChatMessage().startsWith("//")) {
            String weCommand = event.getChatMessage().substring(2);
            if (weCommand.startsWith("desel") || weCommand.startsWith("sel")) {
                this.blockPos[0] = null;
                this.blockPos[1] = null;
            }
            if (weCommand.startsWith("expand")) {
                String[] split = weCommand.split(" ");
                if (split.length >= 3) {
                    double expandAmount = Double.parseDouble(split[1]);
                    String expandDirection = split[2];
                    this.expandSelection(SelectionDir.parseSelectionDir(expandDirection), expandAmount, 0.0);
                } else if (split.length >= 4) {
                    double expandAmount = Double.parseDouble(split[1]);
                    double reverseAmount = Double.parseDouble(split[2]);
                    String expandDirection = split[3];
                    this.expandSelection(SelectionDir.parseSelectionDir(expandDirection), expandAmount, reverseAmount);
                }
            }
        }
    }

    @EventHandler
    public void onReceiveChat(ReceiveChatEvent event) {
        try {
            String message = event.getChatMessage();
            if (message.startsWith((Object)((Object)ChatColor.RESET) + "" + (Object)((Object)ChatColor.LIGHT_PURPLE))) {
                String weSelection = message.substring(4);
                if (weSelection.startsWith("First position set to (")) {
                    String[] split = weSelection.split("\\(");
                    String[] blockPositions = split[1].split(",");
                    String zPos = blockPositions[2].split("\\)")[0];
                    double posX = Double.parseDouble(blockPositions[0]);
                    double posY = Double.parseDouble(blockPositions[1]);
                    double posZ = Double.parseDouble(zPos);
                    this.blockPos[0] = new BlockPos(posX, posY, posZ);
                } else if (weSelection.startsWith("Second position set to (")) {
                    String[] split = weSelection.split("\\(");
                    String[] blockPositions = split[1].split(",");
                    String zPos = blockPositions[2].split("\\)")[0];
                    double posX = Double.parseDouble(blockPositions[0]);
                    double posY = Double.parseDouble(blockPositions[1]);
                    double posZ = Double.parseDouble(zPos);
                    this.blockPos[1] = new BlockPos(posX, posY, posZ);
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    @EventHandler
    public void onGlobalRender(RenderTickEvent event) {
        try {
            this.drawWorldEditESP(this.blockPos[0], this.blockPos[1], 0xFF00FF);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    private void expandSelection(SelectionDir expandDir, double expandAmount, double reverseAmount) {
        if (this.blockPos[0] == null || this.blockPos[1] == null) {
            return;
        }
        switch (expandDir) {
            case NORTH: {
                if (this.blockPos[0].getZ() < this.blockPos[1].getZ()) {
                    this.blockPos[0] = this.blockPos[0].north((int)expandAmount);
                    this.blockPos[1] = this.blockPos[1].south((int)reverseAmount);
                    break;
                }
                this.blockPos[1] = this.blockPos[1].north((int)expandAmount);
                this.blockPos[0] = this.blockPos[0].south((int)reverseAmount);
                break;
            }
            case SOUTH: {
                if (this.blockPos[0].getZ() > this.blockPos[1].getZ()) {
                    this.blockPos[1] = this.blockPos[0] = this.blockPos[0].south((int)expandAmount);
                    this.blockPos[1].north((int)reverseAmount);
                    break;
                }
                this.blockPos[1] = this.blockPos[1].south((int)expandAmount);
                this.blockPos[0] = this.blockPos[0].north((int)reverseAmount);
                break;
            }
            case WEST: {
                if (this.blockPos[0].getX() < this.blockPos[1].getX()) {
                    this.blockPos[0] = this.blockPos[0].west((int)expandAmount);
                    this.blockPos[1] = this.blockPos[1].east((int)reverseAmount);
                    break;
                }
                this.blockPos[1] = this.blockPos[1].west((int)expandAmount);
                this.blockPos[0] = this.blockPos[0].east((int)reverseAmount);
                break;
            }
            case EAST: {
                if (this.blockPos[0].getX() > this.blockPos[1].getX()) {
                    this.blockPos[0] = this.blockPos[0].east((int)expandAmount);
                    this.blockPos[1] = this.blockPos[1].west((int)reverseAmount);
                    break;
                }
                this.blockPos[1] = this.blockPos[1].east((int)expandAmount);
                this.blockPos[0] = this.blockPos[0].west((int)reverseAmount);
                break;
            }
            case DOWN: {
                if (this.blockPos[0].getY() < this.blockPos[1].getY()) {
                    this.blockPos[0] = this.blockPos[0].down((int)expandAmount);
                    this.blockPos[1] = this.blockPos[1].up((int)reverseAmount);
                    break;
                }
                this.blockPos[1] = this.blockPos[1].down((int)expandAmount);
                this.blockPos[0] = this.blockPos[0].up((int)reverseAmount);
                break;
            }
            case UP: {
                if (this.blockPos[0].getY() > this.blockPos[1].getY()) {
                    this.blockPos[0] = this.blockPos[0].up((int)expandAmount);
                    this.blockPos[1] = this.blockPos[1].down((int)reverseAmount);
                    break;
                }
                this.blockPos[1] = this.blockPos[1].up((int)expandAmount);
                this.blockPos[0] = this.blockPos[0].down((int)reverseAmount);
            }
        }
    }

    private void drawWorldEditESP(BlockPos block1, BlockPos block2, int color) {
        EntityPlayerSP ep = Wrapper.getPlayer();
        double xx = ep.lastTickPosX + (ep.posX - ep.lastTickPosX) * (double)Wrapper.getTimer().renderPartialTicks;
        double yy = ep.lastTickPosY + (ep.posY - ep.lastTickPosY) * (double)Wrapper.getTimer().renderPartialTicks;
        double zz = ep.lastTickPosZ + (ep.posZ - ep.lastTickPosZ) * (double)Wrapper.getTimer().renderPartialTicks;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double x1 = 0.0;
        double y1 = 0.0;
        double z1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double z2 = 0.0;
        double widthX = 0.0;
        double bigY = 0.0;
        double smallY = 0.0;
        double heightY = 0.0;
        double widthZ = 0.0;
        if (block1 != null && block2 != null) {
            x = (double)this.getSmaller(block1.getX(), block2.getX()) - xx;
            y = (double)this.getSmaller(block1.getY(), block2.getY()) - yy;
            z = (double)this.getSmaller(block1.getZ(), block2.getZ()) - zz;
            widthX = this.getBigger(block1.getX(), block2.getX()) - this.getSmaller(block1.getX(), block2.getX());
            bigY = this.getBigger(block1.getY(), block2.getY());
            smallY = this.getSmaller(block1.getY(), block2.getY());
            boolean duckFuck = false;
            if (bigY == smallY + 1.0) {
                duckFuck = true;
                smallY -= 1.0;
            }
            if ((heightY = bigY - smallY) == 0.0) {
                heightY = 1.0;
            }
            widthZ = this.getBigger(block1.getZ(), block2.getZ()) - this.getSmaller(block1.getZ(), block2.getZ());
            boolean ba = widthX > x;
            boolean bb = heightY > y;
            boolean bc = widthZ > z;
            widthZ += 1.0;
            widthX += 1.0;
            if (!duckFuck) {
                if (heightY != 1.0 && heightY > 0.0) {
                    heightY += 1.0;
                }
                if (heightY != -1.0 && heightY < 0.0) {
                    heightY -= 1.0;
                }
            }
        }
        if (block1 != null) {
            x1 = (double)block1.getX() - xx;
            y1 = (double)block1.getY() - yy;
            z1 = (double)block1.getZ() - zz;
        }
        if (block2 != null) {
            x2 = (double)block2.getX() - xx;
            y2 = (double)block2.getY() - yy;
            z2 = (double)block2.getZ() - zz;
        }
        GL11.glPushMatrix();
        GL11Helper.enableDefaults();
        GL11.glLineWidth((float)2.0f);
        if (this.blockPos[0] != null && this.blockPos[1] != null) {
            AxisAlignedBB blockBox0 = new AxisAlignedBB(x1, y1, z1, x1 + 1.0, y1 + 1.0, z1 + 1.0);
            AxisAlignedBB blockBox1 = new AxisAlignedBB(x2, y2, z2, x2 + 1.0, y2 + 1.0, z2 + 1.0);
            AxisAlignedBB draw = new AxisAlignedBB(x, y, z, x + widthX, y + heightY, z + widthZ);
            RenderGlobal.drawOutlinedBoundingBox(blockBox0, -343801);
            RenderGlobal.drawOutlinedBoundingBox(blockBox1, -16254393);
            RenderGlobal.drawOutlinedBoundingBox(draw, color);
        } else if (this.blockPos[0] != null) {
            AxisAlignedBB blockBox0 = new AxisAlignedBB(x1, y1, z1, x1 + 1.0, y1 + 1.0, z1 + 1.0);
            RenderGlobal.drawOutlinedBoundingBox(blockBox0, -343801);
        } else if (this.blockPos[1] != null) {
            AxisAlignedBB blockBox1 = new AxisAlignedBB(x2, y2, z2, x2 + 1.0, y2 + 1.0, z2 + 1.0);
            RenderGlobal.drawOutlinedBoundingBox(blockBox1, -16254393);
        }
        GL11Helper.disableDefaults();
        GL11.glPopMatrix();
    }

    private int getBigger(int par1, int par2) {
        if (par1 > par2) {
            return par1;
        }
        return par2;
    }

    private int getSmaller(int par1, int par2) {
        if (par1 < par2) {
            return par1;
        }
        return par2;
    }

    @Override
    public void onDisable() {
        Wrapper.getEventManager().unregister(this);
    }

    private static enum SelectionDir {
        NORTH("NORTH"),
        SOUTH("SOUTH"),
        EAST("EAST"),
        WEST("WEST"),
        UP("UP"),
        DOWN("DOWN");

        private String selectionName;

        private SelectionDir(String selectionName) {
            this.selectionName = selectionName;
        }

        public String getName() {
            return this.selectionName;
        }

        public static SelectionDir parseSelectionDir(String selection) {
            selection = selection.toUpperCase();
            for (SelectionDir selectionDir : SelectionDir.values()) {
                if (!selectionDir.getName().equals(selection)) continue;
                return selectionDir;
            }
            return null;
        }
    }
}

