/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.util.module.killaura;

import de.paxii.clarinet.Wrapper;
import de.paxii.clarinet.module.Module;
import de.paxii.clarinet.util.module.killaura.CameraObject;
import de.paxii.clarinet.util.module.killaura.EntityManager;
import de.paxii.clarinet.util.module.killaura.TimeManager;
import de.paxii.clarinet.util.module.settings.ValueBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;

public class AuraManager {
    private ValueBase valueRange;
    private ValueBase valueDelay;
    private boolean silent = true;
    private boolean mob = true;
    private boolean animal = false;
    private boolean player = true;
    private boolean legit = true;
    private boolean invisible = false;
    private TimeManager timeManager;
    private ArrayList<Float> pitchMap;
    private ArrayList<Float> yawMap;
    private Map<Integer, Long> attackMap = new HashMap<Integer, Long>();
    private CameraObject cameraObject = new CameraObject();
    private Random random;

    public AuraManager(Module module) {
        float f;
        this.pitchMap = new ArrayList();
        this.yawMap = new ArrayList();
        this.random = new Random();
        this.timeManager = new TimeManager();
        this.valueRange = new ValueBase(module.getName() + " Range", 4.1f, 1.0f, 6.0f);
        this.valueDelay = new ValueBase(module.getName() + " Speed", 2.0f, 1.0f, 15.0f);
        module.getModuleValues().put("valueRange", this.valueRange);
        module.getModuleValues().put("valueDelay", this.valueDelay);
        for (f = -10.0f; f <= 10.0f; f += 2.0f) {
            this.yawMap.add(Float.valueOf(f));
        }
        for (f = -10.0f; f <= 50.0f; f += 5.0f) {
            this.pitchMap.add(Float.valueOf(f));
        }
    }

    public void addToAttackMap(int entityId, long last) {
        this.attackMap.put(entityId, last);
    }

    private long getLast(Entity entity) {
        if (this.attackMap.get(entity.getEntityId()) == null) {
            return 0L;
        }
        return this.attackMap.get(entity.getEntityId());
    }

    public long getDelay() {
        return (long)(1000.0f / this.valueDelay.getValue());
    }

    public void setDelay(float delay) {
        this.valueDelay.setValue(delay);
    }

    public double getRange() {
        return this.valueRange.getValue();
    }

    public void setRange(float range) {
        this.valueRange.setValue(range);
    }

    public Map<Integer, Long> getAttackMap() {
        return this.attackMap;
    }

    public void setAttackMap(Map<Integer, Long> attackMap) {
        this.attackMap = attackMap;
    }

    public long convertToMilliseconds(double delay) {
        return 1000L / (long)delay;
    }

    public void saveCamera(EntityPlayer p) {
        this.cameraObject.saveCamera(p);
    }

    public void restoreCamera(EntityPlayer p) {
        this.cameraObject.restoreCamera(p);
    }

    public float getRandomPitchModifier() {
        int randomIndex = this.random.nextInt(this.pitchMap.size() - 1);
        return this.pitchMap.get(randomIndex).floatValue();
    }

    public float getRandomYawModifier() {
        int randomIndex = this.random.nextInt(this.yawMap.size() - 1);
        return this.yawMap.get(randomIndex).floatValue();
    }

    public void setAngles(EntityLivingBase entityLiving, EntityManager entityManager) {
        float yaw = entityManager.getAngles(entityLiving)[0];
        float pitch = entityManager.getAngles(entityLiving)[1];
        if (this.isLegit()) {
            this.timeManager.updateTimer();
            if (this.timeManager.sleep(200L)) {
                this.setPitch(pitch + (this.random.nextFloat() - 0.5f) * 50.0f);
                this.setYaw(yaw + (this.random.nextFloat() - 0.5f) * 10.0f);
                this.timeManager.updateLast();
            } else {
                this.setPitch(pitch);
                this.setYaw(yaw);
            }
        } else {
            this.setPitch(pitch);
            this.setYaw(yaw);
        }
    }

    private void setYaw(float yaw) {
        Wrapper.getPlayer().rotationYaw = yaw;
        Wrapper.getPlayer().rotationYawHead = yaw;
    }

    private void setPitch(float pitch) {
        Wrapper.getPlayer().rotationPitch = pitch;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public boolean isMob() {
        return this.mob;
    }

    public boolean isAnimal() {
        return this.animal;
    }

    public boolean isPlayer() {
        return this.player;
    }

    public boolean isLegit() {
        return this.legit;
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public void setMob(boolean mob) {
        this.mob = mob;
    }

    public void setAnimal(boolean animal) {
        this.animal = animal;
    }

    public void setPlayer(boolean player) {
        this.player = player;
    }

    public void setLegit(boolean legit) {
        this.legit = legit;
    }

    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
    }
}

