/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.util.module.killaura;

import de.paxii.clarinet.Wrapper;
import de.paxii.clarinet.util.module.friends.FriendManager;
import de.paxii.clarinet.util.module.killaura.AuraManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;

public class EntityManager {
    private final AuraManager auraManager;
    private FriendManager friends;

    public EntityManager(AuraManager auraManager, FriendManager friends) {
        this.auraManager = auraManager;
        this.friends = friends;
    }

    public EntityLivingBase getClosestEntity(double range) {
        double distance = range;
        EntityLivingBase tempEntity = null;
        for (Object o : Wrapper.getWorld().loadedEntityList) {
            double curDistance;
            EntityLivingBase living;
            Entity entity;
            if (!(o instanceof Entity) || !((entity = (Entity)o) instanceof EntityLivingBase) || !this.canAttackEntity(living = (EntityLivingBase)entity) || !((curDistance = (double)Wrapper.getPlayer().getDistanceToEntity(living)) <= distance)) continue;
            distance = curDistance;
            tempEntity = living;
        }
        return tempEntity;
    }

    public EntityLivingBase getClosestEntityToCursor(float angle) {
        float distance = angle;
        EntityLivingBase tempEntity = null;
        for (Object o : Wrapper.getWorld().loadedEntityList) {
            float curDistance;
            EntityLivingBase living;
            Entity entity;
            if (!(o instanceof Entity) || !((entity = (Entity)o) instanceof EntityLivingBase) || !this.canAttackEntity(living = (EntityLivingBase)entity)) continue;
            float[] angles = this.getAngles(living);
            float yaw = this.getDistanceBetweenAngles(Wrapper.getPlayer().rotationYawHead, angles[0]);
            float pitch = this.getDistanceBetweenAngles(Wrapper.getPlayer().rotationPitch, angles[1]);
            if (yaw > angle || pitch > angle || !((curDistance = (yaw + pitch) / 2.0f) <= distance)) continue;
            distance = curDistance;
            tempEntity = living;
        }
        return tempEntity;
    }

    public EntityLivingBase getEntity(float angle, double distance) {
        EntityLivingBase distanceCheck = this.getClosestEntity(distance);
        EntityLivingBase angleCheck = this.getClosestEntityToCursor(angle);
        if (this.auraManager.isLegit() && angleCheck == null) {
            return null;
        }
        return angleCheck != null ? angleCheck : distanceCheck;
    }

    public float getDistanceBetweenAngles(float ang1, float ang2) {
        return Math.abs(((ang1 - ang2 + 180.0f) % 360.0f + 360.0f) % 360.0f - 180.0f);
    }

    public boolean canAttackEntity(EntityLivingBase entity) {
        return entity != Wrapper.getPlayer() && this.shouldAttack(entity);
    }

    private boolean shouldAttack(EntityLivingBase entityLiving) {
        if (entityLiving.deathTime > 0 || !entityLiving.isEntityAlive()) {
            return false;
        }
        if (!Wrapper.getPlayer().canEntityBeSeen(entityLiving)) {
            return false;
        }
        if ((double)Wrapper.getPlayer().getDistanceToEntity(entityLiving) > this.auraManager.getRange()) {
            return false;
        }
        if (!entityLiving.canBePushed()) {
            return false;
        }
        if (entityLiving instanceof EntityPlayer && this.auraManager.isPlayer() && this.friends.isFriend(entityLiving.getName())) {
            return false;
        }
        if (entityLiving instanceof EntityAnimal && !this.auraManager.isAnimal()) {
            return false;
        }
        if (entityLiving instanceof EntityMob && !this.auraManager.isMob()) {
            return false;
        }
        if (entityLiving.isInvisible() && !this.auraManager.isInvisible()) {
            return false;
        }
        return entityLiving.ticksExisted >= 20;
    }

    public float[] getAngles(EntityLivingBase entityLiving) {
        double difX = entityLiving.posX - Wrapper.getPlayer().posX;
        double difY = entityLiving.posY + (double)entityLiving.getEyeHeight() - (Wrapper.getPlayer().posY + (double)Wrapper.getPlayer().getEyeHeight());
        double difZ = entityLiving.posZ - Wrapper.getPlayer().posZ;
        double helper = Math.sqrt(difX * difX + difZ * difZ);
        float yaw = (float)(Math.atan2(difZ, difX) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(difY, helper) * 180.0 / Math.PI));
        return new float[]{yaw, pitch};
    }
}

