/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.util.module.killaura;

import java.util.Random;

public class TimeManager {
    private Random utilRandom = new Random();
    private int currentRandomness;
    private long current;
    private long last;
    private int randomness;
    private boolean random;

    public TimeManager() {
        this.createNewRandomDelay();
    }

    public void updateTimer() {
        this.current = this.getCurrentMillis();
    }

    public void updateTimer(int newRandomness) {
        this.randomness = newRandomness;
        this.updateTimer();
    }

    public boolean sleep(long delay) {
        boolean slept;
        boolean bl = slept = this.current - this.last > delay + (long)this.currentRandomness;
        if (slept) {
            this.createNewRandomDelay();
        }
        return slept;
    }

    public final void updateLast() {
        this.last = this.getCurrentMillis();
    }

    public long getCurrentMillis() {
        return System.nanoTime() / 1000000L;
    }

    private void createNewRandomDelay() {
        if (this.isRandom()) {
            this.currentRandomness = this.utilRandom.nextInt(this.randomness);
        }
    }

    public long getCurrent() {
        return this.current;
    }

    public long getLast() {
        return this.last;
    }

    public void setCurrent(long current) {
        this.current = current;
    }

    public void setLast(long last) {
        this.last = last;
    }

    public int getRandomness() {
        return this.randomness;
    }

    public void setRandomness(int randomness) {
        this.randomness = randomness;
    }

    public boolean isRandom() {
        return this.random;
    }

    public void setRandom(boolean random) {
        this.random = random;
    }
}

