/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.util.module.settings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.paxii.clarinet.Wrapper;
import de.paxii.clarinet.event.EventHandler;
import de.paxii.clarinet.event.events.game.StartGameEvent;
import de.paxii.clarinet.event.events.game.StopGameEvent;
import de.paxii.clarinet.module.Module;
import de.paxii.clarinet.util.module.settings.ModuleSettingsContainer;
import de.paxii.clarinet.util.module.settings.ModuleSettingsObject;
import de.paxii.clarinet.util.module.settings.ValueBase;
import de.paxii.clarinet.util.settings.ClientSettings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Map;

public class ModuleSettingsHandler {
    public ModuleSettingsHandler() {
        Wrapper.getEventManager().register(this);
    }

    @EventHandler
    public void onStartGame(StartGameEvent event) {
        new Thread(() -> {
            try {
                Thread.sleep(3000L);
                Gson gson = new Gson();
                File settingsFile = new File(ClientSettings.getClientFolderPath().getSettingValue(), "/modules.json");
                if (settingsFile.exists()) {
                    String line;
                    BufferedReader br = new BufferedReader(new FileReader(settingsFile));
                    String file = "";
                    while ((line = br.readLine()) != null) {
                        file = file + line;
                    }
                    br.close();
                    if (file.length() > 0) {
                        ModuleSettingsContainer moduleSettingsContainer = (ModuleSettingsContainer)gson.fromJson(file, ModuleSettingsContainer.class);
                        moduleSettingsContainer.getModuleSettings().forEach(moduleSettings -> {
                            if (Wrapper.getModuleManager().doesModuleExist(moduleSettings.getModuleName())) {
                                Module module = Wrapper.getModuleManager().getModule(moduleSettings.getModuleName());
                                module.setModuleSettings(moduleSettings.getModuleSettings());
                                moduleSettings.getModuleValues().forEach((k, v) -> {
                                    ValueBase vb;
                                    if (ValueBase.doesValueExist(v.getName()) && (vb = ValueBase.getValueBase(v.getName())) != null) {
                                        vb.setValue(v.getValue());
                                        vb.setMin(v.getMin());
                                        vb.setMax(v.getMax());
                                        vb.setName(v.getName());
                                    }
                                });
                                module.setKey(moduleSettings.getModuleKey());
                                module.onStartup();
                            }
                        });
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
    }

    @EventHandler
    public void onStopGame(StopGameEvent event) {
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            File settingsFile = new File(ClientSettings.getClientFolderPath().getSettingValue(), "/modules.json");
            settingsFile.delete();
            if (settingsFile.createNewFile()) {
                ModuleSettingsContainer moduleSettingsContainer = new ModuleSettingsContainer(new ArrayList<ModuleSettingsObject>());
                for (Map.Entry<String, Module> moduleEntry : Wrapper.getModuleManager().getModuleList().entrySet()) {
                    Module module = moduleEntry.getValue();
                    module.onShutdown();
                    moduleSettingsContainer.getModuleSettings().add(new ModuleSettingsObject(module));
                }
                String jsonString = gson.toJson((Object)moduleSettingsContainer);
                FileWriter fileWriter = new FileWriter(settingsFile);
                fileWriter.write(jsonString);
                fileWriter.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Wrapper.getEventManager().unregister(this);
    }
}

