/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.util.module.store;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import de.paxii.clarinet.Client;
import de.paxii.clarinet.Wrapper;
import de.paxii.clarinet.event.EventHandler;
import de.paxii.clarinet.event.events.game.StopGameEvent;
import de.paxii.clarinet.event.events.player.PlayerSendChatMessageEvent;
import de.paxii.clarinet.module.Module;
import de.paxii.clarinet.util.chat.Chat;
import de.paxii.clarinet.util.module.store.ModuleEntry;
import de.paxii.clarinet.util.settings.ClientSettings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.TreeMap;
import net.minecraft.network.play.client.CPacketChatMessage;
import org.apache.commons.io.FileUtils;

public class ModuleStore {
    private static String moduleUrl = Client.getClientURL() + "modules/%s.jar";
    private static TreeMap<String, String> moduleList = new TreeMap();
    private static ArrayList<String> modulesToDelete = new ArrayList();

    public ModuleStore() {
        Wrapper.getEventManager().register(this);
        this.removeModules();
    }

    public void removeModules() {
        File modulesToDelete = new File(ClientSettings.getClientFolderPath().getSettingValue(), "modulesToDelete.json");
        if (modulesToDelete.exists()) {
            String jsonString = "";
            try {
                Scanner sc = new Scanner(modulesToDelete);
                Gson gson = new Gson();
                while (sc.hasNextLine()) {
                    jsonString = jsonString + sc.nextLine();
                }
                sc.close();
                ArrayList modulesToRemove = (ArrayList)gson.fromJson(jsonString, new TypeToken<ArrayList<String>>(){}.getType());
                if (modulesToRemove != null) {
                    modulesToRemove.forEach(moduleName -> {
                        File moduleFile = new File(ClientSettings.getClientFolderPath().getSettingValue() + "/modules/", String.format("%s.jar", moduleName));
                        moduleFile.delete();
                    });
                }
                modulesToDelete.delete();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static void downloadModule(String moduleName) {
        try {
            File moduleFile = new File(ClientSettings.getClientFolderPath().getSettingValue() + "/modules/", String.format("%s.jar", moduleName));
            URL downloadUrl = new URL(String.format(moduleUrl, moduleName));
            if (moduleFile.exists() && !moduleFile.delete()) {
                return;
            }
            new Thread(() -> {
                try {
                    FileUtils.copyURLToFile((URL)downloadUrl, (File)moduleFile);
                }
                catch (IOException e) {
                    try {
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        Chat.printClientMessage(String.format("Module %s has been downloaded. Reloading Client...", moduleName));
                        Wrapper.getConsole().onChatMessage(new PlayerSendChatMessageEvent(new CPacketChatMessage(ClientSettings.getClientSettings().get("client.prefix").getSettingValue() + "reload")));
                        throw throwable;
                    }
                    Chat.printClientMessage(String.format("Module %s has been downloaded. Reloading Client...", moduleName));
                    Wrapper.getConsole().onChatMessage(new PlayerSendChatMessageEvent(new CPacketChatMessage(ClientSettings.getClientSettings().get("client.prefix").getSettingValue() + "reload")));
                }
                Chat.printClientMessage(String.format("Module %s has been downloaded. Reloading Client...", moduleName));
                Wrapper.getConsole().onChatMessage(new PlayerSendChatMessageEvent(new CPacketChatMessage(ClientSettings.getClientSettings().get("client.prefix").getSettingValue() + "reload")));
            }).start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void removeModule(String moduleName) {
        try {
            if (Wrapper.getModuleManager().doesModuleExist(moduleName)) {
                Module module = Wrapper.getModuleManager().getModule(moduleName);
                module.setEnabled(false);
                module.onShutdown();
                Wrapper.getModuleManager().removeModule(module);
                Wrapper.getClickableGui().loadPanels();
            }
            if (!modulesToDelete.contains(moduleName)) {
                modulesToDelete.add(moduleName);
            } else {
                System.out.println("fred");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        modulesToDelete.forEach(m -> System.out.println((String)m));
    }

    public static TreeMap<String, String> listModules() {
        return moduleList;
    }

    public static void fetchModules() {
        String listPath = Client.getClientURL() + "modules/";
        try {
            String line;
            URL listUrl = new URL(listPath);
            Gson gson = new Gson();
            BufferedReader br = new BufferedReader(new InputStreamReader(listUrl.openStream()));
            String jsonString = "";
            while ((line = br.readLine()) != null) {
                jsonString = jsonString + line;
            }
            br.close();
            ModuleResponse response = (ModuleResponse)gson.fromJson(jsonString, ModuleResponse.class);
            if (response != null) {
                response.getModuleList().forEach(moduleEntry -> moduleList.put(moduleEntry.getModule(), moduleEntry.getDescription()));
            } else if (moduleList.size() == 0) {
                moduleList.put("Error", "Could not get list of external Modules!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isModuleInstalled(String moduleName) {
        return moduleList.containsKey(moduleName) && Wrapper.getModuleManager().getModuleList().containsKey(moduleName);
    }

    @EventHandler
    public void onShutdown(StopGameEvent event) {
        File modulesToDelete = new File(ClientSettings.getClientFolderPath().getSettingValue(), "modulesToDelete.json");
        try {
            modulesToDelete.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (ModuleStore.modulesToDelete.size() > 0) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String jsonString = gson.toJson(ModuleStore.modulesToDelete);
            try {
                FileWriter fw = new FileWriter(modulesToDelete);
                fw.write(jsonString);
                fw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static ArrayList<String> getModulesToDelete() {
        return modulesToDelete;
    }

    class ModuleResponse {
        private ArrayList<ModuleEntry> moduleList;

        public ModuleResponse(ArrayList<ModuleEntry> moduleList) {
            this.moduleList = moduleList;
        }

        public ArrayList<ModuleEntry> getModuleList() {
            return this.moduleList;
        }

        public void setModuleList(ArrayList<ModuleEntry> moduleList) {
            this.moduleList = moduleList;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModuleResponse)) {
                return false;
            }
            ModuleResponse other = (ModuleResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ArrayList<ModuleEntry> this$moduleList = this.getModuleList();
            ArrayList<ModuleEntry> other$moduleList = other.getModuleList();
            return !(this$moduleList == null ? other$moduleList != null : !((Object)this$moduleList).equals(other$moduleList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ModuleResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ArrayList<ModuleEntry> $moduleList = this.getModuleList();
            result = result * 59 + ($moduleList == null ? 0 : ((Object)$moduleList).hashCode());
            return result;
        }

        public String toString() {
            return "ModuleStore.ModuleResponse(moduleList=" + this.getModuleList() + ")";
        }
    }
}

