/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.util.render;

import de.paxii.clarinet.Wrapper;
import java.lang.reflect.Field;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.math.AxisAlignedBB;
import org.lwjgl.opengl.GL11;

public class GuiMethods
extends Gui {
    public void drawGradientRectWithOutline(int xs, int ys, int xe, int ye, int c, int c1, int c2) {
        this.drawGradientRect(xs + 1, ys + 1, xe - 1, ye - 1, c1, c2);
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        this.drawWHollowBorderedRect(xs * 2 + 1, ys * 2 + 1, xe * 2 - 1, ye * 2 - 1, 1, c);
        GL11.glPopMatrix();
    }

    public static void drawGradientBorderedRect(double x, double y, double x2, double y2, float l1, int col1, int col2, int col3) {
        float f = (float)(col1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(col1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(col1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(col1 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        GL11.glDisable((int)3042);
        GL11.glPushMatrix();
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        GL11.glLineWidth((float)1.0f);
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x, (double)y2);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glVertex2d((double)x2, (double)y);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x2, (double)y);
        GL11.glVertex2d((double)x, (double)y2);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glEnd();
        GL11.glPopMatrix();
        GuiMethods.drawGradientRect(x, y, x2, y2, col2, col3);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2848);
    }

    public static void drawGradientRect(double x, double y, double x2, double y2, int col1, int col2) {
        float f = (float)(col1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(col1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(col1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(col1 & 0xFF) / 255.0f;
        float f4 = (float)(col2 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(col2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(col2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(col2 & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        GL11.glShadeModel((int)7425);
        GL11.glPushMatrix();
        GL11.glBegin((int)7);
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        GL11.glVertex2d((double)x2, (double)y);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glColor4f((float)f5, (float)f6, (float)f7, (float)f4);
        GL11.glVertex2d((double)x, (double)y2);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2848);
        GL11.glShadeModel((int)7424);
    }

    public static void drawRoundedRect(int x, int y, int x1, int y1, int borderC, int insideC) {
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        GuiMethods.drawVerticalLine(x *= 2, (y *= 2) + 3, (y1 *= 2) - 4, borderC);
        GuiMethods.drawVerticalLine((x1 *= 2) - 1, y + 3, y1 - 4, borderC);
        GuiMethods.drawHorizontalLine(x + 4, x1 - 5, y, borderC);
        GuiMethods.drawHorizontalLine(x + 4, x1 - 5, y1 - 1, borderC);
        GuiMethods.drawVerticalLine(x + 1, y + 1, y + 4, borderC);
        GuiMethods.drawHorizontalLine(x + 3, x + 2, y + 1, borderC);
        GuiMethods.drawVerticalLine(x1 - 2, y + 1, y + 4, borderC);
        GuiMethods.drawHorizontalLine(x1 - 4, x1 - 3, y + 1, borderC);
        GuiMethods.drawVerticalLine(x + 1, y1 - 2, y1 - 5, borderC);
        GuiMethods.drawHorizontalLine(x + 3, x + 2, y1 - 2, borderC);
        GuiMethods.drawVerticalLine(x1 - 2, y1 - 2, y1 - 5, borderC);
        GuiMethods.drawHorizontalLine(x1 - 3, x1 - 4, y1 - 2, borderC);
        GuiMethods.drawRect(x + 2, y + 2, x1 - 2, y1 - 2, insideC);
        GuiMethods.drawVerticalLine(x + 1, y + 3, y1 - 4, insideC);
        GuiMethods.drawVerticalLine(x1 - 2, y + 3, y1 - 4, insideC);
        GuiMethods.drawHorizontalLine(x + 4, x1 - 5, y + 1, insideC);
        GuiMethods.drawHorizontalLine(x + 4, x1 - 5, y1 - 2, insideC);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
    }

    public void drawGradientRectWithOutline(int xs, int ys, int xe, int ye, int c, int c1, int c2, int c3) {
        this.drawGradientRect(xs + 1, ys + 1, xe - 1, ye - 1, c1, c2);
        GuiMethods.drawVerticalLine(xs + 1, ys, ye - 1, c3);
        GuiMethods.drawHorizontalLine(xs + 1, xe - 2, ys + 1, c3);
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        this.drawWHollowBorderedRect(xs * 2 + 1, ys * 2 + 1, xe * 2 - 1, ye * 2 - 1, 1, c);
        GL11.glPopMatrix();
    }

    public void drawSmallRect(int x, int y, int x1, int y1, int CO1) {
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        GuiMethods.drawRect(x * 2, y * 2, x1 * 2, y1 * 2, CO1);
        GL11.glPopMatrix();
    }

    public void drawSmallWHollowBorderedRect(int x, int y, int x1, int y1, int CO1) {
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        this.drawWHollowBorderedRect(x * 2, y * 2, x1 * 2, y1 * 2, CO1);
        GL11.glPopMatrix();
    }

    public void drawWHollowBorderedRect(int x, int y, int x1, int y1, int CO1) {
        GuiMethods.drawVerticalLine(x, y, y1 - 1, CO1);
        GuiMethods.drawVerticalLine(x1 - 1, y, y1 - 1, CO1);
        GuiMethods.drawHorizontalLine(x + 1, x1 - 2, y, CO1);
        GuiMethods.drawHorizontalLine(x + 1, x1 - 2, y1 - 1, CO1);
    }

    public void drawBarMethod(int x, int y, int x1, int y1, int CO1, int CO2, int CO3) {
        this.drawSmallWBorderedBarRect(x, y, x1, y1, CO1, CO2, CO3);
    }

    public void drawSmallWBorderedBarRect(int x, int y, int x1, int y1, int CO1, int CO2, int CO3) {
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        this.drawWBorderedBarRect(x * 2, y * 2, x1 * 2, y1 * 2, CO1, CO2, CO3);
        GL11.glPopMatrix();
    }

    public void drawWBorderedBarRect(int x, int y, int x1, int y1, int CO1, int CO2, int CO3) {
        GuiMethods.drawRect(x + 1, y + 1, x1 - 1, y1 - 1, CO2);
        GuiMethods.drawRect(x + 1, y + 1, x1 - 1, y1 - 6, CO3);
        GuiMethods.drawVerticalLine(x, y, y1 - 1, CO1);
        GuiMethods.drawVerticalLine(x1 - 1, y, y1 - 1, CO1);
        GuiMethods.drawHorizontalLine(x + 1, x1 - 2, y, CO1);
        GuiMethods.drawHorizontalLine(x + 1, x1 - 2, y1 - 1, CO1);
    }

    public static void drawRect(int x, int y, int x2, int y2, int col1) {
        float f = (float)(col1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(col1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(col1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(col1 & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        GL11.glPushMatrix();
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)x2, (double)y);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x, (double)y2);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glEnd();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2848);
    }

    public void drawGradientRect2(int x, int y, int x2, int y2, int col1, int col2) {
        float f = (float)(col1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(col1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(col1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(col1 & 0xFF) / 255.0f;
        float f4 = (float)(col2 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(col2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(col2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(col2 & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        GL11.glShadeModel((int)7425);
        GL11.glPushMatrix();
        GL11.glBegin((int)7);
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        GL11.glVertex2d((double)x2, (double)y);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glColor4f((float)f5, (float)f6, (float)f7, (float)f4);
        GL11.glVertex2d((double)x, (double)y2);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2848);
        GL11.glShadeModel((int)7424);
    }

    public void drawRoundedGradientRect(int x, int y, int x1, int y1, int size, int col1, int col2, int borderC) {
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        GuiMethods.drawVerticalLine(x *= 2, (y *= 2) + 1, (y1 *= 2) - 2, borderC);
        GuiMethods.drawVerticalLine((x1 *= 2) - 1, y + 1, y1 - 2, borderC);
        GuiMethods.drawHorizontalLine(x + 2, x1 - 3, y, borderC);
        GuiMethods.drawHorizontalLine(x + 2, x1 - 3, y1 - 1, borderC);
        GuiMethods.drawHorizontalLine(x + 1, x + 1, y + 1, borderC);
        GuiMethods.drawHorizontalLine(x1 - 2, x1 - 2, y + 1, borderC);
        GuiMethods.drawHorizontalLine(x1 - 2, x1 - 2, y1 - 2, borderC);
        GuiMethods.drawHorizontalLine(x + 1, x + 1, y1 - 2, borderC);
        float f = (float)(col1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(col1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(col1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(col1 & 0xFF) / 255.0f;
        float f4 = (float)(col2 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(col2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(col2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(col2 & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        GL11.glShadeModel((int)7425);
        GL11.glPushMatrix();
        GL11.glBegin((int)7);
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        GL11.glVertex2d((double)x1, (double)y);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glColor4f((float)f5, (float)f6, (float)f7, (float)f4);
        GL11.glVertex2d((double)x, (double)y1);
        GL11.glVertex2d((double)x1, (double)y1);
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2848);
        GL11.glShadeModel((int)7424);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
    }

    public static void drawBar(int x, int y, int x2, int y2, float l1, int col1, int col2, int col3, int var, boolean inverse) {
        int height = (y2 - y) / 2;
        if (inverse) {
            GuiMethods.drawRect(x, y, x2, y2, col1);
            GuiMethods.drawRect(x2 - var * 4 - 2, y, x2, y + height, col2);
            GuiMethods.drawRect(x2 - var * 4 - 2, y + height, x2, y2, col3);
        } else {
            GuiMethods.drawRect(x, y, x2, y2, col1);
            GuiMethods.drawRect(x, y, x + var * 4 + 2, y + height, col2);
            GuiMethods.drawRect(x, y + height, x + var * 4 + 2, y2, col3);
        }
        float f = (float)(col1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(col1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(col1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(col1 & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        GL11.glPushMatrix();
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        GL11.glLineWidth((float)l1);
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x, (double)y2);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glVertex2d((double)x2, (double)y);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x2, (double)y);
        GL11.glVertex2d((double)x, (double)y2);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2848);
    }

    public static void drawBorderedRect(int x, int y, int x2, int y2, float l1, int col1, int col2) {
        GuiMethods.drawRect(x, y, x2, y2, col2);
        float f = (float)(col1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(col1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(col1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(col1 & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        GL11.glPushMatrix();
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        GL11.glLineWidth((float)l1);
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x, (double)y2);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glVertex2d((double)x2, (double)y);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x2, (double)y);
        GL11.glVertex2d((double)x, (double)y2);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2848);
    }

    public static void drawStringWithMaxWidth(String s, int x, int y, int c, int maxWidth) {
        GL11.glPushMatrix();
        float scaleFactor = 1.0f;
        float f1 = 1.0f;
        while ((float)Wrapper.getFontRenderer().getStringWidth(s) * f1 > (float)maxWidth) {
            scaleFactor = f1;
            f1 -= 0.01f;
        }
        GL11.glScalef((float)scaleFactor, (float)scaleFactor, (float)scaleFactor);
        Wrapper.getFontRenderer().drawString(s, (int)((float)x * (1.0f / scaleFactor)), (int)((float)y * (1.0f / scaleFactor)), c);
        GL11.glPopMatrix();
    }

    public static void drawHollowBorderedRect(int x, int y, int x2, int y2, float l1, int col1) {
        float f = (float)(col1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(col1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(col1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(col1 & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        GL11.glPushMatrix();
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        GL11.glLineWidth((float)l1);
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x, (double)y2);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glVertex2d((double)x2, (double)y);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x2, (double)y);
        GL11.glVertex2d((double)x, (double)y2);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2848);
    }

    public void drawGradientBorderedRect(int x, int y, int x2, int y2, float l1, int col1, int col2, int col3) {
        this.drawGradientRect(x, y, x2, y2, col2, col3);
        float f = (float)(col1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(col1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(col1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(col1 & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        GL11.glPushMatrix();
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        GL11.glLineWidth((float)l1);
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x, (double)y2);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glVertex2d((double)x2, (double)y);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x2, (double)y);
        GL11.glVertex2d((double)x, (double)y2);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2848);
    }

    public void drawWHollowBorderedRect(int x, int y, int x1, int y1, int size, int borderC) {
        Gui.drawVerticalLine(x, y + 1, y1 - 2, borderC);
        Gui.drawVerticalLine(x1 - 1, y + 1, y1 - 2, borderC);
        Gui.drawHorizontalLine(x + 2, x1 - 3, y, borderC);
        Gui.drawHorizontalLine(x + 2, x1 - 3, y1 - 1, borderC);
        Gui.drawHorizontalLine(x + 1, x + 1, y + 1, borderC);
        Gui.drawHorizontalLine(x1 - 2, x1 - 2, y + 1, borderC);
        Gui.drawHorizontalLine(x1 - 2, x1 - 2, y1 - 2, borderC);
        Gui.drawHorizontalLine(x + 1, x + 1, y1 - 2, borderC);
    }

    public static void drawVerticalLine(int x, int y, int y2, float l1, int col1) {
        float f = (float)(col1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(col1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(col1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(col1 & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        GL11.glPushMatrix();
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        GL11.glLineWidth((float)l1);
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x, (double)y2);
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2848);
    }

    public static void drawHorizontalLine(int x, int x2, int y, float l1, int col1) {
        float f = (float)(col1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(col1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(col1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(col1 & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        GL11.glPushMatrix();
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        GL11.glLineWidth((float)l1);
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x2, (double)y);
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2848);
    }

    public static void drawDiagonalLine(int x, int x2, int y, float l1, int col1) {
        float f = (float)(col1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(col1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(col1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(col1 & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        GL11.glPushMatrix();
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        GL11.glLineWidth((float)l1);
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)y, (double)x2);
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2848);
    }

    public static void drawCircle(int xx, int yy, int radius, int col) {
        float f = (float)(col >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(col >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(col >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(col & 0xFF) / 255.0f;
        int sections = 70;
        double dAngle = Math.PI * 2 / (double)sections;
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        GL11.glShadeModel((int)7425);
        GL11.glBegin((int)2);
        for (int i = 0; i < sections; ++i) {
            float x = (float)((double)radius * Math.cos((double)i * dAngle));
            float y = (float)((double)radius * Math.sin((double)i * dAngle));
            GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
            GL11.glVertex2f((float)((float)xx + x), (float)((float)yy + y));
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2848);
        GL11.glPopMatrix();
    }

    public static void drawFilledCircle(int xx, int yy, float radius, int col) {
        float f = (float)(col >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(col >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(col >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(col & 0xFF) / 255.0f;
        int sections = 50;
        double dAngle = Math.PI * 2 / (double)sections;
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        GL11.glBegin((int)6);
        for (int i = 0; i < sections; ++i) {
            float x = (float)((double)radius * Math.sin((double)i * dAngle));
            float y = (float)((double)radius * Math.cos((double)i * dAngle));
            GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
            GL11.glVertex2f((float)((float)xx + x), (float)((float)yy + y));
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2848);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public void drawMoreRoundedBorderedRect2(int x, int y, int x1, int y1, int size, int borderC, int insideC) {
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        GuiMethods.drawVerticalLine(x *= 2, (y *= 2) + 1, (y1 *= 2) - 2, borderC);
        GuiMethods.drawVerticalLine((x1 *= 2) - 1, y + 1, y1 - 2, borderC);
        GuiMethods.drawHorizontalLine(x + 2, x1 - 3, y, borderC);
        GuiMethods.drawHorizontalLine(x + 2, x1 - 3, y1 - 1, borderC);
        GuiMethods.drawHorizontalLine(x + 1, x + 1, y + 1, borderC);
        GuiMethods.drawHorizontalLine(x1 - 2, x1 - 2, y + 1, borderC);
        GuiMethods.drawHorizontalLine(x1 - 2, x1 - 2, y1 - 2, borderC);
        GuiMethods.drawHorizontalLine(x + 1, x + 1, y1 - 2, borderC);
        GuiMethods.drawRect(x + size, y + size, x1 - size, y1 - size, insideC);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
    }

    public static void drawTri(int i, int j, int k) {
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f = (float)(k >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(k >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(k >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(k & 0xFF) / 255.0f;
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2848);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        GL11.glVertex2d((double)i, (double)(j + 2));
        GL11.glVertex2d((double)(i + 2), (double)(j - 2));
        GL11.glVertex2d((double)(i - 2), (double)(j - 2));
        GL11.glEnd();
        GL11.glDisable((int)2848);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glRotatef((float)-180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    public static int ConvertRGB(int r, int g, int b) {
        int value = 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
        return value;
    }

    public static void drawFlagTri(int i, int j, int k) {
        float f = (float)(k >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(k >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(k >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(k & 0xFF) / 255.0f;
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)255.0f);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2848);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        GL11.glVertex2d((double)i, (double)(j + 2));
        GL11.glVertex2d((double)i, (double)(j - 2));
        GL11.glVertex2d((double)(i - 2), (double)j);
        GL11.glEnd();
        GL11.glDisable((int)2848);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawRightTri(int i, int j, int k) {
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f = (float)(k >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(k >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(k >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(k & 0xFF) / 255.0f;
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)255.0f);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2848);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        GL11.glVertex2d((double)i, (double)(j + 2));
        GL11.glVertex2d((double)i, (double)(j - 2));
        GL11.glVertex2d((double)(i - 2), (double)j);
        GL11.glEnd();
        GL11.glDisable((int)2848);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glRotatef((float)-180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    public void color(int c) {
        float f = (float)(c >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(c >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(c >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(c & 0xFF) / 255.0f;
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
    }

    public static void drawDownTri(int i, int j, int k) {
        float f = (float)(k >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(k >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(k >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(k & 0xFF) / 255.0f;
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)255.0f);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2848);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        GL11.glVertex2d((double)i, (double)(j + 2));
        GL11.glVertex2d((double)(i + 2), (double)(j - 2));
        GL11.glVertex2d((double)(i - 2), (double)(j - 2));
        GL11.glEnd();
        GL11.glDisable((int)2848);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawDownLeft(int i, int j, int k) {
        float f = (float)(k >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(k >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(k >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(k & 0xFF) / 255.0f;
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)255.0f);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2848);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        GL11.glVertex2d((double)(i - 2), (double)(j + 2));
        GL11.glVertex2d((double)(i + 2), (double)(j - 1));
        GL11.glVertex2d((double)(i - 2), (double)(j - 2));
        GL11.glEnd();
        GL11.glDisable((int)2848);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawDownRight(int i, int j, int k) {
        float f = (float)(k >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(k >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(k >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(k & 0xFF) / 255.0f;
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)255.0f);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2848);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        GL11.glVertex2d((double)(i + 2), (double)(j + 2));
        GL11.glVertex2d((double)(i + 2), (double)(j - 2));
        GL11.glVertex2d((double)(i - 2), (double)(j - 1));
        GL11.glEnd();
        GL11.glDisable((int)2848);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawUpLeft(int i, int j, int k) {
        float f = (float)(k >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(k >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(k >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(k & 0xFF) / 255.0f;
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)255.0f);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2848);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        GL11.glVertex2d((double)(i - 2), (double)(j + 2));
        GL11.glVertex2d((double)(i + 2), (double)(j - 1));
        GL11.glVertex2d((double)(i - 2), (double)(j - 2));
        GL11.glEnd();
        GL11.glDisable((int)2848);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawUpRight(int i, int j, int k) {
        float f = (float)(k >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(k >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(k >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(k & 0xFF) / 255.0f;
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)255.0f);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2848);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        GL11.glVertex2d((double)(i - 1), (double)(j + 2));
        GL11.glVertex2d((double)(i + 1), (double)(j - 3));
        GL11.glVertex2d((double)(i - 3), (double)(j - 2));
        GL11.glEnd();
        GL11.glDisable((int)2848);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawUpTri(int i, int j, int k) {
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f = (float)(k >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(k >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(k >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(k & 0xFF) / 255.0f;
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2848);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        GL11.glVertex2d((double)i, (double)(j + 2));
        GL11.glVertex2d((double)(i + 2), (double)(j - 2));
        GL11.glVertex2d((double)(i - 2), (double)(j - 2));
        GL11.glEnd();
        GL11.glDisable((int)2848);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glRotatef((float)-180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    public static void drawTriSight(int i, int j, int k) {
        float f = (float)(k >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(k >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(k >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(k & 0xFF) / 255.0f;
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2848);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        GL11.glVertex2d((double)i, (double)(j + 2));
        GL11.glVertex2d((double)(i + 4), (double)(j - 4));
        GL11.glVertex2d((double)(i - 4), (double)(j - 4));
        GL11.glEnd();
        GL11.glDisable((int)2848);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawFullCircle(int i, int j, double d, int k) {
        float f = (float)(k >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(k >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(k >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(k & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2848);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        GL11.glBegin((int)6);
        for (int l = 0; l <= 360; ++l) {
            double d1 = Math.sin((double)l * Math.PI / 180.0) * d;
            double d2 = Math.cos((double)l * Math.PI / 180.0) * d;
            GL11.glVertex2d((double)((double)i + d1), (double)((double)j + d2));
        }
        GL11.glEnd();
        GL11.glDisable((int)2848);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void DrawCircle(float f, float f1, float f2, int i, int j) {
        float f3 = (float)(j >> 24 & 0xFF) / 255.0f;
        float f4 = (float)(j >> 16 & 0xFF) / 255.0f;
        float f5 = (float)(j >> 8 & 0xFF) / 255.0f;
        float f6 = (float)(j & 0xFF) / 255.0f;
        float f7 = (float)(Math.PI * 2 / (double)i);
        float f8 = (float)Math.cos(f7);
        float f9 = (float)Math.sin(f7);
        GL11.glColor4f((float)f4, (float)f5, (float)f6, (float)f3);
        float f11 = f2;
        float f12 = 0.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2848);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)2);
        for (int k = 0; k < i; ++k) {
            GL11.glVertex2f((float)(f11 + f), (float)(f12 + f1));
            float f10 = f11;
            f11 = f8 * f11 - f9 * f12;
            f12 = f9 * f10 + f8 * f12;
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2848);
    }

    public static void drawBorderedRect(int x, int y, int x1, int y1, int size, int borderC, int insideC) {
        GuiMethods.drawVerticalLine(x, y, y1 - 1, borderC);
        GuiMethods.drawVerticalLine(x1 - 1, y, y1 - 1, borderC);
        GuiMethods.drawHorizontalLine(x, x1 - 1, y, borderC);
        GuiMethods.drawHorizontalLine(x, x1 - 1, y1 - 1, borderC);
        GuiMethods.drawRect(x + size, y + size, x1 - size, y1 - size, insideC);
    }

    public static void drawWBorderedRect(int x, int y, int x1, int y1, int size, int borderC, int insideC) {
        GuiMethods.drawVerticalLine(x, y, y1 - 1, borderC);
        GuiMethods.drawVerticalLine(x1 - 1, y, y1 - 1, borderC);
        GuiMethods.drawHorizontalLine(x + 1, x1 - 2, y, borderC);
        GuiMethods.drawHorizontalLine(x + 1, x1 - 2, y1 - 1, borderC);
        GuiMethods.drawRect(x + size, y + size, x1 - size, y1 - size, insideC);
    }

    public static void drawWHollowBorderedRect2(int x, int y, int x1, int y1, int size, int borderC) {
        GuiMethods.drawVerticalLine(x, y, y1 - 1, borderC);
        GuiMethods.drawVerticalLine(x1 - 1, y, y1 - 1, borderC);
        GuiMethods.drawHorizontalLine(x + 1, x1 - 2, y, borderC);
        GuiMethods.drawHorizontalLine(x + 1, x1 - 2, y1 - 1, borderC);
    }

    public void drawBorderedGradientRect(int x, int y, int x1, int y1, int size, int borderC, int insideC1, int insideC2) {
        GuiMethods.drawVerticalLine(x, y, y1 - 1, borderC);
        GuiMethods.drawVerticalLine(x1 - 1, y, y1 - 1, borderC);
        GuiMethods.drawHorizontalLine(x, x1 - 1, y, borderC);
        GuiMethods.drawHorizontalLine(x, x1 - 1, y1 - 1, borderC);
        this.drawGradientRect(x + size, y + size, x1 - size, y1 - size, insideC1, insideC2);
    }

    public void drawWBorderedGradientRect(int x, int y, int x1, int y1, int size, int borderC, int insideC1, int insideC2) {
        GuiMethods.drawVerticalLine(x, y, y1 - 1, borderC);
        GuiMethods.drawVerticalLine(x1 - 1, y, y1 - 1, borderC);
        GuiMethods.drawHorizontalLine(x + 1, x1 - 2, y, borderC);
        GuiMethods.drawHorizontalLine(x + 1, x1 - 2, y1 - 1, borderC);
        this.drawGradientRect(x + size, y + size, x1 - size, y1 - size, insideC1, insideC2);
    }

    public void drawBorderedRectWithString(String s, int x, int y, int x1, int y1, int size, int borderC, int insideC, int SC) {
        GuiMethods.drawVerticalLine(x, y, y1 - 1, borderC);
        GuiMethods.drawVerticalLine(x1 - 1, y, y1 - 1, borderC);
        GuiMethods.drawHorizontalLine(x, x1 - 1, y, borderC);
        GuiMethods.drawHorizontalLine(x, x1 - 1, y1 - 1, borderC);
        GuiMethods.drawRect(x + size, y + size, x1 - size, y1 - size, insideC);
        int S1 = (x1 - x) / 2;
        int S2 = x1 - S1 - Wrapper.getFontRenderer().getStringWidth(s) / 2;
        int S3 = (y1 - y) / 2;
        int S4 = y1 - S3;
        Wrapper.getFontRenderer().drawString(s, S2, S4 - 4, SC);
    }

    public void drawBorderedGradientRectWithString(String s, int x, int y, int x1, int y1, int size, int borderC, int insideC1, int insideC2, int SC) {
        GuiMethods.drawVerticalLine(x, y, y1 - 1, borderC);
        GuiMethods.drawVerticalLine(x1 - 1, y, y1 - 1, borderC);
        GuiMethods.drawHorizontalLine(x, x1 - 1, y, borderC);
        GuiMethods.drawHorizontalLine(x, x1 - 1, y1 - 1, borderC);
        this.drawGradientRect(x + size, y + size, x1 - size, y1 - size, insideC1, insideC2);
        int S1 = (x1 - x) / 2;
        int S2 = x1 - S1 - Wrapper.getFontRenderer().getStringWidth(s) / 2;
        int S3 = (y1 - y) / 2;
        int S4 = y1 - S3;
        Wrapper.getFontRenderer().drawString(s, S2, S4 - 4, SC);
    }

    public void drawRectGui(String s, int X, int Y, boolean F) {
        GuiMethods.drawRect(X, Y, X + 80, Y + 12, 0x43000000);
        GuiMethods.drawRect(X + 80, Y, X + 86, Y + 12, F ? -117375232 : -100728832);
        Wrapper.getFontRenderer().drawString(s, X + 3, Y + 2, 0xFFFFFF);
    }

    public void drawBorderedRectGui(String s, int X, int Y, boolean F) {
        GuiMethods.drawBorderedRect(X, Y, X + 80, Y + 12, 1, -16777216, 0x43000000);
        GuiMethods.drawRect(X + 80, Y, X + 86, Y + 12, F ? -117375232 : -100728832);
        Wrapper.getFontRenderer().drawString(s, X + 3, Y + 2, 0xFFFFFF);
    }

    public void drawBorderedRectGuiArraylist(String s, int X, int Y) {
        GuiMethods.drawBorderedRect(X, Y, X + 80, Y + 12, 1, -16777216, 0x43000000);
        Wrapper.getFontRenderer().drawString(s, X + 3, Y + 2, 0xFFFFFF);
    }

    public static void drawMoreRoundedBorderedRect(int x, int y, int x1, int y1, int size, int borderC, int insideC) {
        GuiMethods.drawVerticalLine(x, y + 1, y1 - 2, borderC);
        GuiMethods.drawVerticalLine(x1 - 1, y + 1, y1 - 2, borderC);
        GuiMethods.drawHorizontalLine(x + 2, x1 - 3, y, borderC);
        GuiMethods.drawHorizontalLine(x + 2, x1 - 3, y1 - 1, borderC);
        GuiMethods.drawHorizontalLine(x + 1, x + 1, y + 1, borderC);
        GuiMethods.drawHorizontalLine(x1 - 2, x1 - 2, y + 1, borderC);
        GuiMethods.drawHorizontalLine(x1 - 2, x1 - 2, y1 - 2, borderC);
        GuiMethods.drawHorizontalLine(x + 1, x + 1, y1 - 2, borderC);
        GuiMethods.drawRect(x + size, y + size, x1 - size, y1 - size, insideC);
    }

    public void drawSmallStringWithShadow(String s, int x, int y, int c) {
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        Wrapper.getFontRenderer().drawString(s, x * 2, y * 2, c);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
    }

    public void drawSmallString(String s, int x, int y, int c) {
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        Wrapper.getFontRenderer().drawString(s, x * 2, y * 2, c);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
    }

    public int getOpenGLVar(String name) {
        try {
            try {
                Field f = GL11.class.getDeclaredField(name);
                return f.getInt(null);
            }
            catch (NoSuchFieldException e) {
                Field[] af = GL11.class.getDeclaredFields();
                if (!name.startsWith("GL_")) {
                    name = "GL_" + name;
                }
                for (Field f : af) {
                    if (!f.getName().toLowerCase().replace("_", "").equals(name)) continue;
                    return f.getInt(null);
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return -1;
    }

    public String getOpenGLVar(int id) {
        Field[] af;
        for (Field f : af = GL11.class.getDeclaredFields()) {
            try {
                if (f.getInt(null) != id) continue;
                return f.getName();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void drawCircle(int x, int y, double r, int numseg, int c) {
        float f = (float)(c >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(c >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(c >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(c & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2848);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        GL11.glBegin((int)2);
        for (int i = 0; i <= numseg; ++i) {
            double x2 = Math.sin((double)i * Math.PI / (double)(numseg / 2)) * r;
            double y2 = Math.cos((double)i * Math.PI / (double)(numseg / 2)) * r;
            GL11.glVertex2d((double)((double)x + x2), (double)((double)y + y2));
        }
        GL11.glEnd();
        GL11.glDisable((int)2848);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public void drawFilledCircle(int x, int y, double r, int numseg, int c) {
        float f = (float)(c >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(c >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(c >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(c & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2848);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        GL11.glBegin((int)6);
        for (int i = 0; i <= numseg; ++i) {
            double x2 = Math.sin((double)i * Math.PI / (double)(numseg / 2)) * r;
            double y2 = Math.cos((double)i * Math.PI / (double)(numseg / 2)) * r;
            GL11.glVertex2d((double)((double)x + x2), (double)((double)y + y2));
        }
        GL11.glEnd();
        GL11.glDisable((int)2848);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public void drawTriangle(int x, int y, double side, int c) {
        float f = (float)(c >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(c >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(c >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(c & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2848);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        GL11.glBegin((int)6);
        GL11.glVertex2d((double)((double)x + side / 2.0), (double)y);
        GL11.glVertex2d((double)((double)x - side / 2.0), (double)y);
        double a = Math.sqrt(side * side - side / 2.0 * (side / 2.0));
        GL11.glVertex2d((double)x, (double)((double)y + a));
        GL11.glEnd();
        GL11.glDisable((int)2848);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawHLine(float par1, float par2, float par3, int par4) {
        if (par2 < par1) {
            float var5 = par1;
            par1 = par2;
            par2 = var5;
        }
        GuiMethods.drawRect((int)par1, (int)par3, (int)par2 + 1, (int)par3 + 1, par4);
    }

    public void drawRect(double x, double y, double d, double e, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        this.drawRect(x, y, d, e, red, green, blue, alpha);
    }

    public void drawRect(double x, double y, double x1, double y1, float r, float g, float b, float a) {
        this.start2dRendering();
        this.enableSmoothing();
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        this.drawRect(x, y, x1, y1);
        this.end2dRendering();
        this.disableSmoothing();
    }

    public void drawRect(double x, double y, double x1, double y1) {
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)x, (double)y1);
        GL11.glVertex2d((double)x1, (double)y1);
        GL11.glVertex2d((double)x1, (double)y);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glEnd();
    }

    public void enableSmoothing() {
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
    }

    public void disableSmoothing() {
        GL11.glDisable((int)2848);
    }

    public void start2dRendering() {
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
    }

    public void end2dRendering() {
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
    }

    public void drawOutlinedBox(AxisAlignedBB box) {
        GL11.glBegin((int)3);
        GL11.glVertex3d((double)box.minX, (double)box.minY, (double)box.minZ);
        GL11.glVertex3d((double)box.maxX, (double)box.minY, (double)box.minZ);
        GL11.glVertex3d((double)box.maxX, (double)box.minY, (double)box.maxZ);
        GL11.glVertex3d((double)box.minX, (double)box.minY, (double)box.maxZ);
        GL11.glVertex3d((double)box.minX, (double)box.minY, (double)box.minZ);
        GL11.glEnd();
        GL11.glBegin((int)3);
        GL11.glVertex3d((double)box.minX, (double)box.maxY, (double)box.minZ);
        GL11.glVertex3d((double)box.maxX, (double)box.maxY, (double)box.minZ);
        GL11.glVertex3d((double)box.maxX, (double)box.maxY, (double)box.maxZ);
        GL11.glVertex3d((double)box.minX, (double)box.maxY, (double)box.maxZ);
        GL11.glVertex3d((double)box.minX, (double)box.maxY, (double)box.minZ);
        GL11.glEnd();
        GL11.glBegin((int)1);
        GL11.glVertex3d((double)box.minX, (double)box.minY, (double)box.minZ);
        GL11.glVertex3d((double)box.minX, (double)box.maxY, (double)box.minZ);
        GL11.glVertex3d((double)box.maxX, (double)box.minY, (double)box.minZ);
        GL11.glVertex3d((double)box.maxX, (double)box.maxY, (double)box.minZ);
        GL11.glVertex3d((double)box.maxX, (double)box.minY, (double)box.maxZ);
        GL11.glVertex3d((double)box.maxX, (double)box.maxY, (double)box.maxZ);
        GL11.glVertex3d((double)box.minX, (double)box.minY, (double)box.maxZ);
        GL11.glVertex3d((double)box.minX, (double)box.maxY, (double)box.maxZ);
        GL11.glEnd();
    }
}

