/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.util.update;

import com.google.gson.Gson;
import de.paxii.clarinet.Client;
import de.paxii.clarinet.Wrapper;
import de.paxii.clarinet.util.module.file.FileManager;
import de.paxii.clarinet.util.module.store.ModuleStore;
import de.paxii.clarinet.util.settings.ClientSettings;
import de.paxii.clarinet.util.update.VersionObject;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JOptionPane;

public class UpdateChecker {
    private static String latestVersion;
    private static boolean upToDate;

    public UpdateChecker() {
        this.checkForUpdates();
    }

    public void checkForUpdates() {
        new Thread(() -> {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(new URL(Client.getClientURL() + "version.json").openStream()));
                Gson gson = new Gson();
                while ((line = br.readLine()) != null) {
                    if (line.length() <= 0) continue;
                    VersionObject newVersion = (VersionObject)gson.fromJson(line, VersionObject.class);
                    latestVersion = newVersion.getVersion();
                    int latestVersionInt = Integer.parseInt(latestVersion.replaceAll("[^0-9]", ""));
                    int currentVersionInt = Integer.parseInt(Client.getClientVersion().replaceAll("[^0-9]", ""));
                    if (currentVersionInt >= latestVersionInt) continue;
                    upToDate = false;
                }
                br.close();
                ModuleStore.fetchModules();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
        new Thread(() -> {
            try {
                URL is = this.getClass().getResource("/Updater.jar");
                String currentUpdaterPath = is.toURI().toString();
                File thisUpdater = new File(currentUpdaterPath);
                File updaterFile = new File(ClientSettings.getClientFolderPath().getSettingValue() + "/Updater.jar");
                if (thisUpdater.exists()) {
                    if (updaterFile.exists()) {
                        if (updaterFile.length() != thisUpdater.length()) {
                            updaterFile.delete();
                        } else {
                            return;
                        }
                    }
                    FileManager.copyFileFromJar("Updater.jar", updaterFile);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
        new Thread(() -> {
            block30: {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!Boolean.parseBoolean(ClientSettings.getClientSettings().get("client.update").getSettingValue())) {
                    return;
                }
                if (!UpdateChecker.isUpToDate()) {
                    File updaterFile = new File(ClientSettings.getClientFolderPath().getSettingValue() + "/Updater.jar");
                    if (updaterFile.exists()) {
                        try {
                            int answer = JOptionPane.showConfirmDialog(null, "There is an Update available, would you like to update?", "Matix Update", 0);
                            if (answer == 0) {
                                Runtime.getRuntime().exec("javaw -jar \"" + updaterFile.getAbsolutePath() + "\"");
                                Wrapper.getMinecraft().shutdown();
                            }
                        }
                        catch (IOException e) {
                            Desktop desktop;
                            int answer = JOptionPane.showConfirmDialog(null, "There is an Update available, but the Updater could not be started. Would you like to open your Browser?", "Matix Update", 0);
                            if (answer != 0) break block30;
                            URL url = null;
                            try {
                                String line;
                                url = new URL("http://paxii.de/Matix/download.json");
                                BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
                                while ((line = br.readLine()) != null) {
                                    if (line.length() <= 0 || !line.contains("string") || !line.contains("\"")) continue;
                                    String downloadURL = line.split("\"")[3];
                                    url = new URL(downloadURL);
                                }
                            }
                            catch (IOException br) {
                                // empty catch block
                            }
                            Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                            if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                                if (url != null) {
                                    try {
                                        desktop.browse(url.toURI());
                                    }
                                    catch (IOException ye) {
                                        JOptionPane.showMessageDialog(null, "Could not open your Browser!", "Error", 0);
                                        ye.printStackTrace();
                                    }
                                    catch (URISyntaxException ye) {
                                        JOptionPane.showMessageDialog(null, "Could not get download URL!", "Error", 0);
                                        ye.printStackTrace();
                                    }
                                } else {
                                    JOptionPane.showMessageDialog(null, "Could not get download URL!", "Error", 0);
                                }
                                break block30;
                            }
                            JOptionPane.showMessageDialog(null, "Could not open your Browser!", "Error", 0);
                        }
                    } else {
                        int answer = JOptionPane.showConfirmDialog(null, "There is an Update available, but it seems like the Updater is not properly installed. Would you like to open your Browser?", "Matix Update", 0);
                        if (answer == 0) {
                            Desktop desktop;
                            URL url = null;
                            try {
                                String line;
                                url = new URL("http://paxii.de/Matix/download.json");
                                BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
                                while ((line = br.readLine()) != null) {
                                    if (line.length() <= 0 || !line.contains("string") || !line.contains("\"")) continue;
                                    String downloadURL = line.split("\"")[3];
                                    url = new URL(downloadURL);
                                }
                            }
                            catch (IOException br) {
                                // empty catch block
                            }
                            Desktop desktop3 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                            if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                                if (url != null) {
                                    try {
                                        desktop.browse(url.toURI());
                                    }
                                    catch (IOException e) {
                                        JOptionPane.showMessageDialog(null, "Could not open your Browser!", "Error", 0);
                                        e.printStackTrace();
                                    }
                                    catch (URISyntaxException e) {
                                        JOptionPane.showMessageDialog(null, "Could not get download URL!", "Error", 0);
                                        e.printStackTrace();
                                    }
                                } else {
                                    JOptionPane.showMessageDialog(null, "Could not get download URL!", "Error", 0);
                                }
                            } else {
                                JOptionPane.showMessageDialog(null, "Could not open your Browser!", "Error", 0);
                            }
                        }
                    }
                } else {
                    System.out.println("Matix is up-to-date");
                }
            }
        }).start();
    }

    public static String getLatestVersion() {
        return latestVersion;
    }

    public static boolean isUpToDate() {
        return upToDate;
    }

    static {
        upToDate = true;
    }
}

