/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.BlockBush;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDeadBush
extends BlockBush {
    protected static final AxisAlignedBB field_185516_a = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, 0.9f, 0.8f, 0.9f);

    protected BlockDeadBush() {
        super(Material.vine);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185516_a;
    }

    @Override
    public MapColor getMapColor(IBlockState state) {
        return MapColor.woodColor;
    }

    @Override
    protected boolean func_185514_i(IBlockState p_185514_1_) {
        return p_185514_1_.getBlock() == Blocks.sand || p_185514_1_.getBlock() == Blocks.hardened_clay || p_185514_1_.getBlock() == Blocks.stained_hardened_clay || p_185514_1_.getBlock() == Blocks.dirt;
    }

    @Override
    public boolean isReplaceable(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    @Override
    public int quantityDropped(Random random) {
        return random.nextInt(3);
    }

    @Override
    public Item getItemDropped(IBlockState state, Random rand, int fortune) {
        return Items.stick;
    }

    @Override
    public void harvestBlock(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack p_180657_6_) {
        if (!worldIn.isRemote && p_180657_6_ != null && p_180657_6_.getItem() == Items.shears) {
            player.triggerAchievement(StatList.func_188055_a(this));
            BlockDeadBush.spawnAsEntity(worldIn, pos, new ItemStack(Blocks.deadbush, 1, 0));
        } else {
            super.harvestBlock(worldIn, player, pos, state, te, p_180657_6_);
        }
    }
}

