/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEndGateway;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockEndGateway
extends BlockContainer {
    protected BlockEndGateway(Material p_i46687_1_) {
        super(p_i46687_1_);
        this.setLightLevel(1.0f);
    }

    @Override
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return new TileEntityEndGateway();
    }

    @Override
    public boolean shouldSideBeRendered(IBlockState worldIn, IBlockAccess pos, BlockPos side, EnumFacing facing) {
        IBlockState iblockstate = pos.getBlockState(side.offset(facing));
        Block block = iblockstate.getBlock();
        return !iblockstate.isOpaqueCube() && block != Blocks.end_gateway;
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBox(IBlockState worldIn, World pos, BlockPos p_180646_3_) {
        return NULL_AABB;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_149662_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState state) {
        return false;
    }

    @Override
    public int quantityDropped(Random random) {
        return 0;
    }

    @Override
    public void randomDisplayTick(IBlockState worldIn, World pos, BlockPos state, Random rand) {
        TileEntity tileentity = pos.getTileEntity(state);
        if (tileentity instanceof TileEntityEndGateway) {
            int i = ((TileEntityEndGateway)tileentity).func_184304_i();
            for (int j = 0; j < i; ++j) {
                double d0 = (float)state.getX() + rand.nextFloat();
                double d1 = (float)state.getY() + rand.nextFloat();
                double d2 = (float)state.getZ() + rand.nextFloat();
                double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
                double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
                double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
                int k = rand.nextInt(2) * 2 - 1;
                if (rand.nextBoolean()) {
                    d2 = (double)state.getZ() + 0.5 + 0.25 * (double)k;
                    d5 = rand.nextFloat() * 2.0f * (float)k;
                } else {
                    d0 = (double)state.getX() + 0.5 + 0.25 * (double)k;
                    d3 = rand.nextFloat() * 2.0f * (float)k;
                }
                pos.spawnParticle(EnumParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5, new int[0]);
            }
        }
    }

    @Override
    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return null;
    }

    @Override
    public MapColor getMapColor(IBlockState state) {
        return MapColor.blackColor;
    }
}

