/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockLeaves
extends Block {
    public static final PropertyBool DECAYABLE = PropertyBool.create("decayable");
    public static final PropertyBool CHECK_DECAY = PropertyBool.create("check_decay");
    protected boolean field_185686_c;
    int[] surroundings;

    public BlockLeaves() {
        super(Material.leaves);
        this.setTickRandomly(true);
        this.setCreativeTab(CreativeTabs.tabDecorations);
        this.setHardness(0.2f);
        this.setLightOpacity(1);
        this.setStepSound(SoundType.PLANT);
    }

    @Override
    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        int i1;
        int l;
        int i = 1;
        int j = i + 1;
        int k = pos.getX();
        if (worldIn.isAreaLoaded(new BlockPos(k - j, (l = pos.getY()) - j, (i1 = pos.getZ()) - j), new BlockPos(k + j, l + j, i1 + j))) {
            for (int j1 = -i; j1 <= i; ++j1) {
                for (int k1 = -i; k1 <= i; ++k1) {
                    for (int l1 = -i; l1 <= i; ++l1) {
                        BlockPos blockpos = pos.add(j1, k1, l1);
                        IBlockState iblockstate = worldIn.getBlockState(blockpos);
                        if (iblockstate.getMaterial() != Material.leaves || iblockstate.getValue(CHECK_DECAY).booleanValue()) continue;
                        worldIn.setBlockState(blockpos, iblockstate.withProperty(CHECK_DECAY, true), 4);
                    }
                }
            }
        }
    }

    @Override
    public void updateTick(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.isRemote && state.getValue(CHECK_DECAY).booleanValue() && state.getValue(DECAYABLE).booleanValue()) {
            int l2;
            int i = 4;
            int j = i + 1;
            int k = pos.getX();
            int l = pos.getY();
            int i1 = pos.getZ();
            int j1 = 32;
            int k1 = j1 * j1;
            int l1 = j1 / 2;
            if (this.surroundings == null) {
                this.surroundings = new int[j1 * j1 * j1];
            }
            if (worldIn.isAreaLoaded(new BlockPos(k - j, l - j, i1 - j), new BlockPos(k + j, l + j, i1 + j))) {
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int i2 = -i; i2 <= i; ++i2) {
                    for (int j2 = -i; j2 <= i; ++j2) {
                        for (int k2 = -i; k2 <= i; ++k2) {
                            IBlockState iblockstate = worldIn.getBlockState(blockpos$mutableblockpos.set(k + i2, l + j2, i1 + k2));
                            Block block = iblockstate.getBlock();
                            if (block != Blocks.log && block != Blocks.log2) {
                                if (iblockstate.getMaterial() == Material.leaves) {
                                    this.surroundings[(i2 + l1) * k1 + (j2 + l1) * j1 + k2 + l1] = -2;
                                    continue;
                                }
                                this.surroundings[(i2 + l1) * k1 + (j2 + l1) * j1 + k2 + l1] = -1;
                                continue;
                            }
                            this.surroundings[(i2 + l1) * k1 + (j2 + l1) * j1 + k2 + l1] = 0;
                        }
                    }
                }
                for (int i3 = 1; i3 <= 4; ++i3) {
                    for (int j3 = -i; j3 <= i; ++j3) {
                        for (int k3 = -i; k3 <= i; ++k3) {
                            for (int l3 = -i; l3 <= i; ++l3) {
                                if (this.surroundings[(j3 + l1) * k1 + (k3 + l1) * j1 + l3 + l1] != i3 - 1) continue;
                                if (this.surroundings[(j3 + l1 - 1) * k1 + (k3 + l1) * j1 + l3 + l1] == -2) {
                                    this.surroundings[(j3 + l1 - 1) * k1 + (k3 + l1) * j1 + l3 + l1] = i3;
                                }
                                if (this.surroundings[(j3 + l1 + 1) * k1 + (k3 + l1) * j1 + l3 + l1] == -2) {
                                    this.surroundings[(j3 + l1 + 1) * k1 + (k3 + l1) * j1 + l3 + l1] = i3;
                                }
                                if (this.surroundings[(j3 + l1) * k1 + (k3 + l1 - 1) * j1 + l3 + l1] == -2) {
                                    this.surroundings[(j3 + l1) * k1 + (k3 + l1 - 1) * j1 + l3 + l1] = i3;
                                }
                                if (this.surroundings[(j3 + l1) * k1 + (k3 + l1 + 1) * j1 + l3 + l1] == -2) {
                                    this.surroundings[(j3 + l1) * k1 + (k3 + l1 + 1) * j1 + l3 + l1] = i3;
                                }
                                if (this.surroundings[(j3 + l1) * k1 + (k3 + l1) * j1 + (l3 + l1 - 1)] == -2) {
                                    this.surroundings[(j3 + l1) * k1 + (k3 + l1) * j1 + (l3 + l1 - 1)] = i3;
                                }
                                if (this.surroundings[(j3 + l1) * k1 + (k3 + l1) * j1 + l3 + l1 + 1] != -2) continue;
                                this.surroundings[(j3 + l1) * k1 + (k3 + l1) * j1 + l3 + l1 + 1] = i3;
                            }
                        }
                    }
                }
            }
            if ((l2 = this.surroundings[l1 * k1 + l1 * j1 + l1]) >= 0) {
                worldIn.setBlockState(pos, state.withProperty(CHECK_DECAY, false), 4);
            } else {
                this.destroy(worldIn, pos);
            }
        }
    }

    @Override
    public void randomDisplayTick(IBlockState worldIn, World pos, BlockPos state, Random rand) {
        if (pos.isRainingAt(state.up()) && !pos.getBlockState(state.down()).func_185896_q() && rand.nextInt(15) == 1) {
            double d0 = (float)state.getX() + rand.nextFloat();
            double d1 = (double)state.getY() - 0.05;
            double d2 = (float)state.getZ() + rand.nextFloat();
            pos.spawnParticle(EnumParticleTypes.DRIP_WATER, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    private void destroy(World worldIn, BlockPos pos) {
        this.dropBlockAsItem(worldIn, pos, worldIn.getBlockState(pos), 0);
        worldIn.setBlockToAir(pos);
    }

    @Override
    public int quantityDropped(Random random) {
        return random.nextInt(20) == 0 ? 1 : 0;
    }

    @Override
    public Item getItemDropped(IBlockState state, Random rand, int fortune) {
        return Item.getItemFromBlock(Blocks.sapling);
    }

    @Override
    public void dropBlockAsItemWithChance(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!worldIn.isRemote) {
            int i = this.getSaplingDropChance(state);
            if (fortune > 0 && (i -= 2 << fortune) < 10) {
                i = 10;
            }
            if (worldIn.rand.nextInt(i) == 0) {
                Item item = this.getItemDropped(state, worldIn.rand, fortune);
                BlockLeaves.spawnAsEntity(worldIn, pos, new ItemStack(item, 1, this.damageDropped(state)));
            }
            i = 200;
            if (fortune > 0 && (i -= 10 << fortune) < 40) {
                i = 40;
            }
            this.dropApple(worldIn, pos, state, i);
        }
    }

    protected void dropApple(World worldIn, BlockPos pos, IBlockState state, int chance) {
    }

    protected int getSaplingDropChance(IBlockState state) {
        return 20;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_149662_1_) {
        return !this.field_185686_c;
    }

    public void setGraphicsLevel(boolean fancy) {
        this.field_185686_c = fancy;
    }

    @Override
    public BlockRenderLayer getBlockLayer() {
        return this.field_185686_c ? BlockRenderLayer.CUTOUT_MIPPED : BlockRenderLayer.SOLID;
    }

    @Override
    public boolean isVisuallyOpaque() {
        return false;
    }

    public abstract BlockPlanks.EnumType getWoodType(int var1);

    @Override
    public boolean shouldSideBeRendered(IBlockState worldIn, IBlockAccess pos, BlockPos side, EnumFacing facing) {
        return !this.field_185686_c && pos.getBlockState(side.offset(facing)).getBlock() == this ? false : super.shouldSideBeRendered(worldIn, pos, side, facing);
    }
}

