/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.audio;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ISoundEventAccessor;
import net.minecraft.client.audio.ISoundEventListener;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundList;
import net.minecraft.client.audio.SoundListSerializer;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.audio.SoundRegistry;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SoundHandler
implements IResourceManagerReloadListener,
ITickable {
    public static final Sound missing_sound = new Sound("meta:missing_sound", 1.0f, 1.0f, 1, Sound.Type.FILE, false);
    private static final Logger logger = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(ITextComponent.class, (Object)new ITextComponent.Serializer()).registerTypeAdapter(SoundList.class, (Object)new SoundListSerializer()).create();
    private static final ParameterizedType TYPE = new ParameterizedType(){

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{String.class, SoundList.class};
        }

        @Override
        public Type getRawType() {
            return Map.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    };
    private final SoundRegistry sndRegistry = new SoundRegistry();
    private final SoundManager sndManager;
    private final IResourceManager mcResourceManager;

    public SoundHandler(IResourceManager manager, GameSettings gameSettingsIn) {
        this.mcResourceManager = manager;
        this.sndManager = new SoundManager(this, gameSettingsIn);
    }

    @Override
    public void onResourceManagerReload(IResourceManager resourceManager) {
        this.sndRegistry.clearMap();
        for (String s : resourceManager.getResourceDomains()) {
            try {
                for (IResource iresource : resourceManager.getAllResources(new ResourceLocation(s, "sounds.json"))) {
                    try {
                        Map<String, SoundList> map = this.getSoundMap(iresource.getInputStream());
                        for (Map.Entry<String, SoundList> entry : map.entrySet()) {
                            this.loadSoundResource(new ResourceLocation(s, entry.getKey()), entry.getValue());
                        }
                    }
                    catch (RuntimeException runtimeexception) {
                        logger.warn("Invalid sounds.json", (Throwable)runtimeexception);
                    }
                }
            }
            catch (IOException iOException) {
            }
        }
        for (ResourceLocation resourcelocation : this.sndRegistry.getKeys()) {
            String s1;
            SoundEventAccessor soundeventaccessor = (SoundEventAccessor)this.sndRegistry.getObject(resourcelocation);
            if (!(soundeventaccessor.func_188712_c() instanceof TextComponentTranslation) || I18n.func_188566_a(s1 = ((TextComponentTranslation)soundeventaccessor.func_188712_c()).getKey())) continue;
            logger.debug("Missing subtitle {} for event: {}", new Object[]{s1, resourcelocation});
        }
        for (ResourceLocation resourcelocation1 : this.sndRegistry.getKeys()) {
            if (SoundEvent.soundEventRegistry.getObject(resourcelocation1) != null) continue;
            logger.debug("Not having sound event for: {}", new Object[]{resourcelocation1});
        }
        this.sndManager.reloadSoundSystem();
    }

    protected Map<String, SoundList> getSoundMap(InputStream stream) {
        Map map;
        try {
            map = (Map)GSON.fromJson((Reader)new InputStreamReader(stream), (Type)TYPE);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
        return map;
    }

    private void loadSoundResource(ResourceLocation location, SoundList sounds) {
        boolean flag;
        SoundEventAccessor soundeventaccessor = (SoundEventAccessor)this.sndRegistry.getObject(location);
        boolean bl = flag = soundeventaccessor == null;
        if (flag || sounds.canReplaceExisting()) {
            if (!flag) {
                logger.debug("Replaced sound event location {}", new Object[]{location});
            }
            soundeventaccessor = new SoundEventAccessor(location, sounds.func_188701_c());
            this.sndRegistry.func_186803_a(soundeventaccessor);
        }
        block4: for (Sound sound : sounds.func_188700_a()) {
            ISoundEventAccessor<Sound> isoundeventaccessor;
            final ResourceLocation resourcelocation = sound.func_188719_a();
            switch (sound.func_188722_g()) {
                case FILE: {
                    if (!this.func_184401_a(sound, location)) continue block4;
                    isoundeventaccessor = sound;
                    break;
                }
                case SOUND_EVENT: {
                    isoundeventaccessor = new ISoundEventAccessor<Sound>(){

                        @Override
                        public int getWeight() {
                            SoundEventAccessor soundeventaccessor1 = (SoundEventAccessor)SoundHandler.this.sndRegistry.getObject(resourcelocation);
                            return soundeventaccessor1 == null ? 0 : soundeventaccessor1.getWeight();
                        }

                        @Override
                        public Sound cloneEntry() {
                            SoundEventAccessor soundeventaccessor1 = (SoundEventAccessor)SoundHandler.this.sndRegistry.getObject(resourcelocation);
                            return soundeventaccessor1 == null ? missing_sound : soundeventaccessor1.cloneEntry();
                        }
                    };
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown SoundEventRegistration type: " + (Object)((Object)sound.func_188722_g()));
                }
            }
            soundeventaccessor.func_188715_a(isoundeventaccessor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    private boolean func_184401_a(Sound p_184401_1_, ResourceLocation p_184401_2_) {
        boolean flag222;
        boolean bl;
        ResourceLocation resourcelocation = p_184401_1_.func_188721_b();
        IResource iresource = null;
        try {
            iresource = this.mcResourceManager.getResource(resourcelocation);
            iresource.getInputStream();
            bl = true;
        }
        catch (FileNotFoundException var11) {
            logger.warn("File {} does not exist, cannot add it to event {}", new Object[]{resourcelocation, p_184401_2_});
            flag222 = false;
            IOUtils.closeQuietly((Closeable)iresource);
        }
        catch (IOException ioexception) {
            boolean flag222;
            logger.warn("Could not load sound file " + resourcelocation + ", cannot add it to event " + p_184401_2_, (Throwable)ioexception);
            boolean bl2 = flag222 = false;
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(iresource);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)iresource);
            return bl2;
        }
        IOUtils.closeQuietly((Closeable)iresource);
        return bl;
        return flag222;
    }

    public SoundEventAccessor func_184398_a(ResourceLocation p_184398_1_) {
        return (SoundEventAccessor)this.sndRegistry.getObject(p_184398_1_);
    }

    public void playSound(ISound sound) {
        this.sndManager.playSound(sound);
    }

    public void playDelayedSound(ISound sound, int delay) {
        this.sndManager.playDelayedSound(sound, delay);
    }

    public void setListener(EntityPlayer player, float p_147691_2_) {
        this.sndManager.setListener(player, p_147691_2_);
    }

    public void pauseSounds() {
        this.sndManager.pauseAllSounds();
    }

    public void stopSounds() {
        this.sndManager.stopAllSounds();
    }

    public void unloadSounds() {
        this.sndManager.unloadSoundSystem();
    }

    @Override
    public void update() {
        this.sndManager.updateAllSounds();
    }

    public void resumeSounds() {
        this.sndManager.resumeAllSounds();
    }

    public void func_184399_a(SoundCategory p_184399_1_, float p_184399_2_) {
        if (p_184399_1_ == SoundCategory.MASTER && p_184399_2_ <= 0.0f) {
            this.stopSounds();
        }
        this.sndManager.func_188771_a(p_184399_1_, p_184399_2_);
    }

    public void stopSound(ISound p_147683_1_) {
        this.sndManager.stopSound(p_147683_1_);
    }

    public boolean isSoundPlaying(ISound sound) {
        return this.sndManager.isSoundPlaying(sound);
    }

    public void func_184402_a(ISoundEventListener p_184402_1_) {
        this.sndManager.func_188774_a(p_184402_1_);
    }

    public void func_184400_b(ISoundEventListener p_184400_1_) {
        this.sndManager.func_188773_b(p_184400_1_);
    }
}

