/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.network.play.server.SPacketUpdateEntityNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoLerping;

public class GuiBossOverlay
extends Gui {
    private static final ResourceLocation field_184058_a = new ResourceLocation("textures/gui/bars.png");
    private final Minecraft field_184059_f;
    private final Map<UUID, BossInfoLerping> field_184060_g = Maps.newLinkedHashMap();

    public GuiBossOverlay(Minecraft p_i46606_1_) {
        this.field_184059_f = p_i46606_1_;
    }

    public void func_184051_a() {
        if (!this.field_184060_g.isEmpty()) {
            ScaledResolution scaledresolution = new ScaledResolution(this.field_184059_f);
            int i = scaledresolution.getScaledWidth();
            int j = 12;
            for (BossInfoLerping bossinfolerping : this.field_184060_g.values()) {
                int k = i / 2 - 91;
                GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
                this.field_184059_f.getTextureManager().bindTexture(field_184058_a);
                this.func_184052_a(k, j, bossinfolerping);
                String s = bossinfolerping.getName().getFormattedText();
                this.field_184059_f.fontRendererObj.drawStringWithShadow(s, i / 2 - this.field_184059_f.fontRendererObj.getStringWidth(s) / 2, j - 9, 0xFFFFFF);
                if ((j += 10 + this.field_184059_f.fontRendererObj.FONT_HEIGHT) < scaledresolution.getScaledHeight() / 3) continue;
                break;
            }
        }
    }

    private void func_184052_a(int p_184052_1_, int p_184052_2_, BossInfo p_184052_3_) {
        int i;
        this.drawTexturedModalRect(p_184052_1_, p_184052_2_, 0, p_184052_3_.getColor().ordinal() * 5 * 2, 182, 5);
        if (p_184052_3_.getOverlay() != BossInfo.Overlay.PROGRESS) {
            this.drawTexturedModalRect(p_184052_1_, p_184052_2_, 0, 80 + (p_184052_3_.getOverlay().ordinal() - 1) * 5 * 2, 182, 5);
        }
        if ((i = (int)(p_184052_3_.getPercent() * 183.0f)) > 0) {
            this.drawTexturedModalRect(p_184052_1_, p_184052_2_, 0, p_184052_3_.getColor().ordinal() * 5 * 2 + 5, i, 5);
            if (p_184052_3_.getOverlay() != BossInfo.Overlay.PROGRESS) {
                this.drawTexturedModalRect(p_184052_1_, p_184052_2_, 0, 80 + (p_184052_3_.getOverlay().ordinal() - 1) * 5 * 2 + 5, i, 5);
            }
        }
    }

    public void func_184055_a(SPacketUpdateEntityNBT p_184055_1_) {
        if (p_184055_1_.getOperation() == SPacketUpdateEntityNBT.Operation.ADD) {
            this.field_184060_g.put(p_184055_1_.getUniqueId(), new BossInfoLerping(p_184055_1_));
        } else if (p_184055_1_.getOperation() == SPacketUpdateEntityNBT.Operation.REMOVE) {
            this.field_184060_g.remove(p_184055_1_.getUniqueId());
        } else {
            this.field_184060_g.get(p_184055_1_.getUniqueId()).updateFromPacket(p_184055_1_);
        }
    }

    public void func_184057_b() {
        this.field_184060_g.clear();
    }

    public boolean shouldPlayEndBossMusic() {
        if (!this.field_184060_g.isEmpty()) {
            for (BossInfo bossInfo : this.field_184060_g.values()) {
                if (!bossInfo.shouldPlayEndBossMusic()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean shouldDarkenSky() {
        if (!this.field_184060_g.isEmpty()) {
            for (BossInfo bossInfo : this.field_184060_g.values()) {
                if (!bossInfo.shouldDarkenSky()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean shouldCreateFog() {
        if (!this.field_184060_g.isEmpty()) {
            for (BossInfo bossInfo : this.field_184060_g.values()) {
                if (!bossInfo.shouldCreateFog()) continue;
                return true;
            }
        }
        return false;
    }
}

