/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.statemap;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.util.ResourceLocation;

public class BlockStateMapper {
    private Map<Block, IStateMapper> blockStateMap = Maps.newIdentityHashMap();
    private Set<Block> setBuiltInBlocks = Sets.newIdentityHashSet();

    public void registerBlockStateMapper(Block p_178447_1_, IStateMapper p_178447_2_) {
        this.blockStateMap.put(p_178447_1_, p_178447_2_);
    }

    public void registerBuiltInBlocks(Block ... p_178448_1_) {
        Collections.addAll(this.setBuiltInBlocks, p_178448_1_);
    }

    public Map<IBlockState, ModelResourceLocation> putAllStateModelLocations() {
        IdentityHashMap map = Maps.newIdentityHashMap();
        for (Block block : Block.blockRegistry) {
            map.putAll(this.getVariants(block));
        }
        return map;
    }

    public Set<ResourceLocation> getBlockstateLocations(Block p_188182_1_) {
        if (this.setBuiltInBlocks.contains(p_188182_1_)) {
            return Collections.emptySet();
        }
        IStateMapper istatemapper = this.blockStateMap.get(p_188182_1_);
        if (istatemapper == null) {
            return Collections.singleton(Block.blockRegistry.getNameForObject(p_188182_1_));
        }
        HashSet set = Sets.newHashSet();
        for (ModelResourceLocation modelresourcelocation : istatemapper.putStateModelLocations(p_188182_1_).values()) {
            set.add(new ResourceLocation(modelresourcelocation.getResourceDomain(), modelresourcelocation.getResourcePath()));
        }
        return set;
    }

    public Map<IBlockState, ModelResourceLocation> getVariants(Block p_188181_1_) {
        return this.setBuiltInBlocks.contains(p_188181_1_) ? Collections.emptyMap() : ((IStateMapper)Objects.firstNonNull((Object)this.blockStateMap.get(p_188181_1_), (Object)new DefaultStateMapper())).putStateModelLocations(p_188181_1_);
    }
}

