/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Sets;
import java.nio.FloatBuffer;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RegionRenderCache;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.chunk.ChunkCompileTaskGenerator;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.src.BlockPosM;
import net.minecraft.src.Config;
import net.minecraft.src.Reflector;
import net.minecraft.src.ReflectorForge;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import shadersmod.client.SVertexBuilder;

public class RenderChunk {
    private World world;
    private final RenderGlobal renderGlobal;
    public static int renderChunksUpdated;
    private BlockPos position;
    public CompiledChunk compiledChunk = CompiledChunk.DUMMY;
    private final ReentrantLock lockCompileTask = new ReentrantLock();
    private final ReentrantLock lockCompiledChunk = new ReentrantLock();
    private ChunkCompileTaskGenerator compileTask = null;
    private final Set<TileEntity> setTileEntities = Sets.newHashSet();
    private final int index;
    private final FloatBuffer modelviewMatrix = GLAllocation.createDirectFloatBuffer(16);
    private final net.minecraft.client.renderer.vertex.VertexBuffer[] vertexBuffers = new net.minecraft.client.renderer.vertex.VertexBuffer[BlockRenderLayer.values().length];
    public AxisAlignedBB boundingBox;
    private int frameIndex = -1;
    private boolean needsUpdate = true;
    private EnumMap<EnumFacing, BlockPos> mapEnumFacing = null;
    private boolean field_188284_q = false;
    private BlockPos[] positionOffsets16 = new BlockPos[EnumFacing.VALUES.length];
    private static BlockRenderLayer[] ENUM_WORLD_BLOCK_LAYERS;
    private BlockRenderLayer[] blockLayersSingle = new BlockRenderLayer[1];
    private boolean isMipmaps = Config.isMipmaps();
    private boolean fixBlockLayer = !Reflector.BetterFoliageClient.exists();

    public RenderChunk(World worldIn, RenderGlobal renderGlobalIn, BlockPos blockPosIn, int indexIn) {
        this.world = worldIn;
        this.renderGlobal = renderGlobalIn;
        this.index = indexIn;
        if (!blockPosIn.equals(this.getPosition())) {
            this.setPosition(blockPosIn);
        }
        if (OpenGlHelper.useVbo()) {
            for (int i = 0; i < BlockRenderLayer.values().length; ++i) {
                this.vertexBuffers[i] = new net.minecraft.client.renderer.vertex.VertexBuffer(DefaultVertexFormats.BLOCK);
            }
        }
    }

    public boolean setFrameIndex(int frameIndexIn) {
        if (this.frameIndex == frameIndexIn) {
            return false;
        }
        this.frameIndex = frameIndexIn;
        return true;
    }

    public net.minecraft.client.renderer.vertex.VertexBuffer getVertexBufferByLayer(int layer) {
        return this.vertexBuffers[layer];
    }

    public void setPosition(BlockPos pos) {
        this.stopCompileTask();
        this.position = pos;
        this.boundingBox = new AxisAlignedBB(pos, pos.add(16, 16, 16));
        this.initModelviewMatrix();
        for (int i = 0; i < this.positionOffsets16.length; ++i) {
            this.positionOffsets16[i] = null;
        }
    }

    public void resortTransparency(float x, float y, float z, ChunkCompileTaskGenerator generator) {
        CompiledChunk compiledchunk = generator.getCompiledChunk();
        if (compiledchunk.getState() != null && !compiledchunk.isLayerEmpty(BlockRenderLayer.TRANSLUCENT)) {
            VertexBuffer vertexbuffer = generator.getRegionRenderCacheBuilder().getWorldRendererByLayer(BlockRenderLayer.TRANSLUCENT);
            this.preRenderBlocks(vertexbuffer, this.position);
            vertexbuffer.setVertexState(compiledchunk.getState());
            this.postRenderBlocks(BlockRenderLayer.TRANSLUCENT, x, y, z, vertexbuffer, compiledchunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildChunk(float x, float y, float z, ChunkCompileTaskGenerator generator) {
        RegionRenderCache iblockaccess;
        CompiledChunk compiledchunk = new CompiledChunk();
        boolean i = true;
        BlockPos blockpos = this.position;
        BlockPos blockpos1 = blockpos.add(15, 15, 15);
        generator.getLock().lock();
        try {
            if (generator.getStatus() != ChunkCompileTaskGenerator.Status.COMPILING) {
                return;
            }
            if (this.world == null) {
                return;
            }
            iblockaccess = this.createRegionRenderCache(this.world, blockpos.add(-1, -1, -1), blockpos1.add(1, 1, 1), 1);
            if (Reflector.MinecraftForgeClient_onRebuildChunk.exists()) {
                Reflector.call(Reflector.MinecraftForgeClient_onRebuildChunk, this.world, this.position, iblockaccess);
            }
            generator.setCompiledChunk(compiledchunk);
        }
        finally {
            generator.getLock().unlock();
        }
        VisGraph lvt_10_1_ = new VisGraph();
        HashSet lvt_11_1_ = Sets.newHashSet();
        if (!iblockaccess.extendedLevelsInChunkCache()) {
            ++renderChunksUpdated;
            boolean[] aboolean = new boolean[ENUM_WORLD_BLOCK_LAYERS.length];
            BlockRendererDispatcher blockrendererdispatcher = Minecraft.getMinecraft().getBlockRendererDispatcher();
            boolean flag = Reflector.ForgeBlock_canRenderInLayer.exists();
            boolean flag1 = Reflector.ForgeHooksClient_setRenderLayer.exists();
            for (Object o : BlockPosM.getAllInBoxMutable(blockpos, blockpos1)) {
                BlockRenderLayer[] ablockrenderlayer;
                if (!(o instanceof BlockPosM)) continue;
                BlockPosM blockposm = (BlockPosM)o;
                IBlockState iblockstate = iblockaccess.getBlockState(blockposm);
                Block block = iblockstate.getBlock();
                if (iblockstate.isOpaqueCube()) {
                    lvt_10_1_.func_178606_a(blockposm);
                }
                if (ReflectorForge.blockHasTileEntity(iblockstate)) {
                    TileEntity tileentity = iblockaccess.getTileEntity(new BlockPos(blockposm));
                    TileEntitySpecialRenderer<TileEntity> tileentityspecialrenderer = TileEntityRendererDispatcher.instance.getSpecialRenderer(tileentity);
                    if (tileentity != null && tileentityspecialrenderer != null) {
                        compiledchunk.addTileEntity(tileentity);
                        if (tileentityspecialrenderer.func_188185_a(tileentity)) {
                            lvt_11_1_.add(tileentity);
                        }
                    }
                }
                if (flag) {
                    ablockrenderlayer = ENUM_WORLD_BLOCK_LAYERS;
                } else {
                    ablockrenderlayer = this.blockLayersSingle;
                    ablockrenderlayer[0] = block.getBlockLayer();
                }
                for (int j = 0; j < ablockrenderlayer.length; ++j) {
                    boolean flag2;
                    BlockRenderLayer blockrenderlayer = ablockrenderlayer[j];
                    if (flag && !(flag2 = Reflector.callBoolean(block, Reflector.ForgeBlock_canRenderInLayer, new Object[]{blockrenderlayer}))) continue;
                    if (flag1) {
                        Reflector.callVoid(Reflector.ForgeHooksClient_setRenderLayer, new Object[]{blockrenderlayer});
                    }
                    if (this.fixBlockLayer) {
                        blockrenderlayer = this.fixBlockLayer(block, blockrenderlayer);
                    }
                    int k = blockrenderlayer.ordinal();
                    if (block.getDefaultState().getRenderType() == EnumBlockRenderType.INVISIBLE) continue;
                    VertexBuffer vertexbuffer = generator.getRegionRenderCacheBuilder().getWorldRendererByLayerId(k);
                    vertexbuffer.setBlockLayer(blockrenderlayer);
                    if (!compiledchunk.isLayerStarted(blockrenderlayer)) {
                        compiledchunk.setLayerStarted(blockrenderlayer);
                        this.preRenderBlocks(vertexbuffer, blockpos);
                    }
                    int n = k;
                    aboolean[n] = aboolean[n] | blockrendererdispatcher.renderBlock(iblockstate, blockposm, iblockaccess, vertexbuffer);
                }
                if (!flag1) continue;
                Reflector.callVoid(Reflector.ForgeHooksClient_setRenderLayer, new Object[]{null});
            }
            for (BlockRenderLayer blockrenderlayer1 : ENUM_WORLD_BLOCK_LAYERS) {
                if (aboolean[blockrenderlayer1.ordinal()]) {
                    compiledchunk.setLayerUsed(blockrenderlayer1);
                }
                if (!compiledchunk.isLayerStarted(blockrenderlayer1)) continue;
                if (Config.isShaders()) {
                    SVertexBuilder.calcNormalChunkLayer(generator.getRegionRenderCacheBuilder().getWorldRendererByLayer(blockrenderlayer1));
                }
                this.postRenderBlocks(blockrenderlayer1, x, y, z, generator.getRegionRenderCacheBuilder().getWorldRendererByLayer(blockrenderlayer1), compiledchunk);
            }
        }
        compiledchunk.setVisibility(lvt_10_1_.computeVisibility());
        this.lockCompileTask.lock();
        try {
            HashSet set = Sets.newHashSet((Iterable)lvt_11_1_);
            HashSet set1 = Sets.newHashSet(this.setTileEntities);
            set.removeAll(this.setTileEntities);
            set1.removeAll(lvt_11_1_);
            this.setTileEntities.clear();
            this.setTileEntities.addAll(lvt_11_1_);
            this.renderGlobal.updateTileEntities(set1, set);
        }
        finally {
            this.lockCompileTask.unlock();
        }
    }

    protected void finishCompileTask() {
        this.lockCompileTask.lock();
        try {
            if (this.compileTask != null && this.compileTask.getStatus() != ChunkCompileTaskGenerator.Status.DONE) {
                this.compileTask.finish();
                this.compileTask = null;
            }
        }
        finally {
            this.lockCompileTask.unlock();
        }
    }

    public ReentrantLock getLockCompileTask() {
        return this.lockCompileTask;
    }

    public ChunkCompileTaskGenerator makeCompileTaskChunk() {
        ChunkCompileTaskGenerator chunkcompiletaskgenerator;
        this.lockCompileTask.lock();
        try {
            this.finishCompileTask();
            chunkcompiletaskgenerator = this.compileTask = new ChunkCompileTaskGenerator(this, ChunkCompileTaskGenerator.Type.REBUILD_CHUNK, this.func_188280_f());
        }
        finally {
            this.lockCompileTask.unlock();
        }
        return chunkcompiletaskgenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChunkCompileTaskGenerator makeCompileTaskTransparency() {
        ChunkCompileTaskGenerator chunkcompiletaskgenerator1;
        this.lockCompileTask.lock();
        try {
            ChunkCompileTaskGenerator chunkcompiletaskgenerator;
            if (this.compileTask != null && this.compileTask.getStatus() == ChunkCompileTaskGenerator.Status.PENDING) {
                ChunkCompileTaskGenerator chunkcompiletaskgenerator2;
                ChunkCompileTaskGenerator chunkCompileTaskGenerator = chunkcompiletaskgenerator2 = null;
                return chunkCompileTaskGenerator;
            }
            if (this.compileTask != null && this.compileTask.getStatus() != ChunkCompileTaskGenerator.Status.DONE) {
                this.compileTask.finish();
                this.compileTask = null;
            }
            this.compileTask = new ChunkCompileTaskGenerator(this, ChunkCompileTaskGenerator.Type.RESORT_TRANSPARENCY, this.func_188280_f());
            this.compileTask.setCompiledChunk(this.compiledChunk);
            chunkcompiletaskgenerator1 = chunkcompiletaskgenerator = this.compileTask;
        }
        finally {
            this.lockCompileTask.unlock();
        }
        return chunkcompiletaskgenerator1;
    }

    protected double func_188280_f() {
        EntityPlayerSP entityplayersp = Minecraft.getMinecraft().thePlayer;
        double d0 = this.boundingBox.minX + 8.0 - entityplayersp.posX;
        double d1 = this.boundingBox.minY + 8.0 - entityplayersp.posY;
        double d2 = this.boundingBox.minZ + 8.0 - entityplayersp.posZ;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    private void preRenderBlocks(VertexBuffer worldRendererIn, BlockPos pos) {
        worldRendererIn.begin(7, DefaultVertexFormats.BLOCK);
        worldRendererIn.setTranslation(-pos.getX(), -pos.getY(), -pos.getZ());
    }

    private void postRenderBlocks(BlockRenderLayer layer, float x, float y, float z, VertexBuffer worldRendererIn, CompiledChunk compiledChunkIn) {
        if (layer == BlockRenderLayer.TRANSLUCENT && !compiledChunkIn.isLayerEmpty(layer)) {
            worldRendererIn.sortVertexData(x, y, z);
            compiledChunkIn.setState(worldRendererIn.getVertexState());
        }
        worldRendererIn.finishDrawing();
    }

    private void initModelviewMatrix() {
        GlStateManager.pushMatrix();
        GlStateManager.loadIdentity();
        float f = 1.000001f;
        GlStateManager.translate(-8.0f, -8.0f, -8.0f);
        GlStateManager.scale(f, f, f);
        GlStateManager.translate(8.0f, 8.0f, 8.0f);
        GlStateManager.getFloat(2982, this.modelviewMatrix);
        GlStateManager.popMatrix();
    }

    public void multModelviewMatrix() {
        GlStateManager.multMatrix(this.modelviewMatrix);
    }

    public CompiledChunk getCompiledChunk() {
        return this.compiledChunk;
    }

    public void setCompiledChunk(CompiledChunk compiledChunkIn) {
        this.lockCompiledChunk.lock();
        try {
            this.compiledChunk = compiledChunkIn;
        }
        finally {
            this.lockCompiledChunk.unlock();
        }
    }

    public void stopCompileTask() {
        this.finishCompileTask();
        this.compiledChunk = CompiledChunk.DUMMY;
    }

    public void deleteGlResources() {
        this.stopCompileTask();
        this.world = null;
        for (int i = 0; i < BlockRenderLayer.values().length; ++i) {
            if (this.vertexBuffers[i] == null) continue;
            this.vertexBuffers[i].deleteGlBuffers();
        }
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public void setNeedsUpdate(boolean needsUpdateIn) {
        if (this.needsUpdate) {
            needsUpdateIn |= this.field_188284_q;
        }
        this.needsUpdate = true;
        this.field_188284_q = needsUpdateIn;
    }

    public void func_188282_m() {
        this.needsUpdate = false;
        this.field_188284_q = false;
    }

    public boolean isNeedsUpdate() {
        return this.needsUpdate;
    }

    public boolean func_188281_o() {
        return this.needsUpdate && this.field_188284_q;
    }

    public BlockPos getBlockPosOffset16(EnumFacing p_181701_1_) {
        return this.getPositionOffset16(p_181701_1_);
    }

    public World func_188283_p() {
        return this.world;
    }

    public BlockPos getPositionOffset16(EnumFacing p_getPositionOffset16_1_) {
        int i = p_getPositionOffset16_1_.getIndex();
        BlockPos blockpos = this.positionOffsets16[i];
        if (blockpos == null) {
            this.positionOffsets16[i] = blockpos = this.getPosition().offset(p_getPositionOffset16_1_, 16);
        }
        return blockpos;
    }

    protected RegionRenderCache createRegionRenderCache(World p_createRegionRenderCache_1_, BlockPos p_createRegionRenderCache_2_, BlockPos p_createRegionRenderCache_3_, int p_createRegionRenderCache_4_) {
        return new RegionRenderCache(p_createRegionRenderCache_1_, p_createRegionRenderCache_2_, p_createRegionRenderCache_3_, p_createRegionRenderCache_4_);
    }

    private BlockRenderLayer fixBlockLayer(Block p_fixBlockLayer_1_, BlockRenderLayer p_fixBlockLayer_2_) {
        if (this.isMipmaps) {
            if (p_fixBlockLayer_2_ == BlockRenderLayer.CUTOUT) {
                if (p_fixBlockLayer_1_ instanceof BlockRedstoneWire) {
                    return p_fixBlockLayer_2_;
                }
                if (p_fixBlockLayer_1_ instanceof BlockCactus) {
                    return p_fixBlockLayer_2_;
                }
                return BlockRenderLayer.CUTOUT_MIPPED;
            }
        } else if (p_fixBlockLayer_2_ == BlockRenderLayer.CUTOUT_MIPPED) {
            return BlockRenderLayer.CUTOUT;
        }
        return p_fixBlockLayer_2_;
    }

    static {
        ENUM_WORLD_BLOCK_LAYERS = BlockRenderLayer.values();
    }
}

