/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.util.math.MathHelper;

public abstract class RenderArrow<T extends EntityArrow>
extends Render<T> {
    public RenderArrow(RenderManager renderManagerIn) {
        super(renderManagerIn);
    }

    @Override
    public void doRender(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.bindEntityTexture(entity);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.pushMatrix();
        GlStateManager.disableLighting();
        GlStateManager.translate((float)x, (float)y, (float)z);
        GlStateManager.rotate(((EntityArrow)entity).prevRotationYaw + (((EntityArrow)entity).rotationYaw - ((EntityArrow)entity).prevRotationYaw) * partialTicks - 90.0f, 0.0f, 1.0f, 0.0f);
        GlStateManager.rotate(((EntityArrow)entity).prevRotationPitch + (((EntityArrow)entity).rotationPitch - ((EntityArrow)entity).prevRotationPitch) * partialTicks, 0.0f, 0.0f, 1.0f);
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer vertexbuffer = tessellator.getBuffer();
        int i = 0;
        float f = 0.0f;
        float f1 = 0.5f;
        float f2 = (float)(0 + i * 10) / 32.0f;
        float f3 = (float)(5 + i * 10) / 32.0f;
        float f4 = 0.0f;
        float f5 = 0.15625f;
        float f6 = (float)(5 + i * 10) / 32.0f;
        float f7 = (float)(10 + i * 10) / 32.0f;
        float f8 = 0.05625f;
        GlStateManager.enableRescaleNormal();
        float f9 = (float)((EntityArrow)entity).arrowShake - partialTicks;
        if (f9 > 0.0f) {
            float f10 = -MathHelper.sin(f9 * 3.0f) * f9;
            GlStateManager.rotate(f10, 0.0f, 0.0f, 1.0f);
        }
        GlStateManager.rotate(45.0f, 1.0f, 0.0f, 0.0f);
        GlStateManager.scale(f8, f8, f8);
        GlStateManager.translate(-4.0f, 0.0f, 0.0f);
        if (this.field_188301_f) {
            GlStateManager.enableColorMaterial();
            GlStateManager.func_187431_e(this.func_188298_c(entity));
        }
        GlStateManager.glNormal3f(f8, 0.0f, 0.0f);
        vertexbuffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        vertexbuffer.pos(-7.0, -2.0, -2.0).tex(f4, f6).endVertex();
        vertexbuffer.pos(-7.0, -2.0, 2.0).tex(f5, f6).endVertex();
        vertexbuffer.pos(-7.0, 2.0, 2.0).tex(f5, f7).endVertex();
        vertexbuffer.pos(-7.0, 2.0, -2.0).tex(f4, f7).endVertex();
        tessellator.draw();
        GlStateManager.glNormal3f(-f8, 0.0f, 0.0f);
        vertexbuffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        vertexbuffer.pos(-7.0, 2.0, -2.0).tex(f4, f6).endVertex();
        vertexbuffer.pos(-7.0, 2.0, 2.0).tex(f5, f6).endVertex();
        vertexbuffer.pos(-7.0, -2.0, 2.0).tex(f5, f7).endVertex();
        vertexbuffer.pos(-7.0, -2.0, -2.0).tex(f4, f7).endVertex();
        tessellator.draw();
        for (int j = 0; j < 4; ++j) {
            GlStateManager.rotate(90.0f, 1.0f, 0.0f, 0.0f);
            GlStateManager.glNormal3f(0.0f, 0.0f, f8);
            vertexbuffer.begin(7, DefaultVertexFormats.POSITION_TEX);
            vertexbuffer.pos(-8.0, -2.0, 0.0).tex(f, f2).endVertex();
            vertexbuffer.pos(8.0, -2.0, 0.0).tex(f1, f2).endVertex();
            vertexbuffer.pos(8.0, 2.0, 0.0).tex(f1, f3).endVertex();
            vertexbuffer.pos(-8.0, 2.0, 0.0).tex(f, f3).endVertex();
            tessellator.draw();
        }
        if (this.field_188301_f) {
            GlStateManager.func_187417_n();
            GlStateManager.disableColorMaterial();
        }
        GlStateManager.disableRescaleNormal();
        GlStateManager.enableLighting();
        GlStateManager.popMatrix();
        super.doRender(entity, x, y, z, entityYaw, partialTicks);
    }
}

