/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.IIconCreator;
import net.minecraft.client.renderer.texture.ITickableTextureObject;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.src.Config;
import net.minecraft.src.ConnectedTextures;
import net.minecraft.src.CustomItems;
import net.minecraft.src.Reflector;
import net.minecraft.src.ReflectorForge;
import net.minecraft.src.TextureUtils;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadersmod.client.ShadersTex;

public class TextureMap
extends AbstractTexture
implements ITickableTextureObject {
    private static final Logger logger = LogManager.getLogger();
    public static final ResourceLocation LOCATION_MISSING_TEXTURE = new ResourceLocation("missingno");
    public static final ResourceLocation locationBlocksTexture = new ResourceLocation("textures/atlas/blocks.png");
    private final List<TextureAtlasSprite> listAnimatedSprites = Lists.newArrayList();
    private final Map<String, TextureAtlasSprite> mapRegisteredSprites = Maps.newHashMap();
    private final Map<String, TextureAtlasSprite> mapUploadedSprites = Maps.newHashMap();
    private final String basePath;
    private final IIconCreator iconCreator;
    private int mipmapLevels;
    private final TextureAtlasSprite missingImage = new TextureAtlasSprite("missingno");
    private TextureAtlasSprite[] iconGrid = null;
    private int iconGridSize = -1;
    private int iconGridCountX = -1;
    private int iconGridCountY = -1;
    private double iconGridSizeU = -1.0;
    private double iconGridSizeV = -1.0;
    private static final boolean ENABLE_SKIP = Boolean.parseBoolean(System.getProperty("fml.skipFirstTextureLoad", "true"));
    private boolean skipFirst = false;
    public int atlasWidth = 0;
    public int atlasHeight = 0;

    public TextureMap(String p_i46099_1_) {
        this(p_i46099_1_, null);
    }

    public TextureMap(String p_i7_1_, boolean p_i7_2_) {
        this(p_i7_1_, null, p_i7_2_);
    }

    public TextureMap(String p_i46100_1_, IIconCreator iconCreatorIn) {
        this(p_i46100_1_, iconCreatorIn, false);
    }

    public TextureMap(String p_i8_1_, IIconCreator p_i8_2_, boolean p_i8_3_) {
        this.basePath = p_i8_1_;
        this.iconCreator = p_i8_2_;
        this.skipFirst = p_i8_3_ && ENABLE_SKIP;
    }

    private void initMissingImage() {
        int i = this.getMinSpriteSize();
        int[] aint = this.getMissingImageData(i);
        this.missingImage.setIconWidth(i);
        this.missingImage.setIconHeight(i);
        int[][] aint1 = new int[this.mipmapLevels + 1][];
        aint1[0] = aint;
        this.missingImage.setFramesTextureData(Lists.newArrayList((Object[])new int[][][]{aint1}));
        this.missingImage.setIndexInMap(0);
    }

    @Override
    public void loadTexture(IResourceManager resourceManager) throws IOException {
        ShadersTex.resManager = resourceManager;
        if (this.iconCreator != null) {
            this.loadSprites(resourceManager, this.iconCreator);
        }
    }

    public void loadSprites(IResourceManager resourceManager, IIconCreator p_174943_2_) {
        this.mapRegisteredSprites.clear();
        p_174943_2_.registerSprites(this);
        if (this.mipmapLevels >= 4) {
            this.mipmapLevels = this.detectMaxMipmapLevel(this.mapRegisteredSprites, resourceManager);
            Config.log("Mipmap levels: " + this.mipmapLevels);
        }
        this.initMissingImage();
        this.deleteGlTexture();
        this.loadTextureAtlas(resourceManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void loadTextureAtlas(IResourceManager resourceManager) {
        int j1;
        int k1;
        int j;
        ShadersTex.resManager = resourceManager;
        Config.dbg("Multitexture: " + Config.isMultiTexture());
        if (Config.isMultiTexture()) {
            for (TextureAtlasSprite textureatlassprite : this.mapUploadedSprites.values()) {
                textureatlassprite.deleteSpriteTexture();
            }
        }
        ConnectedTextures.updateIcons(this);
        CustomItems.updateIcons(this);
        int i1 = Minecraft.getGLMaximumTextureSize();
        Stitcher stitcher = new Stitcher(i1, i1, 0, this.mipmapLevels);
        this.mapUploadedSprites.clear();
        this.listAnimatedSprites.clear();
        int i = Integer.MAX_VALUE;
        Reflector.callVoid(Reflector.ForgeHooksClient_onTextureStitchedPre, this);
        this.iconGridSize = j = this.getMinSpriteSize();
        int k = 1 << this.mipmapLevels;
        for (Map.Entry<String, TextureAtlasSprite> entry : this.mapRegisteredSprites.entrySet()) {
            Iterator resourcelocation;
            TextureAtlasSprite textureatlassprite1;
            block36: {
                if (this.skipFirst) break;
                textureatlassprite1 = entry.getValue();
                resourcelocation = this.func_184396_a(textureatlassprite1);
                IResource iresource = null;
                if (textureatlassprite1.hasCustomLoader(resourceManager, (ResourceLocation)((Object)resourcelocation))) {
                    if (textureatlassprite1.load(resourceManager, (ResourceLocation)((Object)resourcelocation))) {
                        Config.dbg("Custom loader (skipped): " + textureatlassprite1);
                        continue;
                    }
                    Config.dbg("Custom loader: " + textureatlassprite1);
                } else {
                    PngSizeInfo pngsizeinfo = PngSizeInfo.func_188532_a(resourceManager.getResource((ResourceLocation)((Object)resourcelocation)));
                    iresource = Config.isShaders() ? ShadersTex.loadResource(resourceManager, (ResourceLocation)((Object)resourcelocation)) : resourceManager.getResource((ResourceLocation)((Object)resourcelocation));
                    boolean flag = iresource.getMetadata("animation") != null;
                    textureatlassprite1.func_188538_a(pngsizeinfo, flag);
                    IOUtils.closeQuietly((Closeable)iresource);
                }
                break block36;
                catch (RuntimeException runtimeexception) {
                    logger.error("Unable to parse metadata from " + resourcelocation, (Throwable)runtimeexception);
                    ReflectorForge.FMLClientHandler_trackBrokenTexture((ResourceLocation)((Object)resourcelocation), runtimeexception.getMessage());
                    IOUtils.closeQuietly((Closeable)iresource);
                    continue;
                }
                catch (IOException ioexception) {
                    logger.error("Using missing texture, unable to load " + resourcelocation + ", " + ioexception.getClass().getName());
                    ReflectorForge.FMLClientHandler_trackMissingTexture((ResourceLocation)((Object)resourcelocation));
                    {
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(iresource);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((Closeable)iresource);
                    continue;
                }
            }
            int j2 = textureatlassprite1.getIconWidth();
            if (j2 < j || this.mipmapLevels > 0) {
                int k2;
                int n = k2 = this.mipmapLevels > 0 ? TextureUtils.scaleToPowerOfTwo(j2, j) : TextureUtils.scaleMinTo(j2, j);
                if (k2 != j2) {
                    if (!TextureUtils.isPowerOfTwo(j2)) {
                        Config.log("Scaled non power of 2: " + textureatlassprite1.getIconName() + ", " + j2 + " -> " + k2);
                    } else {
                        Config.log("Scaled too small texture: " + textureatlassprite1.getIconName() + ", " + j2 + " -> " + k2);
                    }
                    int l = textureatlassprite1.getIconHeight() * k2 / textureatlassprite1.getIconWidth();
                    textureatlassprite1.setIconWidth(k2);
                    textureatlassprite1.setIconHeight(l);
                }
            }
            i = Math.min(i, Math.min(textureatlassprite1.getIconWidth(), textureatlassprite1.getIconHeight()));
            int l2 = Math.min(Integer.lowestOneBit(textureatlassprite1.getIconWidth()), Integer.lowestOneBit(textureatlassprite1.getIconHeight()));
            if (l2 < k) {
                logger.warn("Texture {} with size {}x{} limits mip level from {} to {}", new Object[]{resourcelocation, textureatlassprite1.getIconWidth(), textureatlassprite1.getIconHeight(), MathHelper.calculateLogBaseTwo(k), MathHelper.calculateLogBaseTwo(l2)});
                k = l2;
            }
            stitcher.addSprite(textureatlassprite1);
        }
        if ((k1 = MathHelper.calculateLogBaseTwo(j1 = Math.min(i, k))) < 0) {
            k1 = 0;
        }
        if (k1 < this.mipmapLevels) {
            logger.info("{}: dropping miplevel from {} to {}, because of minimum power of two: {}", new Object[]{this.basePath, this.mipmapLevels, k1, j1});
            this.mipmapLevels = k1;
        }
        this.missingImage.generateMipmaps(this.mipmapLevels);
        stitcher.addSprite(this.missingImage);
        this.skipFirst = false;
        stitcher.doStitch();
        logger.info("Created: {}x{} {}-atlas", new Object[]{stitcher.getCurrentWidth(), stitcher.getCurrentHeight(), this.basePath});
        if (Config.isShaders()) {
            ShadersTex.allocateTextureMap(this.getGlTextureId(), this.mipmapLevels, stitcher.getCurrentWidth(), stitcher.getCurrentHeight(), stitcher, this);
        } else {
            TextureUtil.allocateTextureImpl(this.getGlTextureId(), this.mipmapLevels, stitcher.getCurrentWidth(), stitcher.getCurrentHeight());
        }
        HashMap map = Maps.newHashMap(this.mapRegisteredSprites);
        for (TextureAtlasSprite textureatlassprite2 : stitcher.getStichSlots()) {
            if (Config.isShaders()) {
                ShadersTex.setIconName(ShadersTex.setSprite(textureatlassprite2).getIconName());
            }
            if (textureatlassprite2 != this.missingImage && !this.func_184397_a(resourceManager, textureatlassprite2)) continue;
            String s = textureatlassprite2.getIconName();
            map.remove(s);
            this.mapUploadedSprites.put(s, textureatlassprite2);
            try {
                if (Config.isShaders()) {
                    ShadersTex.uploadTexSubForLoadAtlas(textureatlassprite2.getFrameTextureData(0), textureatlassprite2.getIconWidth(), textureatlassprite2.getIconHeight(), textureatlassprite2.getOriginX(), textureatlassprite2.getOriginY(), false, false);
                } else {
                    TextureUtil.uploadTextureMipmap(textureatlassprite2.getFrameTextureData(0), textureatlassprite2.getIconWidth(), textureatlassprite2.getIconHeight(), textureatlassprite2.getOriginX(), textureatlassprite2.getOriginY(), false, false);
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Stitching texture atlas");
                CrashReportCategory crashreportcategory = crashreport.makeCategory("Texture being stitched together");
                crashreportcategory.addCrashSection("Atlas path", this.basePath);
                crashreportcategory.addCrashSection("Sprite", textureatlassprite2);
                throw new ReportedException(crashreport);
            }
            if (!textureatlassprite2.hasAnimationMetadata()) continue;
            this.listAnimatedSprites.add(textureatlassprite2);
        }
        for (TextureAtlasSprite textureatlassprite3 : map.values()) {
            textureatlassprite3.copyFrom(this.missingImage);
        }
        if (Config.isMultiTexture()) {
            int l1 = stitcher.getCurrentWidth();
            int i2 = stitcher.getCurrentHeight();
            for (TextureAtlasSprite textureatlassprite4 : stitcher.getStichSlots()) {
                textureatlassprite4.sheetWidth = l1;
                textureatlassprite4.sheetHeight = i2;
                textureatlassprite4.mipmapLevels = this.mipmapLevels;
                TextureAtlasSprite textureatlassprite5 = textureatlassprite4.spriteSingle;
                if (textureatlassprite5 == null) continue;
                if (textureatlassprite5.getIconWidth() <= 0) {
                    textureatlassprite5.setIconWidth(textureatlassprite4.getIconWidth());
                    textureatlassprite5.setIconHeight(textureatlassprite4.getIconHeight());
                    textureatlassprite5.initSprite(textureatlassprite4.getIconWidth(), textureatlassprite4.getIconHeight(), 0, 0, false);
                    textureatlassprite5.clearFramesTextureData();
                    List<int[][]> list = textureatlassprite4.getFramesTextureData();
                    textureatlassprite5.setFramesTextureData(list);
                    textureatlassprite5.setAnimationMetadata(textureatlassprite4.getAnimationMetadata());
                }
                textureatlassprite5.sheetWidth = l1;
                textureatlassprite5.sheetHeight = i2;
                textureatlassprite5.mipmapLevels = this.mipmapLevels;
                textureatlassprite4.bindSpriteTexture();
                boolean flag2 = false;
                boolean flag1 = true;
                try {
                    TextureUtil.uploadTextureMipmap(textureatlassprite5.getFrameTextureData(0), textureatlassprite5.getIconWidth(), textureatlassprite5.getIconHeight(), textureatlassprite5.getOriginX(), textureatlassprite5.getOriginY(), flag2, flag1);
                }
                catch (Exception exception) {
                    Config.dbg("Error uploading sprite single: " + textureatlassprite5 + ", parent: " + textureatlassprite4);
                    exception.printStackTrace();
                }
            }
            Config.getMinecraft().getTextureManager().bindTexture(locationBlocksTexture);
        }
        Reflector.callVoid(Reflector.ForgeHooksClient_onTextureStitchedPost, this);
        this.updateIconGrid(stitcher.getCurrentWidth(), stitcher.getCurrentHeight());
        if (Config.equals(System.getProperty("saveTextureMap"), "true")) {
            Config.dbg("Exporting texture map: " + this.basePath);
            TextureUtils.saveGlTexture("debug/" + this.basePath.replaceAll("/", "_"), this.getGlTextureId(), this.mipmapLevels, stitcher.getCurrentWidth(), stitcher.getCurrentHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean func_184397_a(IResourceManager p_184397_1_, final TextureAtlasSprite p_184397_2_) {
        block11: {
            ResourceLocation resourcelocation = this.func_184396_a(p_184397_2_);
            IResource iresource = null;
            if (p_184397_2_.hasCustomLoader(p_184397_1_, resourcelocation)) {
                TextureUtils.generateCustomMipmaps(p_184397_2_, this.mipmapLevels);
            } else {
                boolean flag12;
                try {
                    iresource = p_184397_1_.getResource(resourcelocation);
                    p_184397_2_.func_188539_a(iresource, this.mipmapLevels + 1);
                    break block11;
                }
                catch (RuntimeException runtimeexception1) {
                    logger.error("Unable to parse metadata from " + resourcelocation, (Throwable)runtimeexception1);
                    flag12 = false;
                }
                catch (IOException ioexception) {
                    boolean flag12;
                    boolean crashreportcategory;
                    logger.error("Using missing texture, unable to load " + resourcelocation, (Throwable)ioexception);
                    boolean bl = crashreportcategory = (flag12 = false);
                    return bl;
                }
                finally {
                    IOUtils.closeQuietly((Closeable)iresource);
                }
                return flag12;
            }
        }
        try {
            p_184397_2_.generateMipmaps(this.mipmapLevels);
            return true;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Applying mipmap");
            CrashReportCategory crashreportcategory = crashreport.makeCategory("Sprite being mipmapped");
            crashreportcategory.addCrashSectionCallable("Sprite name", new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return p_184397_2_.getIconName();
                }
            });
            crashreportcategory.addCrashSectionCallable("Sprite size", new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return p_184397_2_.getIconWidth() + " x " + p_184397_2_.getIconHeight();
                }
            });
            crashreportcategory.addCrashSectionCallable("Sprite frames", new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return p_184397_2_.getFrameCount() + " frames";
                }
            });
            crashreportcategory.addCrashSection("Mipmap levels", this.mipmapLevels);
            throw new ReportedException(crashreport);
        }
    }

    public ResourceLocation func_184396_a(TextureAtlasSprite p_184396_1_) {
        ResourceLocation resourcelocation = new ResourceLocation(p_184396_1_.getIconName());
        return this.completeResourceLocation(resourcelocation);
    }

    public ResourceLocation completeResourceLocation(ResourceLocation p_completeResourceLocation_1_) {
        return this.isAbsoluteLocation(p_completeResourceLocation_1_) ? new ResourceLocation(p_completeResourceLocation_1_.getResourceDomain(), p_completeResourceLocation_1_.getResourcePath() + ".png") : new ResourceLocation(p_completeResourceLocation_1_.getResourceDomain(), String.format("%s/%s%s", this.basePath, p_completeResourceLocation_1_.getResourcePath(), ".png"));
    }

    public TextureAtlasSprite getAtlasSprite(String iconName) {
        TextureAtlasSprite textureatlassprite = this.mapUploadedSprites.get(iconName);
        if (textureatlassprite == null) {
            textureatlassprite = this.missingImage;
        }
        return textureatlassprite;
    }

    public void updateAnimations() {
        if (Config.isShaders()) {
            ShadersTex.updatingTex = this.getMultiTexID();
        }
        TextureUtil.bindTexture(this.getGlTextureId());
        for (TextureAtlasSprite textureatlassprite : this.listAnimatedSprites) {
            if (!this.isTerrainAnimationActive(textureatlassprite)) continue;
            textureatlassprite.updateAnimation();
        }
        if (Config.isMultiTexture()) {
            for (TextureAtlasSprite textureatlassprite2 : this.listAnimatedSprites) {
                TextureAtlasSprite textureatlassprite1;
                if (!this.isTerrainAnimationActive(textureatlassprite2) || (textureatlassprite1 = textureatlassprite2.spriteSingle) == null) continue;
                if (textureatlassprite2 == TextureUtils.iconClock || textureatlassprite2 == TextureUtils.iconCompass) {
                    textureatlassprite1.frameCounter = textureatlassprite2.frameCounter;
                }
                textureatlassprite2.bindSpriteTexture();
                textureatlassprite1.updateAnimation();
            }
            TextureUtil.bindTexture(this.getGlTextureId());
        }
        if (Config.isShaders()) {
            ShadersTex.updatingTex = null;
        }
    }

    public TextureAtlasSprite registerSprite(ResourceLocation location) {
        if (location == null) {
            throw new IllegalArgumentException("Location cannot be null!");
        }
        TextureAtlasSprite textureatlassprite = this.mapRegisteredSprites.get(location.toString());
        if (textureatlassprite == null) {
            textureatlassprite = TextureAtlasSprite.makeAtlasSprite(location);
            this.mapRegisteredSprites.put(location.toString(), textureatlassprite);
            if (textureatlassprite instanceof TextureAtlasSprite && textureatlassprite.getIndexInMap() < 0) {
                textureatlassprite.setIndexInMap(this.mapRegisteredSprites.size());
            }
        }
        return textureatlassprite;
    }

    @Override
    public void tick() {
        this.updateAnimations();
    }

    public void setMipmapLevels(int mipmapLevelsIn) {
        this.mipmapLevels = mipmapLevelsIn;
    }

    public TextureAtlasSprite getMissingSprite() {
        return this.missingImage;
    }

    public TextureAtlasSprite getTextureExtry(String p_getTextureExtry_1_) {
        ResourceLocation resourcelocation = new ResourceLocation(p_getTextureExtry_1_);
        return this.mapRegisteredSprites.get(resourcelocation.toString());
    }

    public boolean setTextureEntry(String p_setTextureEntry_1_, TextureAtlasSprite p_setTextureEntry_2_) {
        if (!this.mapRegisteredSprites.containsKey(p_setTextureEntry_1_)) {
            this.mapRegisteredSprites.put(p_setTextureEntry_1_, p_setTextureEntry_2_);
            if (p_setTextureEntry_2_.getIndexInMap() < 0) {
                p_setTextureEntry_2_.setIndexInMap(this.mapRegisteredSprites.size());
            }
            return true;
        }
        return false;
    }

    private boolean isAbsoluteLocation(ResourceLocation p_isAbsoluteLocation_1_) {
        String s = p_isAbsoluteLocation_1_.getResourcePath();
        return this.isAbsoluteLocationPath(s);
    }

    private boolean isAbsoluteLocationPath(String p_isAbsoluteLocationPath_1_) {
        String s = p_isAbsoluteLocationPath_1_.toLowerCase();
        return s.startsWith("mcpatcher/") || s.startsWith("optifine/");
    }

    public TextureAtlasSprite getSpriteSafe(String p_getSpriteSafe_1_) {
        ResourceLocation resourcelocation = new ResourceLocation(p_getSpriteSafe_1_);
        return this.mapRegisteredSprites.get(resourcelocation.toString());
    }

    private boolean isTerrainAnimationActive(TextureAtlasSprite p_isTerrainAnimationActive_1_) {
        return p_isTerrainAnimationActive_1_ != TextureUtils.iconWaterStill && p_isTerrainAnimationActive_1_ != TextureUtils.iconWaterFlow ? (p_isTerrainAnimationActive_1_ != TextureUtils.iconLavaStill && p_isTerrainAnimationActive_1_ != TextureUtils.iconLavaFlow ? (p_isTerrainAnimationActive_1_ != TextureUtils.iconFireLayer0 && p_isTerrainAnimationActive_1_ != TextureUtils.iconFireLayer1 ? (p_isTerrainAnimationActive_1_ == TextureUtils.iconPortal ? Config.isAnimatedPortal() : (p_isTerrainAnimationActive_1_ != TextureUtils.iconClock && p_isTerrainAnimationActive_1_ != TextureUtils.iconCompass ? Config.isAnimatedTerrain() : true)) : Config.isAnimatedFire()) : Config.isAnimatedLava()) : Config.isAnimatedWater();
    }

    public int getCountRegisteredSprites() {
        return this.mapRegisteredSprites.size();
    }

    private int detectMaxMipmapLevel(Map p_detectMaxMipmapLevel_1_, IResourceManager p_detectMaxMipmapLevel_2_) {
        int j;
        int i = this.detectMinimumSpriteSize(p_detectMaxMipmapLevel_1_, p_detectMaxMipmapLevel_2_, 20);
        if (i < 16) {
            i = 16;
        }
        if ((i = MathHelper.roundUpToPowerOfTwo(i)) > 16) {
            Config.log("Sprite size: " + i);
        }
        if ((j = MathHelper.calculateLogBaseTwo(i)) < 4) {
            j = 4;
        }
        return j;
    }

    private int detectMinimumSpriteSize(Map p_detectMinimumSpriteSize_1_, IResourceManager p_detectMinimumSpriteSize_2_, int p_detectMinimumSpriteSize_3_) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (Map.Entry o : p_detectMinimumSpriteSize_1_.entrySet()) {
            if (!(o instanceof Map.Entry)) continue;
            Map.Entry entry = o;
            TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)entry.getValue();
            ResourceLocation resourcelocation = new ResourceLocation(textureatlassprite.getIconName());
            ResourceLocation resourcelocation1 = this.completeResourceLocation(resourcelocation);
            if (textureatlassprite.hasCustomLoader(p_detectMinimumSpriteSize_2_, resourcelocation)) continue;
            try {
                Dimension dimension;
                InputStream inputstream;
                IResource iresource = p_detectMinimumSpriteSize_2_.getResource(resourcelocation1);
                if (iresource == null || (inputstream = iresource.getInputStream()) == null || (dimension = TextureUtils.getImageSize(inputstream, "png")) == null) continue;
                int i = dimension.width;
                int j = MathHelper.roundUpToPowerOfTwo(i);
                if (!map.containsKey(j)) {
                    map.put(j, 1);
                    continue;
                }
                int k = (Integer)map.get(j);
                map.put(j, k + 1);
            }
            catch (Exception iresource) {}
        }
        int l = 0;
        Set set = map.keySet();
        TreeSet set1 = new TreeSet(set);
        Iterator iterator = set1.iterator();
        while (iterator.hasNext()) {
            int j1 = (Integer)iterator.next();
            int l1 = (Integer)map.get(j1);
            l += l1;
        }
        int i1 = 16;
        int k1 = 0;
        int l1 = l * p_detectMinimumSpriteSize_3_ / 100;
        Iterator iterator1 = set1.iterator();
        while (iterator1.hasNext()) {
            int i2 = (Integer)iterator1.next();
            int j2 = (Integer)map.get(i2);
            k1 += j2;
            if (i2 > i1) {
                i1 = i2;
            }
            if (k1 <= l1) continue;
            return i1;
        }
        return i1;
    }

    private int getMinSpriteSize() {
        int i = 1 << this.mipmapLevels;
        if (i < 8) {
            i = 8;
        }
        return i;
    }

    private int[] getMissingImageData(int p_getMissingImageData_1_) {
        BufferedImage bufferedimage = new BufferedImage(16, 16, 2);
        bufferedimage.setRGB(0, 0, 16, 16, TextureUtil.missingTextureData, 0, 16);
        BufferedImage bufferedimage1 = TextureUtils.scaleToPowerOfTwo(bufferedimage, p_getMissingImageData_1_);
        int[] aint = new int[p_getMissingImageData_1_ * p_getMissingImageData_1_];
        bufferedimage1.getRGB(0, 0, p_getMissingImageData_1_, p_getMissingImageData_1_, aint, 0, p_getMissingImageData_1_);
        return aint;
    }

    public boolean isTextureBound() {
        int j;
        int i = GlStateManager.getBoundTexture();
        return i == (j = this.getGlTextureId());
    }

    private void updateIconGrid(int p_updateIconGrid_1_, int p_updateIconGrid_2_) {
        this.iconGridCountX = -1;
        this.iconGridCountY = -1;
        this.iconGrid = null;
        if (this.iconGridSize > 0) {
            this.iconGridCountX = p_updateIconGrid_1_ / this.iconGridSize;
            this.iconGridCountY = p_updateIconGrid_2_ / this.iconGridSize;
            this.iconGrid = new TextureAtlasSprite[this.iconGridCountX * this.iconGridCountY];
            this.iconGridSizeU = 1.0 / (double)this.iconGridCountX;
            this.iconGridSizeV = 1.0 / (double)this.iconGridCountY;
            for (TextureAtlasSprite textureatlassprite : this.mapUploadedSprites.values()) {
                double d0 = Math.min(textureatlassprite.getMinU(), textureatlassprite.getMaxU());
                double d1 = Math.min(textureatlassprite.getMinV(), textureatlassprite.getMaxV());
                double d2 = Math.max(textureatlassprite.getMinU(), textureatlassprite.getMaxU());
                double d3 = Math.max(textureatlassprite.getMinV(), textureatlassprite.getMaxV());
                int i = (int)(d0 / this.iconGridSizeU);
                int j = (int)(d1 / this.iconGridSizeV);
                int k = (int)(d2 / this.iconGridSizeU);
                int l = (int)(d3 / this.iconGridSizeV);
                for (int i1 = i; i1 <= k; ++i1) {
                    if (i1 >= 0 && i1 < this.iconGridCountX) {
                        for (int j1 = j; j1 <= l; ++j1) {
                            if (j1 >= 0 && j1 < this.iconGridCountX) {
                                int k1 = j1 * this.iconGridCountX + i1;
                                this.iconGrid[k1] = textureatlassprite;
                                continue;
                            }
                            Config.warn("Invalid grid V: " + j1 + ", icon: " + textureatlassprite.getIconName());
                        }
                        continue;
                    }
                    Config.warn("Invalid grid U: " + i1 + ", icon: " + textureatlassprite.getIconName());
                }
            }
        }
    }

    public TextureAtlasSprite getIconByUV(double p_getIconByUV_1_, double p_getIconByUV_3_) {
        if (this.iconGrid == null) {
            return null;
        }
        int j = (int)(p_getIconByUV_3_ / this.iconGridSizeV);
        int i = (int)(p_getIconByUV_1_ / this.iconGridSizeU);
        int k = j * this.iconGridCountX + i;
        return k >= 0 && k <= this.iconGrid.length ? this.iconGrid[k] : null;
    }
}

