/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandEnchant
extends CommandBase {
    @Override
    public String getCommandName() {
        return "enchant";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getCommandUsage(ICommandSender sender) {
        return "commands.enchant.usage";
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        NBTTagList nbttaglist;
        Enchantment enchantment;
        if (args.length < 2) {
            throw new WrongUsageException("commands.enchant.usage", new Object[0]);
        }
        EntityLivingBase entitylivingbase = CommandEnchant.func_184884_a(server, sender, args[0], EntityLivingBase.class);
        sender.setCommandStat(CommandResultStats.Type.AFFECTED_ITEMS, 0);
        try {
            enchantment = Enchantment.getEnchantmentByID(CommandEnchant.parseInt(args[1], 0));
        }
        catch (NumberInvalidException var12) {
            enchantment = Enchantment.getEnchantmentByLocation(args[1]);
        }
        if (enchantment == null) {
            throw new NumberInvalidException("commands.enchant.notFound", Enchantment.getEnchantmentID(enchantment));
        }
        int i = 1;
        ItemStack itemstack = entitylivingbase.getHeldItemMainhand();
        if (itemstack == null) {
            throw new CommandException("commands.enchant.noItem", new Object[0]);
        }
        if (!enchantment.canApply(itemstack)) {
            throw new CommandException("commands.enchant.cantEnchant", new Object[0]);
        }
        if (args.length >= 3) {
            i = CommandEnchant.parseInt(args[2], enchantment.getMinLevel(), enchantment.getMaxLevel());
        }
        if (itemstack.hasTagCompound() && (nbttaglist = itemstack.getEnchantmentTagList()) != null) {
            for (int j = 0; j < nbttaglist.tagCount(); ++j) {
                Enchantment enchantment1;
                short k = nbttaglist.getCompoundTagAt(j).getShort("id");
                if (Enchantment.getEnchantmentByID(k) == null || enchantment.canApplyTogether(enchantment1 = Enchantment.getEnchantmentByID(k))) continue;
                throw new CommandException("commands.enchant.cantCombine", enchantment.getTranslatedName(i), enchantment1.getTranslatedName(nbttaglist.getCompoundTagAt(j).getShort("lvl")));
            }
        }
        itemstack.addEnchantment(enchantment, i);
        CommandEnchant.notifyOperators(sender, (ICommand)this, "commands.enchant.success", new Object[0]);
        sender.setCommandStat(CommandResultStats.Type.AFFECTED_ITEMS, 1);
    }

    @Override
    public List<String> getTabCompletionOptions(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return args.length == 1 ? CommandEnchant.getListOfStringsMatchingLastWord(args, server.getAllUsernames()) : (args.length == 2 ? CommandEnchant.getListOfStringsMatchingLastWord(args, Enchantment.enchantmentRegistry.getKeys()) : Collections.emptyList());
    }

    @Override
    public boolean isUsernameIndex(String[] args, int index) {
        return index == 0;
    }
}

