/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;

public class CommandTime
extends CommandBase {
    @Override
    public String getCommandName() {
        return "time";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getCommandUsage(ICommandSender sender) {
        return "commands.time.usage";
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length > 1) {
            if (args[0].equals("set")) {
                int i1 = args[1].equals("day") ? 1000 : (args[1].equals("night") ? 13000 : CommandTime.parseInt(args[1], 0));
                this.func_184929_a(server, i1);
                CommandTime.notifyOperators(sender, (ICommand)this, "commands.time.set", i1);
                return;
            }
            if (args[0].equals("add")) {
                int l = CommandTime.parseInt(args[1], 0);
                this.func_184928_b(server, l);
                CommandTime.notifyOperators(sender, (ICommand)this, "commands.time.added", l);
                return;
            }
            if (args[0].equals("query")) {
                if (args[1].equals("daytime")) {
                    int k = (int)(sender.getEntityWorld().getWorldTime() % 24000L);
                    sender.setCommandStat(CommandResultStats.Type.QUERY_RESULT, k);
                    CommandTime.notifyOperators(sender, (ICommand)this, "commands.time.query", k);
                    return;
                }
                if (args[1].equals("day")) {
                    int j = (int)(sender.getEntityWorld().getWorldTime() / 24000L % Integer.MAX_VALUE);
                    sender.setCommandStat(CommandResultStats.Type.QUERY_RESULT, j);
                    CommandTime.notifyOperators(sender, (ICommand)this, "commands.time.query", j);
                    return;
                }
                if (args[1].equals("gametime")) {
                    int i = (int)(sender.getEntityWorld().getTotalWorldTime() % Integer.MAX_VALUE);
                    sender.setCommandStat(CommandResultStats.Type.QUERY_RESULT, i);
                    CommandTime.notifyOperators(sender, (ICommand)this, "commands.time.query", i);
                    return;
                }
            }
        }
        throw new WrongUsageException("commands.time.usage", new Object[0]);
    }

    @Override
    public List<String> getTabCompletionOptions(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return args.length == 1 ? CommandTime.getListOfStringsMatchingLastWord(args, "set", "add", "query") : (args.length == 2 && args[0].equals("set") ? CommandTime.getListOfStringsMatchingLastWord(args, "day", "night") : (args.length == 2 && args[0].equals("query") ? CommandTime.getListOfStringsMatchingLastWord(args, "daytime", "gametime", "day") : Collections.emptyList()));
    }

    protected void func_184929_a(MinecraftServer p_184929_1_, int p_184929_2_) {
        for (int i = 0; i < p_184929_1_.worldServers.length; ++i) {
            p_184929_1_.worldServers[i].setWorldTime(p_184929_2_);
        }
    }

    protected void func_184928_b(MinecraftServer p_184928_1_, int p_184928_2_) {
        for (int i = 0; i < p_184928_1_.worldServers.length; ++i) {
            WorldServer worldserver = p_184928_1_.worldServers[i];
            worldserver.setWorldTime(worldserver.getWorldTime() + (long)p_184928_2_);
        }
    }
}

