/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;

public class EntitySelector {
    private static final Pattern tokenPattern = Pattern.compile("^@([pare])(?:\\[([\\w=,!-]*)\\])?$");
    private static final Pattern intListPattern = Pattern.compile("\\G([-!]?[\\w-]*)(?:$|,)");
    private static final Pattern keyValueListPattern = Pattern.compile("\\G(\\w+)=([-!]?[\\w-]*)(?:$|,)");
    private static final Set<String> WORLD_BINDING_ARGS = Sets.newHashSet((Object[])new String[]{"x", "y", "z", "dx", "dy", "dz", "rm", "r"});

    public static EntityPlayerMP matchOnePlayer(ICommandSender sender, String token) {
        return EntitySelector.matchOneEntity(sender, token, EntityPlayerMP.class);
    }

    public static <T extends Entity> T matchOneEntity(ICommandSender sender, String token, Class<? extends T> targetClass) {
        List<T> list = EntitySelector.matchEntities(sender, token, targetClass);
        return (T)(list.size() == 1 ? (Entity)list.get(0) : null);
    }

    public static ITextComponent matchEntitiesToChatComponent(ICommandSender sender, String token) {
        List<Entity> list = EntitySelector.matchEntities(sender, token, Entity.class);
        if (list.isEmpty()) {
            return null;
        }
        ArrayList list1 = Lists.newArrayList();
        for (Entity entity : list) {
            list1.add(entity.getDisplayName());
        }
        return CommandBase.join(list1);
    }

    public static <T extends Entity> List<T> matchEntities(ICommandSender sender, String token, Class<? extends T> targetClass) {
        Matcher matcher = tokenPattern.matcher(token);
        if (matcher.matches() && sender.canCommandSenderUseCommand(1, "@")) {
            Map<String, String> map = EntitySelector.getArgumentMap(matcher.group(2));
            if (!EntitySelector.isEntityTypeValid(sender, map)) {
                return Collections.emptyList();
            }
            String s = matcher.group(1);
            BlockPos blockpos = EntitySelector.getPositionFromArguments(map, sender.getPosition());
            Vec3d vec3d = EntitySelector.getPosFromArguments(map, sender.getPositionVector());
            List<World> list = EntitySelector.getWorlds(sender, map);
            ArrayList list1 = Lists.newArrayList();
            for (World world : list) {
                if (world == null) continue;
                ArrayList list2 = Lists.newArrayList();
                list2.addAll(EntitySelector.getTypePredicates(map, s));
                list2.addAll(EntitySelector.getXpLevelPredicates(map));
                list2.addAll(EntitySelector.getGamemodePredicates(map));
                list2.addAll(EntitySelector.getTeamPredicates(map));
                list2.addAll(EntitySelector.getScorePredicates(sender, map));
                list2.addAll(EntitySelector.getNamePredicates(map));
                list2.addAll(EntitySelector.getTagPredicates(map));
                list2.addAll(EntitySelector.getRadiusPredicates(map, vec3d));
                list2.addAll(EntitySelector.getRotationsPredicates(map));
                list1.addAll(EntitySelector.filterResults(map, targetClass, list2, s, world, blockpos));
            }
            return EntitySelector.getEntitiesFromPredicates(list1, map, sender, targetClass, s, blockpos);
        }
        return Collections.emptyList();
    }

    private static List<World> getWorlds(ICommandSender sender, Map<String, String> argumentMap) {
        ArrayList list = Lists.newArrayList();
        if (EntitySelector.hasArgument(argumentMap)) {
            list.add(sender.getEntityWorld());
        } else {
            Collections.addAll(list, sender.getServer().worldServers);
        }
        return list;
    }

    private static <T extends Entity> boolean isEntityTypeValid(ICommandSender commandSender, Map<String, String> params) {
        String s = EntitySelector.getArgument(params, "type");
        String string = s = s != null && s.startsWith("!") ? s.substring(1) : s;
        if (s != null && !EntityList.isStringValidEntityName(s)) {
            TextComponentTranslation textcomponenttranslation = new TextComponentTranslation("commands.generic.entity.invalidType", s);
            textcomponenttranslation.getChatStyle().setColor(TextFormatting.RED);
            commandSender.addChatMessage(textcomponenttranslation);
            return false;
        }
        return true;
    }

    private static List<Predicate<Entity>> getTypePredicates(Map<String, String> p_179663_0_, String p_179663_1_) {
        boolean flag2;
        boolean flag;
        ArrayList list = Lists.newArrayList();
        String s = EntitySelector.getArgument(p_179663_0_, "type");
        boolean bl = flag = s != null && s.startsWith("!");
        if (flag) {
            s = s.substring(1);
        }
        boolean flag1 = !p_179663_1_.equals("e");
        boolean bl2 = flag2 = p_179663_1_.equals("r") && s != null;
        if (!(s != null && p_179663_1_.equals("e") || flag2)) {
            if (flag1) {
                list.add(new Predicate<Entity>(){

                    public boolean apply(Entity p_apply_1_) {
                        return p_apply_1_ instanceof EntityPlayer;
                    }
                });
            }
        } else {
            final String s_f = s;
            list.add(new Predicate<Entity>(){

                public boolean apply(Entity p_apply_1_) {
                    return EntityList.isStringEntityName(p_apply_1_, s_f) != flag;
                }
            });
        }
        return list;
    }

    private static List<Predicate<Entity>> getXpLevelPredicates(Map<String, String> p_179648_0_) {
        ArrayList list = Lists.newArrayList();
        final int i = EntitySelector.parseIntWithDefault(p_179648_0_, "lm", -1);
        final int j = EntitySelector.parseIntWithDefault(p_179648_0_, "l", -1);
        if (i > -1 || j > -1) {
            list.add(new Predicate<Entity>(){

                public boolean apply(Entity p_apply_1_) {
                    if (!(p_apply_1_ instanceof EntityPlayerMP)) {
                        return false;
                    }
                    EntityPlayerMP entityplayermp = (EntityPlayerMP)p_apply_1_;
                    return !(i > -1 && entityplayermp.experienceLevel < i || j > -1 && entityplayermp.experienceLevel > j);
                }
            });
        }
        return list;
    }

    private static List<Predicate<Entity>> getGamemodePredicates(Map<String, String> p_179649_0_) {
        WorldSettings.GameType worldsettings$gametype;
        ArrayList list = Lists.newArrayList();
        String s = EntitySelector.getArgument(p_179649_0_, "m");
        if (s == null) {
            return list;
        }
        final boolean flag = s.startsWith("!");
        if (flag) {
            s = s.substring(1);
        }
        try {
            int i = Integer.parseInt(s);
            worldsettings$gametype = WorldSettings.GameType.func_185329_a(i, WorldSettings.GameType.NOT_SET);
        }
        catch (Throwable var6) {
            worldsettings$gametype = WorldSettings.GameType.func_185328_a(s, WorldSettings.GameType.NOT_SET);
        }
        final WorldSettings.GameType type = worldsettings$gametype;
        list.add(new Predicate<Entity>(){

            public boolean apply(Entity p_apply_1_) {
                if (!(p_apply_1_ instanceof EntityPlayerMP)) {
                    return false;
                }
                EntityPlayerMP entityplayermp = (EntityPlayerMP)p_apply_1_;
                WorldSettings.GameType worldsettings$gametype1 = entityplayermp.theItemInWorldManager.getGameType();
                return flag ? worldsettings$gametype1 != type : worldsettings$gametype1 == type;
            }
        });
        return list;
    }

    private static List<Predicate<Entity>> getTeamPredicates(Map<String, String> p_179659_0_) {
        boolean flag;
        ArrayList list = Lists.newArrayList();
        String s = EntitySelector.getArgument(p_179659_0_, "team");
        boolean bl = flag = s != null && s.startsWith("!");
        if (flag) {
            s = s.substring(1);
        }
        if (s != null) {
            final String s_f = s;
            list.add(new Predicate<Entity>(){

                public boolean apply(Entity p_apply_1_) {
                    if (!(p_apply_1_ instanceof EntityLivingBase)) {
                        return false;
                    }
                    EntityLivingBase entitylivingbase = (EntityLivingBase)p_apply_1_;
                    Team team = entitylivingbase.getTeam();
                    String s1 = team == null ? "" : team.getRegisteredName();
                    return s1.equals(s_f) != flag;
                }
            });
        }
        return list;
    }

    private static List<Predicate<Entity>> getScorePredicates(final ICommandSender p_184952_0_, Map<String, String> p_184952_1_) {
        final Map<String, Integer> map = EntitySelector.getScoreMap(p_184952_1_);
        return map.isEmpty() ? Collections.emptyList() : Lists.newArrayList((Object[])new Predicate[]{new Predicate<Entity>(){

            public boolean apply(Entity p_apply_1_) {
                if (p_apply_1_ == null) {
                    return false;
                }
                Scoreboard scoreboard = p_184952_0_.getServer().worldServerForDimension(0).getScoreboard();
                for (Map.Entry entry : map.entrySet()) {
                    String s1;
                    ScoreObjective scoreobjective;
                    String s = (String)entry.getKey();
                    boolean flag = false;
                    if (s.endsWith("_min") && s.length() > 4) {
                        flag = true;
                        s = s.substring(0, s.length() - 4);
                    }
                    if ((scoreobjective = scoreboard.getObjective(s)) == null) {
                        return false;
                    }
                    String string = s1 = p_apply_1_ instanceof EntityPlayerMP ? p_apply_1_.getName() : p_apply_1_.getUniqueID().toString();
                    if (!scoreboard.entityHasObjective(s1, scoreobjective)) {
                        return false;
                    }
                    Score score = scoreboard.getValueFromObjective(s1, scoreobjective);
                    int i = score.getScorePoints();
                    if (i < (Integer)entry.getValue() && flag) {
                        return false;
                    }
                    if (i <= (Integer)entry.getValue() || flag) continue;
                    return false;
                }
                return true;
            }
        }});
    }

    private static List<Predicate<Entity>> getNamePredicates(Map<String, String> p_179647_0_) {
        boolean flag;
        ArrayList list = Lists.newArrayList();
        String s = EntitySelector.getArgument(p_179647_0_, "name");
        boolean bl = flag = s != null && s.startsWith("!");
        if (flag) {
            s = s.substring(1);
        }
        if (s != null) {
            final String s_f = s;
            list.add(new Predicate<Entity>(){

                public boolean apply(Entity p_apply_1_) {
                    return p_apply_1_ != null && p_apply_1_.getName().equals(s_f) != flag;
                }
            });
        }
        return list;
    }

    private static List<Predicate<Entity>> getTagPredicates(Map<String, String> p_184951_0_) {
        boolean flag;
        ArrayList list = Lists.newArrayList();
        String s = EntitySelector.getArgument(p_184951_0_, "tag");
        boolean bl = flag = s != null && s.startsWith("!");
        if (flag) {
            s = s.substring(1);
        }
        if (s != null) {
            final String s_f = s;
            list.add(new Predicate<Entity>(){

                public boolean apply(Entity p_apply_1_) {
                    return p_apply_1_ == null ? false : ("".equals(s_f) ? p_apply_1_.getTags().isEmpty() != flag : p_apply_1_.getTags().contains(s_f) != flag);
                }
            });
        }
        return list;
    }

    private static List<Predicate<Entity>> getRadiusPredicates(Map<String, String> p_180698_0_, final Vec3d p_180698_1_) {
        boolean flag1;
        double d0 = EntitySelector.parseIntWithDefault(p_180698_0_, "rm", -1);
        double d1 = EntitySelector.parseIntWithDefault(p_180698_0_, "r", -1);
        final boolean flag = d0 < -0.5;
        boolean bl = flag1 = d1 < -0.5;
        if (flag && flag1) {
            return Collections.emptyList();
        }
        double d2 = Math.max(d0, 1.0E-4);
        final double d3 = d2 * d2;
        double d4 = Math.max(d1, 1.0E-4);
        final double d5 = d4 * d4;
        return Lists.newArrayList((Object[])new Predicate[]{new Predicate<Entity>(){

            public boolean apply(Entity p_apply_1_) {
                if (p_apply_1_ == null) {
                    return false;
                }
                double d6 = p_180698_1_.func_186679_c(p_apply_1_.posX, p_apply_1_.posY, p_apply_1_.posZ);
                return (flag || d6 >= d3) && (flag1 || d6 <= d5);
            }
        }});
    }

    private static List<Predicate<Entity>> getRotationsPredicates(Map<String, String> p_179662_0_) {
        ArrayList list = Lists.newArrayList();
        if (p_179662_0_.containsKey("rym") || p_179662_0_.containsKey("ry")) {
            final int i = MathHelper.func_188209_b(EntitySelector.parseIntWithDefault(p_179662_0_, "rym", 0));
            final int j = MathHelper.func_188209_b(EntitySelector.parseIntWithDefault(p_179662_0_, "ry", 359));
            list.add(new Predicate<Entity>(){

                public boolean apply(Entity p_apply_1_) {
                    if (p_apply_1_ == null) {
                        return false;
                    }
                    int i1 = MathHelper.func_188209_b(MathHelper.floor_float(p_apply_1_.rotationYaw));
                    return i > j ? i1 >= i || i1 <= j : i1 >= i && i1 <= j;
                }
            });
        }
        if (p_179662_0_.containsKey("rxm") || p_179662_0_.containsKey("rx")) {
            final int k = MathHelper.func_188209_b(EntitySelector.parseIntWithDefault(p_179662_0_, "rxm", 0));
            final int l = MathHelper.func_188209_b(EntitySelector.parseIntWithDefault(p_179662_0_, "rx", 359));
            list.add(new Predicate<Entity>(){

                public boolean apply(Entity p_apply_1_) {
                    if (p_apply_1_ == null) {
                        return false;
                    }
                    int i1 = MathHelper.func_188209_b(MathHelper.floor_float(p_apply_1_.rotationPitch));
                    return k > l ? i1 >= k || i1 <= l : i1 >= k && i1 <= l;
                }
            });
        }
        return list;
    }

    private static <T extends Entity> List<T> filterResults(Map<String, String> params, Class<? extends T> entityClass, List<Predicate<Entity>> inputList, String type, World worldIn, BlockPos position) {
        boolean flag2;
        ArrayList list = Lists.newArrayList();
        String s = EntitySelector.getArgument(params, "type");
        s = s != null && s.startsWith("!") ? s.substring(1) : s;
        boolean flag = !type.equals("e");
        boolean flag1 = type.equals("r") && s != null;
        int i = EntitySelector.parseIntWithDefault(params, "dx", 0);
        int j = EntitySelector.parseIntWithDefault(params, "dy", 0);
        int k = EntitySelector.parseIntWithDefault(params, "dz", 0);
        int l = EntitySelector.parseIntWithDefault(params, "r", -1);
        Predicate predicate = Predicates.and(inputList);
        Predicate predicate1 = Predicates.and(EntitySelectors.selectAnything, (Predicate)predicate);
        int i1 = worldIn.playerEntities.size();
        int j1 = worldIn.loadedEntityList.size();
        boolean bl = flag2 = i1 < j1 / 16;
        if (!(params.containsKey("dx") || params.containsKey("dy") || params.containsKey("dz"))) {
            if (l >= 0) {
                AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(position.getX() - l, position.getY() - l, position.getZ() - l, position.getX() + l + 1, position.getY() + l + 1, position.getZ() + l + 1);
                if (flag && flag2 && !flag1) {
                    list.addAll(worldIn.getPlayers(entityClass, predicate1));
                } else {
                    list.addAll(worldIn.getEntitiesWithinAABB(entityClass, axisalignedbb1, predicate1));
                }
            } else if (type.equals("a")) {
                list.addAll(worldIn.getPlayers(entityClass, predicate));
            } else if (!(type.equals("p") || type.equals("r") && !flag1)) {
                list.addAll(worldIn.getEntities(entityClass, predicate1));
            } else {
                list.addAll(worldIn.getPlayers(entityClass, predicate1));
            }
        } else {
            final AxisAlignedBB axisalignedbb = EntitySelector.getAABB(position, i, j, k);
            if (flag && flag2 && !flag1) {
                Predicate<Entity> predicate2 = new Predicate<Entity>(){

                    public boolean apply(Entity p_apply_1_) {
                        return p_apply_1_ != null && axisalignedbb.intersectsWith(p_apply_1_.getEntityBoundingBox());
                    }
                };
                list.addAll(worldIn.getPlayers(entityClass, Predicates.and((Predicate)predicate1, (Predicate)predicate2)));
            } else {
                list.addAll(worldIn.getEntitiesWithinAABB(entityClass, axisalignedbb, predicate1));
            }
        }
        return list;
    }

    private static <T extends Entity> List<T> getEntitiesFromPredicates(List<T> p_179658_0_, Map<String, String> p_179658_1_, ICommandSender p_179658_2_, Class<? extends T> p_179658_3_, String p_179658_4_, final BlockPos p_179658_5_) {
        Entity entity;
        int i = EntitySelector.parseIntWithDefault(p_179658_1_, "c", !p_179658_4_.equals("a") && !p_179658_4_.equals("e") ? 1 : 0);
        if (!(p_179658_4_.equals("p") || p_179658_4_.equals("a") || p_179658_4_.equals("e"))) {
            if (p_179658_4_.equals("r")) {
                Collections.shuffle(p_179658_0_);
            }
        } else {
            Collections.sort(p_179658_0_, new Comparator<Entity>(){

                @Override
                public int compare(Entity p_compare_1_, Entity p_compare_2_) {
                    return ComparisonChain.start().compare(p_compare_1_.getDistanceSq(p_179658_5_), p_compare_2_.getDistanceSq(p_179658_5_)).result();
                }
            });
        }
        if ((entity = p_179658_2_.getCommandSenderEntity()) != null && p_179658_3_.isAssignableFrom(entity.getClass()) && i == 1 && p_179658_0_.contains(entity) && !"r".equals(p_179658_4_)) {
            p_179658_0_ = Lists.newArrayList((Object[])new Entity[]{entity});
        }
        if (i != 0) {
            if (i < 0) {
                Collections.reverse(p_179658_0_);
            }
            p_179658_0_ = p_179658_0_.subList(0, Math.min(Math.abs(i), p_179658_0_.size()));
        }
        return p_179658_0_;
    }

    private static AxisAlignedBB getAABB(BlockPos p_179661_0_, int p_179661_1_, int p_179661_2_, int p_179661_3_) {
        boolean flag = p_179661_1_ < 0;
        boolean flag1 = p_179661_2_ < 0;
        boolean flag2 = p_179661_3_ < 0;
        int i = p_179661_0_.getX() + (flag ? p_179661_1_ : 0);
        int j = p_179661_0_.getY() + (flag1 ? p_179661_2_ : 0);
        int k = p_179661_0_.getZ() + (flag2 ? p_179661_3_ : 0);
        int l = p_179661_0_.getX() + (flag ? 0 : p_179661_1_) + 1;
        int i1 = p_179661_0_.getY() + (flag1 ? 0 : p_179661_2_) + 1;
        int j1 = p_179661_0_.getZ() + (flag2 ? 0 : p_179661_3_) + 1;
        return new AxisAlignedBB(i, j, k, l, i1, j1);
    }

    private static BlockPos getPositionFromArguments(Map<String, String> p_179664_0_, BlockPos p_179664_1_) {
        return new BlockPos(EntitySelector.parseIntWithDefault(p_179664_0_, "x", p_179664_1_.getX()), EntitySelector.parseIntWithDefault(p_179664_0_, "y", p_179664_1_.getY()), EntitySelector.parseIntWithDefault(p_179664_0_, "z", p_179664_1_.getZ()));
    }

    private static Vec3d getPosFromArguments(Map<String, String> p_189210_0_, Vec3d p_189210_1_) {
        return new Vec3d(EntitySelector.getCoordinate(p_189210_0_, "x", p_189210_1_.xCoord, true), EntitySelector.getCoordinate(p_189210_0_, "y", p_189210_1_.yCoord, false), EntitySelector.getCoordinate(p_189210_0_, "z", p_189210_1_.zCoord, true));
    }

    private static double getCoordinate(Map<String, String> p_189211_0_, String p_189211_1_, double p_189211_2_, boolean p_189211_4_) {
        return p_189211_0_.containsKey(p_189211_1_) ? (double)MathHelper.parseIntWithDefault(p_189211_0_.get(p_189211_1_), MathHelper.floor_double(p_189211_2_)) + (p_189211_4_ ? 0.5 : 0.0) : p_189211_2_;
    }

    private static boolean hasArgument(Map<String, String> p_179665_0_) {
        for (String s : WORLD_BINDING_ARGS) {
            if (!p_179665_0_.containsKey(s)) continue;
            return true;
        }
        return false;
    }

    private static int parseIntWithDefault(Map<String, String> p_179653_0_, String p_179653_1_, int p_179653_2_) {
        return p_179653_0_.containsKey(p_179653_1_) ? MathHelper.parseIntWithDefault(p_179653_0_.get(p_179653_1_), p_179653_2_) : p_179653_2_;
    }

    private static String getArgument(Map<String, String> p_179651_0_, String p_179651_1_) {
        return p_179651_0_.get(p_179651_1_);
    }

    public static Map<String, Integer> getScoreMap(Map<String, String> p_96560_0_) {
        HashMap map = Maps.newHashMap();
        for (String s : p_96560_0_.keySet()) {
            if (!s.startsWith("score_") || s.length() <= "score_".length()) continue;
            map.put(s.substring("score_".length()), MathHelper.parseIntWithDefault(p_96560_0_.get(s), 1));
        }
        return map;
    }

    public static boolean matchesMultiplePlayers(String p_82377_0_) {
        Matcher matcher = tokenPattern.matcher(p_82377_0_);
        if (!matcher.matches()) {
            return false;
        }
        Map<String, String> map = EntitySelector.getArgumentMap(matcher.group(2));
        String s = matcher.group(1);
        int i = !"a".equals(s) && !"e".equals(s) ? 1 : 0;
        return EntitySelector.parseIntWithDefault(map, "c", i) != 1;
    }

    public static boolean hasArguments(String p_82378_0_) {
        return tokenPattern.matcher(p_82378_0_).matches();
    }

    private static Map<String, String> getArgumentMap(String argumentString) {
        HashMap map = Maps.newHashMap();
        if (argumentString == null) {
            return map;
        }
        int i = 0;
        int j = -1;
        Matcher matcher = intListPattern.matcher(argumentString);
        while (matcher.find()) {
            String s = null;
            switch (i++) {
                case 0: {
                    s = "x";
                    break;
                }
                case 1: {
                    s = "y";
                    break;
                }
                case 2: {
                    s = "z";
                    break;
                }
                case 3: {
                    s = "r";
                }
            }
            if (s != null && !matcher.group(1).isEmpty()) {
                map.put(s, matcher.group(1));
            }
            j = matcher.end();
        }
        if (j < argumentString.length()) {
            Matcher matcher1 = keyValueListPattern.matcher(j == -1 ? argumentString : argumentString.substring(j));
            while (matcher1.find()) {
                map.put(matcher1.group(1), matcher1.group(2));
            }
        }
        return map;
    }
}

