/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.enchantment;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Util;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.MathHelper;

public class EnchantmentHelper {
    private static final Random enchantmentRand = new Random();
    private static final ModifierDamage enchantmentModifierDamage = new ModifierDamage();
    private static final ModifierLiving enchantmentModifierLiving = new ModifierLiving();
    private static final HurtIterator ENCHANTMENT_ITERATOR_HURT = new HurtIterator();
    private static final DamageIterator ENCHANTMENT_ITERATOR_DAMAGE = new DamageIterator();

    public static int getEnchantmentLevel(Enchantment enchID, ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        NBTTagList nbttaglist = stack.getEnchantmentTagList();
        if (nbttaglist == null) {
            return 0;
        }
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            Enchantment enchantment = Enchantment.getEnchantmentByID(nbttaglist.getCompoundTagAt(i).getShort("id"));
            short j = nbttaglist.getCompoundTagAt(i).getShort("lvl");
            if (enchantment != enchID) continue;
            return j;
        }
        return 0;
    }

    public static Map<Enchantment, Integer> getEnchantments(ItemStack stack) {
        NBTTagList nbttaglist;
        LinkedHashMap map = Maps.newLinkedHashMap();
        NBTTagList nBTTagList = nbttaglist = stack.getItem() == Items.enchanted_book ? Items.enchanted_book.getEnchantments(stack) : stack.getEnchantmentTagList();
        if (nbttaglist != null) {
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                Enchantment enchantment = Enchantment.getEnchantmentByID(nbttaglist.getCompoundTagAt(i).getShort("id"));
                short j = nbttaglist.getCompoundTagAt(i).getShort("lvl");
                map.put(enchantment, Integer.valueOf(j));
            }
        }
        return map;
    }

    public static void setEnchantments(Map<Enchantment, Integer> enchMap, ItemStack stack) {
        NBTTagList nbttaglist = new NBTTagList();
        for (Map.Entry<Enchantment, Integer> entry : enchMap.entrySet()) {
            Enchantment enchantment = entry.getKey();
            if (enchantment == null) continue;
            int i = entry.getValue();
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.setShort("id", (short)Enchantment.getEnchantmentID(enchantment));
            nbttagcompound.setShort("lvl", (short)i);
            nbttaglist.appendTag(nbttagcompound);
            if (stack.getItem() != Items.enchanted_book) continue;
            Items.enchanted_book.addEnchantment(stack, new EnchantmentData(enchantment, i));
        }
        if (nbttaglist.hasNoTags()) {
            if (stack.hasTagCompound()) {
                stack.getTagCompound().removeTag("ench");
            }
        } else if (stack.getItem() != Items.enchanted_book) {
            stack.setTagInfo("ench", nbttaglist);
        }
    }

    private static void applyEnchantmentModifier(IModifier modifier, ItemStack stack) {
        NBTTagList nbttaglist;
        if (stack != null && (nbttaglist = stack.getEnchantmentTagList()) != null) {
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                short j = nbttaglist.getCompoundTagAt(i).getShort("id");
                short k = nbttaglist.getCompoundTagAt(i).getShort("lvl");
                if (Enchantment.getEnchantmentByID(j) == null) continue;
                modifier.calculateModifier(Enchantment.getEnchantmentByID(j), k);
            }
        }
    }

    private static void applyEnchantmentModifierArray(IModifier modifier, Iterable<ItemStack> stacks) {
        for (ItemStack itemstack : stacks) {
            EnchantmentHelper.applyEnchantmentModifier(modifier, itemstack);
        }
    }

    public static int getEnchantmentModifierDamage(Iterable<ItemStack> stacks, DamageSource source) {
        EnchantmentHelper.enchantmentModifierDamage.damageModifier = 0;
        EnchantmentHelper.enchantmentModifierDamage.source = source;
        EnchantmentHelper.applyEnchantmentModifierArray(enchantmentModifierDamage, stacks);
        return EnchantmentHelper.enchantmentModifierDamage.damageModifier;
    }

    public static float getModifierForCreature(ItemStack p_152377_0_, EnumCreatureAttribute p_152377_1_) {
        EnchantmentHelper.enchantmentModifierLiving.livingModifier = 0.0f;
        EnchantmentHelper.enchantmentModifierLiving.entityLiving = p_152377_1_;
        EnchantmentHelper.applyEnchantmentModifier(enchantmentModifierLiving, p_152377_0_);
        return EnchantmentHelper.enchantmentModifierLiving.livingModifier;
    }

    public static void applyThornEnchantments(EntityLivingBase p_151384_0_, Entity p_151384_1_) {
        EnchantmentHelper.ENCHANTMENT_ITERATOR_HURT.attacker = p_151384_1_;
        EnchantmentHelper.ENCHANTMENT_ITERATOR_HURT.user = p_151384_0_;
        if (p_151384_0_ != null) {
            EnchantmentHelper.applyEnchantmentModifierArray(ENCHANTMENT_ITERATOR_HURT, p_151384_0_.func_184209_aF());
        }
        if (p_151384_1_ instanceof EntityPlayer) {
            EnchantmentHelper.applyEnchantmentModifier(ENCHANTMENT_ITERATOR_HURT, p_151384_0_.getHeldItemMainhand());
        }
    }

    public static void applyArthropodEnchantments(EntityLivingBase p_151385_0_, Entity p_151385_1_) {
        EnchantmentHelper.ENCHANTMENT_ITERATOR_DAMAGE.user = p_151385_0_;
        EnchantmentHelper.ENCHANTMENT_ITERATOR_DAMAGE.target = p_151385_1_;
        if (p_151385_0_ != null) {
            EnchantmentHelper.applyEnchantmentModifierArray(ENCHANTMENT_ITERATOR_DAMAGE, p_151385_0_.func_184209_aF());
        }
        if (p_151385_0_ instanceof EntityPlayer) {
            EnchantmentHelper.applyEnchantmentModifier(ENCHANTMENT_ITERATOR_DAMAGE, p_151385_0_.getHeldItemMainhand());
        }
    }

    public static int func_185284_a(Enchantment p_185284_0_, EntityLivingBase p_185284_1_) {
        Iterable<ItemStack> iterable = p_185284_0_.getEntityEquipment(p_185284_1_);
        if (iterable == null) {
            return 0;
        }
        int i = 0;
        for (ItemStack itemstack : iterable) {
            int j = EnchantmentHelper.getEnchantmentLevel(p_185284_0_, itemstack);
            if (j <= i) continue;
            i = j;
        }
        return i;
    }

    public static int getKnockbackModifier(EntityLivingBase player) {
        return EnchantmentHelper.func_185284_a(Enchantments.knockback, player);
    }

    public static int getFireAspectModifier(EntityLivingBase player) {
        return EnchantmentHelper.func_185284_a(Enchantments.fireAspect, player);
    }

    public static int func_185292_c(EntityLivingBase p_185292_0_) {
        return EnchantmentHelper.func_185284_a(Enchantments.respiration, p_185292_0_);
    }

    public static int func_185294_d(EntityLivingBase p_185294_0_) {
        return EnchantmentHelper.func_185284_a(Enchantments.depthStrider, p_185294_0_);
    }

    public static int func_185293_e(EntityLivingBase p_185293_0_) {
        return EnchantmentHelper.func_185284_a(Enchantments.efficiency, p_185293_0_);
    }

    public static int getLuckOfSeaModifier(EntityLivingBase player) {
        return EnchantmentHelper.func_185284_a(Enchantments.luckOfTheSea, player);
    }

    public static int getLureModifier(EntityLivingBase player) {
        return EnchantmentHelper.func_185284_a(Enchantments.lure, player);
    }

    public static int func_185283_h(EntityLivingBase p_185283_0_) {
        return EnchantmentHelper.func_185284_a(Enchantments.looting, p_185283_0_);
    }

    public static boolean func_185287_i(EntityLivingBase p_185287_0_) {
        return EnchantmentHelper.func_185284_a(Enchantments.aquaAffinity, p_185287_0_) > 0;
    }

    public static ItemStack getEnchantedItem(Enchantment p_92099_0_, EntityLivingBase p_92099_1_) {
        Iterable<ItemStack> iterable = p_92099_0_.getEntityEquipment(p_92099_1_);
        if (iterable == null) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        for (ItemStack itemstack : iterable) {
            if (itemstack == null || EnchantmentHelper.getEnchantmentLevel(p_92099_0_, itemstack) <= 0) continue;
            list.add(itemstack);
        }
        return list.isEmpty() ? null : (ItemStack)list.get(p_92099_1_.getRNG().nextInt(list.size()));
    }

    public static int calcItemStackEnchantability(Random rand, int enchantNum, int power, ItemStack stack) {
        Item item = stack.getItem();
        int i = item.getItemEnchantability();
        if (i <= 0) {
            return 0;
        }
        if (power > 15) {
            power = 15;
        }
        int j = rand.nextInt(8) + 1 + (power >> 1) + rand.nextInt(power + 1);
        return enchantNum == 0 ? Math.max(j / 3, 1) : (enchantNum == 1 ? j * 2 / 3 + 1 : Math.max(j, power * 2));
    }

    public static ItemStack addRandomEnchantment(Random p_77504_0_, ItemStack p_77504_1_, int p_77504_2_, boolean p_77504_3_) {
        boolean flag = p_77504_1_.getItem() == Items.book;
        List<EnchantmentData> list = EnchantmentHelper.buildEnchantmentList(p_77504_0_, p_77504_1_, p_77504_2_, p_77504_3_);
        if (flag) {
            p_77504_1_.setItem(Items.enchanted_book);
        }
        for (EnchantmentData enchantmentdata : list) {
            if (flag) {
                Items.enchanted_book.addEnchantment(p_77504_1_, enchantmentdata);
                continue;
            }
            p_77504_1_.addEnchantment(enchantmentdata.enchantmentobj, enchantmentdata.enchantmentLevel);
        }
        return p_77504_1_;
    }

    public static List<EnchantmentData> buildEnchantmentList(Random randomIn, ItemStack itemStackIn, int p_77513_2_, boolean p_77513_3_) {
        ArrayList list = Lists.newArrayList();
        Item item = itemStackIn.getItem();
        int i = item.getItemEnchantability();
        if (i <= 0) {
            return list;
        }
        p_77513_2_ = p_77513_2_ + 1 + randomIn.nextInt(i / 4 + 1) + randomIn.nextInt(i / 4 + 1);
        float f = (randomIn.nextFloat() + randomIn.nextFloat() - 1.0f) * 0.15f;
        List<EnchantmentData> list1 = EnchantmentHelper.func_185291_a(p_77513_2_ = MathHelper.clamp_int(Math.round((float)p_77513_2_ + (float)p_77513_2_ * f), 1, Integer.MAX_VALUE), itemStackIn, p_77513_3_);
        if (!list1.isEmpty()) {
            list.add(WeightedRandom.getRandomItem(randomIn, list1));
            while (randomIn.nextInt(50) <= p_77513_2_) {
                EnchantmentHelper.func_185282_a(list1, (EnchantmentData)Util.getLastElement(list));
                if (list1.isEmpty()) break;
                list.add(WeightedRandom.getRandomItem(randomIn, list1));
                p_77513_2_ /= 2;
            }
        }
        return list;
    }

    public static void func_185282_a(List<EnchantmentData> p_185282_0_, EnchantmentData p_185282_1_) {
        Iterator<EnchantmentData> iterator = p_185282_0_.iterator();
        while (iterator.hasNext()) {
            if (p_185282_1_.enchantmentobj.canApplyTogether(iterator.next().enchantmentobj)) continue;
            iterator.remove();
        }
    }

    public static List<EnchantmentData> func_185291_a(int p_185291_0_, ItemStack p_185291_1_, boolean p_185291_2_) {
        ArrayList list = Lists.newArrayList();
        Item item = p_185291_1_.getItem();
        boolean flag = p_185291_1_.getItem() == Items.book;
        block0: for (Enchantment enchantment : Enchantment.enchantmentRegistry) {
            if (enchantment.isTreasureEnchantment() && !p_185291_2_ || !enchantment.type.canEnchantItem(item) && !flag) continue;
            for (int i = enchantment.getMaxLevel(); i > enchantment.getMinLevel() - 1; --i) {
                if (p_185291_0_ < enchantment.getMinEnchantability(i) || p_185291_0_ > enchantment.getMaxEnchantability(i)) continue;
                list.add(new EnchantmentData(enchantment, i));
                continue block0;
            }
        }
        return list;
    }

    static final class ModifierLiving
    implements IModifier {
        public float livingModifier;
        public EnumCreatureAttribute entityLiving;

        private ModifierLiving() {
        }

        @Override
        public void calculateModifier(Enchantment enchantmentIn, int enchantmentLevel) {
            this.livingModifier += enchantmentIn.calcDamageByCreature(enchantmentLevel, this.entityLiving);
        }
    }

    static final class ModifierDamage
    implements IModifier {
        public int damageModifier;
        public DamageSource source;

        private ModifierDamage() {
        }

        @Override
        public void calculateModifier(Enchantment enchantmentIn, int enchantmentLevel) {
            this.damageModifier += enchantmentIn.calcModifierDamage(enchantmentLevel, this.source);
        }
    }

    static interface IModifier {
        public void calculateModifier(Enchantment var1, int var2);
    }

    static final class HurtIterator
    implements IModifier {
        public EntityLivingBase user;
        public Entity attacker;

        private HurtIterator() {
        }

        @Override
        public void calculateModifier(Enchantment enchantmentIn, int enchantmentLevel) {
            enchantmentIn.onUserHurt(this.user, this.attacker, enchantmentLevel);
        }
    }

    static final class DamageIterator
    implements IModifier {
        public EntityLivingBase user;
        public Entity target;

        private DamageIterator() {
        }

        @Override
        public void calculateModifier(Enchantment enchantmentIn, int enchantmentLevel) {
            enchantmentIn.onEntityDamaged(this.user, this.target, enchantmentLevel);
        }
    }
}

