/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityBodyHelper;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityLeashKnot;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityJumpHelper;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.ai.EntitySenses;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketEntityAttach;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.src.BlockPosM;
import net.minecraft.src.Config;
import net.minecraft.src.Reflector;
import net.minecraft.stats.AchievementList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;

public abstract class EntityLiving
extends EntityLivingBase {
    private static final DataParameter<Byte> AI_FLAGS = EntityDataManager.createKey(EntityLiving.class, DataSerializers.BYTE);
    public int livingSoundTime;
    protected int experienceValue;
    private EntityLookHelper lookHelper;
    protected EntityMoveHelper moveHelper;
    protected EntityJumpHelper jumpHelper;
    private EntityBodyHelper bodyHelper;
    protected PathNavigate navigator;
    protected final EntityAITasks tasks;
    protected final EntityAITasks targetTasks;
    private EntityLivingBase attackTarget;
    private EntitySenses senses;
    private ItemStack[] inventoryHands = new ItemStack[2];
    protected float[] inventoryHandsDropChances = new float[2];
    private ItemStack[] inventoryArmor = new ItemStack[4];
    protected float[] inventoryArmorDropChances = new float[4];
    private boolean canPickUpLoot;
    private boolean persistenceRequired;
    private Map<PathNodeType, Float> field_184658_bz = Maps.newEnumMap(PathNodeType.class);
    private ResourceLocation deathLootTable;
    private long deathLootTableSeed;
    private boolean isLeashed;
    private Entity leashedToEntity;
    private NBTTagCompound leashNBTTag;
    public int randomMobsId = 0;
    public BiomeGenBase spawnBiome = null;
    public BlockPos spawnPosition = null;

    public EntityLiving(World worldIn) {
        super(worldIn);
        this.tasks = new EntityAITasks(worldIn != null && worldIn.theProfiler != null ? worldIn.theProfiler : null);
        this.targetTasks = new EntityAITasks(worldIn != null && worldIn.theProfiler != null ? worldIn.theProfiler : null);
        this.lookHelper = new EntityLookHelper(this);
        this.moveHelper = new EntityMoveHelper(this);
        this.jumpHelper = new EntityJumpHelper(this);
        this.bodyHelper = this.createBodyHelper();
        this.navigator = this.getNewNavigator(worldIn);
        this.senses = new EntitySenses(this);
        for (int i = 0; i < this.inventoryArmorDropChances.length; ++i) {
            this.inventoryArmorDropChances[i] = 0.085f;
        }
        for (int k = 0; k < this.inventoryHandsDropChances.length; ++k) {
            this.inventoryHandsDropChances[k] = 0.085f;
        }
        if (worldIn != null && !worldIn.isRemote) {
            this.initEntityAI();
        }
        UUID uuid = this.getUniqueID();
        long j = uuid.getLeastSignificantBits();
        this.randomMobsId = (int)(j & Integer.MAX_VALUE);
    }

    protected void initEntityAI() {
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.FOLLOW_RANGE).setBaseValue(16.0);
    }

    protected PathNavigate getNewNavigator(World worldIn) {
        return new PathNavigateGround(this, worldIn);
    }

    public float func_184643_a(PathNodeType p_184643_1_) {
        return this.field_184658_bz.containsKey((Object)p_184643_1_) ? this.field_184658_bz.get((Object)p_184643_1_).floatValue() : p_184643_1_.func_186289_a();
    }

    public void func_184644_a(PathNodeType p_184644_1_, float p_184644_2_) {
        this.field_184658_bz.put(p_184644_1_, Float.valueOf(p_184644_2_));
    }

    protected EntityBodyHelper createBodyHelper() {
        return new EntityBodyHelper(this);
    }

    public EntityLookHelper getLookHelper() {
        return this.lookHelper;
    }

    public EntityMoveHelper getMoveHelper() {
        return this.moveHelper;
    }

    public EntityJumpHelper getJumpHelper() {
        return this.jumpHelper;
    }

    public PathNavigate getNavigator() {
        return this.navigator;
    }

    public EntitySenses getEntitySenses() {
        return this.senses;
    }

    public EntityLivingBase getAttackTarget() {
        return this.attackTarget;
    }

    public void setAttackTarget(EntityLivingBase entitylivingbaseIn) {
        this.attackTarget = entitylivingbaseIn;
        Reflector.callVoid(Reflector.ForgeHooks_onLivingSetAttackTarget, this, entitylivingbaseIn);
    }

    public boolean canAttackClass(Class<? extends EntityLivingBase> cls) {
        return cls != EntityGhast.class;
    }

    public void eatGrassBonus() {
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.register(AI_FLAGS, (byte)0);
    }

    public int getTalkInterval() {
        return 80;
    }

    public void playLivingSound() {
        SoundEvent soundevent = this.getAmbientSound();
        if (soundevent != null) {
            this.playSound(soundevent, this.getSoundVolume(), this.getSoundPitch());
        }
    }

    @Override
    public void onEntityUpdate() {
        super.onEntityUpdate();
        this.worldObj.theProfiler.startSection("mobBaseTick");
        if (this.isEntityAlive() && this.rand.nextInt(1000) < this.livingSoundTime++) {
            this.applyEntityAI();
            this.playLivingSound();
        }
        this.worldObj.theProfiler.endSection();
    }

    @Override
    protected void func_184581_c(DamageSource p_184581_1_) {
        this.applyEntityAI();
        super.func_184581_c(p_184581_1_);
    }

    private void applyEntityAI() {
        this.livingSoundTime = -this.getTalkInterval();
    }

    @Override
    protected int getExperiencePoints(EntityPlayer player) {
        if (this.experienceValue > 0) {
            int i = this.experienceValue;
            for (int j = 0; j < this.inventoryArmor.length; ++j) {
                if (this.inventoryArmor[j] == null || !(this.inventoryArmorDropChances[j] <= 1.0f)) continue;
                i += 1 + this.rand.nextInt(3);
            }
            for (int k = 0; k < this.inventoryHands.length; ++k) {
                if (this.inventoryHands[k] == null || !(this.inventoryHandsDropChances[k] <= 1.0f)) continue;
                i += 1 + this.rand.nextInt(3);
            }
            return i;
        }
        return this.experienceValue;
    }

    public void spawnExplosionParticle() {
        if (this.worldObj.isRemote) {
            for (int i = 0; i < 20; ++i) {
                double d0 = this.rand.nextGaussian() * 0.02;
                double d1 = this.rand.nextGaussian() * 0.02;
                double d2 = this.rand.nextGaussian() * 0.02;
                double d3 = 10.0;
                this.worldObj.spawnParticle(EnumParticleTypes.EXPLOSION_NORMAL, this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width - d0 * d3, this.posY + (double)(this.rand.nextFloat() * this.height) - d1 * d3, this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width - d2 * d3, d0, d1, d2, new int[0]);
            }
        } else {
            this.worldObj.setEntityState(this, (byte)20);
        }
    }

    @Override
    public void handleStatusUpdate(byte id) {
        if (id == 20) {
            this.spawnExplosionParticle();
        } else {
            super.handleStatusUpdate(id);
        }
    }

    @Override
    public void onUpdate() {
        if (Config.isSmoothWorld() && this.canSkipUpdate()) {
            this.onUpdateMinimal();
        } else {
            super.onUpdate();
            if (!this.worldObj.isRemote) {
                this.updateLeashedState();
                if (this.ticksExisted % 5 == 0) {
                    boolean flag = !(this.getControllingPassenger() instanceof EntityLiving);
                    boolean flag1 = !(this.getRidingEntity() instanceof EntityBoat);
                    this.tasks.func_188527_a(5, flag && flag1);
                    this.tasks.func_188527_a(2, flag);
                }
            }
        }
    }

    @Override
    protected float updateDistance(float p_110146_1_, float p_110146_2_) {
        this.bodyHelper.updateRenderAngles();
        return p_110146_2_;
    }

    protected SoundEvent getAmbientSound() {
        return null;
    }

    protected Item getDropItem() {
        return null;
    }

    @Override
    protected void dropFewItems(boolean wasRecentlyHit, int lootingModifier) {
        Item item = this.getDropItem();
        if (item != null) {
            int i = this.rand.nextInt(3);
            if (lootingModifier > 0) {
                i += this.rand.nextInt(lootingModifier + 1);
            }
            for (int j = 0; j < i; ++j) {
                this.dropItem(item, 1);
            }
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound tagCompound) {
        super.writeEntityToNBT(tagCompound);
        tagCompound.setBoolean("CanPickUpLoot", this.canPickUpLoot());
        tagCompound.setBoolean("PersistenceRequired", this.persistenceRequired);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventoryArmor.length; ++i) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            if (this.inventoryArmor[i] != null) {
                this.inventoryArmor[i].writeToNBT(nbttagcompound);
            }
            nbttaglist.appendTag(nbttagcompound);
        }
        tagCompound.setTag("ArmorItems", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (int k = 0; k < this.inventoryHands.length; ++k) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            if (this.inventoryHands[k] != null) {
                this.inventoryHands[k].writeToNBT(nbttagcompound1);
            }
            nbttaglist1.appendTag(nbttagcompound1);
        }
        tagCompound.setTag("HandItems", nbttaglist1);
        NBTTagList nbttaglist2 = new NBTTagList();
        for (int l = 0; l < this.inventoryArmorDropChances.length; ++l) {
            nbttaglist2.appendTag(new NBTTagFloat(this.inventoryArmorDropChances[l]));
        }
        tagCompound.setTag("ArmorDropChances", nbttaglist2);
        NBTTagList nbttaglist3 = new NBTTagList();
        for (int j = 0; j < this.inventoryHandsDropChances.length; ++j) {
            nbttaglist3.appendTag(new NBTTagFloat(this.inventoryHandsDropChances[j]));
        }
        tagCompound.setTag("HandDropChances", nbttaglist3);
        tagCompound.setBoolean("Leashed", this.isLeashed);
        if (this.leashedToEntity != null) {
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            if (this.leashedToEntity instanceof EntityLivingBase) {
                UUID uuid = this.leashedToEntity.getUniqueID();
                nbttagcompound2.setUniqueId("UUID", uuid);
            } else if (this.leashedToEntity instanceof EntityHanging) {
                BlockPos blockpos = ((EntityHanging)this.leashedToEntity).getHangingPosition();
                nbttagcompound2.setInteger("X", blockpos.getX());
                nbttagcompound2.setInteger("Y", blockpos.getY());
                nbttagcompound2.setInteger("Z", blockpos.getZ());
            }
            tagCompound.setTag("Leash", nbttagcompound2);
        }
        tagCompound.setBoolean("LeftHanded", this.isLeftHanded());
        if (this.deathLootTable != null) {
            tagCompound.setString("DeathLootTable", this.deathLootTable.toString());
            if (this.deathLootTableSeed != 0L) {
                tagCompound.setLong("DeathLootTableSeed", this.deathLootTableSeed);
            }
        }
        if (this.isAIDisabled()) {
            tagCompound.setBoolean("NoAI", this.isAIDisabled());
        }
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound tagCompund) {
        super.readEntityFromNBT(tagCompund);
        if (tagCompund.hasKey("CanPickUpLoot", 1)) {
            this.setCanPickUpLoot(tagCompund.getBoolean("CanPickUpLoot"));
        }
        this.persistenceRequired = tagCompund.getBoolean("PersistenceRequired");
        if (tagCompund.hasKey("ArmorItems", 9)) {
            NBTTagList nbttaglist = tagCompund.getTagList("ArmorItems", 10);
            for (int i = 0; i < this.inventoryArmor.length; ++i) {
                this.inventoryArmor[i] = ItemStack.loadItemStackFromNBT(nbttaglist.getCompoundTagAt(i));
            }
        }
        if (tagCompund.hasKey("HandItems", 9)) {
            NBTTagList nbttaglist1 = tagCompund.getTagList("HandItems", 10);
            for (int j = 0; j < this.inventoryHands.length; ++j) {
                this.inventoryHands[j] = ItemStack.loadItemStackFromNBT(nbttaglist1.getCompoundTagAt(j));
            }
        }
        if (tagCompund.hasKey("ArmorDropChances", 9)) {
            NBTTagList nbttaglist2 = tagCompund.getTagList("ArmorDropChances", 5);
            for (int k = 0; k < nbttaglist2.tagCount(); ++k) {
                this.inventoryArmorDropChances[k] = nbttaglist2.getFloatAt(k);
            }
        }
        if (tagCompund.hasKey("HandDropChances", 9)) {
            NBTTagList nbttaglist3 = tagCompund.getTagList("HandDropChances", 5);
            for (int l = 0; l < nbttaglist3.tagCount(); ++l) {
                this.inventoryHandsDropChances[l] = nbttaglist3.getFloatAt(l);
            }
        }
        this.isLeashed = tagCompund.getBoolean("Leashed");
        if (this.isLeashed && tagCompund.hasKey("Leash", 10)) {
            this.leashNBTTag = tagCompund.getCompoundTag("Leash");
        }
        this.func_184641_n(tagCompund.getBoolean("LeftHanded"));
        if (tagCompund.hasKey("DeathLootTable", 8)) {
            this.deathLootTable = new ResourceLocation(tagCompund.getString("DeathLootTable"));
            this.deathLootTableSeed = tagCompund.getLong("DeathLootTableSeed");
        }
        this.setNoAI(tagCompund.getBoolean("NoAI"));
    }

    protected ResourceLocation func_184647_J() {
        return null;
    }

    @Override
    protected void func_184610_a(boolean p_184610_1_, int p_184610_2_, DamageSource source) {
        ResourceLocation resourcelocation = this.deathLootTable;
        if (resourcelocation == null) {
            resourcelocation = this.func_184647_J();
        }
        if (resourcelocation != null) {
            LootTable loottable = this.worldObj.getLootTableManager().func_186521_a(resourcelocation);
            this.deathLootTable = null;
            LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.worldObj).withLootedEntity(this).withDamageSource(source);
            if (p_184610_1_ && this.attackingPlayer != null) {
                lootcontext$builder = lootcontext$builder.withPlayer(this.attackingPlayer).withLuck(this.attackingPlayer.getLuck());
            }
            for (ItemStack itemstack : loottable.func_186462_a(this.deathLootTableSeed == 0L ? this.rand : new Random(this.deathLootTableSeed), lootcontext$builder.build())) {
                this.entityDropItem(itemstack, 0.0f);
            }
            this.dropEquipment(p_184610_1_, p_184610_2_);
        } else {
            super.func_184610_a(p_184610_1_, p_184610_2_, source);
        }
    }

    public void setMoveForward(float p_70657_1_) {
        this.moveForward = p_70657_1_;
    }

    public void func_184646_p(float p_184646_1_) {
        this.moveStrafing = p_184646_1_;
    }

    @Override
    public void setAIMoveSpeed(float speedIn) {
        super.setAIMoveSpeed(speedIn);
        this.setMoveForward(speedIn);
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
        this.worldObj.theProfiler.startSection("looting");
        if (!this.worldObj.isRemote && this.canPickUpLoot() && !this.dead && this.worldObj.getGameRules().getBoolean("mobGriefing")) {
            for (EntityItem entityitem : this.worldObj.getEntitiesWithinAABB(EntityItem.class, this.getEntityBoundingBox().expand(1.0, 0.0, 1.0))) {
                if (entityitem.isDead || entityitem.getEntityItem() == null || entityitem.cannotPickup()) continue;
                this.updateEquipmentIfNeeded(entityitem);
            }
        }
        this.worldObj.theProfiler.endSection();
    }

    protected void updateEquipmentIfNeeded(EntityItem itemEntity) {
        ItemStack itemstack = itemEntity.getEntityItem();
        EntityEquipmentSlot entityequipmentslot = EntityLiving.func_184640_d(itemstack);
        boolean flag = true;
        ItemStack itemstack1 = this.getItemStackFromSlot(entityequipmentslot);
        if (itemstack1 != null) {
            if (entityequipmentslot.func_188453_a() == EntityEquipmentSlot.Type.HAND) {
                if (itemstack.getItem() instanceof ItemSword && !(itemstack1.getItem() instanceof ItemSword)) {
                    flag = true;
                } else if (itemstack.getItem() instanceof ItemSword && itemstack1.getItem() instanceof ItemSword) {
                    ItemSword itemsword = (ItemSword)itemstack.getItem();
                    ItemSword itemsword1 = (ItemSword)itemstack1.getItem();
                    flag = itemsword.getDamageVsEntity() == itemsword1.getDamageVsEntity() ? itemstack.getMetadata() > itemstack1.getMetadata() || itemstack.hasTagCompound() && !itemstack1.hasTagCompound() : itemsword.getDamageVsEntity() > itemsword1.getDamageVsEntity();
                } else {
                    flag = itemstack.getItem() instanceof ItemBow && itemstack1.getItem() instanceof ItemBow ? itemstack.hasTagCompound() && !itemstack1.hasTagCompound() : false;
                }
            } else if (itemstack.getItem() instanceof ItemArmor && !(itemstack1.getItem() instanceof ItemArmor)) {
                flag = true;
            } else if (itemstack.getItem() instanceof ItemArmor && itemstack1.getItem() instanceof ItemArmor) {
                ItemArmor itemarmor = (ItemArmor)itemstack.getItem();
                ItemArmor itemarmor1 = (ItemArmor)itemstack1.getItem();
                flag = itemarmor.damageReduceAmount == itemarmor1.damageReduceAmount ? itemstack.getMetadata() > itemstack1.getMetadata() || itemstack.hasTagCompound() && !itemstack1.hasTagCompound() : itemarmor.damageReduceAmount > itemarmor1.damageReduceAmount;
            } else {
                flag = false;
            }
        }
        if (flag && this.func_175448_a(itemstack)) {
            EntityPlayer entityplayer;
            double d0;
            switch (entityequipmentslot.func_188453_a()) {
                case HAND: {
                    d0 = this.inventoryHandsDropChances[entityequipmentslot.func_188454_b()];
                    break;
                }
                case ARMOR: {
                    d0 = this.inventoryArmorDropChances[entityequipmentslot.func_188454_b()];
                    break;
                }
                default: {
                    d0 = 0.0;
                }
            }
            if (itemstack1 != null && (double)(this.rand.nextFloat() - 0.1f) < d0) {
                this.entityDropItem(itemstack1, 0.0f);
            }
            if (itemstack.getItem() == Items.diamond && itemEntity.getThrower() != null && (entityplayer = this.worldObj.getPlayerEntityByName(itemEntity.getThrower())) != null) {
                entityplayer.triggerAchievement(AchievementList.field_187996_x);
            }
            this.setItemStackToSlot(entityequipmentslot, itemstack);
            switch (entityequipmentslot.func_188453_a()) {
                case HAND: {
                    this.inventoryHandsDropChances[entityequipmentslot.func_188454_b()] = 2.0f;
                    break;
                }
                case ARMOR: {
                    this.inventoryArmorDropChances[entityequipmentslot.func_188454_b()] = 2.0f;
                }
            }
            this.persistenceRequired = true;
            this.onItemPickup(itemEntity, 1);
            itemEntity.setDead();
        }
    }

    protected boolean func_175448_a(ItemStack stack) {
        return true;
    }

    protected boolean canDespawn() {
        return true;
    }

    protected void despawnEntity() {
        Object object = null;
        Object object1 = Reflector.getFieldValue(Reflector.Event_Result_DEFAULT);
        Object object2 = Reflector.getFieldValue(Reflector.Event_Result_DENY);
        if (this.persistenceRequired) {
            this.entityAge = 0;
        } else if ((this.entityAge & 0x1F) == 31 && (object = Reflector.call(Reflector.ForgeEventFactory_canEntityDespawn, this)) != object1) {
            if (object == object2) {
                this.entityAge = 0;
            } else {
                this.setDead();
            }
        } else {
            EntityPlayer entity = this.worldObj.getClosestPlayerToEntity(this, -1.0);
            if (entity != null) {
                double d0 = entity.posX - this.posX;
                double d1 = entity.posY - this.posY;
                double d2 = entity.posZ - this.posZ;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.canDespawn() && d3 > 16384.0) {
                    this.setDead();
                }
                if (this.entityAge > 600 && this.rand.nextInt(800) == 0 && d3 > 1024.0 && this.canDespawn()) {
                    this.setDead();
                } else if (d3 < 1024.0) {
                    this.entityAge = 0;
                }
            }
        }
    }

    @Override
    protected final void updateEntityActionState() {
        ++this.entityAge;
        this.worldObj.theProfiler.startSection("checkDespawn");
        this.despawnEntity();
        this.worldObj.theProfiler.endSection();
        this.worldObj.theProfiler.startSection("sensing");
        this.senses.clearSensingCache();
        this.worldObj.theProfiler.endSection();
        this.worldObj.theProfiler.startSection("targetSelector");
        this.targetTasks.onUpdateTasks();
        this.worldObj.theProfiler.endSection();
        this.worldObj.theProfiler.startSection("goalSelector");
        this.tasks.onUpdateTasks();
        this.worldObj.theProfiler.endSection();
        this.worldObj.theProfiler.startSection("navigation");
        this.navigator.onUpdateNavigation();
        this.worldObj.theProfiler.endSection();
        this.worldObj.theProfiler.startSection("mob tick");
        this.updateAITasks();
        this.worldObj.theProfiler.endSection();
        if (this.isRiding() && this.getRidingEntity() instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)this.getRidingEntity();
            entityliving.getNavigator().setPath(this.getNavigator().getPath(), 1.5);
            entityliving.getMoveHelper().func_188487_a(this.getMoveHelper());
        }
        this.worldObj.theProfiler.startSection("controls");
        this.worldObj.theProfiler.startSection("move");
        this.moveHelper.onUpdateMoveHelper();
        this.worldObj.theProfiler.endStartSection("look");
        this.lookHelper.onUpdateLook();
        this.worldObj.theProfiler.endStartSection("jump");
        this.jumpHelper.doJump();
        this.worldObj.theProfiler.endSection();
        this.worldObj.theProfiler.endSection();
    }

    protected void updateAITasks() {
    }

    public int getVerticalFaceSpeed() {
        return 40;
    }

    public int func_184649_cE() {
        return 10;
    }

    public void faceEntity(Entity entityIn, float p_70625_2_, float p_70625_3_) {
        double d2;
        double d0 = entityIn.posX - this.posX;
        double d1 = entityIn.posZ - this.posZ;
        if (entityIn instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)entityIn;
            d2 = entitylivingbase.posY + (double)entitylivingbase.getEyeHeight() - (this.posY + (double)this.getEyeHeight());
        } else {
            d2 = (entityIn.getEntityBoundingBox().minY + entityIn.getEntityBoundingBox().maxY) / 2.0 - (this.posY + (double)this.getEyeHeight());
        }
        double d3 = MathHelper.sqrt_double(d0 * d0 + d1 * d1);
        float f = (float)(MathHelper.atan2(d1, d0) * 57.29577951308232) - 90.0f;
        float f1 = (float)(-(MathHelper.atan2(d2, d3) * 57.29577951308232));
        this.rotationPitch = this.updateRotation(this.rotationPitch, f1, p_70625_3_);
        this.rotationYaw = this.updateRotation(this.rotationYaw, f, p_70625_2_);
    }

    private float updateRotation(float p_70663_1_, float p_70663_2_, float p_70663_3_) {
        float f = MathHelper.wrapAngleTo180_float(p_70663_2_ - p_70663_1_);
        if (f > p_70663_3_) {
            f = p_70663_3_;
        }
        if (f < -p_70663_3_) {
            f = -p_70663_3_;
        }
        return p_70663_1_ + f;
    }

    public boolean getCanSpawnHere() {
        return true;
    }

    public boolean isNotColliding() {
        return !this.worldObj.isAnyLiquid(this.getEntityBoundingBox()) && this.worldObj.func_184144_a(this, this.getEntityBoundingBox()).isEmpty() && this.worldObj.checkNoEntityCollision(this.getEntityBoundingBox(), this);
    }

    public float getRenderSizeModifier() {
        return 1.0f;
    }

    public int getMaxSpawnedInChunk() {
        return 4;
    }

    @Override
    public int getMaxFallHeight() {
        if (this.getAttackTarget() == null) {
            return 3;
        }
        int i = (int)(this.getHealth() - this.getMaxHealth() * 0.33f);
        if ((i -= (3 - this.worldObj.getDifficulty().getDifficultyId()) * 4) < 0) {
            i = 0;
        }
        return i + 3;
    }

    @Override
    public Iterable<ItemStack> getHeldEquipment() {
        return Arrays.asList(this.inventoryHands);
    }

    @Override
    public Iterable<ItemStack> getArmorInventoryList() {
        return Arrays.asList(this.inventoryArmor);
    }

    @Override
    public ItemStack getItemStackFromSlot(EntityEquipmentSlot slotIn) {
        ItemStack itemstack = null;
        switch (slotIn.func_188453_a()) {
            case HAND: {
                itemstack = this.inventoryHands[slotIn.func_188454_b()];
                break;
            }
            case ARMOR: {
                itemstack = this.inventoryArmor[slotIn.func_188454_b()];
            }
        }
        return itemstack;
    }

    @Override
    public void setItemStackToSlot(EntityEquipmentSlot slotIn, ItemStack stack) {
        switch (slotIn.func_188453_a()) {
            case HAND: {
                this.inventoryHands[slotIn.func_188454_b()] = stack;
                break;
            }
            case ARMOR: {
                this.inventoryArmor[slotIn.func_188454_b()] = stack;
            }
        }
    }

    @Override
    protected void dropEquipment(boolean wasRecentlyHit, int lootingModifier) {
        for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
            boolean flag;
            double d0;
            ItemStack itemstack = this.getItemStackFromSlot(entityequipmentslot);
            switch (entityequipmentslot.func_188453_a()) {
                case HAND: {
                    d0 = this.inventoryHandsDropChances[entityequipmentslot.func_188454_b()];
                    break;
                }
                case ARMOR: {
                    d0 = this.inventoryArmorDropChances[entityequipmentslot.func_188454_b()];
                    break;
                }
                default: {
                    d0 = 0.0;
                }
            }
            boolean bl = flag = d0 > 1.0;
            if (itemstack == null || !wasRecentlyHit && !flag || !((double)(this.rand.nextFloat() - (float)lootingModifier * 0.01f) < d0)) continue;
            if (!flag && itemstack.isItemStackDamageable()) {
                int i = Math.max(itemstack.getMaxDamage() - 25, 1);
                int j = itemstack.getMaxDamage() - this.rand.nextInt(this.rand.nextInt(i) + 1);
                if (j > i) {
                    j = i;
                }
                if (j < 1) {
                    j = 1;
                }
                itemstack.setItemDamage(j);
            }
            this.entityDropItem(itemstack, 0.0f);
        }
    }

    protected void setEquipmentBasedOnDifficulty(DifficultyInstance difficulty) {
        if (this.rand.nextFloat() < 0.15f * difficulty.getClampedAdditionalDifficulty()) {
            float f;
            int i = this.rand.nextInt(2);
            float f2 = f = this.worldObj.getDifficulty() == EnumDifficulty.HARD ? 0.1f : 0.25f;
            if (this.rand.nextFloat() < 0.095f) {
                ++i;
            }
            if (this.rand.nextFloat() < 0.095f) {
                ++i;
            }
            if (this.rand.nextFloat() < 0.095f) {
                ++i;
            }
            boolean flag = true;
            for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
                Item item;
                if (entityequipmentslot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR) continue;
                ItemStack itemstack = this.getItemStackFromSlot(entityequipmentslot);
                if (!flag && this.rand.nextFloat() < f) break;
                flag = false;
                if (itemstack != null || (item = EntityLiving.func_184636_a(entityequipmentslot, i)) == null) continue;
                this.setItemStackToSlot(entityequipmentslot, new ItemStack(item));
            }
        }
    }

    public static EntityEquipmentSlot func_184640_d(ItemStack p_184640_0_) {
        return p_184640_0_.getItem() != Item.getItemFromBlock(Blocks.pumpkin) && p_184640_0_.getItem() != Items.skull ? (p_184640_0_.getItem() == Items.elytra ? EntityEquipmentSlot.CHEST : (p_184640_0_.getItem() instanceof ItemArmor ? ((ItemArmor)p_184640_0_.getItem()).armorType : (p_184640_0_.getItem() == Items.elytra ? EntityEquipmentSlot.CHEST : EntityEquipmentSlot.MAINHAND))) : EntityEquipmentSlot.HEAD;
    }

    public static Item func_184636_a(EntityEquipmentSlot p_184636_0_, int p_184636_1_) {
        switch (p_184636_0_) {
            case HEAD: {
                if (p_184636_1_ == 0) {
                    return Items.leather_helmet;
                }
                if (p_184636_1_ == 1) {
                    return Items.golden_helmet;
                }
                if (p_184636_1_ == 2) {
                    return Items.chainmail_helmet;
                }
                if (p_184636_1_ == 3) {
                    return Items.iron_helmet;
                }
                if (p_184636_1_ == 4) {
                    return Items.diamond_helmet;
                }
            }
            case CHEST: {
                if (p_184636_1_ == 0) {
                    return Items.leather_chestplate;
                }
                if (p_184636_1_ == 1) {
                    return Items.golden_chestplate;
                }
                if (p_184636_1_ == 2) {
                    return Items.chainmail_chestplate;
                }
                if (p_184636_1_ == 3) {
                    return Items.iron_chestplate;
                }
                if (p_184636_1_ == 4) {
                    return Items.diamond_chestplate;
                }
            }
            case LEGS: {
                if (p_184636_1_ == 0) {
                    return Items.leather_leggings;
                }
                if (p_184636_1_ == 1) {
                    return Items.golden_leggings;
                }
                if (p_184636_1_ == 2) {
                    return Items.chainmail_leggings;
                }
                if (p_184636_1_ == 3) {
                    return Items.iron_leggings;
                }
                if (p_184636_1_ == 4) {
                    return Items.diamond_leggings;
                }
            }
            case FEET: {
                if (p_184636_1_ == 0) {
                    return Items.leather_boots;
                }
                if (p_184636_1_ == 1) {
                    return Items.golden_boots;
                }
                if (p_184636_1_ == 2) {
                    return Items.chainmail_boots;
                }
                if (p_184636_1_ == 3) {
                    return Items.iron_boots;
                }
                if (p_184636_1_ != 4) break;
                return Items.diamond_boots;
            }
        }
        return null;
    }

    protected void setEnchantmentBasedOnDifficulty(DifficultyInstance difficulty) {
        float f = difficulty.getClampedAdditionalDifficulty();
        if (this.getHeldItemMainhand() != null && this.rand.nextFloat() < 0.25f * f) {
            EnchantmentHelper.addRandomEnchantment(this.rand, this.getHeldItemMainhand(), (int)(5.0f + f * (float)this.rand.nextInt(18)), false);
        }
        for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
            ItemStack itemstack;
            if (entityequipmentslot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR || (itemstack = this.getItemStackFromSlot(entityequipmentslot)) == null || !(this.rand.nextFloat() < 0.5f * f)) continue;
            EnchantmentHelper.addRandomEnchantment(this.rand, itemstack, (int)(5.0f + f * (float)this.rand.nextInt(18)), false);
        }
    }

    public IEntityLivingData onInitialSpawn(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE).applyModifier(new AttributeModifier("Random spawn bonus", this.rand.nextGaussian() * 0.05, 1));
        if (this.rand.nextFloat() < 0.05f) {
            this.func_184641_n(true);
        } else {
            this.func_184641_n(false);
        }
        return livingdata;
    }

    public boolean canBeSteered() {
        return false;
    }

    public void enablePersistence() {
        this.persistenceRequired = true;
    }

    public void func_184642_a(EntityEquipmentSlot slotIn, float chance) {
        switch (slotIn.func_188453_a()) {
            case HAND: {
                this.inventoryHandsDropChances[slotIn.func_188454_b()] = chance;
                break;
            }
            case ARMOR: {
                this.inventoryArmorDropChances[slotIn.func_188454_b()] = chance;
            }
        }
    }

    public boolean canPickUpLoot() {
        return this.canPickUpLoot;
    }

    public void setCanPickUpLoot(boolean canPickup) {
        this.canPickUpLoot = canPickup;
    }

    public boolean isNoDespawnRequired() {
        return this.persistenceRequired;
    }

    @Override
    public final boolean func_184230_a(EntityPlayer p_184230_1_, ItemStack p_184230_2_, EnumHand p_184230_3_) {
        if (this.getLeashed() && this.getLeashedToEntity() == p_184230_1_) {
            this.clearLeashed(true, !p_184230_1_.capabilities.isCreativeMode);
            return true;
        }
        if (p_184230_2_ != null && p_184230_2_.getItem() == Items.lead && this.func_184652_a(p_184230_1_)) {
            this.setLeashedToEntity(p_184230_1_, true);
            --p_184230_2_.stackSize;
            return true;
        }
        return this.func_184645_a(p_184230_1_, p_184230_3_, p_184230_2_) ? true : super.func_184230_a(p_184230_1_, p_184230_2_, p_184230_3_);
    }

    protected boolean func_184645_a(EntityPlayer p_184645_1_, EnumHand p_184645_2_, ItemStack p_184645_3_) {
        return false;
    }

    protected void updateLeashedState() {
        if (this.leashNBTTag != null) {
            this.recreateLeash();
        }
        if (this.isLeashed) {
            if (!this.isEntityAlive()) {
                this.clearLeashed(true, true);
            }
            if (this.leashedToEntity == null || this.leashedToEntity.isDead) {
                this.clearLeashed(true, true);
            }
        }
    }

    public void clearLeashed(boolean sendPacket, boolean dropLead) {
        if (this.isLeashed) {
            this.isLeashed = false;
            this.leashedToEntity = null;
            if (!this.worldObj.isRemote && dropLead) {
                this.dropItem(Items.lead, 1);
            }
            if (!this.worldObj.isRemote && sendPacket && this.worldObj instanceof WorldServer) {
                ((WorldServer)this.worldObj).getEntityTracker().sendToAllTrackingEntity(this, new SPacketEntityAttach(this, null));
            }
        }
    }

    public boolean func_184652_a(EntityPlayer p_184652_1_) {
        return !this.getLeashed() && !(this instanceof IMob);
    }

    public boolean getLeashed() {
        return this.isLeashed;
    }

    public Entity getLeashedToEntity() {
        return this.leashedToEntity;
    }

    public void setLeashedToEntity(Entity entityIn, boolean sendAttachNotification) {
        this.isLeashed = true;
        this.leashedToEntity = entityIn;
        if (!this.worldObj.isRemote && sendAttachNotification && this.worldObj instanceof WorldServer) {
            ((WorldServer)this.worldObj).getEntityTracker().sendToAllTrackingEntity(this, new SPacketEntityAttach(this, this.leashedToEntity));
        }
        if (this.isRiding()) {
            this.dismountRidingEntity();
        }
    }

    @Override
    public boolean startRiding(Entity entityIn, boolean force) {
        boolean flag = super.startRiding(entityIn, force);
        if (flag && this.getLeashed()) {
            this.clearLeashed(true, true);
        }
        return flag;
    }

    private void recreateLeash() {
        if (this.isLeashed && this.leashNBTTag != null) {
            if (this.leashNBTTag.hasUniqueId("UUID")) {
                UUID uuid = this.leashNBTTag.getUniqueId("UUID");
                for (EntityLivingBase entitylivingbase : this.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, this.getEntityBoundingBox().func_186662_g(10.0))) {
                    if (!entitylivingbase.getUniqueID().equals(uuid)) continue;
                    this.leashedToEntity = entitylivingbase;
                    break;
                }
            } else if (this.leashNBTTag.hasKey("X", 99) && this.leashNBTTag.hasKey("Y", 99) && this.leashNBTTag.hasKey("Z", 99)) {
                BlockPos blockpos = new BlockPos(this.leashNBTTag.getInteger("X"), this.leashNBTTag.getInteger("Y"), this.leashNBTTag.getInteger("Z"));
                EntityLeashKnot entityleashknot = EntityLeashKnot.getKnotForPosition(this.worldObj, blockpos);
                if (entityleashknot == null) {
                    entityleashknot = EntityLeashKnot.createKnot(this.worldObj, blockpos);
                }
                this.leashedToEntity = entityleashknot;
            } else {
                this.clearLeashed(false, true);
            }
        }
        this.leashNBTTag = null;
    }

    @Override
    public boolean replaceItemInInventory(int inventorySlot, ItemStack itemStackIn) {
        EntityEquipmentSlot entityequipmentslot;
        if (inventorySlot == 98) {
            entityequipmentslot = EntityEquipmentSlot.MAINHAND;
        } else if (inventorySlot == 99) {
            entityequipmentslot = EntityEquipmentSlot.OFFHAND;
        } else if (inventorySlot == 100 + EntityEquipmentSlot.HEAD.func_188454_b()) {
            entityequipmentslot = EntityEquipmentSlot.HEAD;
        } else if (inventorySlot == 100 + EntityEquipmentSlot.CHEST.func_188454_b()) {
            entityequipmentslot = EntityEquipmentSlot.CHEST;
        } else if (inventorySlot == 100 + EntityEquipmentSlot.LEGS.func_188454_b()) {
            entityequipmentslot = EntityEquipmentSlot.LEGS;
        } else {
            if (inventorySlot != 100 + EntityEquipmentSlot.FEET.func_188454_b()) {
                return false;
            }
            entityequipmentslot = EntityEquipmentSlot.FEET;
        }
        if (itemStackIn != null && !EntityLiving.func_184648_b(entityequipmentslot, itemStackIn) && entityequipmentslot != EntityEquipmentSlot.HEAD) {
            return false;
        }
        this.setItemStackToSlot(entityequipmentslot, itemStackIn);
        return true;
    }

    public static boolean func_184648_b(EntityEquipmentSlot p_184648_0_, ItemStack p_184648_1_) {
        EntityEquipmentSlot entityequipmentslot = EntityLiving.func_184640_d(p_184648_1_);
        return entityequipmentslot == p_184648_0_ || entityequipmentslot == EntityEquipmentSlot.MAINHAND && p_184648_0_ == EntityEquipmentSlot.OFFHAND;
    }

    @Override
    public boolean isServerWorld() {
        return super.isServerWorld() && !this.isAIDisabled();
    }

    public void setNoAI(boolean disable) {
        byte b0 = this.dataWatcher.get(AI_FLAGS);
        this.dataWatcher.set(AI_FLAGS, disable ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE));
    }

    public void func_184641_n(boolean p_184641_1_) {
        byte b0 = this.dataWatcher.get(AI_FLAGS);
        this.dataWatcher.set(AI_FLAGS, p_184641_1_ ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD));
    }

    public boolean isAIDisabled() {
        return (this.dataWatcher.get(AI_FLAGS) & 1) != 0;
    }

    public boolean isLeftHanded() {
        return (this.dataWatcher.get(AI_FLAGS) & 2) != 0;
    }

    @Override
    public EnumHandSide getPrimaryHand() {
        return this.isLeftHanded() ? EnumHandSide.LEFT : EnumHandSide.RIGHT;
    }

    @Override
    public boolean isEntityInsideOpaqueBlock() {
        if (this.noClip) {
            return false;
        }
        BlockPosM blockposm = new BlockPosM(0, 0, 0);
        for (int i = 0; i < 8; ++i) {
            double d0 = this.posX + (double)(((float)((i >> 0) % 2) - 0.5f) * this.width * 0.8f);
            double d1 = this.posY + (double)(((float)((i >> 1) % 2) - 0.5f) * 0.1f);
            double d2 = this.posZ + (double)(((float)((i >> 2) % 2) - 0.5f) * this.width * 0.8f);
            blockposm.setXyz(d0, d1 + (double)this.getEyeHeight(), d2);
            if (!this.worldObj.getBlockState(blockposm).getBlock().isVisuallyOpaque()) continue;
            return true;
        }
        return false;
    }

    private boolean canSkipUpdate() {
        double d1;
        if (this.isChild()) {
            return false;
        }
        if (this.hurtTime > 0) {
            return false;
        }
        if (this.ticksExisted < 20) {
            return false;
        }
        World world = this.getEntityWorld();
        if (world == null) {
            return false;
        }
        if (world.playerEntities.size() != 1) {
            return false;
        }
        Entity entity = world.playerEntities.get(0);
        double d0 = Math.max(Math.abs(this.posX - entity.posX) - 16.0, 0.0);
        double d2 = d0 * d0 + (d1 = Math.max(Math.abs(this.posZ - entity.posZ) - 16.0, 0.0)) * d1;
        return !this.isInRangeToRenderDist(d2);
    }

    private void onUpdateMinimal() {
        float f;
        ++this.entityAge;
        if (this instanceof EntityMob && (f = this.getBrightness(1.0f)) > 0.5f) {
            this.entityAge += 2;
        }
        this.despawnEntity();
    }

    public static enum SpawnPlacementType {
        ON_GROUND,
        IN_AIR,
        IN_WATER;

    }
}

