/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.boss;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.boss.dragon.phase.IPhase;
import net.minecraft.entity.boss.dragon.phase.PhaseList;
import net.minecraft.entity.boss.dragon.phase.PhaseManager;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.end.DragonFightManager;
import net.minecraft.world.gen.feature.WorldGenEndPodium;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityDragon
extends EntityLiving
implements IEntityMultiPart,
IMob {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final DataParameter<Integer> PHASE = EntityDataManager.createKey(EntityDragon.class, DataSerializers.VARINT);
    public double[][] ringBuffer = new double[64][3];
    public int ringBufferIndex = -1;
    public EntityDragonPart[] dragonPartArray;
    public EntityDragonPart dragonPartHead;
    public EntityDragonPart dragonPartNeck;
    public EntityDragonPart dragonPartBody;
    public EntityDragonPart dragonPartTail1;
    public EntityDragonPart dragonPartTail2;
    public EntityDragonPart dragonPartTail3;
    public EntityDragonPart dragonPartWing1;
    public EntityDragonPart dragonPartWing2;
    public float prevAnimTime;
    public float animTime;
    public boolean slowed;
    public int deathTicks;
    public EntityEnderCrystal healingEnderCrystal;
    private final DragonFightManager fightManager;
    private final PhaseManager phaseManager;
    private int field_184678_bK = 200;
    private int field_184679_bL;
    private final PathPoint[] field_184680_bM = new PathPoint[24];
    private final int[] field_184681_bN = new int[24];
    private final Path field_184682_bO = new Path();

    public EntityDragon(World worldIn) {
        super(worldIn);
        this.dragonPartHead = new EntityDragonPart(this, "head", 6.0f, 6.0f);
        this.dragonPartNeck = new EntityDragonPart(this, "neck", 6.0f, 6.0f);
        this.dragonPartBody = new EntityDragonPart(this, "body", 8.0f, 8.0f);
        this.dragonPartTail1 = new EntityDragonPart(this, "tail", 4.0f, 4.0f);
        this.dragonPartTail2 = new EntityDragonPart(this, "tail", 4.0f, 4.0f);
        this.dragonPartTail3 = new EntityDragonPart(this, "tail", 4.0f, 4.0f);
        this.dragonPartWing1 = new EntityDragonPart(this, "wing", 4.0f, 4.0f);
        this.dragonPartWing2 = new EntityDragonPart(this, "wing", 4.0f, 4.0f);
        this.dragonPartArray = new EntityDragonPart[]{this.dragonPartHead, this.dragonPartNeck, this.dragonPartBody, this.dragonPartTail1, this.dragonPartTail2, this.dragonPartTail3, this.dragonPartWing1, this.dragonPartWing2};
        this.setHealth(this.getMaxHealth());
        this.setSize(16.0f, 8.0f);
        this.noClip = true;
        this.isImmuneToFire = true;
        this.field_184678_bK = 100;
        this.ignoreFrustumCheck = true;
        this.fightManager = !worldIn.isRemote && worldIn.provider instanceof WorldProviderEnd ? ((WorldProviderEnd)worldIn.provider).getDragonFightManager() : null;
        this.phaseManager = new PhaseManager(this);
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(200.0);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.getDataManager().register(PHASE, PhaseList.HOVER.getId());
    }

    public double[] getMovementOffsets(int p_70974_1_, float p_70974_2_) {
        if (this.getHealth() <= 0.0f) {
            p_70974_2_ = 0.0f;
        }
        p_70974_2_ = 1.0f - p_70974_2_;
        int i = this.ringBufferIndex - p_70974_1_ & 0x3F;
        int j = this.ringBufferIndex - p_70974_1_ - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.ringBuffer[i][0];
        double d1 = MathHelper.wrapAngleTo180_double(this.ringBuffer[j][0] - d0);
        adouble[0] = d0 + d1 * (double)p_70974_2_;
        d0 = this.ringBuffer[i][1];
        d1 = this.ringBuffer[j][1] - d0;
        adouble[1] = d0 + d1 * (double)p_70974_2_;
        adouble[2] = this.ringBuffer[i][2] + (this.ringBuffer[j][2] - this.ringBuffer[i][2]) * (double)p_70974_2_;
        return adouble;
    }

    @Override
    public void onLivingUpdate() {
        if (this.worldObj.isRemote) {
            this.setHealth(this.getHealth());
            if (!this.isSilent()) {
                float f = MathHelper.cos(this.animTime * ((float)Math.PI * 2));
                float f1 = MathHelper.cos(this.prevAnimTime * ((float)Math.PI * 2));
                if (f1 <= -0.3f && f >= -0.3f) {
                    this.worldObj.func_184134_a(this.posX, this.posY, this.posZ, SoundEvents.entity_enderdragon_flap, this.getSoundCategory(), 5.0f, 0.8f + this.rand.nextFloat() * 0.3f, false);
                }
                if (!this.phaseManager.func_188756_a().func_188654_a() && --this.field_184678_bK < 0) {
                    this.worldObj.func_184134_a(this.posX, this.posY, this.posZ, SoundEvents.entity_enderdragon_growl, this.getSoundCategory(), 2.5f, 0.8f + this.rand.nextFloat() * 0.3f, false);
                    this.field_184678_bK = 200 + this.rand.nextInt(200);
                }
            }
        }
        this.prevAnimTime = this.animTime;
        if (this.getHealth() <= 0.0f) {
            float f13 = (this.rand.nextFloat() - 0.5f) * 8.0f;
            float f15 = (this.rand.nextFloat() - 0.5f) * 4.0f;
            float f17 = (this.rand.nextFloat() - 0.5f) * 8.0f;
            this.worldObj.spawnParticle(EnumParticleTypes.EXPLOSION_LARGE, this.posX + (double)f13, this.posY + 2.0 + (double)f15, this.posZ + (double)f17, 0.0, 0.0, 0.0, new int[0]);
        } else {
            this.updateDragonEnderCrystal();
            float f12 = 0.2f / (MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ) * 10.0f + 1.0f);
            this.animTime = this.phaseManager.func_188756_a().func_188654_a() ? (this.animTime += 0.1f) : (this.slowed ? (this.animTime += f12 * 0.5f) : (this.animTime += (f12 *= (float)Math.pow(2.0, this.motionY))));
            this.rotationYaw = MathHelper.wrapAngleTo180_float(this.rotationYaw);
            if (this.isAIDisabled()) {
                this.animTime = 0.5f;
            } else {
                if (this.ringBufferIndex < 0) {
                    for (int i = 0; i < this.ringBuffer.length; ++i) {
                        this.ringBuffer[i][0] = this.rotationYaw;
                        this.ringBuffer[i][1] = this.posY;
                    }
                }
                if (++this.ringBufferIndex == this.ringBuffer.length) {
                    this.ringBufferIndex = 0;
                }
                this.ringBuffer[this.ringBufferIndex][0] = this.rotationYaw;
                this.ringBuffer[this.ringBufferIndex][1] = this.posY;
                if (this.worldObj.isRemote) {
                    if (this.newPosRotationIncrements > 0) {
                        double d5 = this.posX + (this.field_184623_bh - this.posX) / (double)this.newPosRotationIncrements;
                        double d0 = this.posY + (this.field_184624_bi - this.posY) / (double)this.newPosRotationIncrements;
                        double d1 = this.posZ + (this.field_184625_bj - this.posZ) / (double)this.newPosRotationIncrements;
                        double d2 = MathHelper.wrapAngleTo180_double(this.field_184626_bk - (double)this.rotationYaw);
                        this.rotationYaw = (float)((double)this.rotationYaw + d2 / (double)this.newPosRotationIncrements);
                        this.rotationPitch = (float)((double)this.rotationPitch + (this.newPosX - (double)this.rotationPitch) / (double)this.newPosRotationIncrements);
                        --this.newPosRotationIncrements;
                        this.setPosition(d5, d0, d1);
                        this.setRotation(this.rotationYaw, this.rotationPitch);
                    }
                    this.phaseManager.func_188756_a().func_188657_b();
                } else {
                    Vec3d vec3d;
                    IPhase iphase = this.phaseManager.func_188756_a();
                    iphase.func_188659_c();
                    if (this.phaseManager.func_188756_a() != iphase) {
                        iphase = this.phaseManager.func_188756_a();
                        iphase.func_188659_c();
                    }
                    if ((vec3d = iphase.func_188650_g()) != null) {
                        double d6 = vec3d.xCoord - this.posX;
                        double d7 = vec3d.yCoord - this.posY;
                        double d8 = vec3d.zCoord - this.posZ;
                        double d3 = d6 * d6 + d7 * d7 + d8 * d8;
                        float f6 = iphase.func_188651_f();
                        d7 = MathHelper.clamp_double(d7 / (double)MathHelper.sqrt_double(d6 * d6 + d8 * d8), -f6, f6);
                        this.motionY += d7 * (double)0.1f;
                        this.rotationYaw = MathHelper.wrapAngleTo180_float(this.rotationYaw);
                        double d4 = MathHelper.clamp_double(MathHelper.wrapAngleTo180_double(180.0 - MathHelper.atan2(d6, d8) * 57.29577951308232 - (double)this.rotationYaw), -50.0, 50.0);
                        Vec3d vec3d1 = new Vec3d(vec3d.xCoord - this.posX, vec3d.yCoord - this.posY, vec3d.zCoord - this.posZ).normalize();
                        Vec3d vec3d2 = new Vec3d(MathHelper.sin(this.rotationYaw * ((float)Math.PI / 180)), this.motionY, -MathHelper.cos(this.rotationYaw * ((float)Math.PI / 180))).normalize();
                        float f8 = Math.max(((float)vec3d2.dotProduct(vec3d1) + 0.5f) / 1.5f, 0.0f);
                        this.randomYawVelocity *= 0.8f;
                        this.randomYawVelocity = (float)((double)this.randomYawVelocity + d4 * (double)iphase.func_188653_h());
                        this.rotationYaw += this.randomYawVelocity * 0.1f;
                        float f9 = (float)(2.0 / (d3 + 1.0));
                        float f10 = 0.06f;
                        this.moveFlying(0.0f, -1.0f, f10 * (f8 * f9 + (1.0f - f9)));
                        if (this.slowed) {
                            this.moveEntity(this.motionX * (double)0.8f, this.motionY * (double)0.8f, this.motionZ * (double)0.8f);
                        } else {
                            this.moveEntity(this.motionX, this.motionY, this.motionZ);
                        }
                        Vec3d vec3d3 = new Vec3d(this.motionX, this.motionY, this.motionZ).normalize();
                        float f11 = ((float)vec3d3.dotProduct(vec3d2) + 1.0f) / 2.0f;
                        f11 = 0.8f + 0.15f * f11;
                        this.motionX *= (double)f11;
                        this.motionZ *= (double)f11;
                        this.motionY *= (double)0.91f;
                    }
                }
                this.renderYawOffset = this.rotationYaw;
                this.dragonPartHead.height = 1.0f;
                this.dragonPartHead.width = 1.0f;
                this.dragonPartNeck.height = 3.0f;
                this.dragonPartNeck.width = 3.0f;
                this.dragonPartTail1.height = 2.0f;
                this.dragonPartTail1.width = 2.0f;
                this.dragonPartTail2.height = 2.0f;
                this.dragonPartTail2.width = 2.0f;
                this.dragonPartTail3.height = 2.0f;
                this.dragonPartTail3.width = 2.0f;
                this.dragonPartBody.height = 3.0f;
                this.dragonPartBody.width = 5.0f;
                this.dragonPartWing1.height = 2.0f;
                this.dragonPartWing1.width = 4.0f;
                this.dragonPartWing2.height = 3.0f;
                this.dragonPartWing2.width = 4.0f;
                float f14 = (float)(this.getMovementOffsets(5, 1.0f)[1] - this.getMovementOffsets(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
                float f16 = MathHelper.cos(f14);
                float f18 = MathHelper.sin(f14);
                float f2 = this.rotationYaw * ((float)Math.PI / 180);
                float f19 = MathHelper.sin(f2);
                float f3 = MathHelper.cos(f2);
                this.dragonPartBody.onUpdate();
                this.dragonPartBody.setLocationAndAngles(this.posX + (double)(f19 * 0.5f), this.posY, this.posZ - (double)(f3 * 0.5f), 0.0f, 0.0f);
                this.dragonPartWing1.onUpdate();
                this.dragonPartWing1.setLocationAndAngles(this.posX + (double)(f3 * 4.5f), this.posY + 2.0, this.posZ + (double)(f19 * 4.5f), 0.0f, 0.0f);
                this.dragonPartWing2.onUpdate();
                this.dragonPartWing2.setLocationAndAngles(this.posX - (double)(f3 * 4.5f), this.posY + 2.0, this.posZ - (double)(f19 * 4.5f), 0.0f, 0.0f);
                if (!this.worldObj.isRemote && this.hurtTime == 0) {
                    this.collideWithEntities(this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.dragonPartWing1.getEntityBoundingBox().expand(4.0, 2.0, 4.0).offset(0.0, -2.0, 0.0)));
                    this.collideWithEntities(this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.dragonPartWing2.getEntityBoundingBox().expand(4.0, 2.0, 4.0).offset(0.0, -2.0, 0.0)));
                    this.attackEntitiesInList(this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.dragonPartHead.getEntityBoundingBox().func_186662_g(1.0)));
                    this.attackEntitiesInList(this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.dragonPartNeck.getEntityBoundingBox().func_186662_g(1.0)));
                }
                double[] adouble = this.getMovementOffsets(5, 1.0f);
                float f4 = MathHelper.sin(this.rotationYaw * ((float)Math.PI / 180) - this.randomYawVelocity * 0.01f);
                float f20 = MathHelper.cos(this.rotationYaw * ((float)Math.PI / 180) - this.randomYawVelocity * 0.01f);
                this.dragonPartHead.onUpdate();
                this.dragonPartNeck.onUpdate();
                float f5 = this.func_184662_q(1.0f);
                this.dragonPartHead.setLocationAndAngles(this.posX + (double)(f4 * 6.5f * f16), this.posY + (double)f5 + (double)(f18 * 6.5f), this.posZ - (double)(f20 * 6.5f * f16), 0.0f, 0.0f);
                this.dragonPartNeck.setLocationAndAngles(this.posX + (double)(f4 * 5.5f * f16), this.posY + (double)f5 + (double)(f18 * 5.5f), this.posZ - (double)(f20 * 5.5f * f16), 0.0f, 0.0f);
                for (int j = 0; j < 3; ++j) {
                    EntityDragonPart entitydragonpart = null;
                    if (j == 0) {
                        entitydragonpart = this.dragonPartTail1;
                    }
                    if (j == 1) {
                        entitydragonpart = this.dragonPartTail2;
                    }
                    if (j == 2) {
                        entitydragonpart = this.dragonPartTail3;
                    }
                    double[] adouble1 = this.getMovementOffsets(12 + j * 2, 1.0f);
                    float f21 = this.rotationYaw * ((float)Math.PI / 180) + this.simplifyAngle(adouble1[0] - adouble[0]) * ((float)Math.PI / 180);
                    float f22 = MathHelper.sin(f21);
                    float f7 = MathHelper.cos(f21);
                    float f23 = 1.5f;
                    float f24 = (float)(j + 1) * 2.0f;
                    entitydragonpart.onUpdate();
                    entitydragonpart.setLocationAndAngles(this.posX - (double)((f19 * f23 + f22 * f24) * f16), this.posY + (adouble1[1] - adouble[1]) - (double)((f24 + f23) * f18) + 1.5, this.posZ + (double)((f3 * f23 + f7 * f24) * f16), 0.0f, 0.0f);
                }
                if (!this.worldObj.isRemote) {
                    this.slowed = this.destroyBlocksInAABB(this.dragonPartHead.getEntityBoundingBox()) | this.destroyBlocksInAABB(this.dragonPartNeck.getEntityBoundingBox()) | this.destroyBlocksInAABB(this.dragonPartBody.getEntityBoundingBox());
                    if (this.fightManager != null) {
                        this.fightManager.func_186099_b(this);
                    }
                }
            }
        }
    }

    private float func_184662_q(float p_184662_1_) {
        double d0 = 0.0;
        if (this.phaseManager.func_188756_a().func_188654_a()) {
            d0 = -1.0;
        } else {
            double[] adouble = this.getMovementOffsets(5, 1.0f);
            double[] adouble1 = this.getMovementOffsets(0, 1.0f);
            d0 = adouble[1] - adouble1[0];
        }
        return (float)d0;
    }

    private void updateDragonEnderCrystal() {
        if (this.healingEnderCrystal != null) {
            if (this.healingEnderCrystal.isDead) {
                this.healingEnderCrystal = null;
            } else if (this.ticksExisted % 10 == 0 && this.getHealth() < this.getMaxHealth()) {
                this.setHealth(this.getHealth() + 1.0f);
            }
        }
        if (this.rand.nextInt(10) == 0) {
            List<EntityEnderCrystal> list = this.worldObj.getEntitiesWithinAABB(EntityEnderCrystal.class, this.getEntityBoundingBox().func_186662_g(32.0));
            EntityEnderCrystal entityendercrystal = null;
            double d0 = Double.MAX_VALUE;
            for (EntityEnderCrystal entityendercrystal1 : list) {
                double d1 = entityendercrystal1.getDistanceSqToEntity(this);
                if (!(d1 < d0)) continue;
                d0 = d1;
                entityendercrystal = entityendercrystal1;
            }
            this.healingEnderCrystal = entityendercrystal;
        }
    }

    private void collideWithEntities(List<Entity> p_70970_1_) {
        double d0 = (this.dragonPartBody.getEntityBoundingBox().minX + this.dragonPartBody.getEntityBoundingBox().maxX) / 2.0;
        double d1 = (this.dragonPartBody.getEntityBoundingBox().minZ + this.dragonPartBody.getEntityBoundingBox().maxZ) / 2.0;
        for (Entity entity : p_70970_1_) {
            if (!(entity instanceof EntityLivingBase)) continue;
            double d2 = entity.posX - d0;
            double d3 = entity.posZ - d1;
            double d4 = d2 * d2 + d3 * d3;
            entity.addVelocity(d2 / d4 * 4.0, 0.2f, d3 / d4 * 4.0);
            if (this.phaseManager.func_188756_a().func_188654_a() || ((EntityLivingBase)entity).getRevengeTimer() >= entity.ticksExisted - 2) continue;
            entity.attackEntityFrom(DamageSource.causeMobDamage(this), 5.0f);
            this.applyEnchantments(this, entity);
        }
    }

    private void attackEntitiesInList(List<Entity> p_70971_1_) {
        for (int i = 0; i < p_70971_1_.size(); ++i) {
            Entity entity = p_70971_1_.get(i);
            if (!(entity instanceof EntityLivingBase)) continue;
            entity.attackEntityFrom(DamageSource.causeMobDamage(this), 10.0f);
            this.applyEnchantments(this, entity);
        }
    }

    private float simplifyAngle(double p_70973_1_) {
        return (float)MathHelper.wrapAngleTo180_double(p_70973_1_);
    }

    private boolean destroyBlocksInAABB(AxisAlignedBB p_70972_1_) {
        int i = MathHelper.floor_double(p_70972_1_.minX);
        int j = MathHelper.floor_double(p_70972_1_.minY);
        int k = MathHelper.floor_double(p_70972_1_.minZ);
        int l = MathHelper.floor_double(p_70972_1_.maxX);
        int i1 = MathHelper.floor_double(p_70972_1_.maxY);
        int j1 = MathHelper.floor_double(p_70972_1_.maxZ);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    IBlockState iblockstate = this.worldObj.getBlockState(blockpos);
                    Block block = iblockstate.getBlock();
                    if (iblockstate.getMaterial() == Material.air || iblockstate.getMaterial() == Material.fire) continue;
                    if (!this.worldObj.getGameRules().getBoolean("mobGriefing")) {
                        flag = true;
                        continue;
                    }
                    if (block != Blocks.barrier && block != Blocks.obsidian && block != Blocks.end_stone && block != Blocks.bedrock && block != Blocks.end_portal && block != Blocks.end_portal_frame) {
                        if (block != Blocks.command_block && block != Blocks.repeating_command_block && block != Blocks.chain_command_block && block != Blocks.iron_bars && block != Blocks.end_gateway) {
                            flag1 = this.worldObj.setBlockToAir(blockpos) || flag1;
                            continue;
                        }
                        flag = true;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            double d0 = p_70972_1_.minX + (p_70972_1_.maxX - p_70972_1_.minX) * (double)this.rand.nextFloat();
            double d1 = p_70972_1_.minY + (p_70972_1_.maxY - p_70972_1_.minY) * (double)this.rand.nextFloat();
            double d2 = p_70972_1_.minZ + (p_70972_1_.maxZ - p_70972_1_.minZ) * (double)this.rand.nextFloat();
            this.worldObj.spawnParticle(EnumParticleTypes.EXPLOSION_LARGE, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
        return flag;
    }

    @Override
    public boolean attackEntityFromPart(EntityDragonPart dragonPart, DamageSource source, float p_70965_3_) {
        p_70965_3_ = this.phaseManager.func_188756_a().func_188656_a(dragonPart, source, p_70965_3_);
        if (dragonPart != this.dragonPartHead) {
            p_70965_3_ = p_70965_3_ / 4.0f + Math.min(p_70965_3_, 1.0f);
        }
        if (p_70965_3_ < 0.01f) {
            return false;
        }
        if (source.getEntity() instanceof EntityPlayer || source.isExplosion()) {
            float f = this.getHealth();
            this.attackDragonFrom(source, p_70965_3_);
            if (this.getHealth() <= 0.0f && !this.phaseManager.func_188756_a().func_188654_a()) {
                this.setHealth(1.0f);
                this.phaseManager.func_188758_a(PhaseList.DYING);
            }
            if (this.phaseManager.func_188756_a().func_188654_a()) {
                this.field_184679_bL = (int)((float)this.field_184679_bL + (f - this.getHealth()));
                if ((float)this.field_184679_bL > 0.25f * this.getMaxHealth()) {
                    this.field_184679_bL = 0;
                    this.phaseManager.func_188758_a(PhaseList.TAKEOFF);
                }
            }
        }
        return true;
    }

    @Override
    public boolean attackEntityFrom(DamageSource source, float amount) {
        if (source instanceof EntityDamageSource && ((EntityDamageSource)source).getIsThornsDamage()) {
            this.attackEntityFromPart(this.dragonPartBody, source, amount);
        }
        return false;
    }

    protected boolean attackDragonFrom(DamageSource source, float amount) {
        return super.attackEntityFrom(source, amount);
    }

    @Override
    public void onKillCommand() {
        this.setDead();
        if (this.fightManager != null) {
            this.fightManager.func_186099_b(this);
            this.fightManager.processDragonDeath(this);
        }
    }

    @Override
    protected void onDeathUpdate() {
        if (this.fightManager != null) {
            this.fightManager.func_186099_b(this);
        }
        ++this.deathTicks;
        if (this.deathTicks >= 180 && this.deathTicks <= 200) {
            float f = (this.rand.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.rand.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.rand.nextFloat() - 0.5f) * 8.0f;
            this.worldObj.spawnParticle(EnumParticleTypes.EXPLOSION_HUGE, this.posX + (double)f, this.posY + 2.0 + (double)f1, this.posZ + (double)f2, 0.0, 0.0, 0.0, new int[0]);
        }
        boolean flag = this.worldObj.getGameRules().getBoolean("doMobLoot");
        int i = 500;
        if (this.fightManager != null && !this.fightManager.func_186102_d()) {
            i = 12000;
        }
        if (!this.worldObj.isRemote) {
            if (this.deathTicks > 150 && this.deathTicks % 5 == 0 && flag) {
                this.func_184668_a(MathHelper.floor_float((float)i * 0.08f));
            }
            if (this.deathTicks == 1) {
                this.worldObj.playBroadcastSound(1028, new BlockPos(this), 0);
            }
        }
        this.moveEntity(0.0, 0.1f, 0.0);
        this.renderYawOffset = this.rotationYaw += 20.0f;
        if (this.deathTicks == 200 && !this.worldObj.isRemote) {
            if (flag) {
                this.func_184668_a(MathHelper.floor_float((float)i * 0.2f));
            }
            if (this.fightManager != null) {
                this.fightManager.processDragonDeath(this);
            }
            this.setDead();
        }
    }

    private void func_184668_a(int p_184668_1_) {
        while (p_184668_1_ > 0) {
            int i = EntityXPOrb.getXPSplit(p_184668_1_);
            p_184668_1_ -= i;
            this.worldObj.spawnEntityInWorld(new EntityXPOrb(this.worldObj, this.posX, this.posY, this.posZ, i));
        }
    }

    public int func_184671_o() {
        if (this.field_184680_bM[0] == null) {
            int i = 0;
            int j = 0;
            int k = 0;
            int l = 0;
            for (int i1 = 0; i1 < 24; ++i1) {
                int j1 = 5;
                if (i1 < 12) {
                    i = (int)(60.0f * MathHelper.cos(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i1)));
                    k = (int)(60.0f * MathHelper.sin(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i1)));
                } else if (i1 < 20) {
                    l = i1 - 12;
                    i = (int)(40.0f * MathHelper.cos(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)l)));
                    k = (int)(40.0f * MathHelper.sin(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)l)));
                    j1 += 10;
                } else {
                    l = i1 - 20;
                    i = (int)(20.0f * MathHelper.cos(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)l)));
                    k = (int)(20.0f * MathHelper.sin(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)l)));
                }
                j = Math.max(this.worldObj.getSeaLevel() + 10, this.worldObj.getTopSolidOrLiquidBlock(new BlockPos(i, 0, k)).getY() + j1);
                this.field_184680_bM[i1] = new PathPoint(i, j, k);
            }
            this.field_184681_bN[0] = 6146;
            this.field_184681_bN[1] = 8197;
            this.field_184681_bN[2] = 8202;
            this.field_184681_bN[3] = 16404;
            this.field_184681_bN[4] = 32808;
            this.field_184681_bN[5] = 32848;
            this.field_184681_bN[6] = 65696;
            this.field_184681_bN[7] = 131392;
            this.field_184681_bN[8] = 131712;
            this.field_184681_bN[9] = 263424;
            this.field_184681_bN[10] = 526848;
            this.field_184681_bN[11] = 525313;
            this.field_184681_bN[12] = 1581057;
            this.field_184681_bN[13] = 3166214;
            this.field_184681_bN[14] = 2138120;
            this.field_184681_bN[15] = 6373424;
            this.field_184681_bN[16] = 4358208;
            this.field_184681_bN[17] = 12910976;
            this.field_184681_bN[18] = 9044480;
            this.field_184681_bN[19] = 9706496;
            this.field_184681_bN[20] = 15216640;
            this.field_184681_bN[21] = 0xD0E000;
            this.field_184681_bN[22] = 11763712;
            this.field_184681_bN[23] = 0x7E0000;
        }
        return this.func_184663_l(this.posX, this.posY, this.posZ);
    }

    public int func_184663_l(double p_184663_1_, double p_184663_3_, double p_184663_5_) {
        float f = 10000.0f;
        int i = 0;
        PathPoint pathpoint = new PathPoint(MathHelper.floor_double(p_184663_1_), MathHelper.floor_double(p_184663_3_), MathHelper.floor_double(p_184663_5_));
        int j = 0;
        if (this.fightManager == null || this.fightManager.func_186092_c() == 0) {
            j = 12;
        }
        for (int k = j; k < 24; ++k) {
            float f1;
            if (this.field_184680_bM[k] == null || !((f1 = this.field_184680_bM[k].distanceToSquared(pathpoint)) < f)) continue;
            f = f1;
            i = k;
        }
        return i;
    }

    public PathEntity func_184666_a(int p_184666_1_, int p_184666_2_, PathPoint p_184666_3_) {
        for (int i = 0; i < 24; ++i) {
            PathPoint pathpoint = this.field_184680_bM[i];
            pathpoint.visited = false;
            pathpoint.distanceToTarget = 0.0f;
            pathpoint.totalPathDistance = 0.0f;
            pathpoint.distanceToNext = 0.0f;
            pathpoint.previous = null;
            pathpoint.index = -1;
        }
        PathPoint pathpoint4 = this.field_184680_bM[p_184666_1_];
        PathPoint pathpoint5 = this.field_184680_bM[p_184666_2_];
        pathpoint4.totalPathDistance = 0.0f;
        pathpoint4.distanceToTarget = pathpoint4.distanceToNext = pathpoint4.distanceTo(pathpoint5);
        this.field_184682_bO.clearPath();
        this.field_184682_bO.addPoint(pathpoint4);
        PathPoint pathpoint1 = pathpoint4;
        int j = 0;
        if (this.fightManager == null || this.fightManager.func_186092_c() == 0) {
            j = 12;
        }
        while (!this.field_184682_bO.isPathEmpty()) {
            PathPoint pathpoint2 = this.field_184682_bO.dequeue();
            if (pathpoint2.equals(pathpoint5)) {
                if (p_184666_3_ != null) {
                    p_184666_3_.previous = pathpoint5;
                    pathpoint5 = p_184666_3_;
                }
                return this.func_184669_a(pathpoint4, pathpoint5);
            }
            if (pathpoint2.distanceTo(pathpoint5) < pathpoint1.distanceTo(pathpoint5)) {
                pathpoint1 = pathpoint2;
            }
            pathpoint2.visited = true;
            int k = 0;
            for (int l = 0; l < 24; ++l) {
                if (this.field_184680_bM[l] != pathpoint2) continue;
                k = l;
                break;
            }
            for (int i1 = j; i1 < 24; ++i1) {
                if ((this.field_184681_bN[k] & 1 << i1) <= 0) continue;
                PathPoint pathpoint3 = this.field_184680_bM[i1];
                if (pathpoint3.visited) continue;
                float f = pathpoint2.totalPathDistance + pathpoint2.distanceTo(pathpoint3);
                if (pathpoint3.isAssigned() && !(f < pathpoint3.totalPathDistance)) continue;
                pathpoint3.previous = pathpoint2;
                pathpoint3.totalPathDistance = f;
                pathpoint3.distanceToNext = pathpoint3.distanceTo(pathpoint5);
                if (pathpoint3.isAssigned()) {
                    this.field_184682_bO.changeDistance(pathpoint3, pathpoint3.totalPathDistance + pathpoint3.distanceToNext);
                    continue;
                }
                pathpoint3.distanceToTarget = pathpoint3.totalPathDistance + pathpoint3.distanceToNext;
                this.field_184682_bO.addPoint(pathpoint3);
            }
        }
        if (pathpoint1 == pathpoint4) {
            return null;
        }
        LOGGER.debug("Failed to find path from {} to {}", new Object[]{p_184666_1_, p_184666_2_});
        if (p_184666_3_ != null) {
            p_184666_3_.previous = pathpoint1;
            pathpoint1 = p_184666_3_;
        }
        return this.func_184669_a(pathpoint4, pathpoint1);
    }

    private PathEntity func_184669_a(PathPoint p_184669_1_, PathPoint p_184669_2_) {
        int i = 1;
        PathPoint pathpoint = p_184669_2_;
        while (pathpoint.previous != null) {
            ++i;
            pathpoint = pathpoint.previous;
        }
        PathPoint[] apathpoint = new PathPoint[i];
        PathPoint pathpoint1 = p_184669_2_;
        apathpoint[--i] = p_184669_2_;
        while (pathpoint1.previous != null) {
            pathpoint1 = pathpoint1.previous;
            apathpoint[--i] = pathpoint1;
        }
        return new PathEntity(apathpoint);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound tagCompound) {
        super.writeEntityToNBT(tagCompound);
        tagCompound.setInteger("DragonPhase", this.phaseManager.func_188756_a().func_188652_i().getId());
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound tagCompund) {
        super.readEntityFromNBT(tagCompund);
        if (tagCompund.hasKey("DragonPhase")) {
            this.phaseManager.func_188758_a(PhaseList.func_188738_a(tagCompund.getInteger("DragonPhase")));
        }
    }

    @Override
    protected void despawnEntity() {
    }

    @Override
    public Entity[] getParts() {
        return this.dragonPartArray;
    }

    @Override
    public boolean canBeCollidedWith() {
        return false;
    }

    @Override
    public World getWorld() {
        return this.worldObj;
    }

    @Override
    public SoundCategory getSoundCategory() {
        return SoundCategory.HOSTILE;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.entity_enderdragon_ambient;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.entity_enderdragon_hurt;
    }

    @Override
    protected float getSoundVolume() {
        return 5.0f;
    }

    public float func_184667_a(int p_184667_1_, double[] p_184667_2_, double[] p_184667_3_) {
        double d0;
        IPhase iphase = this.phaseManager.func_188756_a();
        PhaseList<? extends IPhase> phaselist = iphase.func_188652_i();
        if (phaselist != PhaseList.LANDING && phaselist != PhaseList.TAKEOFF) {
            d0 = iphase.func_188654_a() ? (double)p_184667_1_ : (p_184667_1_ == 6 ? 0.0 : p_184667_3_[1] - p_184667_2_[1]);
        } else {
            BlockPos blockpos = this.worldObj.getTopSolidOrLiquidBlock(WorldGenEndPodium.field_186139_a);
            float f = Math.max(MathHelper.sqrt_double(this.getDistanceSqToCenter(blockpos)) / 4.0f, 1.0f);
            d0 = (float)p_184667_1_ / f;
        }
        return (float)d0;
    }

    public Vec3d func_184665_a(float p_184665_1_) {
        Vec3d vec3d;
        IPhase iphase = this.phaseManager.func_188756_a();
        PhaseList<? extends IPhase> phaselist = iphase.func_188652_i();
        if (phaselist != PhaseList.LANDING && phaselist != PhaseList.TAKEOFF) {
            if (iphase.func_188654_a()) {
                float f4 = this.rotationPitch;
                float f5 = 1.5f;
                this.rotationPitch = -6.0f * f5 * 5.0f;
                vec3d = this.getLook(p_184665_1_);
                this.rotationPitch = f4;
            } else {
                vec3d = this.getLook(p_184665_1_);
            }
        } else {
            BlockPos blockpos = this.worldObj.getTopSolidOrLiquidBlock(WorldGenEndPodium.field_186139_a);
            float f = Math.max(MathHelper.sqrt_double(this.getDistanceSqToCenter(blockpos)) / 4.0f, 1.0f);
            float f1 = 6.0f / f;
            float f2 = this.rotationPitch;
            float f3 = 1.5f;
            this.rotationPitch = -f1 * f3 * 5.0f;
            vec3d = this.getLook(p_184665_1_);
            this.rotationPitch = f2;
        }
        return vec3d;
    }

    public void func_184672_a(EntityEnderCrystal p_184672_1_, BlockPos p_184672_2_, DamageSource p_184672_3_) {
        EntityPlayer entityplayer = p_184672_3_.getEntity() instanceof EntityPlayer ? (EntityPlayer)p_184672_3_.getEntity() : this.worldObj.func_184139_a(p_184672_2_, 64.0, 64.0);
        if (p_184672_1_ == this.healingEnderCrystal) {
            this.attackEntityFromPart(this.dragonPartHead, DamageSource.func_188405_b(entityplayer), 10.0f);
        }
        this.phaseManager.func_188756_a().func_188655_a(p_184672_1_, p_184672_2_, p_184672_3_, entityplayer);
    }

    @Override
    public void notifyDataManagerChange(DataParameter<?> key) {
        if (PHASE.equals(key) && this.worldObj.isRemote) {
            this.phaseManager.func_188758_a(PhaseList.func_188738_a(this.getDataManager().get(PHASE)));
        }
        super.notifyDataManagerChange(key);
    }

    public PhaseManager getPhaseManager() {
        return this.phaseManager;
    }

    public DragonFightManager getFightManager() {
        return this.fightManager;
    }

    @Override
    public void addPotionEffect(PotionEffect potioneffectIn) {
    }

    @Override
    protected boolean canBeRidden(Entity entityIn) {
        return false;
    }

    @Override
    public boolean func_184222_aU() {
        return false;
    }
}

