/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import com.google.common.base.Predicate;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityArmorStand
extends EntityLivingBase {
    private static final Rotations DEFAULT_HEAD_ROTATION = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_BODY_ROTATION = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_LEFTARM_ROTATION = new Rotations(-10.0f, 0.0f, -10.0f);
    private static final Rotations DEFAULT_RIGHTARM_ROTATION = new Rotations(-15.0f, 0.0f, 10.0f);
    private static final Rotations DEFAULT_LEFTLEG_ROTATION = new Rotations(-1.0f, 0.0f, -1.0f);
    private static final Rotations DEFAULT_RIGHTLEG_ROTATION = new Rotations(1.0f, 0.0f, 1.0f);
    public static final DataParameter<Byte> field_184801_a = EntityDataManager.createKey(EntityArmorStand.class, DataSerializers.BYTE);
    public static final DataParameter<Rotations> HEAD_ROTATION = EntityDataManager.createKey(EntityArmorStand.class, DataSerializers.ROTATIONS);
    public static final DataParameter<Rotations> BODY_ROTATION = EntityDataManager.createKey(EntityArmorStand.class, DataSerializers.ROTATIONS);
    public static final DataParameter<Rotations> LEFT_ARM_ROTATION = EntityDataManager.createKey(EntityArmorStand.class, DataSerializers.ROTATIONS);
    public static final DataParameter<Rotations> RIGHT_ARM_ROTATION = EntityDataManager.createKey(EntityArmorStand.class, DataSerializers.ROTATIONS);
    public static final DataParameter<Rotations> LEFT_LEG_ROTATION = EntityDataManager.createKey(EntityArmorStand.class, DataSerializers.ROTATIONS);
    public static final DataParameter<Rotations> RIGHT_LEG_ROTATION = EntityDataManager.createKey(EntityArmorStand.class, DataSerializers.ROTATIONS);
    private static final Predicate<Entity> field_184798_bv = new Predicate<Entity>(){

        public boolean apply(Entity p_apply_1_) {
            return p_apply_1_ instanceof EntityMinecart && ((EntityMinecart)p_apply_1_).func_184264_v() == EntityMinecart.Type.RIDEABLE;
        }
    };
    private final ItemStack[] field_184799_bw = new ItemStack[2];
    private final ItemStack[] field_184800_bx = new ItemStack[4];
    private boolean canInteract;
    public long punchCooldown;
    private int disabledSlots;
    private boolean field_181028_bj;
    private Rotations headRotation = DEFAULT_HEAD_ROTATION;
    private Rotations bodyRotation = DEFAULT_BODY_ROTATION;
    private Rotations leftArmRotation = DEFAULT_LEFTARM_ROTATION;
    private Rotations rightArmRotation = DEFAULT_RIGHTARM_ROTATION;
    private Rotations leftLegRotation = DEFAULT_LEFTLEG_ROTATION;
    private Rotations rightLegRotation = DEFAULT_RIGHTLEG_ROTATION;

    public EntityArmorStand(World worldIn) {
        super(worldIn);
        this.noClip = this.hasNoGravity();
        this.setSize(0.5f, 1.975f);
    }

    public EntityArmorStand(World worldIn, double posX, double posY, double posZ) {
        this(worldIn);
        this.setPosition(posX, posY, posZ);
    }

    @Override
    public boolean isServerWorld() {
        return super.isServerWorld() && !this.hasNoGravity();
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.register(field_184801_a, (byte)0);
        this.dataWatcher.register(HEAD_ROTATION, DEFAULT_HEAD_ROTATION);
        this.dataWatcher.register(BODY_ROTATION, DEFAULT_BODY_ROTATION);
        this.dataWatcher.register(LEFT_ARM_ROTATION, DEFAULT_LEFTARM_ROTATION);
        this.dataWatcher.register(RIGHT_ARM_ROTATION, DEFAULT_RIGHTARM_ROTATION);
        this.dataWatcher.register(LEFT_LEG_ROTATION, DEFAULT_LEFTLEG_ROTATION);
        this.dataWatcher.register(RIGHT_LEG_ROTATION, DEFAULT_RIGHTLEG_ROTATION);
    }

    @Override
    public Iterable<ItemStack> getHeldEquipment() {
        return Arrays.asList(this.field_184799_bw);
    }

    @Override
    public Iterable<ItemStack> getArmorInventoryList() {
        return Arrays.asList(this.field_184800_bx);
    }

    @Override
    public ItemStack getItemStackFromSlot(EntityEquipmentSlot slotIn) {
        ItemStack itemstack = null;
        switch (slotIn.func_188453_a()) {
            case HAND: {
                itemstack = this.field_184799_bw[slotIn.func_188454_b()];
                break;
            }
            case ARMOR: {
                itemstack = this.field_184800_bx[slotIn.func_188454_b()];
            }
        }
        return itemstack;
    }

    @Override
    public void setItemStackToSlot(EntityEquipmentSlot slotIn, ItemStack stack) {
        switch (slotIn.func_188453_a()) {
            case HAND: {
                this.func_184606_a_(stack);
                this.field_184799_bw[slotIn.func_188454_b()] = stack;
                break;
            }
            case ARMOR: {
                this.func_184606_a_(stack);
                this.field_184800_bx[slotIn.func_188454_b()] = stack;
            }
        }
    }

    @Override
    public boolean replaceItemInInventory(int inventorySlot, ItemStack itemStackIn) {
        EntityEquipmentSlot entityequipmentslot;
        if (inventorySlot == 98) {
            entityequipmentslot = EntityEquipmentSlot.MAINHAND;
        } else if (inventorySlot == 99) {
            entityequipmentslot = EntityEquipmentSlot.OFFHAND;
        } else if (inventorySlot == 100 + EntityEquipmentSlot.HEAD.func_188454_b()) {
            entityequipmentslot = EntityEquipmentSlot.HEAD;
        } else if (inventorySlot == 100 + EntityEquipmentSlot.CHEST.func_188454_b()) {
            entityequipmentslot = EntityEquipmentSlot.CHEST;
        } else if (inventorySlot == 100 + EntityEquipmentSlot.LEGS.func_188454_b()) {
            entityequipmentslot = EntityEquipmentSlot.LEGS;
        } else {
            if (inventorySlot != 100 + EntityEquipmentSlot.FEET.func_188454_b()) {
                return false;
            }
            entityequipmentslot = EntityEquipmentSlot.FEET;
        }
        if (itemStackIn != null && !EntityLiving.func_184648_b(entityequipmentslot, itemStackIn) && entityequipmentslot != EntityEquipmentSlot.HEAD) {
            return false;
        }
        this.setItemStackToSlot(entityequipmentslot, itemStackIn);
        return true;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound tagCompound) {
        super.writeEntityToNBT(tagCompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.field_184800_bx.length; ++i) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            if (this.field_184800_bx[i] != null) {
                this.field_184800_bx[i].writeToNBT(nbttagcompound);
            }
            nbttaglist.appendTag(nbttagcompound);
        }
        tagCompound.setTag("ArmorItems", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (int j = 0; j < this.field_184799_bw.length; ++j) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            if (this.field_184799_bw[j] != null) {
                this.field_184799_bw[j].writeToNBT(nbttagcompound1);
            }
            nbttaglist1.appendTag(nbttagcompound1);
        }
        tagCompound.setTag("HandItems", nbttaglist1);
        if (this.getAlwaysRenderNameTag() && (this.getCustomNameTag() == null || this.getCustomNameTag().isEmpty())) {
            tagCompound.setBoolean("CustomNameVisible", this.getAlwaysRenderNameTag());
        }
        tagCompound.setBoolean("Invisible", this.isInvisible());
        tagCompound.setBoolean("Small", this.isSmall());
        tagCompound.setBoolean("ShowArms", this.getShowArms());
        tagCompound.setInteger("DisabledSlots", this.disabledSlots);
        tagCompound.setBoolean("NoGravity", this.hasNoGravity());
        tagCompound.setBoolean("NoBasePlate", this.hasNoBasePlate());
        if (this.hasMarker()) {
            tagCompound.setBoolean("Marker", this.hasMarker());
        }
        tagCompound.setTag("Pose", this.readPoseFromNBT());
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound tagCompund) {
        super.readEntityFromNBT(tagCompund);
        if (tagCompund.hasKey("ArmorItems", 9)) {
            NBTTagList nbttaglist = tagCompund.getTagList("ArmorItems", 10);
            for (int i = 0; i < this.field_184800_bx.length; ++i) {
                this.field_184800_bx[i] = ItemStack.loadItemStackFromNBT(nbttaglist.getCompoundTagAt(i));
            }
        }
        if (tagCompund.hasKey("HandItems", 9)) {
            NBTTagList nbttaglist1 = tagCompund.getTagList("HandItems", 10);
            for (int j = 0; j < this.field_184799_bw.length; ++j) {
                this.field_184799_bw[j] = ItemStack.loadItemStackFromNBT(nbttaglist1.getCompoundTagAt(j));
            }
        }
        this.setInvisible(tagCompund.getBoolean("Invisible"));
        this.setSmall(tagCompund.getBoolean("Small"));
        this.setShowArms(tagCompund.getBoolean("ShowArms"));
        this.disabledSlots = tagCompund.getInteger("DisabledSlots");
        this.setNoGravity(tagCompund.getBoolean("NoGravity"));
        this.setNoBasePlate(tagCompund.getBoolean("NoBasePlate"));
        this.setMarker(tagCompund.getBoolean("Marker"));
        this.field_181028_bj = !this.hasMarker();
        this.noClip = this.hasNoGravity();
        NBTTagCompound nbttagcompound = tagCompund.getCompoundTag("Pose");
        this.writePoseToNBT(nbttagcompound);
    }

    private void writePoseToNBT(NBTTagCompound tagCompound) {
        NBTTagList nbttaglist = tagCompound.getTagList("Head", 5);
        this.setHeadRotation(nbttaglist.hasNoTags() ? DEFAULT_HEAD_ROTATION : new Rotations(nbttaglist));
        NBTTagList nbttaglist1 = tagCompound.getTagList("Body", 5);
        this.setBodyRotation(nbttaglist1.hasNoTags() ? DEFAULT_BODY_ROTATION : new Rotations(nbttaglist1));
        NBTTagList nbttaglist2 = tagCompound.getTagList("LeftArm", 5);
        this.setLeftArmRotation(nbttaglist2.hasNoTags() ? DEFAULT_LEFTARM_ROTATION : new Rotations(nbttaglist2));
        NBTTagList nbttaglist3 = tagCompound.getTagList("RightArm", 5);
        this.setRightArmRotation(nbttaglist3.hasNoTags() ? DEFAULT_RIGHTARM_ROTATION : new Rotations(nbttaglist3));
        NBTTagList nbttaglist4 = tagCompound.getTagList("LeftLeg", 5);
        this.setLeftLegRotation(nbttaglist4.hasNoTags() ? DEFAULT_LEFTLEG_ROTATION : new Rotations(nbttaglist4));
        NBTTagList nbttaglist5 = tagCompound.getTagList("RightLeg", 5);
        this.setRightLegRotation(nbttaglist5.hasNoTags() ? DEFAULT_RIGHTLEG_ROTATION : new Rotations(nbttaglist5));
    }

    private NBTTagCompound readPoseFromNBT() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (!DEFAULT_HEAD_ROTATION.equals(this.headRotation)) {
            nbttagcompound.setTag("Head", this.headRotation.writeToNBT());
        }
        if (!DEFAULT_BODY_ROTATION.equals(this.bodyRotation)) {
            nbttagcompound.setTag("Body", this.bodyRotation.writeToNBT());
        }
        if (!DEFAULT_LEFTARM_ROTATION.equals(this.leftArmRotation)) {
            nbttagcompound.setTag("LeftArm", this.leftArmRotation.writeToNBT());
        }
        if (!DEFAULT_RIGHTARM_ROTATION.equals(this.rightArmRotation)) {
            nbttagcompound.setTag("RightArm", this.rightArmRotation.writeToNBT());
        }
        if (!DEFAULT_LEFTLEG_ROTATION.equals(this.leftLegRotation)) {
            nbttagcompound.setTag("LeftLeg", this.leftLegRotation.writeToNBT());
        }
        if (!DEFAULT_RIGHTLEG_ROTATION.equals(this.rightLegRotation)) {
            nbttagcompound.setTag("RightLeg", this.rightLegRotation.writeToNBT());
        }
        return nbttagcompound;
    }

    @Override
    public boolean canBePushed() {
        return false;
    }

    @Override
    protected void collideWithEntity(Entity entityIn) {
    }

    @Override
    protected void collideWithNearbyEntities() {
        List<Entity> list = this.worldObj.getEntitiesInAABBexcluding(this, this.getEntityBoundingBox(), field_184798_bv);
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = list.get(i);
            if (!(this.getDistanceSqToEntity(entity) <= 0.2)) continue;
            entity.applyEntityCollision(this);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, ItemStack stack, EnumHand hand) {
        block12: {
            block14: {
                block15: {
                    block13: {
                        if (this.hasMarker()) {
                            return EnumActionResult.PASS;
                        }
                        if (this.worldObj.isRemote || player.isSpectator()) break block12;
                        entityequipmentslot = EntityEquipmentSlot.MAINHAND;
                        flag = stack != null;
                        v0 = item = flag != false ? stack.getItem() : null;
                        if (flag && item instanceof ItemArmor) {
                            entityequipmentslot = ((ItemArmor)item).armorType;
                        }
                        if (flag && (item == Items.skull || item == Item.getItemFromBlock(Blocks.pumpkin))) {
                            entityequipmentslot = EntityEquipmentSlot.HEAD;
                        }
                        d0 = 0.1;
                        d1 = 0.9;
                        d2 = 0.4;
                        d3 = 1.6;
                        entityequipmentslot1 = EntityEquipmentSlot.MAINHAND;
                        flag1 = this.isSmall();
                        v1 = d4 = flag1 != false ? vec.yCoord * 2.0 : vec.yCoord;
                        if (!(d4 >= 0.1)) break block13;
                        v2 = flag1 != false ? 0.8 : 0.45;
                        if (!(d4 < 0.1 + v2) || this.getItemStackFromSlot(EntityEquipmentSlot.FEET) == null) break block13;
                        entityequipmentslot1 = EntityEquipmentSlot.FEET;
                        break block14;
                    }
                    v3 = flag1 != false ? 0.3 : 0.0;
                    if (!(d4 >= 0.9 + v3)) break block15;
                    v4 = flag1 != false ? 1.0 : 0.7;
                    if (!(d4 < 0.9 + v4) || this.getItemStackFromSlot(EntityEquipmentSlot.CHEST) == null) break block15;
                    entityequipmentslot1 = EntityEquipmentSlot.CHEST;
                    break block14;
                }
                if (!(d4 >= 0.4)) ** GOTO lbl-1000
                v5 = flag1 != false ? 1.0 : 0.8;
                if (d4 < 0.4 + v5 && this.getItemStackFromSlot(EntityEquipmentSlot.LEGS) != null) {
                    entityequipmentslot1 = EntityEquipmentSlot.LEGS;
                } else if (d4 >= 1.6 && this.getItemStackFromSlot(EntityEquipmentSlot.HEAD) != null) {
                    entityequipmentslot1 = EntityEquipmentSlot.HEAD;
                }
            }
            v6 = flag2 = this.getItemStackFromSlot(entityequipmentslot1) != null;
            if (this.func_184796_b(entityequipmentslot1) || this.func_184796_b(entityequipmentslot)) {
                entityequipmentslot1 = entityequipmentslot;
                if (this.func_184796_b(entityequipmentslot)) {
                    return EnumActionResult.FAIL;
                }
            }
            if (flag && entityequipmentslot == EntityEquipmentSlot.MAINHAND && !this.getShowArms()) {
                return EnumActionResult.FAIL;
            }
            if (flag) {
                this.func_184795_a(player, entityequipmentslot, stack, hand);
            } else if (flag2) {
                this.func_184795_a(player, entityequipmentslot1, stack, hand);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.SUCCESS;
    }

    private boolean func_184796_b(EntityEquipmentSlot p_184796_1_) {
        return (this.disabledSlots & 1 << p_184796_1_.func_188452_c()) != 0;
    }

    private void func_184795_a(EntityPlayer p_184795_1_, EntityEquipmentSlot p_184795_2_, ItemStack p_184795_3_, EnumHand p_184795_4_) {
        ItemStack itemstack = this.getItemStackFromSlot(p_184795_2_);
        if (!(itemstack != null && (this.disabledSlots & 1 << p_184795_2_.func_188452_c() + 8) != 0 || itemstack == null && (this.disabledSlots & 1 << p_184795_2_.func_188452_c() + 16) != 0)) {
            if (p_184795_1_.capabilities.isCreativeMode && (itemstack == null || itemstack.getItem() == Item.getItemFromBlock(Blocks.air)) && p_184795_3_ != null) {
                ItemStack itemstack2 = p_184795_3_.copy();
                itemstack2.stackSize = 1;
                this.setItemStackToSlot(p_184795_2_, itemstack2);
            } else if (p_184795_3_ != null && p_184795_3_.stackSize > 1) {
                if (itemstack == null) {
                    ItemStack itemstack1 = p_184795_3_.copy();
                    itemstack1.stackSize = 1;
                    this.setItemStackToSlot(p_184795_2_, itemstack1);
                    --p_184795_3_.stackSize;
                }
            } else {
                this.setItemStackToSlot(p_184795_2_, p_184795_3_);
                p_184795_1_.setHeldItem(p_184795_4_, itemstack);
            }
        }
    }

    @Override
    public boolean attackEntityFrom(DamageSource source, float amount) {
        if (!this.worldObj.isRemote && !this.isDead) {
            if (DamageSource.outOfWorld.equals(source)) {
                this.setDead();
                return false;
            }
            if (!(this.isEntityInvulnerable(source) || this.canInteract || this.hasMarker())) {
                if (source.isExplosion()) {
                    this.dropContents();
                    this.setDead();
                    return false;
                }
                if (DamageSource.inFire.equals(source)) {
                    if (this.isBurning()) {
                        this.damageArmorStand(0.15f);
                    } else {
                        this.setFire(5);
                    }
                    return false;
                }
                if (DamageSource.onFire.equals(source) && this.getHealth() > 0.5f) {
                    this.damageArmorStand(4.0f);
                    return false;
                }
                boolean flag = "arrow".equals(source.getDamageType());
                boolean flag1 = "player".equals(source.getDamageType());
                if (!flag1 && !flag) {
                    return false;
                }
                if (source.getSourceOfDamage() instanceof EntityArrow) {
                    source.getSourceOfDamage().setDead();
                }
                if (source.getEntity() instanceof EntityPlayer && !((EntityPlayer)source.getEntity()).capabilities.allowEdit) {
                    return false;
                }
                if (source.isCreativePlayer()) {
                    this.playParticles();
                    this.setDead();
                    return false;
                }
                long i = this.worldObj.getTotalWorldTime();
                if (i - this.punchCooldown > 5L && !flag) {
                    this.worldObj.setEntityState(this, (byte)32);
                    this.punchCooldown = i;
                } else {
                    this.dropBlock();
                    this.playParticles();
                    this.setDead();
                }
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public void handleStatusUpdate(byte id) {
        if (id == 32) {
            if (this.worldObj.isRemote) {
                this.worldObj.func_184134_a(this.posX, this.posY, this.posZ, SoundEvents.entity_armorstand_hit, this.getSoundCategory(), 0.3f, 1.0f, false);
                this.punchCooldown = this.worldObj.getTotalWorldTime();
            }
        } else {
            super.handleStatusUpdate(id);
        }
    }

    @Override
    public boolean isInRangeToRenderDist(double distance) {
        double d0 = this.getEntityBoundingBox().getAverageEdgeLength() * 4.0;
        if (Double.isNaN(d0) || d0 == 0.0) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    private void playParticles() {
        if (this.worldObj instanceof WorldServer) {
            ((WorldServer)this.worldObj).spawnParticle(EnumParticleTypes.BLOCK_DUST, this.posX, this.posY + (double)this.height / 1.5, this.posZ, 10, (double)(this.width / 4.0f), (double)(this.height / 4.0f), (double)(this.width / 4.0f), 0.05, Block.getStateId(Blocks.planks.getDefaultState()));
        }
    }

    private void damageArmorStand(float p_175406_1_) {
        float f = this.getHealth();
        if ((f -= p_175406_1_) <= 0.5f) {
            this.dropContents();
            this.setDead();
        } else {
            this.setHealth(f);
        }
    }

    private void dropBlock() {
        Block.spawnAsEntity(this.worldObj, new BlockPos(this), new ItemStack(Items.armor_stand));
        this.dropContents();
    }

    private void dropContents() {
        this.worldObj.func_184148_a(null, this.posX, this.posY, this.posZ, SoundEvents.entity_armorstand_break, this.getSoundCategory(), 1.0f, 1.0f);
        for (int i = 0; i < this.field_184799_bw.length; ++i) {
            if (this.field_184799_bw[i] == null || this.field_184799_bw[i].stackSize <= 0) continue;
            if (this.field_184799_bw[i] != null) {
                Block.spawnAsEntity(this.worldObj, new BlockPos(this).up(), this.field_184799_bw[i]);
            }
            this.field_184799_bw[i] = null;
        }
        for (int j = 0; j < this.field_184800_bx.length; ++j) {
            if (this.field_184800_bx[j] == null || this.field_184800_bx[j].stackSize <= 0) continue;
            if (this.field_184800_bx[j] != null) {
                Block.spawnAsEntity(this.worldObj, new BlockPos(this).up(), this.field_184800_bx[j]);
            }
            this.field_184800_bx[j] = null;
        }
    }

    @Override
    protected float updateDistance(float p_110146_1_, float p_110146_2_) {
        this.prevRenderYawOffset = this.prevRotationYaw;
        this.renderYawOffset = this.rotationYaw;
        return 0.0f;
    }

    @Override
    public float getEyeHeight() {
        return this.isChild() ? this.height * 0.5f : this.height * 0.9f;
    }

    @Override
    public double getYOffset() {
        return this.hasMarker() ? 0.0 : (double)0.1f;
    }

    @Override
    public void moveEntityWithHeading(float strafe, float forward) {
        if (!this.hasNoGravity()) {
            super.moveEntityWithHeading(strafe, forward);
        }
    }

    @Override
    public void onUpdate() {
        Rotations rotations5;
        Rotations rotations4;
        Rotations rotations3;
        Rotations rotations2;
        Rotations rotations1;
        super.onUpdate();
        Rotations rotations = this.dataWatcher.get(HEAD_ROTATION);
        if (!this.headRotation.equals(rotations)) {
            this.setHeadRotation(rotations);
        }
        if (!this.bodyRotation.equals(rotations1 = this.dataWatcher.get(BODY_ROTATION))) {
            this.setBodyRotation(rotations1);
        }
        if (!this.leftArmRotation.equals(rotations2 = this.dataWatcher.get(LEFT_ARM_ROTATION))) {
            this.setLeftArmRotation(rotations2);
        }
        if (!this.rightArmRotation.equals(rotations3 = this.dataWatcher.get(RIGHT_ARM_ROTATION))) {
            this.setRightArmRotation(rotations3);
        }
        if (!this.leftLegRotation.equals(rotations4 = this.dataWatcher.get(LEFT_LEG_ROTATION))) {
            this.setLeftLegRotation(rotations4);
        }
        if (!this.rightLegRotation.equals(rotations5 = this.dataWatcher.get(RIGHT_LEG_ROTATION))) {
            this.setRightLegRotation(rotations5);
        }
        boolean flag = this.hasMarker();
        if (!this.field_181028_bj && flag) {
            this.func_181550_a(false);
            this.preventEntitySpawning = false;
        } else {
            if (!this.field_181028_bj || flag) {
                return;
            }
            this.func_181550_a(true);
            this.preventEntitySpawning = true;
        }
        this.field_181028_bj = flag;
    }

    private void func_181550_a(boolean p_181550_1_) {
        double d0 = this.posX;
        double d1 = this.posY;
        double d2 = this.posZ;
        if (p_181550_1_) {
            this.setSize(0.5f, 1.975f);
        } else {
            this.setSize(0.0f, 0.0f);
        }
        this.setPosition(d0, d1, d2);
    }

    @Override
    protected void updatePotionMetadata() {
        this.setInvisible(this.canInteract);
    }

    @Override
    public void setInvisible(boolean invisible) {
        this.canInteract = invisible;
        super.setInvisible(invisible);
    }

    @Override
    public boolean isChild() {
        return this.isSmall();
    }

    @Override
    public void onKillCommand() {
        this.setDead();
    }

    @Override
    public boolean isImmuneToExplosions() {
        return this.isInvisible();
    }

    private void setSmall(boolean p_175420_1_) {
        this.dataWatcher.set(field_184801_a, this.func_184797_a(this.dataWatcher.get(field_184801_a), 1, p_175420_1_));
    }

    public boolean isSmall() {
        return (this.dataWatcher.get(field_184801_a) & 1) != 0;
    }

    private void setNoGravity(boolean p_175425_1_) {
        this.dataWatcher.set(field_184801_a, this.func_184797_a(this.dataWatcher.get(field_184801_a), 2, p_175425_1_));
    }

    public boolean hasNoGravity() {
        return (this.dataWatcher.get(field_184801_a) & 2) != 0;
    }

    private void setShowArms(boolean p_175413_1_) {
        this.dataWatcher.set(field_184801_a, this.func_184797_a(this.dataWatcher.get(field_184801_a), 4, p_175413_1_));
    }

    public boolean getShowArms() {
        return (this.dataWatcher.get(field_184801_a) & 4) != 0;
    }

    private void setNoBasePlate(boolean p_175426_1_) {
        this.dataWatcher.set(field_184801_a, this.func_184797_a(this.dataWatcher.get(field_184801_a), 8, p_175426_1_));
    }

    public boolean hasNoBasePlate() {
        return (this.dataWatcher.get(field_184801_a) & 8) != 0;
    }

    private void setMarker(boolean p_181027_1_) {
        this.dataWatcher.set(field_184801_a, this.func_184797_a(this.dataWatcher.get(field_184801_a), 16, p_181027_1_));
    }

    public boolean hasMarker() {
        return (this.dataWatcher.get(field_184801_a) & 0x10) != 0;
    }

    private byte func_184797_a(byte p_184797_1_, int p_184797_2_, boolean p_184797_3_) {
        p_184797_1_ = p_184797_3_ ? (byte)(p_184797_1_ | p_184797_2_) : (byte)(p_184797_1_ & ~p_184797_2_);
        return p_184797_1_;
    }

    public void setHeadRotation(Rotations p_175415_1_) {
        this.headRotation = p_175415_1_;
        this.dataWatcher.set(HEAD_ROTATION, p_175415_1_);
    }

    public void setBodyRotation(Rotations p_175424_1_) {
        this.bodyRotation = p_175424_1_;
        this.dataWatcher.set(BODY_ROTATION, p_175424_1_);
    }

    public void setLeftArmRotation(Rotations p_175405_1_) {
        this.leftArmRotation = p_175405_1_;
        this.dataWatcher.set(LEFT_ARM_ROTATION, p_175405_1_);
    }

    public void setRightArmRotation(Rotations p_175428_1_) {
        this.rightArmRotation = p_175428_1_;
        this.dataWatcher.set(RIGHT_ARM_ROTATION, p_175428_1_);
    }

    public void setLeftLegRotation(Rotations p_175417_1_) {
        this.leftLegRotation = p_175417_1_;
        this.dataWatcher.set(LEFT_LEG_ROTATION, p_175417_1_);
    }

    public void setRightLegRotation(Rotations p_175427_1_) {
        this.rightLegRotation = p_175427_1_;
        this.dataWatcher.set(RIGHT_LEG_ROTATION, p_175427_1_);
    }

    public Rotations getHeadRotation() {
        return this.headRotation;
    }

    public Rotations getBodyRotation() {
        return this.bodyRotation;
    }

    public Rotations getLeftArmRotation() {
        return this.leftArmRotation;
    }

    public Rotations getRightArmRotation() {
        return this.rightArmRotation;
    }

    public Rotations getLeftLegRotation() {
        return this.leftLegRotation;
    }

    public Rotations getRightLegRotation() {
        return this.rightLegRotation;
    }

    @Override
    public boolean canBeCollidedWith() {
        return super.canBeCollidedWith() && !this.hasMarker();
    }

    @Override
    public EnumHandSide getPrimaryHand() {
        return EnumHandSide.RIGHT;
    }

    @Override
    protected SoundEvent getFallSound(int heightIn) {
        return SoundEvents.entity_armorstand_fall;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.entity_armorstand_hit;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.entity_armorstand_break;
    }

    @Override
    public void onStruckByLightning(EntityLightningBolt lightningBolt) {
    }

    @Override
    public boolean func_184603_cC() {
        return false;
    }
}

