/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.CommandBlockBaseLogic;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class EntityMinecartCommandBlock
extends EntityMinecart {
    private static final DataParameter<String> field_184273_a = EntityDataManager.createKey(EntityMinecartCommandBlock.class, DataSerializers.STRING);
    private static final DataParameter<ITextComponent> field_184274_b = EntityDataManager.createKey(EntityMinecartCommandBlock.class, DataSerializers.TEXT_COMPONENT);
    private final CommandBlockBaseLogic commandBlockLogic = new CommandBlockBaseLogic(){

        @Override
        public void updateCommand() {
            EntityMinecartCommandBlock.this.getDataManager().set(field_184273_a, this.getCommand());
            EntityMinecartCommandBlock.this.getDataManager().set(field_184274_b, this.getLastOutput());
        }

        @Override
        public int func_145751_f() {
            return 1;
        }

        @Override
        public void func_145757_a(ByteBuf p_145757_1_) {
            p_145757_1_.writeInt(EntityMinecartCommandBlock.this.getEntityId());
        }

        @Override
        public BlockPos getPosition() {
            return new BlockPos(EntityMinecartCommandBlock.this.posX, EntityMinecartCommandBlock.this.posY + 0.5, EntityMinecartCommandBlock.this.posZ);
        }

        @Override
        public Vec3d getPositionVector() {
            return new Vec3d(EntityMinecartCommandBlock.this.posX, EntityMinecartCommandBlock.this.posY, EntityMinecartCommandBlock.this.posZ);
        }

        @Override
        public World getEntityWorld() {
            return EntityMinecartCommandBlock.this.worldObj;
        }

        @Override
        public Entity getCommandSenderEntity() {
            return EntityMinecartCommandBlock.this;
        }

        @Override
        public MinecraftServer getServer() {
            return EntityMinecartCommandBlock.this.worldObj.getMinecraftServer();
        }
    };
    private int activatorRailCooldown = 0;

    public EntityMinecartCommandBlock(World p_i46754_1_) {
        super(p_i46754_1_);
    }

    public EntityMinecartCommandBlock(World p_i46755_1_, double p_i46755_2_, double p_i46755_4_, double p_i46755_6_) {
        super(p_i46755_1_, p_i46755_2_, p_i46755_4_, p_i46755_6_);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.getDataManager().register(field_184273_a, "");
        this.getDataManager().register(field_184274_b, new TextComponentString(""));
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound tagCompund) {
        super.readEntityFromNBT(tagCompund);
        this.commandBlockLogic.readDataFromNBT(tagCompund);
        this.getDataManager().set(field_184273_a, this.getCommandBlockLogic().getCommand());
        this.getDataManager().set(field_184274_b, this.getCommandBlockLogic().getLastOutput());
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound tagCompound) {
        super.writeEntityToNBT(tagCompound);
        this.commandBlockLogic.writeDataToNBT(tagCompound);
    }

    @Override
    public EntityMinecart.Type func_184264_v() {
        return EntityMinecart.Type.COMMAND_BLOCK;
    }

    @Override
    public IBlockState getDefaultDisplayTile() {
        return Blocks.command_block.getDefaultState();
    }

    public CommandBlockBaseLogic getCommandBlockLogic() {
        return this.commandBlockLogic;
    }

    @Override
    public void onActivatorRailPass(int x, int y, int z, boolean receivingPower) {
        if (receivingPower && this.ticksExisted - this.activatorRailCooldown >= 4) {
            this.getCommandBlockLogic().trigger(this.worldObj);
            this.activatorRailCooldown = this.ticksExisted;
        }
    }

    @Override
    public boolean func_184230_a(EntityPlayer p_184230_1_, ItemStack p_184230_2_, EnumHand p_184230_3_) {
        this.commandBlockLogic.tryOpenEditCommandBlock(p_184230_1_);
        return false;
    }

    @Override
    public void notifyDataManagerChange(DataParameter<?> key) {
        super.notifyDataManagerChange(key);
        if (field_184274_b.equals(key)) {
            try {
                this.commandBlockLogic.setLastOutput(this.getDataManager().get(field_184274_b));
            }
            catch (Throwable throwable) {}
        } else if (field_184273_a.equals(key)) {
            this.commandBlockLogic.setCommand(this.getDataManager().get(field_184273_a));
        }
    }

    @Override
    public boolean func_184213_bq() {
        return true;
    }
}

