/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.List;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityWitch
extends EntityMob
implements IRangedAttackMob {
    private static final UUID MODIFIER_UUID = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    private static final AttributeModifier MODIFIER = new AttributeModifier(MODIFIER_UUID, "Drinking speed penalty", -0.25, 0).setSaved(false);
    private static final DataParameter<Boolean> IS_AGGRESSIVE = EntityDataManager.createKey(EntityWitch.class, DataSerializers.BOOLEAN);
    private int witchAttackTimer;

    public EntityWitch(World worldIn) {
        super(worldIn);
        this.setSize(0.6f, 1.95f);
    }

    @Override
    protected void initEntityAI() {
        this.tasks.addTask(1, new EntityAISwimming(this));
        this.tasks.addTask(2, new EntityAIAttackRanged(this, 1.0, 60, 10.0f));
        this.tasks.addTask(2, new EntityAIWander(this, 1.0));
        this.tasks.addTask(3, new EntityAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(3, new EntityAILookIdle(this));
        this.targetTasks.addTask(1, new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.targetTasks.addTask(2, new EntityAINearestAttackableTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class, true));
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.getDataManager().register(IS_AGGRESSIVE, false);
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.entity_witch_ambient;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.entity_witch_hurt;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.entity_witch_death;
    }

    public void setAggressive(boolean aggressive) {
        this.getDataManager().set(IS_AGGRESSIVE, aggressive);
    }

    public boolean func_184730_o() {
        return this.getDataManager().get(IS_AGGRESSIVE);
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(26.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.25);
    }

    @Override
    public void onLivingUpdate() {
        if (!this.worldObj.isRemote) {
            if (this.func_184730_o()) {
                if (this.witchAttackTimer-- <= 0) {
                    List<PotionEffect> list;
                    this.setAggressive(false);
                    ItemStack itemstack = this.getHeldItemMainhand();
                    this.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, null);
                    if (itemstack != null && itemstack.getItem() == Items.potionitem && (list = PotionUtils.getEffectsFromStack(itemstack)) != null) {
                        for (PotionEffect potioneffect : list) {
                            this.addPotionEffect(new PotionEffect(potioneffect));
                        }
                    }
                    this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).removeModifier(MODIFIER);
                }
            } else {
                PotionType potiontype = null;
                if (this.rand.nextFloat() < 0.15f && this.isInsideOfMaterial(Material.water) && !this.isPotionActive(MobEffects.waterBreathing)) {
                    potiontype = PotionTypes.water_breathing;
                } else if (this.rand.nextFloat() < 0.15f && this.isBurning() && !this.isPotionActive(MobEffects.fireResistance)) {
                    potiontype = PotionTypes.fire_resistance;
                } else if (this.rand.nextFloat() < 0.05f && this.getHealth() < this.getMaxHealth()) {
                    potiontype = PotionTypes.healing;
                } else if (this.rand.nextFloat() < 0.5f && this.getAttackTarget() != null && !this.isPotionActive(MobEffects.moveSpeed) && this.getAttackTarget().getDistanceSqToEntity(this) > 121.0) {
                    potiontype = PotionTypes.swiftness;
                }
                if (potiontype != null) {
                    this.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, PotionUtils.func_185188_a(new ItemStack(Items.potionitem), potiontype));
                    this.witchAttackTimer = this.getHeldItemMainhand().getMaxItemUseDuration();
                    this.setAggressive(true);
                    this.worldObj.func_184148_a(null, this.posX, this.posY, this.posZ, SoundEvents.entity_witch_drink, this.getSoundCategory(), 1.0f, 0.8f + this.rand.nextFloat() * 0.4f);
                    IAttributeInstance iattributeinstance = this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED);
                    iattributeinstance.removeModifier(MODIFIER);
                    iattributeinstance.applyModifier(MODIFIER);
                }
            }
            if (this.rand.nextFloat() < 7.5E-4f) {
                this.worldObj.setEntityState(this, (byte)15);
            }
        }
        super.onLivingUpdate();
    }

    @Override
    public void handleStatusUpdate(byte id) {
        if (id == 15) {
            for (int i = 0; i < this.rand.nextInt(35) + 10; ++i) {
                this.worldObj.spawnParticle(EnumParticleTypes.SPELL_WITCH, this.posX + this.rand.nextGaussian() * (double)0.13f, this.getEntityBoundingBox().maxY + 0.5 + this.rand.nextGaussian() * (double)0.13f, this.posZ + this.rand.nextGaussian() * (double)0.13f, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.handleStatusUpdate(id);
        }
    }

    @Override
    protected float applyPotionDamageCalculations(DamageSource source, float damage) {
        damage = super.applyPotionDamageCalculations(source, damage);
        if (source.getEntity() == this) {
            damage = 0.0f;
        }
        if (source.isMagicDamage()) {
            damage = (float)((double)damage * 0.15);
        }
        return damage;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return LootTableList.ENTITIES_WITCH;
    }

    @Override
    public void attackEntityWithRangedAttack(EntityLivingBase target, float p_82196_2_) {
        if (!this.func_184730_o()) {
            double d0 = target.posY + (double)target.getEyeHeight() - (double)1.1f;
            double d1 = target.posX + target.motionX - this.posX;
            double d2 = d0 - this.posY;
            double d3 = target.posZ + target.motionZ - this.posZ;
            float f = MathHelper.sqrt_double(d1 * d1 + d3 * d3);
            PotionType potiontype = PotionTypes.harming;
            if (f >= 8.0f && !target.isPotionActive(MobEffects.moveSlowdown)) {
                potiontype = PotionTypes.slowness;
            } else if (target.getHealth() >= 8.0f && !target.isPotionActive(MobEffects.poison)) {
                potiontype = PotionTypes.poison;
            } else if (f <= 3.0f && !target.isPotionActive(MobEffects.weakness) && this.rand.nextFloat() < 0.25f) {
                potiontype = PotionTypes.weakness;
            }
            EntityPotion entitypotion = new EntityPotion(this.worldObj, this, PotionUtils.func_185188_a(new ItemStack(Items.splash_potion), potiontype));
            entitypotion.rotationPitch -= -20.0f;
            entitypotion.setThrowableHeading(d1, d2 + (double)(f * 0.2f), d3, 0.75f, 8.0f);
            this.worldObj.func_184148_a(null, this.posX, this.posY, this.posZ, SoundEvents.entity_witch_throw, this.getSoundCategory(), 1.0f, 0.8f + this.rand.nextFloat() * 0.4f);
            this.worldObj.spawnEntityInWorld(entitypotion);
        }
    }

    @Override
    public float getEyeHeight() {
        return 1.62f;
    }
}

