/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityCow
extends EntityAnimal {
    public EntityCow(World worldIn) {
        super(worldIn);
        this.setSize(0.9f, 1.4f);
    }

    @Override
    protected void initEntityAI() {
        this.tasks.addTask(0, new EntityAISwimming(this));
        this.tasks.addTask(1, new EntityAIPanic(this, 2.0));
        this.tasks.addTask(2, new EntityAIMate(this, 1.0));
        this.tasks.addTask(3, new EntityAITempt((EntityCreature)this, 1.25, Items.wheat, false));
        this.tasks.addTask(4, new EntityAIFollowParent(this, 1.25));
        this.tasks.addTask(5, new EntityAIWander(this, 1.0));
        this.tasks.addTask(6, new EntityAIWatchClosest(this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(7, new EntityAILookIdle(this));
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(10.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.2f);
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.entity_cow_ambient;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.entity_cow_hurt;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.entity_cow_death;
    }

    @Override
    protected void playStepSound(BlockPos pos, Block blockIn) {
        this.playSound(SoundEvents.entity_cow_step, 0.15f, 1.0f);
    }

    @Override
    protected float getSoundVolume() {
        return 0.4f;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return LootTableList.ENTITIES_COW;
    }

    @Override
    public boolean func_184645_a(EntityPlayer p_184645_1_, EnumHand p_184645_2_, ItemStack p_184645_3_) {
        if (p_184645_3_ != null && p_184645_3_.getItem() == Items.bucket && !p_184645_1_.capabilities.isCreativeMode && !this.isChild()) {
            p_184645_1_.playSound(SoundEvents.entity_cow_milk, 1.0f, 1.0f);
            if (--p_184645_3_.stackSize == 0) {
                p_184645_1_.setHeldItem(p_184645_2_, new ItemStack(Items.milk_bucket));
            } else if (!p_184645_1_.inventory.addItemStackToInventory(new ItemStack(Items.milk_bucket))) {
                p_184645_1_.dropPlayerItemWithRandomChoice(new ItemStack(Items.milk_bucket), false);
            }
            return true;
        }
        return super.func_184645_a(p_184645_1_, p_184645_2_, p_184645_3_);
    }

    @Override
    public EntityCow createChild(EntityAgeable ageable) {
        return new EntityCow(this.worldObj);
    }

    @Override
    public float getEyeHeight() {
        return this.isChild() ? this.height : 1.3f;
    }
}

