/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.player;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.player.PlayerCapabilities;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryEnderChest;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.CommandBlockBaseLogic;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.FoodStats;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.LockCode;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;

public abstract class EntityPlayer
extends EntityLivingBase {
    private static final DataParameter<Float> ABSORPTION = EntityDataManager.createKey(EntityPlayer.class, DataSerializers.FLOAT);
    private static final DataParameter<Integer> PLAYER_SCORE = EntityDataManager.createKey(EntityPlayer.class, DataSerializers.VARINT);
    protected static final DataParameter<Byte> PLAYER_MODEL_FLAG = EntityDataManager.createKey(EntityPlayer.class, DataSerializers.BYTE);
    protected static final DataParameter<Byte> MAIN_HAND = EntityDataManager.createKey(EntityPlayer.class, DataSerializers.BYTE);
    public InventoryPlayer inventory = new InventoryPlayer(this);
    private InventoryEnderChest theInventoryEnderChest = new InventoryEnderChest();
    public Container inventoryContainer;
    public Container openContainer;
    protected FoodStats foodStats = new FoodStats();
    protected int flyToggleTimer;
    public float prevCameraYaw;
    public float cameraYaw;
    public int xpCooldown;
    public double prevChasingPosX;
    public double prevChasingPosY;
    public double prevChasingPosZ;
    public double chasingPosX;
    public double chasingPosY;
    public double chasingPosZ;
    protected boolean sleeping;
    public BlockPos playerLocation;
    private int sleepTimer;
    public float renderOffsetX;
    public float renderOffsetY;
    public float renderOffsetZ;
    private BlockPos spawnChunk;
    private boolean spawnForced;
    private BlockPos startMinecartRidingCoordinate;
    public PlayerCapabilities capabilities = new PlayerCapabilities();
    public int experienceLevel;
    public int experienceTotal;
    public float experience;
    private int xpSeed;
    protected float speedOnGround = 0.1f;
    protected float speedInAir = 0.02f;
    private int lastXPSound;
    private final GameProfile gameProfile;
    private boolean hasReducedDebug = false;
    private ItemStack field_184831_bT = null;
    private final CooldownTracker cooldownTracker = this.createCooldownTracker();
    public EntityFishHook fishEntity;

    protected CooldownTracker createCooldownTracker() {
        return new CooldownTracker();
    }

    public EntityPlayer(World worldIn, GameProfile gameProfileIn) {
        super(worldIn);
        this.entityUniqueID = EntityPlayer.getUUID(gameProfileIn);
        this.gameProfile = gameProfileIn;
        this.openContainer = this.inventoryContainer = new ContainerPlayer(this.inventory, !worldIn.isRemote, this);
        BlockPos blockpos = worldIn.getSpawnPoint();
        this.setLocationAndAngles((double)blockpos.getX() + 0.5, blockpos.getY() + 1, (double)blockpos.getZ() + 0.5, 0.0f, 0.0f);
        this.unused180 = 180.0f;
        this.fireResistance = 20;
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(1.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.1f);
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.ATTACK_SPEED);
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.LUCK);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.register(ABSORPTION, Float.valueOf(0.0f));
        this.dataWatcher.register(PLAYER_SCORE, 0);
        this.dataWatcher.register(PLAYER_MODEL_FLAG, (byte)0);
        this.dataWatcher.register(MAIN_HAND, (byte)1);
    }

    @Override
    public void onUpdate() {
        this.noClip = this.isSpectator();
        if (this.isSpectator()) {
            this.onGround = false;
        }
        if (this.xpCooldown > 0) {
            --this.xpCooldown;
        }
        if (this.isPlayerSleeping()) {
            ++this.sleepTimer;
            if (this.sleepTimer > 100) {
                this.sleepTimer = 100;
            }
            if (!this.worldObj.isRemote) {
                if (!this.isInBed()) {
                    this.wakeUpPlayer(true, true, false);
                } else if (this.worldObj.isDaytime()) {
                    this.wakeUpPlayer(false, true, true);
                }
            }
        } else if (this.sleepTimer > 0) {
            ++this.sleepTimer;
            if (this.sleepTimer >= 110) {
                this.sleepTimer = 0;
            }
        }
        super.onUpdate();
        if (!this.worldObj.isRemote && this.openContainer != null && !this.openContainer.canInteractWith(this)) {
            this.closeScreen();
            this.openContainer = this.inventoryContainer;
        }
        if (this.isBurning() && this.capabilities.disableDamage) {
            this.extinguish();
        }
        this.func_184820_o();
        if (!this.isRiding()) {
            this.startMinecartRidingCoordinate = null;
        }
        if (!this.worldObj.isRemote) {
            this.foodStats.onUpdate(this);
            this.triggerAchievement(StatList.field_188097_g);
            if (this.isEntityAlive()) {
                this.triggerAchievement(StatList.field_188098_h);
            }
            if (this.isSneaking()) {
                this.triggerAchievement(StatList.field_188099_i);
            }
        }
        int i = 29999999;
        double d0 = MathHelper.clamp_double(this.posX, -2.9999999E7, 2.9999999E7);
        double d1 = MathHelper.clamp_double(this.posZ, -2.9999999E7, 2.9999999E7);
        if (d0 != this.posX || d1 != this.posZ) {
            this.setPosition(d0, this.posY, d1);
        }
        ++this.field_184617_aD;
        ItemStack itemstack = this.getHeldItemMainhand();
        if (!ItemStack.areItemStacksEqual(this.field_184831_bT, itemstack)) {
            if (!ItemStack.func_185132_d(this.field_184831_bT, itemstack)) {
                this.func_184821_cY();
            }
            this.field_184831_bT = itemstack == null ? null : itemstack.copy();
        }
        this.cooldownTracker.tick();
        this.func_184808_cD();
    }

    private void func_184820_o() {
        this.prevChasingPosX = this.chasingPosX;
        this.prevChasingPosY = this.chasingPosY;
        this.prevChasingPosZ = this.chasingPosZ;
        double d0 = this.posX - this.chasingPosX;
        double d1 = this.posY - this.chasingPosY;
        double d2 = this.posZ - this.chasingPosZ;
        double d3 = 10.0;
        if (d0 > d3) {
            this.prevChasingPosX = this.chasingPosX = this.posX;
        }
        if (d2 > d3) {
            this.prevChasingPosZ = this.chasingPosZ = this.posZ;
        }
        if (d1 > d3) {
            this.prevChasingPosY = this.chasingPosY = this.posY;
        }
        if (d0 < -d3) {
            this.prevChasingPosX = this.chasingPosX = this.posX;
        }
        if (d2 < -d3) {
            this.prevChasingPosZ = this.chasingPosZ = this.posZ;
        }
        if (d1 < -d3) {
            this.prevChasingPosY = this.chasingPosY = this.posY;
        }
        this.chasingPosX += d0 * 0.25;
        this.chasingPosZ += d2 * 0.25;
        this.chasingPosY += d1 * 0.25;
    }

    protected void func_184808_cD() {
        float f = this.width;
        float f1 = this.height;
        if (this.func_184613_cA()) {
            f = 0.6f;
            f1 = 0.6f;
        } else if (this.isPlayerSleeping()) {
            f = 0.2f;
            f1 = 0.2f;
        } else if (this.isSneaking()) {
            f = 0.6f;
            f1 = 1.65f;
        } else {
            f = 0.6f;
            f1 = 1.8f;
        }
        if (f != this.width || f1 != this.height) {
            AxisAlignedBB axisalignedbb = this.getEntityBoundingBox();
            axisalignedbb = new AxisAlignedBB(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ, axisalignedbb.minX + (double)f, axisalignedbb.minY + (double)f1, axisalignedbb.minZ + (double)f);
            if (!this.worldObj.func_184143_b(axisalignedbb)) {
                this.setSize(f, f1);
            }
        }
    }

    @Override
    public int getMaxInPortalTime() {
        return this.capabilities.disableDamage ? 1 : 80;
    }

    @Override
    protected SoundEvent getSwimSound() {
        return SoundEvents.entity_player_swim;
    }

    @Override
    protected SoundEvent getSplashSound() {
        return SoundEvents.entity_player_splash;
    }

    @Override
    public int getPortalCooldown() {
        return 10;
    }

    @Override
    public void playSound(SoundEvent soundIn, float volume, float pitch) {
        this.worldObj.func_184148_a(this, this.posX, this.posY, this.posZ, soundIn, this.getSoundCategory(), volume, pitch);
    }

    @Override
    public SoundCategory getSoundCategory() {
        return SoundCategory.PLAYERS;
    }

    @Override
    public void handleStatusUpdate(byte id) {
        if (id == 9) {
            this.onItemUseFinish();
        } else if (id == 23) {
            this.hasReducedDebug = false;
        } else if (id == 22) {
            this.hasReducedDebug = true;
        } else {
            super.handleStatusUpdate(id);
        }
    }

    @Override
    protected boolean isMovementBlocked() {
        return this.getHealth() <= 0.0f || this.isPlayerSleeping();
    }

    protected void closeScreen() {
        this.openContainer = this.inventoryContainer;
    }

    @Override
    public void updateRidden() {
        if (!this.worldObj.isRemote && this.isSneaking() && this.isRiding()) {
            this.dismountRidingEntity();
            this.setSneaking(false);
        } else {
            double d0 = this.posX;
            double d1 = this.posY;
            double d2 = this.posZ;
            float f = this.rotationYaw;
            float f1 = this.rotationPitch;
            super.updateRidden();
            this.prevCameraYaw = this.cameraYaw;
            this.cameraYaw = 0.0f;
            this.addMountedMovementStat(this.posX - d0, this.posY - d1, this.posZ - d2);
            if (this.getRidingEntity() instanceof EntityPig) {
                this.rotationPitch = f1;
                this.rotationYaw = f;
                this.renderYawOffset = ((EntityPig)this.getRidingEntity()).renderYawOffset;
            }
        }
    }

    @Override
    public void preparePlayerToSpawn() {
        this.setSize(0.6f, 1.8f);
        super.preparePlayerToSpawn();
        this.setHealth(this.getMaxHealth());
        this.deathTime = 0;
    }

    @Override
    protected void updateEntityActionState() {
        super.updateEntityActionState();
        this.updateArmSwingProgress();
        this.rotationYawHead = this.rotationYaw;
    }

    @Override
    public void onLivingUpdate() {
        if (this.flyToggleTimer > 0) {
            --this.flyToggleTimer;
        }
        if (this.worldObj.getDifficulty() == EnumDifficulty.PEACEFUL && this.worldObj.getGameRules().getBoolean("naturalRegeneration")) {
            if (this.getHealth() < this.getMaxHealth() && this.ticksExisted % 20 == 0) {
                this.heal(1.0f);
            }
            if (this.foodStats.needFood() && this.ticksExisted % 10 == 0) {
                this.foodStats.setFoodLevel(this.foodStats.getFoodLevel() + 1);
            }
        }
        this.inventory.decrementAnimations();
        this.prevCameraYaw = this.cameraYaw;
        super.onLivingUpdate();
        IAttributeInstance iattributeinstance = this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED);
        if (!this.worldObj.isRemote) {
            iattributeinstance.setBaseValue(this.capabilities.getWalkSpeed());
        }
        this.jumpMovementFactor = this.speedInAir;
        if (this.isSprinting()) {
            this.jumpMovementFactor = (float)((double)this.jumpMovementFactor + (double)this.speedInAir * 0.3);
        }
        this.setAIMoveSpeed((float)iattributeinstance.getAttributeValue());
        float f = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ);
        float f1 = (float)(Math.atan(-this.motionY * (double)0.2f) * 15.0);
        if (f > 0.1f) {
            f = 0.1f;
        }
        if (!this.onGround || this.getHealth() <= 0.0f) {
            f = 0.0f;
        }
        if (this.onGround || this.getHealth() <= 0.0f) {
            f1 = 0.0f;
        }
        this.cameraYaw += (f - this.cameraYaw) * 0.4f;
        this.cameraPitch += (f1 - this.cameraPitch) * 0.8f;
        if (this.getHealth() > 0.0f && !this.isSpectator()) {
            AxisAlignedBB axisalignedbb = null;
            axisalignedbb = this.isRiding() && !this.getRidingEntity().isDead ? this.getEntityBoundingBox().union(this.getRidingEntity().getEntityBoundingBox()).expand(1.0, 0.0, 1.0) : this.getEntityBoundingBox().expand(1.0, 0.5, 1.0);
            List<Entity> list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, axisalignedbb);
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = list.get(i);
                if (entity.isDead) continue;
                this.collideWithPlayer(entity);
            }
        }
    }

    private void collideWithPlayer(Entity p_71044_1_) {
        p_71044_1_.onCollideWithPlayer(this);
    }

    public int getScore() {
        return this.dataWatcher.get(PLAYER_SCORE);
    }

    public void setScore(int p_85040_1_) {
        this.dataWatcher.set(PLAYER_SCORE, p_85040_1_);
    }

    public void addScore(int p_85039_1_) {
        int i = this.getScore();
        this.dataWatcher.set(PLAYER_SCORE, i + p_85039_1_);
    }

    @Override
    public void onDeath(DamageSource cause) {
        super.onDeath(cause);
        this.setSize(0.2f, 0.2f);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.motionY = 0.1f;
        if (this.getName().equals("Notch")) {
            this.dropItem(new ItemStack(Items.apple, 1), true, false);
        }
        if (!this.worldObj.getGameRules().getBoolean("keepInventory") && !this.isSpectator()) {
            this.inventory.dropAllItems();
        }
        if (cause != null) {
            this.motionX = -MathHelper.cos((this.attackedAtYaw + this.rotationYaw) * ((float)Math.PI / 180)) * 0.1f;
            this.motionZ = -MathHelper.sin((this.attackedAtYaw + this.rotationYaw) * ((float)Math.PI / 180)) * 0.1f;
        } else {
            this.motionZ = 0.0;
            this.motionX = 0.0;
        }
        this.triggerAchievement(StatList.field_188069_A);
        this.func_175145_a(StatList.field_188098_h);
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.entity_player_hurt;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.entity_player_death;
    }

    @Override
    public void addToPlayerScore(Entity entityIn, int amount) {
        if (entityIn != this) {
            this.addScore(amount);
            Collection<ScoreObjective> collection = this.getWorldScoreboard().getObjectivesFromCriteria(IScoreCriteria.totalKillCount);
            if (entityIn instanceof EntityPlayer) {
                this.triggerAchievement(StatList.playerKillsStat);
                collection.addAll(this.getWorldScoreboard().getObjectivesFromCriteria(IScoreCriteria.playerKillCount));
            } else {
                this.triggerAchievement(StatList.field_188070_B);
            }
            collection.addAll(this.func_175137_e(entityIn));
            for (ScoreObjective scoreobjective : collection) {
                Score score = this.getWorldScoreboard().getValueFromObjective(this.getName(), scoreobjective);
                score.func_96648_a();
            }
        }
    }

    private Collection<ScoreObjective> func_175137_e(Entity p_175137_1_) {
        int j;
        ScorePlayerTeam scoreplayerteam1;
        int i;
        String s = p_175137_1_ instanceof EntityPlayer ? p_175137_1_.getName() : p_175137_1_.getUniqueID().toString();
        ScorePlayerTeam scoreplayerteam = this.getWorldScoreboard().getPlayersTeam(this.getName());
        if (scoreplayerteam != null && (i = scoreplayerteam.getChatFormat().getColorIndex()) >= 0 && i < IScoreCriteria.field_178793_i.length) {
            for (ScoreObjective scoreobjective : this.getWorldScoreboard().getObjectivesFromCriteria(IScoreCriteria.field_178793_i[i])) {
                Score score = this.getWorldScoreboard().getValueFromObjective(s, scoreobjective);
                score.func_96648_a();
            }
        }
        if ((scoreplayerteam1 = this.getWorldScoreboard().getPlayersTeam(s)) != null && (j = scoreplayerteam1.getChatFormat().getColorIndex()) >= 0 && j < IScoreCriteria.field_178792_h.length) {
            return this.getWorldScoreboard().getObjectivesFromCriteria(IScoreCriteria.field_178792_h[j]);
        }
        return Lists.newArrayList();
    }

    public EntityItem dropOneItem(boolean dropAll) {
        return this.dropItem(this.inventory.decrStackSize(this.inventory.currentItem, dropAll && this.inventory.getCurrentItem() != null ? this.inventory.getCurrentItem().stackSize : 1), false, true);
    }

    public EntityItem dropPlayerItemWithRandomChoice(ItemStack itemStackIn, boolean unused) {
        return this.dropItem(itemStackIn, false, false);
    }

    public EntityItem dropItem(ItemStack droppedItem, boolean dropAround, boolean traceItem) {
        if (droppedItem == null) {
            return null;
        }
        if (droppedItem.stackSize == 0) {
            return null;
        }
        double d0 = this.posY - (double)0.3f + (double)this.getEyeHeight();
        EntityItem entityitem = new EntityItem(this.worldObj, this.posX, d0, this.posZ, droppedItem);
        entityitem.setPickupDelay(40);
        if (traceItem) {
            entityitem.setThrower(this.getName());
        }
        if (dropAround) {
            float f = this.rand.nextFloat() * 0.5f;
            float f1 = this.rand.nextFloat() * ((float)Math.PI * 2);
            entityitem.motionX = -MathHelper.sin(f1) * f;
            entityitem.motionZ = MathHelper.cos(f1) * f;
            entityitem.motionY = 0.2f;
        } else {
            float f2 = 0.3f;
            entityitem.motionX = -MathHelper.sin(this.rotationYaw * ((float)Math.PI / 180)) * MathHelper.cos(this.rotationPitch * ((float)Math.PI / 180)) * f2;
            entityitem.motionZ = MathHelper.cos(this.rotationYaw * ((float)Math.PI / 180)) * MathHelper.cos(this.rotationPitch * ((float)Math.PI / 180)) * f2;
            entityitem.motionY = -MathHelper.sin(this.rotationPitch * ((float)Math.PI / 180)) * f2 + 0.1f;
            float f3 = this.rand.nextFloat() * ((float)Math.PI * 2);
            f2 = 0.02f * this.rand.nextFloat();
            entityitem.motionX += Math.cos(f3) * (double)f2;
            entityitem.motionY += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f);
            entityitem.motionZ += Math.sin(f3) * (double)f2;
        }
        ItemStack itemstack = this.func_184816_a(entityitem);
        if (traceItem) {
            if (itemstack != null) {
                this.addStat(StatList.func_188058_e(itemstack.getItem()), droppedItem.stackSize);
            }
            this.triggerAchievement(StatList.dropStat);
        }
        return entityitem;
    }

    protected ItemStack func_184816_a(EntityItem p_184816_1_) {
        this.worldObj.spawnEntityInWorld(p_184816_1_);
        ItemStack itemstack = p_184816_1_.getEntityItem();
        return itemstack;
    }

    public float func_184813_a(IBlockState p_184813_1_) {
        float f = this.inventory.func_184438_a(p_184813_1_);
        if (f > 1.0f) {
            int i = EnchantmentHelper.func_185293_e(this);
            ItemStack itemstack = this.getHeldItemMainhand();
            if (i > 0 && itemstack != null) {
                f += (float)(i * i + 1);
            }
        }
        if (this.isPotionActive(MobEffects.digSpeed)) {
            f *= 1.0f + (float)(this.getActivePotionEffect(MobEffects.digSpeed).getAmplifier() + 1) * 0.2f;
        }
        if (this.isPotionActive(MobEffects.digSlowdown)) {
            float f1 = 1.0f;
            switch (this.getActivePotionEffect(MobEffects.digSlowdown).getAmplifier()) {
                case 0: {
                    f1 = 0.3f;
                    break;
                }
                case 1: {
                    f1 = 0.09f;
                    break;
                }
                case 2: {
                    f1 = 0.0027f;
                    break;
                }
                default: {
                    f1 = 8.1E-4f;
                }
            }
            f *= f1;
        }
        if (this.isInsideOfMaterial(Material.water) && !EnchantmentHelper.func_185287_i(this)) {
            f /= 5.0f;
        }
        if (!this.onGround) {
            f /= 5.0f;
        }
        return f;
    }

    public boolean func_184823_b(IBlockState p_184823_1_) {
        return this.inventory.func_184432_b(p_184823_1_);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound tagCompund) {
        super.readEntityFromNBT(tagCompund);
        this.entityUniqueID = EntityPlayer.getUUID(this.gameProfile);
        NBTTagList nbttaglist = tagCompund.getTagList("Inventory", 10);
        this.inventory.readFromNBT(nbttaglist);
        this.inventory.currentItem = tagCompund.getInteger("SelectedItemSlot");
        this.sleeping = tagCompund.getBoolean("Sleeping");
        this.sleepTimer = tagCompund.getShort("SleepTimer");
        this.experience = tagCompund.getFloat("XpP");
        this.experienceLevel = tagCompund.getInteger("XpLevel");
        this.experienceTotal = tagCompund.getInteger("XpTotal");
        this.xpSeed = tagCompund.getInteger("XpSeed");
        if (this.xpSeed == 0) {
            this.xpSeed = this.rand.nextInt();
        }
        this.setScore(tagCompund.getInteger("Score"));
        if (this.sleeping) {
            this.playerLocation = new BlockPos(this);
            this.wakeUpPlayer(true, true, false);
        }
        if (tagCompund.hasKey("SpawnX", 99) && tagCompund.hasKey("SpawnY", 99) && tagCompund.hasKey("SpawnZ", 99)) {
            this.spawnChunk = new BlockPos(tagCompund.getInteger("SpawnX"), tagCompund.getInteger("SpawnY"), tagCompund.getInteger("SpawnZ"));
            this.spawnForced = tagCompund.getBoolean("SpawnForced");
        }
        this.foodStats.readNBT(tagCompund);
        this.capabilities.readCapabilitiesFromNBT(tagCompund);
        if (tagCompund.hasKey("EnderItems", 9)) {
            NBTTagList nbttaglist1 = tagCompund.getTagList("EnderItems", 10);
            this.theInventoryEnderChest.loadInventoryFromNBT(nbttaglist1);
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound tagCompound) {
        super.writeEntityToNBT(tagCompound);
        tagCompound.setInteger("DataVersion", 169);
        tagCompound.setTag("Inventory", this.inventory.writeToNBT(new NBTTagList()));
        tagCompound.setInteger("SelectedItemSlot", this.inventory.currentItem);
        tagCompound.setBoolean("Sleeping", this.sleeping);
        tagCompound.setShort("SleepTimer", (short)this.sleepTimer);
        tagCompound.setFloat("XpP", this.experience);
        tagCompound.setInteger("XpLevel", this.experienceLevel);
        tagCompound.setInteger("XpTotal", this.experienceTotal);
        tagCompound.setInteger("XpSeed", this.xpSeed);
        tagCompound.setInteger("Score", this.getScore());
        if (this.spawnChunk != null) {
            tagCompound.setInteger("SpawnX", this.spawnChunk.getX());
            tagCompound.setInteger("SpawnY", this.spawnChunk.getY());
            tagCompound.setInteger("SpawnZ", this.spawnChunk.getZ());
            tagCompound.setBoolean("SpawnForced", this.spawnForced);
        }
        this.foodStats.writeNBT(tagCompound);
        this.capabilities.writeCapabilitiesToNBT(tagCompound);
        tagCompound.setTag("EnderItems", this.theInventoryEnderChest.saveInventoryToNBT());
    }

    @Override
    public boolean attackEntityFrom(DamageSource source, float amount) {
        if (this.isEntityInvulnerable(source)) {
            return false;
        }
        if (this.capabilities.disableDamage && !source.canHarmInCreative()) {
            return false;
        }
        this.entityAge = 0;
        if (this.getHealth() <= 0.0f) {
            return false;
        }
        if (this.isPlayerSleeping() && !this.worldObj.isRemote) {
            this.wakeUpPlayer(true, true, false);
        }
        if (source.isDifficultyScaled()) {
            if (this.worldObj.getDifficulty() == EnumDifficulty.PEACEFUL) {
                amount = 0.0f;
            }
            if (this.worldObj.getDifficulty() == EnumDifficulty.EASY) {
                amount = amount / 2.0f + 1.0f;
            }
            if (this.worldObj.getDifficulty() == EnumDifficulty.HARD) {
                amount = amount * 3.0f / 2.0f;
            }
        }
        if (amount == 0.0f) {
            return false;
        }
        Entity entity = source.getEntity();
        if (entity instanceof EntityArrow && ((EntityArrow)entity).shootingEntity != null) {
            entity = ((EntityArrow)entity).shootingEntity;
        }
        return super.attackEntityFrom(source, amount);
    }

    public boolean canAttackPlayer(EntityPlayer other) {
        Team team = this.getTeam();
        Team team1 = other.getTeam();
        return team == null ? true : (!team.isSameTeam(team1) ? true : team.getAllowFriendlyFire());
    }

    @Override
    protected void damageArmor(float p_70675_1_) {
        this.inventory.damageArmor(p_70675_1_);
    }

    @Override
    protected void func_184590_k(float p_184590_1_) {
        if (p_184590_1_ > 0.0f && this.field_184627_bm != null && this.field_184627_bm.getItem() == Items.shield) {
            int i = 1 + MathHelper.floor_float(p_184590_1_);
            this.field_184627_bm.damageItem(i, this);
            if (this.field_184627_bm.stackSize <= 0) {
                EnumHand enumhand = this.func_184600_cs();
                if (enumhand == EnumHand.MAIN_HAND) {
                    this.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, null);
                } else {
                    this.setItemStackToSlot(EntityEquipmentSlot.OFFHAND, null);
                }
                this.field_184627_bm = null;
                this.playSound(SoundEvents.item_shield_break, 0.8f, 0.8f + this.worldObj.rand.nextFloat() * 0.4f);
            }
        }
    }

    public float getArmorVisibility() {
        int i = 0;
        for (ItemStack itemstack : this.inventory.armorInventory) {
            if (itemstack == null) continue;
            ++i;
        }
        return (float)i / (float)this.inventory.armorInventory.length;
    }

    @Override
    protected void damageEntity(DamageSource damageSrc, float damageAmount) {
        if (!this.isEntityInvulnerable(damageSrc)) {
            damageAmount = this.applyArmorCalculations(damageSrc, damageAmount);
            float f = damageAmount = this.applyPotionDamageCalculations(damageSrc, damageAmount);
            damageAmount = Math.max(damageAmount - this.getAbsorptionAmount(), 0.0f);
            this.setAbsorptionAmount(this.getAbsorptionAmount() - (f - damageAmount));
            if (damageAmount != 0.0f) {
                this.addExhaustion(damageSrc.getHungerDamage());
                float f1 = this.getHealth();
                this.setHealth(this.getHealth() - damageAmount);
                this.getCombatTracker().trackDamage(damageSrc, f1, damageAmount);
                if (damageAmount < 3.4028235E37f) {
                    this.addStat(StatList.field_188112_z, Math.round(damageAmount * 10.0f));
                }
            }
        }
    }

    public void openEditSign(TileEntitySign signTile) {
    }

    public void func_184809_a(CommandBlockBaseLogic p_184809_1_) {
    }

    public void func_184824_a(TileEntityCommandBlock p_184824_1_) {
    }

    public void displayVillagerTradeGui(IMerchant villager) {
    }

    public void displayGUIChest(IInventory chestInventory) {
    }

    public void func_184826_a(EntityHorse p_184826_1_, IInventory p_184826_2_) {
    }

    public void displayGui(IInteractionObject guiOwner) {
    }

    public void func_184814_a(ItemStack p_184814_1_, EnumHand p_184814_2_) {
    }

    public EnumActionResult func_184822_a(Entity p_184822_1_, ItemStack p_184822_2_, EnumHand p_184822_3_) {
        ItemStack itemstack;
        if (this.isSpectator()) {
            if (p_184822_1_ instanceof IInventory) {
                this.displayGUIChest((IInventory)((Object)p_184822_1_));
            }
            return EnumActionResult.PASS;
        }
        ItemStack itemStack = itemstack = p_184822_2_ != null ? p_184822_2_.copy() : null;
        if (!p_184822_1_.func_184230_a(this, p_184822_2_, p_184822_3_)) {
            if (p_184822_2_ != null && p_184822_1_ instanceof EntityLivingBase) {
                if (this.capabilities.isCreativeMode) {
                    p_184822_2_ = itemstack;
                }
                if (p_184822_2_.interactWithEntity(this, (EntityLivingBase)p_184822_1_, p_184822_3_)) {
                    if (p_184822_2_.stackSize <= 0 && !this.capabilities.isCreativeMode) {
                        this.setHeldItem(p_184822_3_, null);
                    }
                    return EnumActionResult.SUCCESS;
                }
            }
            return EnumActionResult.PASS;
        }
        if (p_184822_2_ != null && p_184822_2_ == this.getHeldItem(p_184822_3_)) {
            if (p_184822_2_.stackSize <= 0 && !this.capabilities.isCreativeMode) {
                this.setHeldItem(p_184822_3_, null);
            } else if (p_184822_2_.stackSize < itemstack.stackSize && this.capabilities.isCreativeMode) {
                p_184822_2_.stackSize = itemstack.stackSize;
            }
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public double getYOffset() {
        return -0.35;
    }

    @Override
    public void dismountRidingEntity() {
        super.dismountRidingEntity();
        this.field_184245_j = 0;
    }

    public void attackTargetEntityWithCurrentItem(Entity targetEntity) {
        if (targetEntity.canAttackWithItem() && !targetEntity.hitByEntity(this)) {
            float f = (float)this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).getAttributeValue();
            float f1 = 0.0f;
            f1 = targetEntity instanceof EntityLivingBase ? EnchantmentHelper.getModifierForCreature(this.getHeldItemMainhand(), ((EntityLivingBase)targetEntity).getCreatureAttribute()) : EnchantmentHelper.getModifierForCreature(this.getHeldItemMainhand(), EnumCreatureAttribute.UNDEFINED);
            float f2 = this.func_184825_o(0.5f);
            f1 *= f2;
            this.func_184821_cY();
            if ((f *= 0.2f + f2 * f2 * 0.8f) > 0.0f || f1 > 0.0f) {
                ItemStack itemstack;
                boolean flag = f2 > 0.9f;
                boolean flag1 = false;
                boolean flag2 = false;
                boolean flag3 = false;
                int i = 0;
                i += EnchantmentHelper.getKnockbackModifier(this);
                if (this.isSprinting() && flag) {
                    this.worldObj.func_184148_a(null, this.posX, this.posY, this.posZ, SoundEvents.entity_player_attack_knockback, this.getSoundCategory(), 1.0f, 1.0f);
                    ++i;
                    flag1 = true;
                }
                flag2 = flag && this.fallDistance > 0.0f && !this.onGround && !this.isOnLadder() && !this.isInWater() && !this.isPotionActive(MobEffects.blindness) && !this.isRiding() && targetEntity instanceof EntityLivingBase;
                boolean bl = flag2 = flag2 && !this.isSprinting();
                if (flag2) {
                    f *= 1.5f;
                }
                f += f1;
                double d0 = this.distanceWalkedModified - this.prevDistanceWalkedModified;
                if (flag && !flag2 && !flag1 && this.onGround && d0 < (double)this.getAIMoveSpeed() && (itemstack = this.getHeldItem(EnumHand.MAIN_HAND)) != null && itemstack.getItem() instanceof ItemSword) {
                    flag3 = true;
                }
                float f4 = 0.0f;
                boolean flag4 = false;
                int j = EnchantmentHelper.getFireAspectModifier(this);
                if (targetEntity instanceof EntityLivingBase) {
                    f4 = ((EntityLivingBase)targetEntity).getHealth();
                    if (j > 0 && !targetEntity.isBurning()) {
                        flag4 = true;
                        targetEntity.setFire(1);
                    }
                }
                double d1 = targetEntity.motionX;
                double d2 = targetEntity.motionY;
                double d3 = targetEntity.motionZ;
                boolean flag5 = targetEntity.attackEntityFrom(DamageSource.causePlayerDamage(this), f);
                if (flag5) {
                    IEntityMultiPart ientitymultipart;
                    if (i > 0) {
                        if (targetEntity instanceof EntityLivingBase) {
                            ((EntityLivingBase)targetEntity).knockBack(this, (float)i * 0.5f, MathHelper.sin(this.rotationYaw * ((float)Math.PI / 180)), -MathHelper.cos(this.rotationYaw * ((float)Math.PI / 180)));
                        } else {
                            targetEntity.addVelocity(-MathHelper.sin(this.rotationYaw * ((float)Math.PI / 180)) * (float)i * 0.5f, 0.1, MathHelper.cos(this.rotationYaw * ((float)Math.PI / 180)) * (float)i * 0.5f);
                        }
                        this.motionX *= 0.6;
                        this.motionZ *= 0.6;
                        this.setSprinting(false);
                    }
                    if (flag3) {
                        for (EntityLivingBase entitylivingbase : this.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, targetEntity.getEntityBoundingBox().expand(1.0, 0.25, 1.0))) {
                            if (entitylivingbase == this || entitylivingbase == targetEntity || this.func_184191_r(entitylivingbase) || !(this.getDistanceSqToEntity(entitylivingbase) < 9.0)) continue;
                            entitylivingbase.knockBack(this, 0.4f, MathHelper.sin(this.rotationYaw * ((float)Math.PI / 180)), -MathHelper.cos(this.rotationYaw * ((float)Math.PI / 180)));
                            entitylivingbase.attackEntityFrom(DamageSource.causePlayerDamage(this), 1.0f);
                        }
                        this.worldObj.func_184148_a(null, this.posX, this.posY, this.posZ, SoundEvents.entity_player_attack_sweep, this.getSoundCategory(), 1.0f, 1.0f);
                        this.func_184810_cG();
                    }
                    if (targetEntity instanceof EntityPlayerMP && targetEntity.velocityChanged) {
                        ((EntityPlayerMP)targetEntity).playerNetServerHandler.sendPacket(new SPacketEntityVelocity(targetEntity));
                        targetEntity.velocityChanged = false;
                        targetEntity.motionX = d1;
                        targetEntity.motionY = d2;
                        targetEntity.motionZ = d3;
                    }
                    if (flag2) {
                        this.worldObj.func_184148_a(null, this.posX, this.posY, this.posZ, SoundEvents.entity_player_attack_crit, this.getSoundCategory(), 1.0f, 1.0f);
                        this.onCriticalHit(targetEntity);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            this.worldObj.func_184148_a(null, this.posX, this.posY, this.posZ, SoundEvents.entity_player_attack_strong, this.getSoundCategory(), 1.0f, 1.0f);
                        } else {
                            this.worldObj.func_184148_a(null, this.posX, this.posY, this.posZ, SoundEvents.entity_player_attack_weak, this.getSoundCategory(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        this.onEnchantmentCritical(targetEntity);
                    }
                    if (!this.worldObj.isRemote && targetEntity instanceof EntityPlayer) {
                        ItemStack itemstack3;
                        EntityPlayer entityplayer = (EntityPlayer)targetEntity;
                        ItemStack itemstack2 = this.getHeldItemMainhand();
                        ItemStack itemStack = itemstack3 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : null;
                        if (itemstack2 != null && itemstack3 != null && itemstack2.getItem() instanceof ItemAxe && itemstack3.getItem() == Items.shield) {
                            float f3 = 0.25f + (float)EnchantmentHelper.func_185293_e(this) * 0.05f;
                            if (flag1) {
                                f3 += 0.75f;
                            }
                            if (this.rand.nextFloat() < f3) {
                                entityplayer.func_184811_cZ().setCooldown(Items.shield, 100);
                                this.worldObj.setEntityState(entityplayer, (byte)30);
                            }
                        }
                    }
                    if (f >= 18.0f) {
                        this.triggerAchievement(AchievementList.field_187973_F);
                    }
                    this.setLastAttacker(targetEntity);
                    if (targetEntity instanceof EntityLivingBase) {
                        EnchantmentHelper.applyThornEnchantments((EntityLivingBase)targetEntity, this);
                    }
                    EnchantmentHelper.applyArthropodEnchantments(this, targetEntity);
                    ItemStack itemstack1 = this.getHeldItemMainhand();
                    Entity entity = targetEntity;
                    if (targetEntity instanceof EntityDragonPart && (ientitymultipart = ((EntityDragonPart)targetEntity).entityDragonObj) instanceof EntityLivingBase) {
                        entity = (EntityLivingBase)((Object)ientitymultipart);
                    }
                    if (itemstack1 != null && entity instanceof EntityLivingBase) {
                        itemstack1.hitEntity((EntityLivingBase)entity, this);
                        if (itemstack1.stackSize <= 0) {
                            this.setHeldItem(EnumHand.MAIN_HAND, null);
                        }
                    }
                    if (targetEntity instanceof EntityLivingBase) {
                        float f5 = f4 - ((EntityLivingBase)targetEntity).getHealth();
                        this.addStat(StatList.field_188111_y, Math.round(f5 * 10.0f));
                        if (j > 0) {
                            targetEntity.setFire(j * 4);
                        }
                        if (this.worldObj instanceof WorldServer && f5 > 2.0f) {
                            int k = (int)((double)f5 * 0.5);
                            ((WorldServer)this.worldObj).spawnParticle(EnumParticleTypes.DAMAGE_INDICATOR, targetEntity.posX, targetEntity.posY + (double)(targetEntity.height * 0.5f), targetEntity.posZ, k, 0.1, 0.0, 0.1, 0.2, new int[0]);
                        }
                    }
                    this.addExhaustion(0.3f);
                } else {
                    this.worldObj.func_184148_a(null, this.posX, this.posY, this.posZ, SoundEvents.entity_player_attack_nodamage, this.getSoundCategory(), 1.0f, 1.0f);
                    if (flag4) {
                        targetEntity.extinguish();
                    }
                }
            }
        }
    }

    public void onCriticalHit(Entity entityHit) {
    }

    public void onEnchantmentCritical(Entity entityHit) {
    }

    public void func_184810_cG() {
        double d0 = -MathHelper.sin(this.rotationYaw * ((float)Math.PI / 180));
        double d1 = MathHelper.cos(this.rotationYaw * ((float)Math.PI / 180));
        if (this.worldObj instanceof WorldServer) {
            ((WorldServer)this.worldObj).spawnParticle(EnumParticleTypes.SWEEP_ATTACK, this.posX + d0, this.posY + (double)this.height * 0.5, this.posZ + d1, 0, d0, 0.0, d1, 0.0, new int[0]);
        }
    }

    public void respawnPlayer() {
    }

    @Override
    public void setDead() {
        super.setDead();
        this.inventoryContainer.onContainerClosed(this);
        if (this.openContainer != null) {
            this.openContainer.onContainerClosed(this);
        }
    }

    @Override
    public boolean isEntityInsideOpaqueBlock() {
        return !this.sleeping && super.isEntityInsideOpaqueBlock();
    }

    public boolean isUser() {
        return false;
    }

    public GameProfile getGameProfile() {
        return this.gameProfile;
    }

    public EnumStatus trySleep(BlockPos bedLocation) {
        if (!this.worldObj.isRemote) {
            if (this.isPlayerSleeping() || !this.isEntityAlive()) {
                return EnumStatus.OTHER_PROBLEM;
            }
            if (!this.worldObj.provider.isSurfaceWorld()) {
                return EnumStatus.NOT_POSSIBLE_HERE;
            }
            if (this.worldObj.isDaytime()) {
                return EnumStatus.NOT_POSSIBLE_NOW;
            }
            if (Math.abs(this.posX - (double)bedLocation.getX()) > 3.0 || Math.abs(this.posY - (double)bedLocation.getY()) > 2.0 || Math.abs(this.posZ - (double)bedLocation.getZ()) > 3.0) {
                return EnumStatus.TOO_FAR_AWAY;
            }
            double d0 = 8.0;
            double d1 = 5.0;
            List<EntityMob> list = this.worldObj.getEntitiesWithinAABB(EntityMob.class, new AxisAlignedBB((double)bedLocation.getX() - d0, (double)bedLocation.getY() - d1, (double)bedLocation.getZ() - d0, (double)bedLocation.getX() + d0, (double)bedLocation.getY() + d1, (double)bedLocation.getZ() + d0));
            if (!list.isEmpty()) {
                return EnumStatus.NOT_SAFE;
            }
        }
        if (this.isRiding()) {
            this.dismountRidingEntity();
        }
        this.setSize(0.2f, 0.2f);
        if (this.worldObj.isBlockLoaded(bedLocation)) {
            EnumFacing enumfacing = this.worldObj.getBlockState(bedLocation).getValue(BlockHorizontal.FACING);
            float f = 0.5f;
            float f1 = 0.5f;
            switch (enumfacing) {
                case SOUTH: {
                    f1 = 0.9f;
                    break;
                }
                case NORTH: {
                    f1 = 0.1f;
                    break;
                }
                case WEST: {
                    f = 0.1f;
                    break;
                }
                case EAST: {
                    f = 0.9f;
                }
            }
            this.func_175139_a(enumfacing);
            this.setPosition((float)bedLocation.getX() + f, (float)bedLocation.getY() + 0.6875f, (float)bedLocation.getZ() + f1);
        } else {
            this.setPosition((float)bedLocation.getX() + 0.5f, (float)bedLocation.getY() + 0.6875f, (float)bedLocation.getZ() + 0.5f);
        }
        this.sleeping = true;
        this.sleepTimer = 0;
        this.playerLocation = bedLocation;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.motionX = 0.0;
        if (!this.worldObj.isRemote) {
            this.worldObj.updateAllPlayersSleepingFlag();
        }
        return EnumStatus.OK;
    }

    private void func_175139_a(EnumFacing p_175139_1_) {
        this.renderOffsetX = 0.0f;
        this.renderOffsetZ = 0.0f;
        switch (p_175139_1_) {
            case SOUTH: {
                this.renderOffsetZ = -1.8f;
                break;
            }
            case NORTH: {
                this.renderOffsetZ = 1.8f;
                break;
            }
            case WEST: {
                this.renderOffsetX = 1.8f;
                break;
            }
            case EAST: {
                this.renderOffsetX = -1.8f;
            }
        }
    }

    public void wakeUpPlayer(boolean immediately, boolean updateWorldFlag, boolean setSpawn) {
        this.setSize(0.6f, 1.8f);
        IBlockState iblockstate = this.worldObj.getBlockState(this.playerLocation);
        if (this.playerLocation != null && iblockstate.getBlock() == Blocks.bed) {
            this.worldObj.setBlockState(this.playerLocation, iblockstate.withProperty(BlockBed.OCCUPIED, false), 4);
            BlockPos blockpos = BlockBed.getSafeExitLocation(this.worldObj, this.playerLocation, 0);
            if (blockpos == null) {
                blockpos = this.playerLocation.up();
            }
            this.setPosition((float)blockpos.getX() + 0.5f, (float)blockpos.getY() + 0.1f, (float)blockpos.getZ() + 0.5f);
        }
        this.sleeping = false;
        if (!this.worldObj.isRemote && updateWorldFlag) {
            this.worldObj.updateAllPlayersSleepingFlag();
        }
        int n = this.sleepTimer = immediately ? 0 : 100;
        if (setSpawn) {
            this.setSpawnPoint(this.playerLocation, false);
        }
    }

    private boolean isInBed() {
        return this.worldObj.getBlockState(this.playerLocation).getBlock() == Blocks.bed;
    }

    public static BlockPos getBedSpawnLocation(World worldIn, BlockPos bedLocation, boolean forceSpawn) {
        Block block = worldIn.getBlockState(bedLocation).getBlock();
        if (block != Blocks.bed) {
            if (!forceSpawn) {
                return null;
            }
            boolean flag = block.canSpawnInBlock();
            boolean flag1 = worldIn.getBlockState(bedLocation.up()).getBlock().canSpawnInBlock();
            return flag && flag1 ? bedLocation : null;
        }
        return BlockBed.getSafeExitLocation(worldIn, bedLocation, 0);
    }

    public float getBedOrientationInDegrees() {
        if (this.playerLocation != null) {
            EnumFacing enumfacing = this.worldObj.getBlockState(this.playerLocation).getValue(BlockHorizontal.FACING);
            switch (enumfacing) {
                case SOUTH: {
                    return 90.0f;
                }
                case NORTH: {
                    return 270.0f;
                }
                case WEST: {
                    return 0.0f;
                }
                case EAST: {
                    return 180.0f;
                }
            }
        }
        return 0.0f;
    }

    @Override
    public boolean isPlayerSleeping() {
        return this.sleeping;
    }

    public boolean isPlayerFullyAsleep() {
        return this.sleeping && this.sleepTimer >= 100;
    }

    public int getSleepTimer() {
        return this.sleepTimer;
    }

    public void addChatComponentMessage(ITextComponent chatComponent) {
    }

    public BlockPos getBedLocation() {
        return this.spawnChunk;
    }

    public boolean isSpawnForced() {
        return this.spawnForced;
    }

    public void setSpawnPoint(BlockPos pos, boolean forced) {
        if (pos != null) {
            this.spawnChunk = pos;
            this.spawnForced = forced;
        } else {
            this.spawnChunk = null;
            this.spawnForced = false;
        }
    }

    public boolean func_189102_a(Achievement p_189102_1_) {
        return false;
    }

    public void triggerAchievement(StatBase achievementIn) {
        this.addStat(achievementIn, 1);
    }

    public void addStat(StatBase stat, int amount) {
    }

    public void func_175145_a(StatBase p_175145_1_) {
    }

    @Override
    public void jump() {
        super.jump();
        this.triggerAchievement(StatList.jumpStat);
        if (this.isSprinting()) {
            this.addExhaustion(0.8f);
        } else {
            this.addExhaustion(0.2f);
        }
    }

    @Override
    public void moveEntityWithHeading(float strafe, float forward) {
        double d0 = this.posX;
        double d1 = this.posY;
        double d2 = this.posZ;
        if (this.capabilities.isFlying && !this.isRiding()) {
            double d3 = this.motionY;
            float f = this.jumpMovementFactor;
            this.jumpMovementFactor = this.capabilities.getFlySpeed() * (float)(this.isSprinting() ? 2 : 1);
            super.moveEntityWithHeading(strafe, forward);
            this.motionY = d3 * 0.6;
            this.jumpMovementFactor = f;
            this.fallDistance = 0.0f;
            this.setFlag(7, false);
        } else {
            super.moveEntityWithHeading(strafe, forward);
        }
        this.addMovementStat(this.posX - d0, this.posY - d1, this.posZ - d2);
    }

    @Override
    public float getAIMoveSpeed() {
        return (float)this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).getAttributeValue();
    }

    public void addMovementStat(double p_71000_1_, double p_71000_3_, double p_71000_5_) {
        if (!this.isRiding()) {
            if (this.isInsideOfMaterial(Material.water)) {
                int i = Math.round(MathHelper.sqrt_double(p_71000_1_ * p_71000_1_ + p_71000_3_ * p_71000_3_ + p_71000_5_ * p_71000_5_) * 100.0f);
                if (i > 0) {
                    this.addStat(StatList.field_188105_q, i);
                    this.addExhaustion(0.015f * (float)i * 0.01f);
                }
            } else if (this.isInWater()) {
                int j = Math.round(MathHelper.sqrt_double(p_71000_1_ * p_71000_1_ + p_71000_5_ * p_71000_5_) * 100.0f);
                if (j > 0) {
                    this.addStat(StatList.distanceSwumStat, j);
                    this.addExhaustion(0.015f * (float)j * 0.01f);
                }
            } else if (this.isOnLadder()) {
                if (p_71000_3_ > 0.0) {
                    this.addStat(StatList.field_188103_o, (int)Math.round(p_71000_3_ * 100.0));
                }
            } else if (this.onGround) {
                int k = Math.round(MathHelper.sqrt_double(p_71000_1_ * p_71000_1_ + p_71000_5_ * p_71000_5_) * 100.0f);
                if (k > 0) {
                    if (this.isSprinting()) {
                        this.addStat(StatList.field_188102_l, k);
                        this.addExhaustion(0.099999994f * (float)k * 0.01f);
                    } else if (this.isSneaking()) {
                        this.addStat(StatList.field_188101_k, k);
                        this.addExhaustion(0.005f * (float)k * 0.01f);
                    } else {
                        this.addStat(StatList.field_188100_j, k);
                        this.addExhaustion(0.01f * (float)k * 0.01f);
                    }
                }
            } else if (this.func_184613_cA()) {
                int l = Math.round(MathHelper.sqrt_double(p_71000_1_ * p_71000_1_ + p_71000_3_ * p_71000_3_ + p_71000_5_ * p_71000_5_) * 100.0f);
                this.addStat(StatList.field_188110_v, l);
            } else {
                int i1 = Math.round(MathHelper.sqrt_double(p_71000_1_ * p_71000_1_ + p_71000_5_ * p_71000_5_) * 100.0f);
                if (i1 > 25) {
                    this.addStat(StatList.field_188104_p, i1);
                }
            }
        }
    }

    private void addMountedMovementStat(double p_71015_1_, double p_71015_3_, double p_71015_5_) {
        int i;
        if (this.isRiding() && (i = Math.round(MathHelper.sqrt_double(p_71015_1_ * p_71015_1_ + p_71015_3_ * p_71015_3_ + p_71015_5_ * p_71015_5_) * 100.0f)) > 0) {
            if (this.getRidingEntity() instanceof EntityMinecart) {
                this.addStat(StatList.field_188106_r, i);
                if (this.startMinecartRidingCoordinate == null) {
                    this.startMinecartRidingCoordinate = new BlockPos(this);
                } else if (this.startMinecartRidingCoordinate.distanceSq(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ)) >= 1000000.0) {
                    this.triggerAchievement(AchievementList.field_187990_q);
                }
            } else if (this.getRidingEntity() instanceof EntityBoat) {
                this.addStat(StatList.field_188107_s, i);
            } else if (this.getRidingEntity() instanceof EntityPig) {
                this.addStat(StatList.field_188108_t, i);
            } else if (this.getRidingEntity() instanceof EntityHorse) {
                this.addStat(StatList.field_188109_u, i);
            }
        }
    }

    @Override
    public void fall(float distance, float damageMultiplier) {
        if (!this.capabilities.allowFlying) {
            if (distance >= 2.0f) {
                this.addStat(StatList.distanceFallenStat, (int)Math.round((double)distance * 100.0));
            }
            super.fall(distance, damageMultiplier);
        }
    }

    @Override
    protected void resetHeight() {
        if (!this.isSpectator()) {
            super.resetHeight();
        }
    }

    @Override
    protected SoundEvent getFallSound(int heightIn) {
        return heightIn > 4 ? SoundEvents.entity_player_big_fall : SoundEvents.entity_player_small_fall;
    }

    @Override
    public void onKillEntity(EntityLivingBase entityLivingIn) {
        EntityList.EntityEggInfo entitylist$entityegginfo;
        if (entityLivingIn instanceof IMob) {
            this.triggerAchievement(AchievementList.field_187992_s);
        }
        if ((entitylist$entityegginfo = EntityList.entityEggs.get(EntityList.getEntityString(entityLivingIn))) != null) {
            this.triggerAchievement(entitylist$entityegginfo.field_151512_d);
        }
    }

    @Override
    public void setInWeb() {
        if (!this.capabilities.isFlying) {
            super.setInWeb();
        }
    }

    public void addExperience(int amount) {
        this.addScore(amount);
        int i = Integer.MAX_VALUE - this.experienceTotal;
        if (amount > i) {
            amount = i;
        }
        this.experience += (float)amount / (float)this.xpBarCap();
        this.experienceTotal += amount;
        while (this.experience >= 1.0f) {
            this.experience = (this.experience - 1.0f) * (float)this.xpBarCap();
            this.addExperienceLevel(1);
            this.experience /= (float)this.xpBarCap();
        }
    }

    public int getXPSeed() {
        return this.xpSeed;
    }

    public void removeExperienceLevel(int levels) {
        this.experienceLevel -= levels;
        if (this.experienceLevel < 0) {
            this.experienceLevel = 0;
            this.experience = 0.0f;
            this.experienceTotal = 0;
        }
        this.xpSeed = this.rand.nextInt();
    }

    public void addExperienceLevel(int levels) {
        this.experienceLevel += levels;
        if (this.experienceLevel < 0) {
            this.experienceLevel = 0;
            this.experience = 0.0f;
            this.experienceTotal = 0;
        }
        if (levels > 0 && this.experienceLevel % 5 == 0 && (float)this.lastXPSound < (float)this.ticksExisted - 100.0f) {
            float f = this.experienceLevel > 30 ? 1.0f : (float)this.experienceLevel / 30.0f;
            this.worldObj.func_184148_a(null, this.posX, this.posY, this.posZ, SoundEvents.entity_player_levelup, this.getSoundCategory(), f * 0.75f, 1.0f);
            this.lastXPSound = this.ticksExisted;
        }
    }

    public int xpBarCap() {
        return this.experienceLevel >= 30 ? 112 + (this.experienceLevel - 30) * 9 : (this.experienceLevel >= 15 ? 37 + (this.experienceLevel - 15) * 5 : 7 + this.experienceLevel * 2);
    }

    public void addExhaustion(float p_71020_1_) {
        if (!this.capabilities.disableDamage && !this.worldObj.isRemote) {
            this.foodStats.addExhaustion(p_71020_1_);
        }
    }

    public FoodStats getFoodStats() {
        return this.foodStats;
    }

    public boolean canEat(boolean ignoreHunger) {
        return (ignoreHunger || this.foodStats.needFood()) && !this.capabilities.disableDamage;
    }

    public boolean shouldHeal() {
        return this.getHealth() > 0.0f && this.getHealth() < this.getMaxHealth();
    }

    public boolean isAllowEdit() {
        return this.capabilities.allowEdit;
    }

    public boolean canPlayerEdit(BlockPos p_175151_1_, EnumFacing p_175151_2_, ItemStack p_175151_3_) {
        if (this.capabilities.allowEdit) {
            return true;
        }
        if (p_175151_3_ == null) {
            return false;
        }
        BlockPos blockpos = p_175151_1_.offset(p_175151_2_.getOpposite());
        Block block = this.worldObj.getBlockState(blockpos).getBlock();
        return p_175151_3_.canPlaceOn(block) || p_175151_3_.canEditBlocks();
    }

    @Override
    protected int getExperiencePoints(EntityPlayer player) {
        if (!this.worldObj.getGameRules().getBoolean("keepInventory") && !this.isSpectator()) {
            int i = this.experienceLevel * 7;
            return i > 100 ? 100 : i;
        }
        return 0;
    }

    @Override
    protected boolean isPlayer() {
        return true;
    }

    @Override
    public boolean getAlwaysRenderNameTagForRender() {
        return true;
    }

    public void clonePlayer(EntityPlayer oldPlayer, boolean respawnFromEnd) {
        if (respawnFromEnd) {
            this.inventory.copyInventory(oldPlayer.inventory);
            this.setHealth(oldPlayer.getHealth());
            this.foodStats = oldPlayer.foodStats;
            this.experienceLevel = oldPlayer.experienceLevel;
            this.experienceTotal = oldPlayer.experienceTotal;
            this.experience = oldPlayer.experience;
            this.setScore(oldPlayer.getScore());
            this.lastPortalPos = oldPlayer.lastPortalPos;
            this.lastPortalVec = oldPlayer.lastPortalVec;
            this.teleportDirection = oldPlayer.teleportDirection;
        } else if (this.worldObj.getGameRules().getBoolean("keepInventory") || oldPlayer.isSpectator()) {
            this.inventory.copyInventory(oldPlayer.inventory);
            this.experienceLevel = oldPlayer.experienceLevel;
            this.experienceTotal = oldPlayer.experienceTotal;
            this.experience = oldPlayer.experience;
            this.setScore(oldPlayer.getScore());
        }
        this.xpSeed = oldPlayer.xpSeed;
        this.theInventoryEnderChest = oldPlayer.theInventoryEnderChest;
        this.getDataManager().set(PLAYER_MODEL_FLAG, oldPlayer.getDataManager().get(PLAYER_MODEL_FLAG));
    }

    @Override
    protected boolean canTriggerWalking() {
        return !this.capabilities.isFlying;
    }

    public void sendPlayerAbilities() {
    }

    public void setGameType(WorldSettings.GameType gameType) {
    }

    @Override
    public String getName() {
        return this.gameProfile.getName();
    }

    public InventoryEnderChest getInventoryEnderChest() {
        return this.theInventoryEnderChest;
    }

    @Override
    public ItemStack getItemStackFromSlot(EntityEquipmentSlot slotIn) {
        return slotIn == EntityEquipmentSlot.MAINHAND ? this.inventory.getCurrentItem() : (slotIn == EntityEquipmentSlot.OFFHAND ? this.inventory.field_184439_c[0] : (slotIn.func_188453_a() == EntityEquipmentSlot.Type.ARMOR ? this.inventory.armorInventory[slotIn.func_188454_b()] : null));
    }

    @Override
    public void setItemStackToSlot(EntityEquipmentSlot slotIn, ItemStack stack) {
        if (slotIn == EntityEquipmentSlot.MAINHAND) {
            this.func_184606_a_(stack);
            this.inventory.mainInventory[this.inventory.currentItem] = stack;
        } else if (slotIn == EntityEquipmentSlot.OFFHAND) {
            this.func_184606_a_(stack);
            this.inventory.field_184439_c[0] = stack;
        } else if (slotIn.func_188453_a() == EntityEquipmentSlot.Type.ARMOR) {
            this.func_184606_a_(stack);
            this.inventory.armorInventory[slotIn.func_188454_b()] = stack;
        }
    }

    @Override
    public Iterable<ItemStack> getHeldEquipment() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.getHeldItemMainhand(), this.getHeldItemOffhand()});
    }

    @Override
    public Iterable<ItemStack> getArmorInventoryList() {
        return Arrays.asList(this.inventory.armorInventory);
    }

    @Override
    public boolean isInvisibleToPlayer(EntityPlayer player) {
        if (!this.isInvisible()) {
            return false;
        }
        if (player.isSpectator()) {
            return false;
        }
        Team team = this.getTeam();
        return team == null || player == null || player.getTeam() != team || !team.getSeeFriendlyInvisiblesEnabled();
    }

    public abstract boolean isSpectator();

    public abstract boolean isCreative();

    @Override
    public boolean isPushedByWater() {
        return !this.capabilities.isFlying;
    }

    public Scoreboard getWorldScoreboard() {
        return this.worldObj.getScoreboard();
    }

    @Override
    public Team getTeam() {
        return this.getWorldScoreboard().getPlayersTeam(this.getName());
    }

    @Override
    public ITextComponent getDisplayName() {
        TextComponentString itextcomponent = new TextComponentString(ScorePlayerTeam.formatPlayerName(this.getTeam(), this.getName()));
        itextcomponent.getChatStyle().setChatClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/msg " + this.getName() + " "));
        itextcomponent.getChatStyle().setChatHoverEvent(this.getHoverEvent());
        itextcomponent.getChatStyle().setInsertion(this.getName());
        return itextcomponent;
    }

    @Override
    public float getEyeHeight() {
        float f = 1.62f;
        if (this.isPlayerSleeping()) {
            f = 0.2f;
        } else if (!this.isSneaking() && this.height != 1.65f) {
            if (this.func_184613_cA() || this.height == 0.6f) {
                f = 0.4f;
            }
        } else {
            f -= 0.08f;
        }
        return f;
    }

    @Override
    public void setAbsorptionAmount(float amount) {
        if (amount < 0.0f) {
            amount = 0.0f;
        }
        this.getDataManager().set(ABSORPTION, Float.valueOf(amount));
    }

    @Override
    public float getAbsorptionAmount() {
        return this.getDataManager().get(ABSORPTION).floatValue();
    }

    public static UUID getUUID(GameProfile profile) {
        UUID uuid = profile.getId();
        if (uuid == null) {
            uuid = EntityPlayer.getOfflineUUID(profile.getName());
        }
        return uuid;
    }

    public static UUID getOfflineUUID(String username) {
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + username).getBytes(Charsets.UTF_8));
    }

    public boolean canOpen(LockCode code) {
        if (code.isEmpty()) {
            return true;
        }
        ItemStack itemstack = this.getHeldItemMainhand();
        return itemstack != null && itemstack.hasDisplayName() ? itemstack.getDisplayName().equals(code.getLock()) : false;
    }

    public boolean isWearing(EnumPlayerModelParts p_175148_1_) {
        return (this.getDataManager().get(PLAYER_MODEL_FLAG) & p_175148_1_.getPartMask()) == p_175148_1_.getPartMask();
    }

    @Override
    public boolean sendCommandFeedback() {
        return this.getServer().worldServers[0].getGameRules().getBoolean("sendCommandFeedback");
    }

    @Override
    public boolean replaceItemInInventory(int inventorySlot, ItemStack itemStackIn) {
        if (inventorySlot >= 0 && inventorySlot < this.inventory.mainInventory.length) {
            this.inventory.setInventorySlotContents(inventorySlot, itemStackIn);
            return true;
        }
        EntityEquipmentSlot entityequipmentslot = inventorySlot == 100 + EntityEquipmentSlot.HEAD.func_188454_b() ? EntityEquipmentSlot.HEAD : (inventorySlot == 100 + EntityEquipmentSlot.CHEST.func_188454_b() ? EntityEquipmentSlot.CHEST : (inventorySlot == 100 + EntityEquipmentSlot.LEGS.func_188454_b() ? EntityEquipmentSlot.LEGS : (inventorySlot == 100 + EntityEquipmentSlot.FEET.func_188454_b() ? EntityEquipmentSlot.FEET : null)));
        if (inventorySlot == 98) {
            this.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, itemStackIn);
            return true;
        }
        if (inventorySlot == 99) {
            this.setItemStackToSlot(EntityEquipmentSlot.OFFHAND, itemStackIn);
            return true;
        }
        if (entityequipmentslot == null) {
            int i = inventorySlot - 200;
            if (i >= 0 && i < this.theInventoryEnderChest.getSizeInventory()) {
                this.theInventoryEnderChest.setInventorySlotContents(i, itemStackIn);
                return true;
            }
            return false;
        }
        if (itemStackIn != null && itemStackIn.getItem() != null && (!(itemStackIn.getItem() instanceof ItemArmor) && !(itemStackIn.getItem() instanceof ItemElytra) ? entityequipmentslot != EntityEquipmentSlot.HEAD : EntityLiving.func_184640_d(itemStackIn) != entityequipmentslot)) {
            return false;
        }
        this.inventory.setInventorySlotContents(entityequipmentslot.func_188454_b() + this.inventory.mainInventory.length, itemStackIn);
        return true;
    }

    public boolean hasReducedDebug() {
        return this.hasReducedDebug;
    }

    public void setReducedDebug(boolean reducedDebug) {
        this.hasReducedDebug = reducedDebug;
    }

    @Override
    public EnumHandSide getPrimaryHand() {
        return this.dataWatcher.get(MAIN_HAND) == 0 ? EnumHandSide.LEFT : EnumHandSide.RIGHT;
    }

    public void func_184819_a(EnumHandSide p_184819_1_) {
        this.dataWatcher.set(MAIN_HAND, (byte)(p_184819_1_ != EnumHandSide.LEFT ? 1 : 0));
    }

    public float func_184818_cX() {
        return (float)(1.0 / this.getEntityAttribute(SharedMonsterAttributes.ATTACK_SPEED).getAttributeValue() * 20.0);
    }

    public float func_184825_o(float p_184825_1_) {
        return MathHelper.clamp_float(((float)this.field_184617_aD + p_184825_1_) / this.func_184818_cX(), 0.0f, 1.0f);
    }

    public void func_184821_cY() {
        this.field_184617_aD = 0;
    }

    public CooldownTracker func_184811_cZ() {
        return this.cooldownTracker;
    }

    @Override
    public void applyEntityCollision(Entity entityIn) {
        if (!this.isPlayerSleeping()) {
            super.applyEntityCollision(entityIn);
        }
    }

    public float getLuck() {
        return (float)this.getEntityAttribute(SharedMonsterAttributes.LUCK).getAttributeValue();
    }

    public static enum EnumStatus {
        OK,
        NOT_POSSIBLE_HERE,
        NOT_POSSIBLE_NOW,
        TOO_FAR_AWAY,
        OTHER_PROBLEM,
        NOT_SAFE;

    }

    public static enum EnumChatVisibility {
        FULL(0, "options.chat.visibility.full"),
        SYSTEM(1, "options.chat.visibility.system"),
        HIDDEN(2, "options.chat.visibility.hidden");

        private static final EnumChatVisibility[] ID_LOOKUP;
        private final int chatVisibility;
        private final String resourceKey;

        private EnumChatVisibility(int id, String resourceKey) {
            this.chatVisibility = id;
            this.resourceKey = resourceKey;
        }

        public int getChatVisibility() {
            return this.chatVisibility;
        }

        public static EnumChatVisibility getEnumChatVisibility(int id) {
            return ID_LOOKUP[id % ID_LOOKUP.length];
        }

        public String getResourceKey() {
            return this.resourceKey;
        }

        static {
            ID_LOOKUP = new EnumChatVisibility[EnumChatVisibility.values().length];
            EnumChatVisibility[] enumChatVisibilityArray = EnumChatVisibility.values();
            int n = enumChatVisibilityArray.length;
            for (int i = 0; i < n; ++i) {
                EnumChatVisibility entityplayer$enumchatvisibility;
                EnumChatVisibility.ID_LOOKUP[entityplayer$enumchatvisibility.chatVisibility] = entityplayer$enumchatvisibility = enumChatVisibilityArray[i];
            }
        }
    }
}

